/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.lcs.business.servicehelper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LargeTextProp;
import kd.hr.hbp.common.util.HRStringUtils;

public class LCSBaseDataHelper {
    private LCSBaseDataHelper() {
    }

    public static List<String> getEntryEntitys(MainEntityType mainEntityType) {
        ArrayList<String> entitys = new ArrayList<String>();
        Map entityTypeMap = mainEntityType.getAllEntities();
        for (Map.Entry entry : entityTypeMap.entrySet()) {
            if (!(entry.getValue() instanceof EntryType) || entry.getValue() instanceof SubEntryType) continue;
            entitys.add((String)entry.getKey());
        }
        return entitys;
    }

    public static Map<String, List<String>> getSubEntryEntitys(MainEntityType mainEntityType) {
        HashMap<String, List<String>> subEntryEntityMap = new HashMap<String, List<String>>();
        Map entityTypeMap = mainEntityType.getAllEntities();
        for (Map.Entry entry : entityTypeMap.entrySet()) {
            if (!(entry.getValue() instanceof SubEntryType)) continue;
            String entryEntity = ((EntityType)entry.getValue()).getParent().getName();
            String subEntryEntity = (String)entry.getKey();
            ArrayList<String> subEntryentitys = (ArrayList<String>)subEntryEntityMap.get(entryEntity);
            if (subEntryentitys == null) {
                subEntryentitys = new ArrayList<String>();
                subEntryEntityMap.put(entryEntity, subEntryentitys);
            }
            subEntryentitys.add(subEntryEntity);
        }
        return subEntryEntityMap;
    }

    public static List<String> getAllEntitys(MainEntityType mainEntityType) {
        Map entityTypeMap = mainEntityType.getAllEntities();
        Iterator entries = entityTypeMap.entrySet().iterator();
        ArrayList<String> entitys = new ArrayList<String>(entityTypeMap.size());
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            entitys.add((String)entry.getKey());
        }
        return entitys;
    }

    public static Map<String, List<String>> getEntityFieldsMap(MainEntityType mainEntityType) {
        Map entityTypeMap = mainEntityType.getAllEntities();
        HashMap<String, List<String>> entityFieldsMap = new HashMap<String, List<String>>(entityTypeMap.size());
        for (Map.Entry entry : entityTypeMap.entrySet()) {
            String entity = (String)entry.getKey();
            EntityType entityType = (EntityType)entry.getValue();
            Map fieldsMap = entityType.getFields();
            ArrayList<String> fields = new ArrayList<String>(fieldsMap.size());
            for (Map.Entry entry01 : fieldsMap.entrySet()) {
                IDataEntityProperty entityProperty = (IDataEntityProperty)entry01.getValue();
                fields.add(entityProperty.getName());
            }
            entityFieldsMap.put(entity, fields);
        }
        return entityFieldsMap;
    }

    public static Map<String, List<IDataEntityProperty>> getEntityPropertiesMap(MainEntityType mainEntityType) {
        Map entityTypeMap = mainEntityType.getAllEntities();
        HashMap<String, List<IDataEntityProperty>> entityFieldsMap = new HashMap<String, List<IDataEntityProperty>>(entityTypeMap.size());
        for (Map.Entry entry : entityTypeMap.entrySet()) {
            String entity = (String)entry.getKey();
            EntityType entityType = (EntityType)entry.getValue();
            Map fieldsMap = entityType.getFields();
            ArrayList<IDataEntityProperty> fields = new ArrayList<IDataEntityProperty>(fieldsMap.size());
            for (Map.Entry entry01 : fieldsMap.entrySet()) {
                IDataEntityProperty entityProperty = (IDataEntityProperty)entry01.getValue();
                fields.add(entityProperty);
            }
            entityFieldsMap.put(entity, fields);
        }
        return entityFieldsMap;
    }

    public static String getSelectProperties(MainEntityType mainEntityType) {
        List<String> allFields = LCSBaseDataHelper.getAllFields(mainEntityType);
        Map entityTypes = mainEntityType.getAllEntities();
        for (EntityType entityType : entityTypes.values()) {
            if (!(entityType instanceof EntryType)) continue;
            allFields.add(entityType.getName() + "." + ((EntryType)entityType).getSeqProperty().getName());
        }
        return LCSBaseDataHelper.join(allFields, ",");
    }

    public static String join(List<String> arr, String separator) {
        StringBuilder sb = new StringBuilder();
        for (String obj : arr) {
            sb.append((Object)obj).append(separator);
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.lastIndexOf(separator));
        }
        return null;
    }

    public static String getSelectProperties(String entityNumber) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        return LCSBaseDataHelper.getSelectProperties(mainEntityType);
    }

    public static List<String> getAllFields(MainEntityType mainEntityType) {
        ArrayList<String> fields = new ArrayList<String>();
        Map fieldTypeMap = mainEntityType.getAllFields();
        for (Map.Entry entry : fieldTypeMap.entrySet()) {
            IDataEntityProperty entityProperty = (IDataEntityProperty)entry.getValue();
            if (entityProperty instanceof BasedataProp) {
                fields.add(entityProperty.getName() + ".id");
            } else {
                fields.add(entityProperty.getName());
            }
            if (!(entityProperty instanceof LargeTextProp)) continue;
            fields.add(entityProperty.getName() + "_tag");
        }
        return fields;
    }

    public static List<String> getFields(MainEntityType mainEntityType) {
        Map fieldTypeMap = mainEntityType.getFields();
        Iterator entries = fieldTypeMap.entrySet().iterator();
        ArrayList<String> fields = new ArrayList<String>(fieldTypeMap.size());
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            IDataEntityProperty entityProperty = (IDataEntityProperty)entry.getValue();
            fields.add(entityProperty.getName());
        }
        return fields;
    }

    public static List<IDataEntityProperty> getEntityPropeties(MainEntityType mainEntityType) {
        Map fieldTypeMap = mainEntityType.getFields();
        Iterator entries = fieldTypeMap.entrySet().iterator();
        ArrayList<IDataEntityProperty> propeties = new ArrayList<IDataEntityProperty>(fieldTypeMap.size());
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            IDataEntityProperty entityProperty = (IDataEntityProperty)entry.getValue();
            propeties.add(entityProperty);
        }
        return propeties;
    }

    public static List<String> getEntityFields(MainEntityType mainEntityType, String entryEntity) {
        EntityType type = (EntityType)mainEntityType.getAllEntities().get(entryEntity);
        Map fieldsMap = type.getFields();
        Iterator entries = fieldsMap.entrySet().iterator();
        ArrayList<String> fields = new ArrayList<String>(fieldsMap.size());
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            IDataEntityProperty entityProperty = (IDataEntityProperty)entry.getValue();
            fields.add(entityProperty.getName());
        }
        return fields;
    }

    public static List<String> getEntityFieldsOnlyId(MainEntityType mainEntityType, String entryEntity) {
        EntityType type = (EntityType)mainEntityType.getAllEntities().get(entryEntity);
        Map fieldsMap = type.getFields();
        Iterator entries = fieldsMap.entrySet().iterator();
        ArrayList<String> fields = new ArrayList<String>(fieldsMap.size());
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            IDataEntityProperty entityProperty = (IDataEntityProperty)entry.getValue();
            if (HRStringUtils.isEmpty((String)entityProperty.getAlias())) continue;
            if (entityProperty instanceof BasedataProp) {
                fields.add(entityProperty.getName() + ".id");
                continue;
            }
            fields.add(entityProperty.getName());
        }
        return fields;
    }

    public static List<IDataEntityProperty> getEntityPropeties(MainEntityType mainEntityType, String entryEntity) {
        EntityType type = (EntityType)mainEntityType.getAllEntities().get(entryEntity);
        Map fieldsMap = type.getFields();
        Iterator entries = fieldsMap.entrySet().iterator();
        ArrayList<IDataEntityProperty> fields = new ArrayList<IDataEntityProperty>(fieldsMap.size());
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            IDataEntityProperty entityProperty = (IDataEntityProperty)entry.getValue();
            fields.add(entityProperty);
        }
        return fields;
    }
}

