/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.lcs.opplugin.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class CostAdaptionSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        HashMap<Long, DynamicObject> databseDatas = new HashMap<Long, DynamicObject>(extendedDataEntities.length);
        HashSet<Long> numberSets = new HashSet<Long>(extendedDataEntities.length);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            this.checkIfFieldMapNotChoose(extendedDataEntity);
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            numberSets.add(dataEntity.getLong("id"));
        }
        this.validateCountryModify(extendedDataEntities, databseDatas, numberSets);
    }

    private void validateCountryModify(ExtendedDataEntity[] extendedDataEntities, Map<Long, DynamicObject> databseDatas, Set<Long> numberSets) {
        HRBaseServiceHelper orm = new HRBaseServiceHelper("lcs_costadaption");
        DynamicObject[] query = orm.query("id,areatype,country,country.number", new QFilter[]{new QFilter("id", "in", numberSets)});
        if (query == null || query.length == 0) {
            return;
        }
        for (DynamicObject dynamicObject : query) {
            databseDatas.put(dynamicObject.getLong("id"), dynamicObject);
        }
        this.checkCountryModify(extendedDataEntities, databseDatas);
    }

    private void checkCountryModify(ExtendedDataEntity[] extendedDataEntities, Map<Long, DynamicObject> databseDatas) {
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            Long id = dataEntity.getLong("id");
            DynamicObject dynamicObject = databseDatas.get(id);
            if (dynamicObject == null) continue;
            String lastAreatype = dynamicObject.getString("areatype");
            String lastCountryNumber = dynamicObject.getString("country.number");
            String areatype = dataEntity.getString("areatype");
            String countryNumber = dataEntity.getString("country.number");
            if (this.isEquale(lastAreatype, areatype) && this.isEquale(lastCountryNumber, countryNumber)) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4fee\u6539\u201c\u56fd\u5bb6/\u5730\u533a\u7c7b\u578b\u201d\u548c\u201c\u56fd\u5bb6/\u5730\u533a\u201d\u3002", (String)"CostAdaptionSaveValidator_2", (String)"hrmp-lcs-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean isEquale(String source, String target) {
        if (HRStringUtils.isEmpty((String)source)) {
            source = "";
        }
        if (HRStringUtils.isEmpty((String)target)) {
            target = "";
        }
        return source.equals(target);
    }

    private void checkIfFieldMapNotChoose(ExtendedDataEntity entity) {
        DynamicObject dataEntity = entity.getDataEntity();
        String areaType = dataEntity.getString("areatype");
        if ("1".equals(areaType)) {
            this.checkGeneralData(entity);
        } else {
            this.checkAssignedData(entity);
        }
    }

    private void checkAssignedData(ExtendedDataEntity entity) {
        DynamicObject dataEntity = entity.getDataEntity();
        if (null == dataEntity) {
            return;
        }
        DynamicObject dynamicObject = dataEntity.getDynamicObject("country");
        if (null == dynamicObject) {
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u201c\u56fd\u5bb6/\u5730\u533a\u7c7b\u578b\u201d\u4e3a\u201c\u6307\u5b9a\u201d\u65f6\uff0c\u9700\u8981\u586b\u5199\u201c\u56fd\u5bb6/\u5730\u533a\u201d\u5b57\u6bb5\u3002", (String)"CostAdaptionSaveValidator_0", (String)"hrmp-lcs-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkGeneralData(ExtendedDataEntity entity) {
        DynamicObject dataEntity = entity.getDataEntity();
        if (null == dataEntity) {
            return;
        }
        DynamicObject dynamicObject = dataEntity.getDynamicObject("country");
        if (null != dynamicObject) {
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u201c\u56fd\u5bb6/\u5730\u533a\u7c7b\u578b\u201d\u4e3a\u201c\u901a\u7528\u201d\u65f6\uff0c\u4e0d\u9700\u586b\u5199\u201c\u56fd\u5bb6/\u5730\u533a\u201d\u5b57\u6bb5\u3002", (String)"CostAdaptionSaveValidator_1", (String)"hrmp-lcs-opplugin", (Object[])new Object[0]));
        }
    }
}

