/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.lcs.opplugin.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class CostAdaptionUnAuditValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        ArrayList<Object> dimensionIdList = new ArrayList<Object>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            dimensionIdList.add(dataEntity.getBillPkId());
        }
        this.checkIsRefenced(dataEntities, dimensionIdList);
    }

    private void checkIsRefenced(ExtendedDataEntity[] dataEntities, List<Object> costStruIdList) {
        BasedataEntityType basedataEntityType = (BasedataEntityType)dataEntities[0].getDataEntity().getDataEntityType();
        Map<Object, BaseDataCheckRefrenceResult> checkResult = CostAdaptionUnAuditValidator.getIsRefencedInfo(basedataEntityType, costStruIdList.toArray());
        if (checkResult == null || checkResult.isEmpty()) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Object billPkId = dataEntity.getBillPkId();
            BaseDataCheckRefrenceResult refResult = checkResult.get(billPkId);
            if (refResult == null) continue;
            MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refResult.getRefenceKey().getRefEntityKey());
            String billName = refMainType.getDisplayName().toString();
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u88ab\u6210\u672c\u8bbe\u7f6e\u5f15\u7528\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002\u53ef\u524d\u5f80\u201c\u85aa\u916c\u6210\u672c\u5e94\u7528>\u6210\u672c\u6838\u7b97\u8bbe\u7f6e>\u85aa\u916c\u9879\u76ee/\u7ec4\u7ec7/\u4eba\u5458/\u5c97\u4f4d/\u85aa\u8d44\u6863\u6848/\u6863\u6848\u9879\u76ee\u6210\u672c\u8bbe\u7f6e\u201d \u8fdb\u884c\u6570\u636e\u68c0\u67e5\u3002", (String)"CostAdaptionUnAuditValidator_1", (String)"hrmp-lcs-opplugin", (Object[])new Object[]{billName}));
        }
    }

    private static Map<Object, BaseDataCheckRefrenceResult> getIsRefencedInfo(BasedataEntityType baseEntityType, Object[] objIds) {
        BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
        checker.setDraftValidReference(false);
        return checker.checkRef(baseEntityType, objIds);
    }
}

