/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.lcs.opplugin.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.lcs.business.basedata.CostBasaDataHelper;

public class CostDimensionDeleteValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        ArrayList<Object> dimensionIdList = new ArrayList<Object>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            dimensionIdList.add(dataEntity.getBillPkId());
        }
        this.checkIsRefenced(dataEntities, dimensionIdList);
    }

    private void checkIsRefenced(ExtendedDataEntity[] dataEntities, List<Object> dimensionIdList) {
        BasedataEntityType basedataEntityType = (BasedataEntityType)dataEntities[0].getDataEntity().getDataEntityType();
        Map<Object, BaseDataCheckRefrenceResult> checkResult = CostDimensionDeleteValidator.getIsRefencedInfo(basedataEntityType, dimensionIdList.toArray());
        if (checkResult == null || checkResult.isEmpty()) {
            return;
        }
        ArrayList<Object> refencedDimensionIdList = new ArrayList<Object>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Object billPkId = dataEntity.getBillPkId();
            BaseDataCheckRefrenceResult refrenceResult = checkResult.get(billPkId);
            if (refrenceResult == null) continue;
            refencedDimensionIdList.add(billPkId);
        }
        if (refencedDimensionIdList.isEmpty()) {
            return;
        }
        Map dimesionIdRefStruIdListMap = CostBasaDataHelper.getRefencedCostStruIds(refencedDimensionIdList);
        if (dimesionIdRefStruIdListMap == null || dimesionIdRefStruIdListMap.isEmpty()) {
            return;
        }
        ArrayList costStruIdList = new ArrayList(10);
        dimesionIdRefStruIdListMap.values().forEach(struIds -> costStruIdList.addAll(struIds));
        Map costStruFidRefNameMap = CostBasaDataHelper.queryCostStruFidRefName(costStruIdList);
        if (costStruFidRefNameMap == null | costStruFidRefNameMap.isEmpty()) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Object billPkId = dataEntity.getBillPkId();
            BaseDataCheckRefrenceResult refrenceResult = checkResult.get(billPkId);
            if (refrenceResult == null) continue;
            List struIds2 = (List)dimesionIdRefStruIdListMap.get(String.valueOf(billPkId));
            StringBuilder errorTip = new StringBuilder();
            struIds2.forEach(strucId -> errorTip.append((String)costStruFidRefNameMap.get(strucId.toString())).append('\u3001'));
            this.addMessage(dataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5df2\u88ab\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u7ec4\u5408%s\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"CostDimensionDeleteValidator_0", (String)"hrmp-lcs-opplugin", (Object[])new Object[0]), errorTip.substring(0, errorTip.length() - 1)));
        }
    }

    private static Map<Object, BaseDataCheckRefrenceResult> getIsRefencedInfo(BasedataEntityType baseEntityType, Object[] objIds) {
        BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
        checker.setDraftValidReference(false);
        return checker.checkRef(baseEntityType, objIds);
    }
}

