/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.lcs.opplugin.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.lcs.business.basedata.CostBasaDataHelper;

public class CostStruUnAuditValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        ArrayList<Object> dimensionIdList = new ArrayList<Object>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            dimensionIdList.add(dataEntity.getBillPkId());
        }
        this.checkIsRefenced(dataEntities, dimensionIdList);
    }

    private void checkIsRefenced(ExtendedDataEntity[] dataEntities, List<Object> costStruIdList) {
        BasedataEntityType basedataEntityType = (BasedataEntityType)dataEntities[0].getDataEntity().getDataEntityType();
        Map<Object, BaseDataCheckRefrenceResult> checkResult = CostStruUnAuditValidator.getIsRefencedInfo(basedataEntityType, costStruIdList.toArray());
        if (checkResult == null || checkResult.isEmpty()) {
            return;
        }
        ArrayList<Object> refCostStruIdList = new ArrayList<Object>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Object billPkId = dataEntity.getBillPkId();
            BaseDataCheckRefrenceResult refrenceResult = checkResult.get(billPkId);
            if (refrenceResult == null) continue;
            refCostStruIdList.add(billPkId);
        }
        if (refCostStruIdList.isEmpty()) {
            return;
        }
        Map struIdRefAdaptionIdListMap = CostBasaDataHelper.getRefencedCostAdaptionIds(refCostStruIdList);
        if (struIdRefAdaptionIdListMap == null || struIdRefAdaptionIdListMap.isEmpty()) {
            return;
        }
        ArrayList costAdaptionIdList = new ArrayList(10);
        struIdRefAdaptionIdListMap.values().forEach(adaptionIds -> costAdaptionIdList.addAll(adaptionIds));
        Map costAdaptionFidRefNameMap = CostBasaDataHelper.queryCostAdaptionFidRefName(costAdaptionIdList);
        if (costAdaptionFidRefNameMap == null | costAdaptionFidRefNameMap.isEmpty()) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Object billPkId = dataEntity.getBillPkId();
            BaseDataCheckRefrenceResult refResult = checkResult.get(billPkId);
            if (refResult == null) continue;
            List adaptionIds2 = (List)struIdRefAdaptionIdListMap.get(String.valueOf(billPkId));
            StringBuilder errorTip = new StringBuilder();
            adaptionIds2.forEach(adaptionId -> errorTip.append((String)costAdaptionFidRefNameMap.get(adaptionId.toString())).append('\u3001'));
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u88ab\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u65b9\u6848%s\u5f15\u7528\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"CostStruUnAuditValidator_0", (String)"hrmp-lcs-opplugin", (Object[])new Object[]{errorTip.substring(0, errorTip.length() - 1)}));
        }
    }

    private static Map<Object, BaseDataCheckRefrenceResult> getIsRefencedInfo(BasedataEntityType baseEntityType, Object[] objIds) {
        BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
        checker.setDraftValidReference(false);
        return checker.checkRef(baseEntityType, objIds);
    }
}

