/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.soecs.business.domain.appremperson;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hrmp.soecs.business.domain.appremperson.AppRemPersonService;
import org.apache.commons.lang3.tuple.Pair;

public class AppRemPersonServiceImpl
implements AppRemPersonService {
    private static final HRBaseServiceHelper REPOSITORY = HRBaseServiceHelper.create((String)"soecs_appremperson");
    private static final Log LOG = LogFactory.getLog(AppRemPersonServiceImpl.class);

    @Override
    public Long saveOrUpdate(DynamicObject dynamicObject) {
        long returnId;
        if (Objects.isNull(dynamicObject) || !dynamicObject.containsProperty("telephone") || !dynamicObject.containsProperty("name")) {
            return 0L;
        }
        String phone = dynamicObject.getString("telephone");
        String name = dynamicObject.getString("name");
        DynamicObject appRemPerson = this.queryOne(name, phone);
        LOG.info("AppRemPersonService.saveOrUpdate isAlreadyHave:{}", (Object)Objects.nonNull(appRemPerson));
        Date now = new Date();
        long currUserId = RequestContext.get().getCurrUserId();
        if (Objects.isNull(appRemPerson)) {
            dynamicObject.set("type", (Object)"1");
            dynamicObject.set("enable", (Object)"1");
            dynamicObject.set("status", (Object)"C");
            if (dynamicObject.get("age") == null) {
                dynamicObject.set("age", (Object)0);
            }
            dynamicObject.set("creator", (Object)currUserId);
            dynamicObject.set("createtime", (Object)now);
            dynamicObject.set("modifier", (Object)currUserId);
            dynamicObject.set("modifytime", (Object)now);
            DynamicObject obj = (DynamicObject)REPOSITORY.saveOne(dynamicObject);
            returnId = Objects.isNull(obj) ? 0L : obj.getLong("id");
        } else {
            Set ignoreSet = Stream.of("creator", "creator_id", "createtime", "type", "enable", "status", "id").collect(Collectors.toSet());
            for (String dyProperty : dynamicObject.getDynamicObjectType().getProperties().stream().map(IMetadata::getName).collect(Collectors.toSet())) {
                if (ignoreSet.contains(dyProperty)) continue;
                appRemPerson.set(dyProperty, dynamicObject.get(dyProperty));
            }
            if (appRemPerson.get("age") == null) {
                appRemPerson.set("age", (Object)0);
            }
            appRemPerson.set("modifier", (Object)currUserId);
            appRemPerson.set("modifytime", (Object)now);
            DynamicObject obj = (DynamicObject)REPOSITORY.updateOne(appRemPerson);
            returnId = Objects.isNull(obj) ? 0L : obj.getLong("id");
        }
        LOG.info("AppRemPersonService.saveOrUpdate returnId:{}", (Object)returnId);
        return returnId;
    }

    @Override
    public Long saveOrUpdateByEmployee(DynamicObject employee) {
        if (Objects.isNull(employee)) {
            return 0L;
        }
        LOG.info("AppRemPersonService.saveOrUpdateByEmployee param:{}", (Object)employee.getLong("id"));
        HRBaseServiceHelper employeeHelper = HRBaseServiceHelper.create((String)"hrpi_employee");
        DynamicObject employeeDO = employeeHelper.queryOriginalOne("id,person.id,person.name,person.number", employee.get("id"));
        if (Objects.isNull(employeeDO)) {
            LOG.warn("AppRemPersonService.saveOrUpdateByEmployee employee not exist, param:{}", (Object)employee.getLong("id"));
            return 0L;
        }
        long employeeId = employeeDO.getLong("id");
        DynamicObject dynamicObject = REPOSITORY.queryOne("id,name", new QFilter("employee", "=", (Object)employeeId));
        if (Objects.nonNull(dynamicObject)) {
            LOG.info("AppRemPersonService.saveOrUpdateByEmployee already have appremperson, employeeId:{},oldName:{},newName:{}", new Object[]{employee.getLong("id"), dynamicObject.getString("name"), employeeDO.getString("person.name")});
            dynamicObject.set("name", (Object)employeeDO.getString("person.name"));
            dynamicObject.set("number", (Object)employeeDO.getString("person.number"));
            REPOSITORY.saveOne(dynamicObject);
            return dynamicObject.getLong("id");
        }
        DynamicObject appRemPersonDO = REPOSITORY.generateEmptyDynamicObject();
        long appRemPersonId = ORM.create().genLongId(REPOSITORY.getEntityName());
        appRemPersonDO.set("id", (Object)appRemPersonId);
        appRemPersonDO.set("employee", (Object)employeeId);
        appRemPersonDO.set("name", (Object)employeeDO.getString("person.name"));
        appRemPersonDO.set("number", (Object)employeeDO.getString("person.number"));
        appRemPersonDO.set("type", (Object)"0");
        appRemPersonDO.set("person", employeeDO.get("person.id"));
        appRemPersonDO.set("enable", (Object)"1");
        appRemPersonDO.set("status", (Object)"C");
        appRemPersonDO.set("age", (Object)0);
        REPOSITORY.saveOne(appRemPersonDO);
        LOG.info("AppRemPersonService.saveOrUpdateByEmployee not have appremperson, employeeId:{}, apprempersonId", (Object)employee.getLong("id"), (Object)appRemPersonId);
        return appRemPersonId;
    }

    @Override
    public List<Long> saveOrUpdateByEmployees(List<Long> employeeIds) {
        Object[] savedDyn;
        if (CollectionUtils.isEmpty(employeeIds)) {
            return new ArrayList<Long>(0);
        }
        LOG.info("AppRemPersonService.saveOrUpdateByEmployees param:{}", employeeIds);
        HRBaseServiceHelper employeeHelper = HRBaseServiceHelper.create((String)"hrpi_employee");
        Object[] employeeDOs = employeeHelper.queryOriginalArray("id,person.id,person.name,person.number", new QFilter[]{new QFilter("id", "in", employeeIds)});
        if (HRArrayUtils.isEmpty((Object[])employeeDOs)) {
            LOG.warn("AppRemPersonService.saveOrUpdateByEmployee employee not exist");
            return new ArrayList<Long>(0);
        }
        List idCollect = Arrays.stream(employeeDOs).map(employeeDO -> employeeDO.getLong("id")).collect(Collectors.toList());
        DynamicObject[] dynamicObjects = REPOSITORY.query("id,name,employee", new QFilter[]{new QFilter("employee", "in", idCollect)});
        Map<Long, DynamicObject> existDynMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(appremPersonDO -> appremPersonDO.getLong("employee.id"), appremPersonDO -> appremPersonDO, (existValue, newValue) -> existValue));
        ArrayList saveDyn = new ArrayList(10);
        Arrays.stream(employeeDOs).forEach(employeeDO -> {
            long employeeId = employeeDO.getLong("id");
            if (!HRMapUtils.isEmpty((Map)existDynMap) && existDynMap.containsKey(employeeId)) {
                DynamicObject existDyn = (DynamicObject)existDynMap.get(employeeId);
                existDyn.set("name", (Object)employeeDO.getString("person.name"));
                existDyn.set("number", (Object)employeeDO.getString("person.number"));
                saveDyn.add(existDyn);
            } else {
                DynamicObject appRemPersonDO = REPOSITORY.generateEmptyDynamicObject();
                long appRemPersonId = ORM.create().genLongId(REPOSITORY.getEntityName());
                appRemPersonDO.set("id", (Object)appRemPersonId);
                appRemPersonDO.set("employee", (Object)employeeId);
                appRemPersonDO.set("name", (Object)employeeDO.getString("person.name"));
                appRemPersonDO.set("number", (Object)employeeDO.getString("person.number"));
                appRemPersonDO.set("type", (Object)"0");
                appRemPersonDO.set("person", employeeDO.get("person.id"));
                appRemPersonDO.set("enable", (Object)"1");
                appRemPersonDO.set("status", (Object)"C");
                appRemPersonDO.set("age", (Object)0);
                saveDyn.add(appRemPersonDO);
            }
        });
        if (!CollectionUtils.isEmpty(saveDyn) && !HRArrayUtils.isEmpty((Object[])(savedDyn = (DynamicObject[])REPOSITORY.save(saveDyn.toArray(new DynamicObject[0]))))) {
            return Arrays.stream(savedDyn).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        }
        return new ArrayList<Long>(0);
    }

    @Override
    public DynamicObject queryOne(String name, String phone) {
        QFilter nameQF = new QFilter("name", "=", (Object)name);
        QFilter phoneQF = new QFilter("telephone", "=", (Object)phone);
        return REPOSITORY.loadDynamicObject(new QFilter[]{nameQF, phoneQF});
    }

    @Override
    public DynamicObject queryOne(Object id) {
        return REPOSITORY.queryOne(id);
    }

    @Override
    public Pair<Boolean, DynamicObject> queryWithIsExistInnerPerson(String name, String phone) {
        return Pair.of((Object)this.isExistEmployee(name, phone), (Object)this.queryOne(name, phone));
    }

    private boolean isExistEmployee(String name, String phone) {
        List list;
        Map hrpiEmpentrel;
        ImmutableMap maps = ImmutableMap.of((Object)"name", (Object)name, (Object)"phone", (Object)phone, (Object)"fuzzyFlag", (Object)false);
        boolean flag = false;
        Map data = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getPersonInfoFuzzy", (Object[])new Object[]{maps});
        if (!data.isEmpty() && ((Boolean)data.get("success")).booleanValue() && !(hrpiEmpentrel = (list = (List)data.get("data")).stream().filter(rs -> rs.containsKey("hrpi_empentrel")).findFirst().orElseGet(() -> Maps.newHashMapWithExpectedSize((int)8))).isEmpty()) {
            flag = true;
        }
        LOG.info("AppRemPersonService.isExistEmployee result:{}", (Object)flag);
        return flag;
    }
}

