/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.soecs.formplugin.web;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.EventObject;
import java.util.Locale;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.soecs.business.domain.appremperson.AppRemPersonService;
import kd.hrmp.soecs.business.domain.appremperson.AppRemPersonServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AppRemPersonBaseEdit
extends HRDataBaseEdit {
    private static final AppRemPersonService SERVICE = new AppRemPersonServiceImpl();
    private static final String SYSTEM_TYPE = "hrmp-soecs-formplugin";
    private static final String KEY_CONFIRM = "confirm";
    private static final String KEY_CANCEL = "Cancel";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u5916\u90e8\u4eba\u5458\u7ba1\u7406", (String)"AppRemPersonBaseList_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String property = args.getProperty().getName();
        if ("name".equals(property) || "telephone".equals(property)) {
            Pair pair;
            String nameVal = ((OrmLocaleValue)this.getModelVal("name")).getLocaleValue();
            String telephone = this.getModelValStr("telephone");
            if (StringUtils.isNotEmpty((CharSequence)nameVal) && StringUtils.isNotEmpty((CharSequence)telephone) && ((Boolean)(pair = SERVICE.queryWithIsExistInnerPerson(nameVal, telephone)).getLeft()).booleanValue()) {
                String format = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u3010%s\u3011\u4e3a\u7ec4\u7ec7\u5185\u4eba\u5458,\u8bf7\u786e\u8ba4\u59d3\u540d\u3001\u624b\u673a\u53f7\u3002", (String)"AppRemPersonBaseEdit_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), nameVal);
                this.getView().showTipNotification(format);
                this.getModel().setValue(property, null);
                this.getPageCache().put("changeProperty", property);
            }
        } else if ("birthyear".equals(property)) {
            Object newValue = args.getChangeSet()[0].getNewValue();
            if (newValue == null) {
                this.getModel().setValue("age", null);
                return;
            }
            Date birthDate = (Date)this.getModelVal("birthyear");
            LocalDate localDate = birthDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            int birthYear = localDate.getYear();
            int year = LocalDate.now().getYear();
            this.getModel().setValue("age", (Object)(year - birthYear));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("type", (Object)"1");
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String changeProperty;
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        String resultValue = messageBoxClosedEvent.getResultValue();
        if (KEY_CONFIRM.equals(callBackId) && KEY_CANCEL.equals(resultValue) && HRStringUtils.isNotEmpty((String)(changeProperty = this.getPageCache().get("changeProperty")))) {
            this.getModel().setValue(changeProperty, null);
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        event.setSkipNoField(true);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DataEntityState dataEntityState = dataEntity.getDataEntityState();
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        IDataEntityProperty number = (IDataEntityProperty)properties.get((Object)"number");
        if (!HRObjectUtils.isEmpty((Object)number)) {
            dataEntityState.setBizChanged(number.getOrdinal(), false);
        }
    }
}

