/*
 * Decompiled with CFR 0.152.
 */
package kd.hros.hrom.formplugin.route.utils;

import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;

public class ShowFormUtils {
    private static final Log LOGGER = LogFactory.getLog(ShowFormUtils.class);

    public static void showForm(IFormView view, String formId, ShowType type, Map<String, Object> map, String terminal) {
        HashMap<String, Object> customs = new HashMap<String, Object>(16);
        customs.put("content", map.get("content"));
        customs.put("name", map.get("name"));
        customs.put("id", map.get("id"));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(type);
        if ("pc".equals(terminal)) {
            showParameter.setCloseCallBack(new CloseCallBack("kd.hros.hrom.formplugin.route.pc.HSSCPortalRoutePlugin", "hrobs_pc_privacy"));
            showParameter.setClientParam("requestBeforeClose", (Object)Boolean.TRUE);
        }
        showParameter.setCustomParams(customs);
        view.showForm(showParameter);
    }

    public static void showPortalHome(IFormView formView, String formId, ShowType type, String terminal) {
        LOGGER.info("showPortalHome().start=====================");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.setStatus(OperationStatus.VIEW);
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setShowType(type);
        LOGGER.info("showPortalHome().terminal:{}", (Object)terminal);
        if ("pc".equals(terminal)) {
            String pageId = formView.getPageId();
            formShowParameter.setPageId(pageId);
            formShowParameter.setParentPageId(formView.getFormShowParameter().getParentPageId());
            formView.showForm(formShowParameter);
            SessionManager sessionManager = SessionManager.getCurrent();
            IPageCache pageCache = sessionManager.getPageCache(pageId);
            String simpleName = FormShowParameter.class.getSimpleName();
            String parameter = pageCache.get(simpleName);
            if (StringUtils.isNotBlank((CharSequence)parameter)) {
                FormShowParameter showParameter = FormShowParameter.fromJsonString((String)parameter);
                showParameter.getOpenStyle().setClientShowType(ShowType.NewTabPage);
                showParameter.getOpenStyle().setTargetKey("tabap");
                pageCache.put(simpleName, FormShowParameter.toJsonString((FormShowParameter)showParameter));
            }
        } else {
            formView.showForm(formShowParameter);
        }
    }
}

