/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.component;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.util.CacheHelper;
import org.apache.commons.lang.StringUtils;

public class ComponentResponseHandler {
    public static MsgResponse handleComponentIssueInvoiceResponse(JSONObject jsonObject) {
        String errCode = jsonObject.getString("errcode");
        String description = jsonObject.getString("description");
        MsgResponse msgResponse = new MsgResponse();
        msgResponse.setErrorCode(errCode);
        msgResponse.setErrorMsg(description);
        if ("0".equals(errCode) || ErrorType.SUCCESS.getCode().equals(errCode) || "7011".equals(errCode)) {
            msgResponse.setErrorCode(ErrorType.SUCCESS.getCode());
            JSONArray jsonArray = jsonObject.getJSONArray("lists");
            if (jsonArray != null && jsonArray.size() > 0) {
                JSONObject dataObj = jsonArray.getJSONObject(0);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("checkcode", dataObj.getString("jym"));
                map.put("invoicecode", dataObj.getString("fpdm"));
                map.put("invoiceno", dataObj.getString("fphm"));
                map.put("issuetime", dataObj.getString("kprq"));
                map.put("fileurl", dataObj.getString("pdfurl"));
                map.put("skm", jsonObject.getString("secret"));
                map.put("snapshoturl", "");
                msgResponse.setRespData(JSONObject.toJSONString(map));
            }
        } else {
            if (StringUtils.isNotBlank((String)description)) {
                if (description.contains("\u5f00\u7968\u8bbe\u5907\u4e0d\u5728\u7ebf")) {
                    CacheHelper.remove("dim_sync_config");
                }
                if (description.contains("<returnmsg>")) {
                    description = description.substring(description.indexOf("<returnmsg>") + 11, description.indexOf("</returnmsg>"));
                }
                msgResponse.setErrorMsg(description);
            }
            msgResponse.setErrorCode("9999");
        }
        return msgResponse;
    }
}

