/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.enums;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.imc.bdm.common.constant.MultiLangEnumBridge;

public enum SmsBillStatusEnum {
    UNCOMMIT_AUDIT(1, new MultiLangEnumBridge("\u672a\u63d0\u4ea4", "SmsBillStatusEnum_0", "imc-bdm-common")),
    AUDITTING(2, new MultiLangEnumBridge("\u5ba1\u6838\u4e2d", "SmsBillStatusEnum_1", "imc-bdm-common")),
    AUDIT_SUCCESS(3, new MultiLangEnumBridge("\u5ba1\u6838\u6210\u529f", "SmsBillStatusEnum_2", "imc-bdm-common")),
    AUDIT_FAIL(4, new MultiLangEnumBridge("\u5ba1\u6838\u5931\u8d25", "SmsBillStatusEnum_3", "imc-bdm-common"));

    private int status;
    private MultiLangEnumBridge bridge;

    private SmsBillStatusEnum(int status, MultiLangEnumBridge bridge) {
        this.status = status;
        this.bridge = bridge;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusText() {
        return String.valueOf(this.status);
    }

    public String getDescription() {
        return this.bridge.loadKDString();
    }

    public static boolean submitAudit(String billStatus) {
        SmsBillStatusEnum[] values;
        SmsBillStatusEnum billStatusEnum = null;
        for (SmsBillStatusEnum value : values = SmsBillStatusEnum.values()) {
            if (!String.valueOf(value.getStatus()).equals(billStatus)) continue;
            billStatusEnum = value;
            break;
        }
        return UNCOMMIT_AUDIT == billStatusEnum || AUDIT_FAIL == billStatusEnum;
    }

    public static String getDescription(String status) {
        if (StringUtils.isEmpty((CharSequence)status)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5ba1\u6838\u72b6\u6001\u4e3a\u7a7a", (String)"SmsBillStatusEnum_4", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        try {
            Integer statusInt = Integer.parseInt(status);
            return SmsBillStatusEnum.getDescription(statusInt);
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5ba1\u6838\u72b6\u6001:%s\u4e0d\u5b58\u5728", (String)"SmsBillStatusEnum_5", (String)"imc-bdm-common", (Object[])new Object[0]), status));
        }
    }

    public static String getDescription(Integer status) {
        SmsBillStatusEnum[] values;
        if (null == status) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5ba1\u6838\u72b6\u6001\u4e3a\u7a7a", (String)"SmsBillStatusEnum_4", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        for (SmsBillStatusEnum value : values = SmsBillStatusEnum.values()) {
            if (value.getStatus() != status.intValue()) continue;
            return value.getDescription();
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5ba1\u6838\u72b6\u6001:%s\u4e0d\u5b58\u5728", (String)"SmsBillStatusEnum_5", (String)"imc-bdm-common", (Object[])new Object[0]), status));
    }
}

