/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.enums;

import kd.bos.dataentity.utils.StringUtils;
import kd.imc.bdm.common.constant.MultiLangEnumBridge;

public enum SmsSignatureStatusEnum {
    INIT(0, new MultiLangEnumBridge("\u521d\u59cb\u5316", "SmsSignatureStatusEnum_0", "imc-bdm-common")),
    AUDITTING(1, new MultiLangEnumBridge("\u5ba1\u6838\u4e2d", "SmsSignatureStatusEnum_1", "imc-bdm-common")),
    AUDIT_SUCCESS(2, new MultiLangEnumBridge("\u5ba1\u6838\u6210\u529f", "SmsSignatureStatusEnum_2", "imc-bdm-common")),
    AUDIT_FAIL(3, new MultiLangEnumBridge("\u5ba1\u6838\u5931\u8d25", "SmsSignatureStatusEnum_3", "imc-bdm-common"));

    private int status;
    private MultiLangEnumBridge bridge;

    private SmsSignatureStatusEnum(int status, MultiLangEnumBridge bridge) {
        this.status = status;
        this.bridge = bridge;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusText() {
        return String.valueOf(this.status);
    }

    public String getDescription() {
        return this.bridge.loadKDString();
    }

    public static boolean validStatus(String status) {
        if (StringUtils.isEmpty((CharSequence)status)) {
            return false;
        }
        try {
            Integer statusInt = Integer.parseInt(status);
            return SmsSignatureStatusEnum.validStatus(statusInt);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static boolean validStatus(Integer status) {
        if (null == status) {
            return false;
        }
        return AUDIT_SUCCESS.getStatus() == status.intValue();
    }

    private static boolean cannotSubmit(Integer status) {
        if (null == status) {
            return false;
        }
        return AUDIT_SUCCESS.getStatus() == status.intValue() || AUDITTING.getStatus() == status.intValue();
    }

    public static boolean cannotSubmit(String status) {
        if (StringUtils.isEmpty((CharSequence)status)) {
            return false;
        }
        try {
            Integer statusInt = Integer.parseInt(status);
            return SmsSignatureStatusEnum.cannotSubmit(statusInt);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

