/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.constant.allele.AllEleLonType;
import kd.imc.bdm.common.dto.allele.AllEleInvoiceApplyAsyncRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleInvoiceQueryAsyncRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleLoginRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleLoginResponseDTO;
import kd.imc.bdm.common.dto.allele.AllElePaperInvoiceCancelRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleRedApplyQueryAsyncRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseListDTO;
import kd.imc.bdm.common.dto.allele.AllEleVehicleResponseDTO;
import kd.imc.bdm.common.dto.aws.AwsConfigDTO;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.ComponentServiceHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.helper.LeqiCombineHelper;
import kd.imc.bdm.common.helper.honortest.AllEleDownLoadHonorDTO;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.service.ApiLogService;
import kd.imc.bdm.common.service.AwsFpyService;
import kd.imc.bdm.common.util.AES128;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.HttpUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.RandomString;
import kd.imc.bdm.common.util.UUID;
import kd.imc.bdm.common.util.ViewUtil;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.NoHttpResponseException;
import org.apache.http.conn.ConnectTimeoutException;

public class AllEleServiceHelper {
    public static final String BDM_TAX_LOGIN = "bdm_tax_login";
    private static final Log LOGGER = LogFactory.getLog(AllEleServiceHelper.class);
    public static final String accessToken = "accessToken_";
    public static final String creditQuota = "creditQuota_";
    public static final String totalCreditQuota = "totalCreditQuota_";
    public static final String TEST_CONFIRM_NO = "1234567890";
    private static final ImmutableSet<String> COMBINE_IGNORE_URL = new ImmutableSet.Builder().add((Object)AllEleInterfaceTypeEnum.GET_LOGIN_STATUS.getRequestPath()).add((Object)AllEleInterfaceTypeEnum.LOGIN_CHECK.getRequestPath()).add((Object)AllEleInterfaceTypeEnum.QUERY_INVOICE_BY_ORDERNO.getRequestPath()).build();
    private static final ImmutableSet<String> IGNORE_DATA_URL = new ImmutableSet.Builder().add((Object)AllEleInterfaceTypeEnum.ADD_OR_UPDATE_ACCOUNT.getRequestPath()).add((Object)AllEleInterfaceTypeEnum.ASYNC_ACCOUNT_QUERY.getRequestPath()).build();

    public static String getAwsAccessToken(String taxNo) {
        String accessToken;
        String accessTokenCacheKey = accessToken + taxNo;
        String accessTokenCache = CacheHelper.get(accessTokenCacheKey);
        if (StringUtils.isNotBlank((String)accessTokenCache)) {
            return accessTokenCache;
        }
        AwsConfigDTO awsConfig = AllEleServiceHelper.getAwsConfig(taxNo);
        AwsFpyService awsFpyService = AwsFpyService.newInstance();
        try {
            accessToken = awsFpyService.getAccessToken(awsConfig.getClientId(), awsConfig.getClientSecret());
            CacheHelper.put(accessTokenCacheKey, accessToken, 86400);
        }
        catch (Exception e) {
            throw new MsgException(ErrorType.FAIL.getCode(), e.getMessage());
        }
        return accessToken;
    }

    public static AwsConfigDTO getAwsConfig(String taxNo) {
        QFilter filter = new QFilter("taxno", "=", (Object)taxNo);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bdm_einvoice_account", (String)"clientid,clientsecret,encryptkey", (QFilter[])filter.toArray());
        if (dynamicObject == null) {
            throw new MsgException(String.format(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u7a0e\u53f7%s\u7684aws\u79df\u6237\u4fe1\u606f\uff0c\u8bf7\u524d\u5f80\u53d1\u7968\u4e91\u300b\u57fa\u7840\u8d44\u6599\u300b\u4f01\u4e1a\u7ba1\u7406\u300b\u6570\u7535\u914d\u7f6e\u5217\u8868\uff0c\u8fdb\u884c\u5347\u7ea7\u6570\u7535\u53d1\u7968", (String)"AllEleServiceHelper_0", (String)"imc-bdm-common", (Object[])new Object[0]), taxNo));
        }
        String clientId = dynamicObject.getString("clientid");
        if (StringUtils.isBlank((String)clientId)) {
            throw new MsgException(String.format(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u7a0e\u53f7%s\u7684aws\u79df\u6237\u4fe1\u606f\uff0c\u8bf7\u524d\u5f80\u53d1\u7968\u4e91\u300b\u57fa\u7840\u8d44\u6599\u300b\u4f01\u4e1a\u7ba1\u7406\u300b\u6570\u7535\u914d\u7f6e\u5217\u8868\uff0c\u8fdb\u884c\u66f4\u65b0\u6216\u8005\u5bfc\u5165\u6fc0\u6d3b\u7801(\u5df2\u5bfc\u5165\u5bf9\u5e94\u4f01\u4e1a\u7684\u6fc0\u6d3b\u7801\u9009\u62e9\u66f4\u65b0\uff0c\u672a\u5bfc\u5165\u9009\u62e9\u5bfc\u5165\u6fc0\u6d3b\u7801)", (String)"AllEleServiceHelper_1", (String)"imc-bdm-common", (Object[])new Object[0]), taxNo));
        }
        AwsConfigDTO awsConfig = new AwsConfigDTO();
        awsConfig.setClientId(clientId);
        awsConfig.setClientSecret(dynamicObject.getString("clientsecret"));
        awsConfig.setEncryptKey(dynamicObject.getString("encryptkey"));
        return awsConfig;
    }

    private static String getWebSocketUrl(String taxNo, AllEleRequestDTO request) {
        StringBuilder urlBuilder = new StringBuilder(AwsFpyService.newInstance().getBaseUrl());
        if ("2".equals(request.getChannelType()) && !COMBINE_IGNORE_URL.contains((Object)request.getRequest_path())) {
            LOGGER.info("requestParam:" + JSONObject.toJSONString((Object)request));
            urlBuilder.append(request.getCombinePatch()).append('?').append("taxNo=").append(taxNo).append('&').append("access_token=").append(AllEleServiceHelper.getAwsAccessToken(taxNo)).append('&').append("reqid=").append(RequestContext.get().getTraceId()).append('-').append(RandomString.nextString(6, false, false));
            return urlBuilder.toString();
        }
        urlBuilder.append(AllEleInterfaceTypeEnum.getVersionByRequestPath(request.getRequest_path()));
        urlBuilder.append('?').append("taxNo=").append(taxNo);
        urlBuilder.append("&fpdk_type=4");
        urlBuilder.append('&').append("access_token=").append(AllEleServiceHelper.getAwsAccessToken(taxNo));
        urlBuilder.append('&').append("reqid=").append(RequestContext.get().getTraceId()).append('-').append(RandomString.nextString(6, false, false));
        if (StringUtils.isNotBlank((String)request.getOperationType())) {
            urlBuilder.append('&').append("operationType=").append(request.getOperationType());
        } else {
            urlBuilder.append('&').append("operationType=1");
        }
        return urlBuilder.toString();
    }

    public static AllEleResponseDTO<AllEleLoginResponseDTO> eleLogin(String taxNo, AllEleInterfaceTypeEnum eleInterface, String account) {
        AllEleLoginRequestDTO eleIssue = new AllEleLoginRequestDTO();
        eleIssue.setRequest_path(eleInterface.getRequestPath());
        eleIssue.setCheckAuth(Boolean.TRUE);
        eleIssue.setAccount(account);
        return AllEleServiceHelper.eleLogin(taxNo, eleIssue);
    }

    public static AllEleResponseDTO<AllEleLoginResponseDTO> eleLogin(String taxNo, AllEleLoginRequestDTO eleIssue) {
        return AllEleServiceHelper.doPost(taxNo, eleIssue, AllEleLoginResponseDTO.class);
    }

    public static <T> AllEleResponseDTO<T> doPost(String taxNo, AllEleRequestDTO request, Class<T> clazz) {
        return AllEleServiceHelper.requestWebSocket(taxNo, request, clazz, "POST", null);
    }

    public static <T> AllEleResponseDTO<T> doGet(String taxNo, AllEleRequestDTO request, Class<T> clazz, Map<String, String> queryParams) {
        return AllEleServiceHelper.requestWebSocket(taxNo, request, clazz, "GET", queryParams);
    }

    private static <T> AllEleResponseDTO<T> requestWebSocket(String taxNo, AllEleRequestDTO request, Class<T> clazz, String methodName, Map<String, String> queryParams) {
        try {
            String serviceConfig;
            boolean isVirtual;
            if (EnterpriseHelper.isLeqiCombineChannel(taxNo)) {
                EnterpriseHelper.fillLeqiInfo(taxNo, request);
                request = LeqiCombineHelper.covertRequest2LeqiCobineRequest(request);
            }
            String response = (isVirtual = StringUtils.isNotBlank((String)ImcConfigUtil.getValue("all_ele_mock_invoice", taxNo))) ? AllEleServiceHelper.virtualAllEle(request, taxNo, queryParams) : AllEleServiceHelper.getClientResponse(taxNo, request, StringUtils.isNotBlank((String)(serviceConfig = ImcConfigUtil.getValue("bdm_ek_service", "AllEleService"))) ? serviceConfig : AllEleServiceHelper.getWebSocketUrl(taxNo, request), methodName, queryParams);
            JSONObject jsonObject = JSONObject.parseObject((String)response);
            Object obj = null;
            if (jsonObject.containsKey((Object)"data")) {
                obj = JSONObject.parseObject((String)jsonObject.getString("data"), clazz);
            }
            if (!ErrorType.SUCCESS.getCode().equals(jsonObject.getString("errcode"))) {
                AllEleServiceHelper.clearCache(jsonObject, taxNo);
            }
            return new AllEleResponseDTO<Object>(isVirtual, jsonObject.getString("errcode"), jsonObject.getString("description"), obj);
        }
        catch (MsgException e) {
            return new AllEleResponseDTO("rpa9999", e.getErrorMsg());
        }
        catch (KDBizException e) {
            return new AllEleResponseDTO("rpa9999", e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("do component request error,caused by ", (Throwable)e);
            return new AllEleResponseDTO("rpa9999", String.format(ResManager.loadKDString((String)"\u5185\u90e8\u5904\u7406\u5f02\u5e38\uff0ctraceid\u4e3a[%s]", (String)"AllEleServiceHelper_2", (String)"imc-bdm-common", (Object[])new Object[0]), RequestContext.get().getTraceId()));
        }
    }

    public static <T> AllEleResponseListDTO<T> doPostList(String taxNo, AllEleRequestDTO request, Class<T> clazz) {
        try {
            String serviceConfig;
            if (EnterpriseHelper.isLeqiCombineChannel(taxNo)) {
                EnterpriseHelper.fillLeqiInfo(taxNo, request);
                request = LeqiCombineHelper.covertRequest2LeqiCobineRequest(request);
            }
            String response = StringUtils.isNotBlank((String)ImcConfigUtil.getValue("all_ele_mock_invoice", taxNo)) ? AllEleServiceHelper.virtualAllEle(request, taxNo, new HashMap<String, String>(1)) : AllEleServiceHelper.getClientResponse(taxNo, request, StringUtils.isNotBlank((String)(serviceConfig = ImcConfigUtil.getValue("bdm_ek_service", "AllEleService"))) ? serviceConfig : AllEleServiceHelper.getWebSocketUrl(taxNo, request), "POST", null);
            AllEleResponseListDTO responseDTO = (AllEleResponseListDTO)JSONObject.parseObject((String)response, AllEleResponseListDTO.class);
            JSONObject jsonObject = JSONObject.parseObject((String)response);
            if (!ErrorType.SUCCESS.getCode().equals(jsonObject.getString("errcode"))) {
                AllEleServiceHelper.clearCache(jsonObject, taxNo);
            } else if (jsonObject.containsKey((Object)"data")) {
                responseDTO.setData(JSONObject.parseArray((String)jsonObject.getString("data"), clazz));
            }
            return responseDTO;
        }
        catch (MsgException e) {
            return new AllEleResponseListDTO("9999", e.getErrorMsg());
        }
        catch (KDBizException e) {
            return new AllEleResponseListDTO("9999", e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("do component request error,caused by ", (Throwable)e);
            return new AllEleResponseListDTO("9999", String.format(ResManager.loadKDString((String)"\u5185\u90e8\u5904\u7406\u5f02\u5e38\uff0ctraceid\u4e3a[%s]", (String)"AllEleServiceHelper_2", (String)"imc-bdm-common", (Object[])new Object[0]), RequestContext.get().getTraceId()));
        }
    }

    private static String getClientResponse(String taxNo, AllEleRequestDTO request, String requestUrl, String methodName, Map<String, String> queryParams) {
        try {
            String response;
            if (requestUrl.contains(",")) {
                String[] configs = requestUrl.split(",");
                HashMap<String, Object> param = new HashMap<String, Object>(4);
                param.put("taxNo", taxNo);
                param.put("AllEleRequestDTO", JSONObject.toJSON((Object)request));
                param.put("queryParams", queryParams);
                Object reulst = DispatchServiceHelper.invokeService((String)configs[0], (String)configs[1], (String)configs[2], (String)configs[3], (Object[])new Object[]{param});
                String response2 = reulst instanceof String ? (String)reulst : JSONObject.toJSONString((Object)reulst);
                return response2;
            }
            if (AllEleInterfaceTypeEnum.GET_LOGIN_STATUS.getRequestPath().equals(request.getRequest_path())) {
                AllEleLoginRequestDTO login = (AllEleLoginRequestDTO)request;
                if (!requestUrl.contains("&name=")) {
                    requestUrl = requestUrl + "&name=" + login.getLongLinkName();
                }
            } else if (AllEleInterfaceTypeEnum.QUERY_CREDIT_QUOTA.getRequestPath().equals(request.getRequest_path())) {
                requestUrl = requestUrl + "&disableCache=true";
            }
            AwsConfigDTO awsConfig = AllEleServiceHelper.getAwsConfig(taxNo);
            DynamicObject account = AllEleAuthHelper.getAccountByTaxNo(taxNo);
            if (account == null) {
                throw new MsgException(String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:[%s]\u672a\u67e5\u8be2\u5230\u8d26\u53f7\u4fe1\u606f\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599-\u4f01\u4e1a\u7ba1\u7406-\u6570\u7535\u914d\u7f6e\u8fdb\u884c\u76f8\u5173\u914d\u7f6e", (String)"AllEleServiceHelper_3", (String)"imc-bdm-common", (Object[])new Object[0]), taxNo));
            }
            if (StringUtils.isBlank((String)request.getAccount()) && StringUtils.isBlank((String)request.getOptionAccountList())) {
                String defaultAccount = AllEleAuthHelper.getEpDefaultAccount(account, true, request.isHistorySync());
                if (StringUtils.isBlank((String)defaultAccount)) {
                    Map accountList = (Map)AllEleAuthHelper.getAccountList(account, true).getValue();
                    if (accountList == null || accountList.size() == 0 || StringUtils.isEmpty((String)((String)accountList.values().iterator().next()))) {
                        throw new MsgException(String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:[%s]\u672a\u67e5\u8be2\u5230\u53ef\u7528\u7684\u6570\u7535\u8d26\u53f7\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599-\u4f01\u4e1a\u7ba1\u7406-\u6570\u7535\u914d\u7f6e\u8fdb\u884c\u76f8\u5173\u914d\u7f6e", (String)"AllEleServiceHelper_4", (String)"imc-bdm-common", (Object[])new Object[0]), taxNo));
                    }
                    request.setAccount((String)accountList.values().iterator().next());
                } else {
                    request.setAccount(defaultAccount);
                }
            }
            String requestStr = JSONObject.toJSONString((Object)request);
            ApiLogService apiLogService = new ApiLogService(request.getRequest_path(), requestUrl, requestStr);
            String req = AES128.ecbEncrypt(requestStr, awsConfig.getEncryptKey());
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("\u6570\u7535\u7ec4\u4ef6\u8bf7\u6c42\u7a0e\u53f7[%s],\u8bf7\u6c42\u63a5\u53e3[%s],\u8bf7\u6c42\u6570\u636e:[%s] ", taxNo, request.getRequest_path(), requestStr));
            }
            JSONObject requestJson = new JSONObject();
            requestJson.put("data", (Object)req);
            String body = requestJson.toJSONString();
            if (IGNORE_DATA_URL.contains((Object)request.getRequest_path()) || "2".equals(request.getChannelType()) && !COMBINE_IGNORE_URL.contains((Object)request.getRequest_path())) {
                body = req;
            }
            int readTime = ComponentServiceHelper.getReadTime();
            boolean isSaveLog = true;
            if ("GET".equals(methodName)) {
                response = HttpUtil.doGet(requestUrl, null, queryParams, null);
                if (AllEleInterfaceTypeEnum.ASYNC_ISSUE_INVOICE_QUERY.getRequestPath().equals(request.getRequest_path()) && StringUtils.isNotBlank((String)response) && response.contains("1304")) {
                    isSaveLog = false;
                } else if (AllEleInterfaceTypeEnum.GET_LOGIN_STATUS.getRequestPath().equals(request.getRequest_path())) {
                    isSaveLog = false;
                } else if (AllEleInterfaceTypeEnum.LOGIN_CHECK.getRequestPath().equals(request.getRequest_path())) {
                    isSaveLog = false;
                }
            } else {
                response = HttpUtil.doPostJson(requestUrl, null, body, readTime, readTime);
            }
            if (isSaveLog) {
                apiLogService.saveLog(response);
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("\u6570\u7535\u7ec4\u4ef6\u8bf7\u6c42\u7a0e\u53f7[%s],\u8bf7\u6c42\u63a5\u53e3[%s],\u8fd4\u56de\u6570\u636e:[%s]", taxNo, request.getRequest_path(), response));
            }
            if (StringUtils.isEmpty((String)response)) {
                throw new MsgException(ResManager.loadKDString((String)"\u4e0e\u7a0e\u63a7\u7cfb\u7edf\u901a\u8baf\u5931\u8d25\uff0c\u4e3a\u4fdd\u8bc1\u6570\u636e\u4e00\u81f4\uff0c\u8bf7\u91cd\u8bd5", (String)"AllEleServiceHelper_7", (String)"imc-bdm-common", (Object[])new Object[0]));
            }
            return response;
        }
        catch (NoHttpResponseException e) {
            LOGGER.error("do component request error,caused by ", (Throwable)e);
            throw new MsgException(ResManager.loadKDString((String)"NoHttpResponseException,\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"AllEleServiceHelper_8", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        catch (ConnectTimeoutException e) {
            LOGGER.error("do component request error,caused by ", (Throwable)e);
            throw new MsgException(ResManager.loadKDString((String)"\u8fde\u63a5\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"AllEleServiceHelper_9", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        catch (SocketTimeoutException e) {
            LOGGER.error("do component request error,caused by ", (Throwable)e);
            throw new MsgException(ResManager.loadKDString((String)"\u54cd\u5e94\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"AllEleServiceHelper_10", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        catch (MsgException e) {
            LOGGER.error("excepiton,caused by ", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("excepiton,caused by ", (Throwable)e);
            throw new MsgException(String.format(ResManager.loadKDString((String)"\u5185\u90e8\u5904\u7406\u5f02\u5e38\uff0ctraceid\u4e3a[%s]", (String)"AllEleServiceHelper_2", (String)"imc-bdm-common", (Object[])new Object[0]), RequestContext.get().getTraceId()));
        }
    }

    private static void clearCache(JSONObject jsonObject, String taxNo) {
        String description = jsonObject.getString("description");
        if (StringUtils.isNotBlank((String)description) && description.contains(ResManager.loadKDString((String)"token\u5df2\u7ecf\u5931\u6548", (String)"AllEleServiceHelper_11", (String)"imc-bdm-common", (Object[])new Object[0]))) {
            CacheHelper.remove(accessToken + taxNo);
        }
    }

    public static String virtualAllEle(AllEleRequestDTO request, String taxNo, Map<String, String> queryParams) {
        JSONObject dataJson;
        JSONObject applyRequestJson;
        JSONObject applyJson;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("\u6570\u7535mock\u8bf7\u6c42\u7a0e\u53f7[%s],\u8bf7\u6c42\u63a5\u53e3[%s],\u8bf7\u6c42\u6570\u636e:[%s] ", taxNo, request.getRequest_path(), JSONObject.toJSONString((Object)request)));
        }
        JSONObject json = new JSONObject();
        json.put("errcode", (Object)ErrorType.SUCCESS.getCode());
        String jsonStr = "";
        JSONObject data = new JSONObject();
        String jsonFileName = AllEleInterfaceTypeEnum.getDescByRequestPath(request.getRequest_path());
        if (request instanceof AllEleInvoiceApplyAsyncRequestDTO && (((AllEleInvoiceApplyAsyncRequestDTO)request).getInvoiceTypes().contains(12) || ((AllEleInvoiceApplyAsyncRequestDTO)request).getInvoiceTypes().contains(83))) {
            jsonFileName = jsonFileName + "Vehicle";
        }
        if (request instanceof AllEleInvoiceQueryAsyncRequestDTO && ((AllEleInvoiceQueryAsyncRequestDTO)request).getBatchNo().contains("Vehicle")) {
            jsonFileName = jsonFileName + "Vehicle";
        }
        try (InputStream inStream2 = Thread.currentThread().getContextClassLoader().getResourceAsStream("elemock/" + jsonFileName + ".json");){
            if (inStream2 != null) {
                jsonStr = IOUtils.toString((InputStream)inStream2, (String)"utf-8");
            }
        }
        catch (IOException inStream2) {
            // empty catch block
        }
        if (AllEleInterfaceTypeEnum.OPEN_INVOICE.getRequestPath().equals(request.getRequest_path())) {
            QFilter filter;
            DynamicObject redDynamic;
            JSONObject issueInvoiceJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)request));
            if ((StringUtils.contains((String)issueInvoiceJson.getString("redConfirmBillNo"), (String)"066574780154360004") || StringUtils.contains((String)issueInvoiceJson.getString("originalInvoiceNo"), (String)"06657478015436000")) && (redDynamic = BusinessDataServiceHelper.loadSingle((String)"sim_red_confirm_bill", (String)"confirmstatus", (QFilter[])(filter = new QFilter("number", "=", (Object)issueInvoiceJson.getString("redConfirmBillNo"))).toArray())) != null && !StringUtils.equals((String)redDynamic.getString("confirmstatus"), (String)"01") && !StringUtils.equals((String)redDynamic.getString("confirmstatus"), (String)"04")) {
                json.put("errcode", (Object)ErrorType.RPA_CONFIRM_STATUS_ERROR.getCode());
                json.put("description", (Object)String.format(ResManager.loadKDString((String)"\u5f00\u7968\u5931\u8d25\uff0c\u5f53\u524d\u7ea2\u5b57\u53d1\u7968\u786e\u8ba4\u5355\u72b6\u6001\u4e3a\uff1a%s", (String)"AllEleServiceHelper_12", (String)"imc-bdm-common", (Object[])new Object[0]), AllEleServiceHelper.getConfirmInfo(redDynamic.getString("confirmstatus"))));
                return json.toJSONString();
            }
            JSONObject issueJson = JSONObject.parseObject((String)jsonStr);
            issueJson.put("serialNo", (Object)issueInvoiceJson.getString("serialNo"));
            issueJson.put("batchNo", (Object)issueInvoiceJson.getString("serialNo"));
            if ("1".equals(ImcConfigUtil.getValue("mockOpenInvoiceFail", "mockOpenInvoiceFail"))) {
                json.put("errcode", (Object)ErrorType.FAIL.getCode());
                json.put("description", (Object)"mockOpenInvoiceErrormockOpenInvoiceErrormockOpenInvoiceErrormockOpenInvoiceErrormockOpenInvoiceErrormockOpenInvoiceErrormockOpenInvoiceErrormockOpenInvoiceErrormockOpenInvoiceErrormockOpenInvoiceErrormockOpenInvoiceErrormockOpenInvoiceErrormockOpenInvoiceErrormockOpenInvoiceErrormockOpenInvoiceErrormockOpenInvoiceErrormockOpenInvoiceErrormockOpenInvoiceErrormockOpenInvoiceErrormockOpenInvoiceErrormockOpenInvoiceErrormockOpenInvoiceErrormockOpenInvoiceErrormockOpenInvoiceErrormockOpenInvoiceErrormockOpenInvoiceErrormockOpenInvoiceErrormockOpenInvoiceErrormockOpenInvoiceErrormockOpenInvoiceError");
            }
            jsonStr = issueJson.toJSONString();
        } else if (AllEleInterfaceTypeEnum.ASYNC_ISSUE_INVOICE_QUERY.getRequestPath().equals(request.getRequest_path()) || AllEleInterfaceTypeEnum.ASYNC_ISSUE_INVOICE_QUERY.getCombinePath().equals(request.getCombinePatch())) {
            int i;
            String creditQuotaStr = CacheHelper.get(creditQuota + taxNo);
            BigDecimal creditQuota = StringUtils.isNotBlank((String)creditQuotaStr) ? new BigDecimal(creditQuotaStr.replaceAll(",", "")) : new BigDecimal("999999999.99");
            boolean isLeqiCombine = AllEleInterfaceTypeEnum.ASYNC_ISSUE_INVOICE_QUERY.getCombinePath().equals(request.getCombinePatch());
            JSONObject responseJson = JSONObject.parseObject((String)jsonStr);
            String serialNo = null;
            if (isLeqiCombine) {
                serialNo = request.getBatchNo();
                responseJson.put("govSerialNo", (Object)request.getBatchNo());
            } else {
                serialNo = queryParams.get("serialNo");
                responseJson.put("govSerialNo", (Object)queryParams.get("serialNo"));
            }
            DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "id", "invoiceamount", "invoicetype"), (QFilter[])new QFilter("orderno", "=", (Object)serialNo).toArray());
            if (null == invoice) {
                invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice_vehicles", (String)String.join((CharSequence)",", "id", "invoiceamount", "invoicetype"), (QFilter[])new QFilter("orderno", "=", (Object)serialNo).toArray());
            }
            String invoiceIdStr = String.valueOf(invoice.getLong("id"));
            StringBuilder invoiceNo = new StringBuilder(invoiceIdStr);
            if (invoiceIdStr.length() < 20) {
                for (i = 0; i < 20 - invoiceIdStr.length(); ++i) {
                    invoiceNo.append('0');
                }
            }
            responseJson.put("invoiceNo", (Object)invoiceNo.substring(0, 20));
            responseJson.put("invoiceDate", (Object)DateUtils.format(new Date(), "yyyy-MM-dd HH:mm:ss"));
            responseJson.put("availableVolume", (Object)creditQuota.subtract(invoice.getBigDecimal("invoiceamount").abs()));
            responseJson.put("drawer", (Object)ResManager.loadKDString((String)"\u865a\u62df\u5f00\u7968", (String)"AllEleServiceHelper_13", (String)"imc-bdm-common", (Object[])new Object[0]));
            if (InvoiceUtils.isPaperInvoice(invoice.getString("invoicetype")) && invoice.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) > 0 || InvoiceUtils.isAllEVehicleInv(invoice.getString("invoicetype")) || InvoiceUtils.isUsedCarInvoice(invoice.getString("invoicetype"))) {
                responseJson.put("etaxInvoiceNo", (Object)invoiceNo);
                responseJson.put("invoiceCode", (Object)invoiceNo.substring(0, 12));
                responseJson.put("invoiceNo", (Object)invoiceNo.substring(12));
            }
            if (InvoiceUtils.isAllEVehicleOrAllEUsedCar(invoice.getString("invoicetype"))) {
                invoiceIdStr = String.valueOf(invoice.getLong("id"));
                invoiceNo = new StringBuilder(invoiceIdStr);
                if (invoiceIdStr.length() < 20) {
                    for (i = 0; i < 20 - invoiceIdStr.length(); ++i) {
                        invoiceNo.append('0');
                    }
                }
                responseJson.put("etaxInvoiceNo", null);
                responseJson.put("invoiceCode", null);
                responseJson.put("invoiceNo", (Object)String.valueOf(invoiceNo).substring(0, 20));
            }
            if ("1".equals(ImcConfigUtil.getValue("mockAsyncQueryFail", "mockAsyncQueryFail"))) {
                json.put("errcode", (Object)ErrorType.FAIL.getCode());
                json.put("description", (Object)"mockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockErrormockError");
            }
            if (InvoiceUtils.isAllEVehicleOrAllEUsedCar(invoice.getString("invoicetype"))) {
                responseJson.put("fileurl", (Object)"http://wewewerrrr");
                responseJson.put("xmlfileurl", (Object)"http://wewewerrrr");
                responseJson.put("pdffileurl", (Object)"http://wewewerrrr");
                responseJson.put("snapshoturl", (Object)"http://wewewerrrr");
                if ("1".equals(ImcConfigUtil.getValue("mockVehicleUrl", "mockVehicleUrl"))) {
                    responseJson.put("fileurl", (Object)"https://api-sit.piaozone.com/doc/free/fileInfo/preview/nf1387081904424148992");
                    responseJson.put("xmlfileurl", (Object)"https://api-sit.piaozone.com/doc/free/fileInfo/preview/nf1387081894311682048");
                    responseJson.put("pdffileurl", (Object)"https://api-sit.piaozone.com/doc/free/fileInfo/preview/nf1387081894311682048");
                    responseJson.put("snapshoturl", (Object)"https://api-sit.piaozone.com/doc/free/fileInfo/preview/ns2025061387081932416933888");
                }
            }
            jsonStr = responseJson.toJSONString();
        } else if (AllEleInterfaceTypeEnum.RED_CONFIRM_BILL_APPLY.getCombinePath().equals(request.getCombinePatch())) {
            applyJson = JSONObject.parseObject((String)jsonStr);
            applyJson.put("batchNo", (Object)RandomString.nextString(20, false, false));
            jsonStr = applyJson.toJSONString();
        } else if (AllEleInterfaceTypeEnum.RED_CONFIRM_RESULT_QUERY.getCombinePath().equals(request.getCombinePatch())) {
            applyJson = new JSONObject();
            applyRequestJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)request));
            String status = "01";
            DynamicObject redConfirm = QueryServiceHelper.queryOne((String)"sim_red_confirm_bill", (String)String.join((CharSequence)",", "enteridentity", "buyertaxno", "salertaxno"), (QFilter[])new QFilter("orderno", "=", (Object)applyRequestJson.getString("orderNo")).toArray());
            if (redConfirm != null) {
                String buyerTaxNo = redConfirm.getString("buyertaxno");
                if ("1".equals(redConfirm.getString("enteridentity"))) {
                    buyerTaxNo = redConfirm.getString("salertaxno");
                }
                if (QueryServiceHelper.exists((String)"bdm_enterprise_baseinfo", (QFilter[])new QFilter("number", "=", (Object)buyerTaxNo).toArray())) {
                    status = "02";
                    if ("1".equals(redConfirm.getString("enteridentity"))) {
                        status = "03";
                    }
                }
            }
            applyJson.put("govRedConfirmBillUuid", (Object)RandomString.nextString(20, false, false));
            applyJson.put("redConfirmBillNo", (Object)(TEST_CONFIRM_NO + RandomString.nextString(10, true, false)));
            applyJson.put("redConfirmEnterDate", (Object)DateUtils.format(new Date(), "yyyy-MM-dd HH:mm:ss"));
            applyJson.put("redConfirmBillStatus", (Object)status);
            jsonStr = applyJson.toJSONString();
        } else if (AllEleInterfaceTypeEnum.RED_CONFIRM_BILL_APPLY.getRequestPath().equals(request.getRequest_path())) {
            DynamicObject redConfirm;
            applyJson = JSONObject.parseObject((String)jsonStr);
            applyRequestJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)request));
            if (InvoiceType.ALL_E_SPECIAL.getBaseCode().equals(applyRequestJson.getString("invoiceType")) && (redConfirm = QueryServiceHelper.queryOne((String)"sim_red_confirm_bill", (String)String.join((CharSequence)",", "enteridentity", "buyertaxno", "salertaxno"), (QFilter[])new QFilter("orderno", "=", (Object)applyRequestJson.getString("serialNo")).toArray())) != null) {
                String buyerTaxNo = redConfirm.getString("buyertaxno");
                if ("1".equals(redConfirm.getString("enteridentity"))) {
                    buyerTaxNo = redConfirm.getString("salertaxno");
                }
                if (QueryServiceHelper.exists((String)"bdm_enterprise_baseinfo", (QFilter[])new QFilter("number", "=", (Object)buyerTaxNo).toArray())) {
                    applyJson.put("redConfirmBillStatus", (Object)"02");
                    if ("1".equals(redConfirm.getString("enteridentity"))) {
                        applyJson.put("redConfirmBillStatus", (Object)"03");
                    }
                }
            }
            applyJson.put("govRedConfirmBillUuid", (Object)RandomString.nextString(20, false, false));
            applyJson.put("redConfirmBillNo", (Object)(TEST_CONFIRM_NO + RandomString.nextString(10, true, false)));
            applyJson.put("redConfirmEnterDate", (Object)DateUtils.format(new Date(), "yyyy-MM-dd HH:mm:ss"));
            jsonStr = applyJson.toJSONString();
        } else if (AllEleInterfaceTypeEnum.PAGE_QUERY_INVOICE_BODY.getRequestPath().equals(request.getRequest_path()) || AllEleInterfaceTypeEnum.PAGE_QUERY_FULL_INVOICE_BODY.getRequestPath().equals(request.getRequest_path()) || AllEleInterfaceTypeEnum.RED_CONFIRM_BILL_QUERY.getRequestPath().equals(request.getRequest_path()) || AllEleInterfaceTypeEnum.ASYNC_ACCOUNT_QUERY.getRequestPath().equals(request.getRequest_path()) || AllEleInterfaceTypeEnum.QUERY_CROSSCITY_TAXVERIFYNO_INFO.getRequestPath().equals(request.getRequest_path())) {
            LOGGER.info("mock...");
            json.put("totalElement", (Object)1);
            json.put("pageNo", (Object)1);
            json.put("pageSize", (Object)50);
            json.put("data", (Object)jsonStr);
            jsonStr = "";
        } else if (AllEleInterfaceTypeEnum.RED_CONFIRM_BILL_REVOKE.getRequestPath().equals(request.getRequest_path())) {
            JSONObject revokeJson = JSONObject.parseObject((String)jsonStr);
            revokeJson.put("govRedConfirmBillUuid", (Object)RandomString.nextString(20, false, false));
            jsonStr = revokeJson.toJSONString();
        } else if (AllEleInterfaceTypeEnum.RED_CONFIRM_BILL_UPDATE.getRequestPath().equals(request.getRequest_path())) {
            JSONObject uploadRequestJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)request));
            JSONObject updateJson = JSONObject.parseObject((String)jsonStr);
            updateJson.put("govRedConfirmBillUuid", (Object)RandomString.nextString(20, false, false));
            if (StringUtils.equals((String)uploadRequestJson.getString("confirmationType"), (String)"Y")) {
                updateJson.put("redConfirmBillStatus", (Object)"04");
            } else {
                String redConfirmBillStatus = StringUtils.equals((String)uploadRequestJson.getString("salerTaxNo"), (String)taxNo) ? "06" : "05";
                updateJson.put("redConfirmBillStatus", (Object)redConfirmBillStatus);
            }
            jsonStr = updateJson.toJSONString();
        } else if (AllEleInterfaceTypeEnum.RED_CONFIRM_BILL_DETAIL_QUERY.getRequestPath().equals(request.getRequest_path())) {
            JSONObject confirmRedJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)request));
            String govRedConfirmBillUuid = confirmRedJson.getString("govRedConfirmBillUuid");
            if (StringUtils.isNotEmpty((String)govRedConfirmBillUuid)) {
                QFilter filter = new QFilter("govuuid", "=", (Object)govRedConfirmBillUuid);
                DynamicObject redDynamic = BusinessDataServiceHelper.loadSingle((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_red_confirm_bill", true), (QFilter[])filter.toArray());
                if (redDynamic != null) {
                    AllEleDownLoadHonorDTO confirmResult = DynamicObjectUtil.dynamicObject2Bean(AllEleDownLoadHonorDTO.class, redDynamic);
                    jsonStr = JSON.toJSONString((Object)confirmResult);
                }
            }
        } else if (AllEleInterfaceTypeEnum.ELE_PAPER_MOTORVEHICLE_INFO_QUERY.getRequestPath().equals(request.getRequest_path())) {
            AllEleVehicleResponseDTO dto = new AllEleVehicleResponseDTO();
            dto.setBusinessNo("232323");
            dto.setChassisNo("232323");
            dto.setComplianceNo("232323");
            dto.setEngineNo("yyyyxx22323");
            dto.setImportNo("2323323333333");
            dto.setManufacturer("BYD");
            dto.setModel("GuangDong ShenZhen");
            dto.setTaxationVoucher("12332155444");
            dto.setVehicleCapacity("13");
            dto.setVehicleType("Vehicle");
            dto.setVehicleWeight("32");
            dto.setOrigin("GuangDong ShenZhen BYD");
            dto.setVehicleUuid(UUID.randomUUID());
            jsonStr = JSONObject.toJSONString((Object)dto);
        } else if (AllEleInterfaceTypeEnum.QUERY_INVOICE_RED_PRE.getRequestPath().equals(request.getRequest_path())) {
            dataJson = new JSONObject();
            dataJson.put("valueAddedTaxUses", (Object)"03");
            dataJson.put("creditingStatus", (Object)"00");
            dataJson.put("exciseTaxPurposes", (Object)"00");
            json.put("data", (Object)dataJson);
        } else if (AllEleInterfaceTypeEnum.QUERY_INVOICE_RED_INFO.getRequestPath().equals(request.getRequest_path())) {
            LOGGER.info("mock...");
            json.put("totalElement", (Object)1);
            json.put("pageNo", (Object)1);
            json.put("pageSize", (Object)50);
            json.put("data", (Object)jsonStr);
            jsonStr = "";
        } else if (AllEleInterfaceTypeEnum.ASYNC_QUERY_INVOICE_PURPOSE_STATUS_REQ.getRequestPath().equals(request.getRequest_path())) {
            dataJson = new JSONObject();
            dataJson.put("batchNo", (Object)((AllEleRedApplyQueryAsyncRequestDTO)request).getBatchNo());
            json.put("data", (Object)dataJson);
        } else if (AllEleInterfaceTypeEnum.ASYNC_QUERY_INVOICE_PURPOSE_STATUS_RSP.getRequestPath().equals(request.getRequest_path())) {
            String batchNo = ((AllEleRedApplyQueryAsyncRequestDTO)request).getBatchNo();
            QFilter qFilter = new QFilter("batchno", "=", (Object)batchNo);
            DynamicObject[] dataArr = BusinessDataServiceHelper.load((String)"sim_his_inv_data_imp_st", (String)"invoicecode,invoiceno", (QFilter[])qFilter.toArray());
            JSONObject dataJson2 = new JSONObject();
            if (dataArr != null) {
                JSONArray successArray = new JSONArray();
                for (DynamicObject currentData : dataArr) {
                    JSONObject currentJson = new JSONObject();
                    currentJson.put("invoicecode", currentData.get("invoicecode"));
                    currentJson.put("invoiceno", currentData.get("invoiceno"));
                    currentJson.put("valueAddedTaxUses", (Object)"03");
                    currentJson.put("creditingStatus", (Object)"00");
                    currentJson.put("exciseTaxPurposes", (Object)"00");
                    successArray.add((Object)currentJson);
                }
                dataJson2.put("success", (Object)successArray);
            }
            json.put("data", (Object)dataJson2);
            json.put("description", (Object)"success");
        }
        if (AllEleInterfaceTypeEnum.PAGE_QUERY_FULL_INVOICE_BODY.getRequestPath().equals(request.getRequest_path())) {
            String str2 = "[{\"errcode\":\"0000\",\"totalElement\":1,\"traceId\":\"c5f5b67c74ab455c\",\"tongjiInfo\":{\"totalAmount\":-350000.00,\"juanpiaoNum\":0,\"tollBillNum\":0,\"invoiceAmount\":-309734.51,\"totalTaxAmount\":-40265.49,\"invoiceNum\":1},\"data\":[{\"etaxInvoiceNo\":\"\",\"salerName\":\"\u5e7f\u4e1c\u4f0a\u4e4b\u5bc6\u7cbe\u5bc6\u6ce8\u538b\u79d1\u6280\u6709\u9650\u516c\u53f8\",\"buyerTaxNo\":\"91130000104361580W\",\"drawer\":\"\u9ea6\u9536\u5b87\",\"invoiceAmount\":-309734.51,\"remark\":\"\u88ab\u7ea2\u51b2\u84dd\u5b57\u6570\u7535\u7968\u53f7\u7801\uff1a24442000000284278495 \u7ea2\u5b57\u53d1\u7968\u4fe1\u606f\u786e\u8ba4\u5355\u7f16\u53f7\uff1a44068124091000606179 \u6536\u6b3e\u4eba:\u6d82\u6587\u83ca \u590d\u6838\u4eba:\u6768\u8fdc\u8d35\",\"invoiceDate\":\"2024-09-03 14:24:41\",\"buyerName\":\"\u6cb3\u5317\u7701\u91d1\u878d\u79df\u8d41\u6709\u9650\u516c\u53f8\",\"invoiceCode\":\"\",\"invoiceSource\":\"\u7535\u5b50\u53d1\u7968\u670d\u52a1\u5e73\u53f0\",\"totalAmount\":-350000.00,\"salerTaxNo\":\"91440606688680314N\",\"invoiceType\":26,\"invoiceNo\":\"24442000000403478786\",\"taxAmount\":-40265.49,\"totalTaxAmount\":-40265.49,\"invoiceStatus\":0,\"items\":[{\"unitPrice\":\"309734.51\",\"taxRate\":\"0.13\",\"unit\":\"\u53f0/\u5957\",\"num\":\"-1\",\"detailAmount\":\"-309734.51\",\"specModel\":\"UN320A5S\",\"goodsCode\":\"1090209010000000000\",\"taxAmount\":\"-40265.49\",\"zeroTaxRateFlag\":\"\",\"goodsName\":\"*\u5851\u6599\u52a0\u5de5\u8bbe\u5907*\u6ce8\u5851\u673a-UN320A5S,UN320A5S\"}],\"invoiceRiskLevel\":\"\u6b63\u5e38\"}],\"pageNo\":1,\"description\":\"\u64cd\u4f5c\u6210\u529f\",\"pageSize\":50}]";
            JSONArray jsonArray = JSONObject.parseArray((String)str2);
            JSONObject json1 = jsonArray.getJSONObject(0);
            return json1.toJSONString();
        }
        if (AllEleInterfaceTypeEnum.ASYNC_QUERY_INVOICE_DATA_STATUS_RSP.getRequestPath().equals(request.getRequest_path())) {
            JSONArray jsonArray = JSONObject.parseArray((String)jsonStr);
            json.put("data", (Object)jsonArray);
            return json.toJSONString();
        }
        if (AllEleInterfaceTypeEnum.ADD_OR_UPDATE_ACCOUNT.getRequestPath().equals(request.getRequest_path())) {
            String str = "{\n    \"errcode\": \"0000\",\n    \"description\": \"string\",\n    \"traceId\": \"string\",\n    \"data\": {\n        \"batchNo\": \"22342342344\",\n        \"estimatedDuration\": 0\n    }\n}";
            JSONObject accountJson = JSONObject.parseObject((String)str);
            JSONObject innerData = accountJson.getJSONObject("data");
            innerData.put("batchNo", (Object)RandomString.nextString(20, false, false));
            return accountJson.toJSONString();
        }
        if (StringUtils.isNotEmpty((String)jsonStr)) {
            data.putAll((Map)JSONObject.parseObject((String)jsonStr));
            json.put("data", (Object)data);
        }
        String responseStr = json.toJSONString();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("\u6570\u7535mock\u8bf7\u6c42\u7a0e\u53f7[%s],\u8bf7\u6c42\u63a5\u53e3[%s],\u8fd4\u56de\u6570\u636e:[%s]", taxNo, request.getRequest_path(), responseStr));
        }
        return responseStr;
    }

    public static String getConfirmInfo(String code) {
        String msg = "";
        if (StringUtils.isEmpty((String)code)) {
            return msg;
        }
        switch (code) {
            case "01": {
                msg = "\u65e0\u9700\u786e\u8ba4";
                break;
            }
            case "02": {
                msg = "\u9500\u65b9\u5f55\u5165\u5f85\u8d2d\u65b9\u786e\u8ba4";
                break;
            }
            case "03": {
                msg = "\u8d2d\u65b9\u5f55\u5165\u5f85\u9500\u65b9\u786e\u8ba4";
                break;
            }
            case "04": {
                msg = "\u8d2d\u9500\u53cc\u65b9\u5df2\u786e\u8ba4";
                break;
            }
            case "05": {
                msg = "\u4f5c\u5e9f\uff08\u9500\u65b9\u5f55\u5165\u8d2d\u65b9\u5426\u8ba4\uff09";
                break;
            }
            case "06": {
                msg = "\u4f5c\u5e9f\uff08\u8d2d\u65b9\u5f55\u5165\u9500\u65b9\u5426\u8ba4\uff09";
                break;
            }
            case "07": {
                msg = "\u4f5c\u5e9f\uff08\u8d8572\u5c0f\u65f6\u672a\u786e\u8ba4\uff09";
                break;
            }
            case "08": {
                msg = "\u4f5c\u5e9f\uff08\u53d1\u8d77\u65b9\u5df2\u64a4\u9500\uff09";
                break;
            }
            case "09": {
                msg = "\u4f5c\u5e9f\uff08\u786e\u8ba4\u540e\u64a4\u9500\uff09";
                break;
            }
            case "10": {
                msg = "\u4f5c\u5e9f\uff08\u5f02\u5e38\u51ed\u8bc1\uff09";
                break;
            }
        }
        return msg;
    }

    public static boolean isNeedLogin(AbstractFormPlugin than, Map<String, Object> param, boolean forceRpa) {
        AllEleResponseDTO<AllEleLoginResponseDTO> loginInfo;
        String taxNo = (String)param.get("salertaxno");
        if (!forceRpa && EnterpriseHelper.isLqptChannel(taxNo)) {
            return false;
        }
        AllEleLoginRequestDTO eleIssue = new AllEleLoginRequestDTO();
        eleIssue.setRequest_path(AllEleInterfaceTypeEnum.LOGIN_CHECK.getRequestPath());
        eleIssue.setCheckAuth(Boolean.TRUE);
        eleIssue.setAccount((String)param.get("account"));
        if (param.containsKey("checkAuth")) {
            eleIssue.setCheckAuth((Boolean)param.get("checkAuth"));
        }
        if (!(loginInfo = AllEleServiceHelper.eleLogin((String)param.get("salertaxno"), eleIssue)).getSuccess().booleanValue()) {
            String description = loginInfo.getDescription();
            than.getView().showErrorNotification(StringUtils.isBlank((String)description) ? ResManager.loadKDString((String)"\u767b\u5f55\u5931\u8d25", (String)"AllEleServiceHelper_24", (String)"imc-bdm-common", (Object[])new Object[0]) : description);
            return true;
        }
        AllEleLoginResponseDTO data = loginInfo.getData();
        if (eleIssue.getCheckAuth().booleanValue() && data.getNeedAuth().booleanValue() || !AllEleLonType.AUTO_LOGIN.equals(data.getLoginType()) && data.getEtaxAccountType() == -1) {
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            map.putAll(param);
            map.put("taxNo", param.get("salertaxno"));
            map.put("longLinkName", loginInfo.getData().getLongLinkName());
            map.put("loginWebUrls", loginInfo.getData().getLoginWebUrl());
            map.put("checkAuth", eleIssue.getCheckAuth() != false ? "1" : "0");
            ViewUtil.openDialog(than, map, BDM_TAX_LOGIN, BDM_TAX_LOGIN);
            return true;
        }
        return false;
    }

    public static boolean isNeedLogin(AbstractFormPlugin than, Map<String, Object> param) {
        return AllEleServiceHelper.isNeedLogin(than, param, false);
    }

    public static MsgResponse elePaperInvoiceAbolish(DynamicObject invoice, String cancelReason) {
        AllElePaperInvoiceCancelRequestDTO dto = new AllElePaperInvoiceCancelRequestDTO();
        dto.setInvoiceCode(invoice.getString("invoicecode"));
        dto.setInvoiceNo(invoice.getString("invoiceno"));
        if (StringUtils.isBlank((String)cancelReason)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f5c\u5e9f\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a", (String)"AllEleServiceHelper_25", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        dto.setReason(AllEleServiceHelper.getCancelCode(cancelReason));
        dto.setSalerTaxNo(invoice.getString("salertaxno"));
        dto.setRequest_path(AllEleInterfaceTypeEnum.ELE_PAPER_INVOICE_CANCEL.getRequestPath());
        AllEleResponseDTO<AllEleResponseDTO> response = AllEleServiceHelper.doPost(invoice.getString("salertaxno"), dto, AllEleResponseDTO.class);
        MsgResponse msgResponse = new MsgResponse();
        msgResponse.setErrorCode(response.getErrcode());
        msgResponse.setErrorMsg(response.getDescription());
        return msgResponse;
    }

    private static String getCancelCode(String cancelReason) {
        if ("\u586b\u5199\u6709\u8bef".equals(cancelReason)) {
            return "01";
        }
        if ("\u9500\u8d27\u9000\u56de".equals(cancelReason)) {
            return "04";
        }
        if ("\u670d\u52a1\u7ec8\u6b62".equals(cancelReason)) {
            return "03";
        }
        return "05";
    }
}

