/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper;

import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.helper.BdmConditionMatchHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;

public class BatchPushMailSettingHelper {
    private static final String[] ctrlStrategy = new String[]{"7", "2", "1", "6", "5"};

    public static DynamicObjectCollection getBatchPushMailSettingByOrg(long orgId, String ctrlStrategy) {
        QFilter baseDataFilter = ImcBaseDataHelper.getBacthMailPushFilter(orgId);
        baseDataFilter.and("ctrlstrategy", "=", (Object)ctrlStrategy);
        return QueryServiceHelper.query((String)"bdm_batchemail_setting", (String)String.join((CharSequence)",", "filter_tag", "mailsendtype", "mailsendgrouprule"), (QFilter[])baseDataFilter.toArray(), (String)"priority asc");
    }

    public static DynamicObject matchBatchPushMailSetting(DynamicObject invoice) {
        DynamicObject pushMailStrategyRes = null;
        block2: for (int i = 0; i < ctrlStrategy.length; ++i) {
            DynamicObjectCollection pushMailStrategyArr = BatchPushMailSettingHelper.getBatchPushMailSettingByOrg(DynamicObjectUtil.getDynamicObjectLongValue(invoice.get("orgid")), ctrlStrategy[i]);
            if (CollectionUtils.isEmpty((Collection)pushMailStrategyArr)) continue;
            try {
                for (DynamicObject pushMailStrategy : pushMailStrategyArr) {
                    String filterStr = pushMailStrategy.getString("filter_tag");
                    if (!BdmConditionMatchHelper.verify(filterStr, invoice)) continue;
                    pushMailStrategyRes = pushMailStrategy;
                    continue block2;
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pushMailStrategyRes;
    }

    public static DynamicObject[] checkOrgsRepeatPriority(Object number, long orgId, Object priority) {
        QFilter baseDataFilter = new QFilter("createorg.id", "=", (Object)orgId);
        baseDataFilter.and("priority", "=", priority).and("number", "!=", number);
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"bdm_batchemail_setting", (String)PropertieUtil.getAllPropertiesSplitByComma("bdm_batchemail_setting"), (QFilter[])baseDataFilter.toArray());
        return array;
    }
}

