/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.UUID;

public class BillArchiveHelper {
    private static final Log logger = LogFactory.getLog(BillArchiveHelper.class);

    public static int archive(String sentityKey, String tentityKey, List<Long> pkList) {
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            logger.info("\u5f52\u6863\u6570\u636e{},{},{}", new Object[]{sentityKey, tentityKey, pkList});
            QFilter filter = new QFilter("id", "in", pkList);
            MainEntityType smainEntityType = EntityMetadataCache.getDataEntityType((String)sentityKey);
            DynamicObject[] collect = BusinessDataServiceHelper.load((Object[])pkList.toArray(), (DynamicObjectType)smainEntityType);
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(pkList.size());
            String batch = UUID.getBatchNumber();
            ArrayList<Object> deleteList = new ArrayList<Object>(pkList.size());
            HashSet<String> monthSet = new HashSet<String>(4);
            QFilter filter1 = new QFilter("sentity", "=", (Object)sentityKey);
            DynamicObject config = QueryServiceHelper.queryOne((String)"bdm_bill_archive_config", (String)"date_field,month_field,org_field,billno_field,taxno_field,bak_entity,bak_batch,bak_pk,bak_sentity,bak_billno,bak_tentity,bak_data", (QFilter[])filter1.toArray());
            for (DynamicObject obj : collect) {
                DynamicObject target = BusinessDataServiceHelper.newDynamicObject((String)tentityKey);
                BillArchiveHelper.dynamicObjectCopy(obj, target, false);
                BillArchiveHelper.setOrg(obj, target, config);
                String month = BillArchiveHelper.setDataMonth(obj, target, config);
                if (month != null) {
                    monthSet.add(month);
                }
                deleteList.add(obj.get("id"));
                list.add(target);
                BillArchiveHelper.saveLog(batch, sentityKey, tentityKey, config, obj);
            }
            QFilter filter2 = new QFilter("id", "in", deleteList);
            DeleteServiceHelper.delete((String)tentityKey, (QFilter[])filter2.toArray());
            DeleteServiceHelper.delete((String)sentityKey, (QFilter[])filter.toArray());
            SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
            BillArchiveHelper.saveDataMonth(tentityKey, monthSet);
            int n = list.size();
            return n;
        }
        catch (Throwable e) {
            try {
                h.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static void setOrg(DynamicObject object1, DynamicObject object2, DynamicObject config) {
        Object[] orgIds;
        if (config == null) {
            return;
        }
        String taxnoField = config.getString("taxno_field");
        String orgField = config.getString("org_field");
        if (StringUtils.isEmpty((Object)orgField) || StringUtils.isEmpty((Object)taxnoField)) {
            return;
        }
        Long orgId = BigDecimalUtil.transDecimal(object2.get(orgField)).longValue();
        if (orgId > 0L) {
            return;
        }
        String taxNo = object1.getString(taxnoField);
        if (!StringUtils.isEmpty((Object)taxNo) && (orgIds = new OrgHelper().getOrgIdsByTaxNo(taxNo)).length > 0) {
            object2.set(orgField, (Object)((Long)orgIds[0]));
        }
    }

    private static void saveDataMonth(String tentityKey, Set<String> monthSet) {
        if (monthSet == null || monthSet.isEmpty()) {
            return;
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                QFilter filter1 = new QFilter("tentity", "=", (Object)tentityKey);
                QFilter filter2 = new QFilter("data_month", "in", monthSet);
                DeleteServiceHelper.delete((String)"bdm_bill_archive_month", (QFilter[])new QFilter[]{filter1, filter2});
                Iterator<String> iterator = monthSet.iterator();
                ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(monthSet.size());
                while (iterator.hasNext()) {
                    DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"bdm_bill_archive_month");
                    obj.set("tentity", (Object)tentityKey);
                    obj.set("data_month", (Object)iterator.next());
                    list.add(obj);
                }
                SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
            }
            catch (Throwable e) {
                logger.info("\u4fdd\u5b58\u6570\u636e\u6708\u4efd\u51fa\u9519");
            }
        }
    }

    private static String setDataMonth(DynamicObject object1, DynamicObject object2, DynamicObject config) {
        if (config == null) {
            return null;
        }
        String dateField = config.getString("date_field");
        String monthField = config.getString("month_field");
        if (StringUtils.isEmpty((Object)dateField) || StringUtils.isEmpty((Object)monthField)) {
            return null;
        }
        Date date = object1.getDate(dateField);
        if (date != null) {
            String month = DateUtils.format(date, "yyyyMM");
            object2.set(monthField, (Object)month);
            return month;
        }
        return null;
    }

    public static int revokeBySourceBill(String sentityKey, List<Long> pkList) {
        String tentityKey = BillArchiveHelper.getArchiveEnetity(sentityKey);
        if (!StringUtils.isEmpty((Object)tentityKey)) {
            return BillArchiveHelper.revoke(sentityKey, tentityKey, pkList);
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int revoke(String sentityKey, String tentityKey, List<Long> pkList) {
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            logger.info("\u53cd\u5f52\u6863\u6570\u636e{},{},{}", new Object[]{sentityKey, tentityKey, pkList});
            QFilter filter = new QFilter("id", "in", pkList);
            DynamicObjectCollection collect = QueryServiceHelper.query((String)sentityKey, (String)"id", (QFilter[])filter.toArray());
            for (DynamicObject object : collect) {
                pkList.remove(object.getLong("id"));
            }
            String batch = UUID.getBatchNumber();
            if (pkList.isEmpty()) return 0;
            MainEntityType tmainEntityType = EntityMetadataCache.getDataEntityType((String)tentityKey);
            DynamicObject[] datalist = BusinessDataServiceHelper.load((Object[])pkList.toArray(), (DynamicObjectType)tmainEntityType);
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(pkList.size());
            QFilter filter1 = new QFilter("tentity", "=", (Object)tentityKey);
            DynamicObject config = QueryServiceHelper.queryOne((String)"bdm_bill_archive_config", (String)"date_field,month_field,org_field,billno_field,taxno_field,bak_entity,bak_batch,bak_pk,bak_sentity,bak_billno,bak_tentity,bak_data", (QFilter[])filter1.toArray());
            DynamicObject[] dynamicObjectArray = datalist;
            int n = dynamicObjectArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    DeleteServiceHelper.delete((String)tentityKey, (QFilter[])filter.toArray());
                    SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
                    int n3 = list.size();
                    return n3;
                }
                DynamicObject obj = dynamicObjectArray[n2];
                DynamicObject target = BusinessDataServiceHelper.newDynamicObject((String)sentityKey);
                BillArchiveHelper.dynamicObjectCopy(obj, target, true);
                list.add(target);
                BillArchiveHelper.saveLog(batch, tentityKey, sentityKey, config, obj);
                ++n2;
            }
        }
        catch (Throwable e) {
            h.markRollback();
            throw e;
        }
    }

    public static void dynamicObjectCopy(DynamicObject sobject, DynamicObject tObject, boolean isIgnore) {
        DynamicObjectType stype = sobject.getDynamicObjectType();
        DataEntityPropertyCollection collect = stype.getProperties();
        for (IDataEntityProperty property : collect) {
            if (property instanceof EntryProp) {
                BillArchiveHelper.dynamicObjectEntryCopy(sobject.getDynamicObjectCollection(property.getName()), tObject.getDynamicObjectCollection(property.getName()), isIgnore);
                continue;
            }
            try {
                tObject.set(property.getName(), sobject.get(property.getName()));
            }
            catch (Exception e) {
                if (isIgnore) continue;
                throw e;
            }
        }
    }

    public static void dynamicObjectEntryCopy(DynamicObjectCollection sCollection, DynamicObjectCollection tCollection, boolean isIgnore) {
        DynamicObjectType sDynamicObjectType = sCollection.getDynamicObjectType();
        DataEntityPropertyCollection itemProperties = sDynamicObjectType.getProperties();
        for (DynamicObject sDynamicObject : sCollection) {
            DynamicObject tDynamicObject = tCollection.addNew();
            for (IDataEntityProperty property : itemProperties) {
                if (property instanceof EntryProp) {
                    BillArchiveHelper.dynamicObjectEntryCopy(sDynamicObject.getDynamicObjectCollection(property.getName()), tDynamicObject.getDynamicObjectCollection(property.getName()), isIgnore);
                    continue;
                }
                try {
                    tDynamicObject.set(property.getName(), sDynamicObject.get(property.getName()));
                }
                catch (Exception e) {
                    if (isIgnore) continue;
                    throw e;
                }
            }
        }
    }

    public static String getArchiveEnetity(String sentityKey) {
        DynamicObject[] collection;
        QFilter filter1 = new QFilter("config_type", "=", (Object)CacheKeyEnum.ORIGINAL_BILL_BACKUP.getConfigType());
        QFilter filter2 = new QFilter("config_key", "=", (Object)sentityKey);
        for (DynamicObject obj : collection = BusinessDataServiceHelper.load((String)"invsm_param_configuration", (String)"config_type,config_key,config_value", (QFilter[])new QFilter[]{filter1, filter2})) {
            String val = obj.getString("config_value");
            if (StringUtils.isEmpty((Object)val)) continue;
            return val;
        }
        return null;
    }

    private static void saveLog(String batch, String sentityKey, String tentityKey, DynamicObject config, DynamicObject data) {
        boolean istaxc;
        boolean bl = istaxc = config == null || StringUtils.isEmpty((Object)config.getString("bak_entity")) || "bdm_bill_archive_log".equals(config.getString("bak_entity"));
        if (istaxc) {
            String billno_field;
            DynamicObject logObject = BusinessDataServiceHelper.newDynamicObject((String)"bdm_bill_archive_log");
            logObject.set("batch", (Object)batch);
            logObject.set("snumber", (Object)sentityKey);
            logObject.set("tnumber", (Object)tentityKey);
            if (config != null && !StringUtils.isEmpty((Object)(billno_field = config.getString("billno_field")))) {
                logObject.set("billno", data.get(billno_field));
            }
            logObject.set("pk", (Object)(data.get("id") + ""));
            logObject.set("content_tag", (Object)SerializationUtils.toJsonString(DynamicObjectUtil.dynamicObjectToMap(data, false)));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logObject});
        } else {
            String billno_field;
            DynamicObject logObject = BusinessDataServiceHelper.newDynamicObject((String)config.getString("bak_entity"));
            logObject.set(config.getString("bak_batch"), (Object)batch);
            logObject.set(config.getString("bak_sentity"), (Object)sentityKey);
            logObject.set(config.getString("bak_tentity"), (Object)tentityKey);
            if (config != null && !StringUtils.isEmpty((Object)(billno_field = config.getString("billno_field")))) {
                logObject.set(config.getString("bak_billno"), data.get(billno_field));
            }
            logObject.set(config.getString("bak_pk"), (Object)(data.get("id") + ""));
            logObject.set(config.getString("bak_data"), (Object)SerializationUtils.toJsonString(DynamicObjectUtil.dynamicObjectToMap(data, false)));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logObject});
        }
    }

    public static boolean compare(String sEntityKey, String tEntityKey) {
        MainEntityType sEntityType = EntityMetadataCache.getDataEntityType((String)sEntityKey);
        MainEntityType tEntityType = EntityMetadataCache.getDataEntityType((String)tEntityKey);
        DataEntityPropertyCollection sproperties = sEntityType.getProperties();
        HashSet<String> sfieldSet = new HashSet<String>(sproperties.size());
        BillArchiveHelper.getField(sproperties, sfieldSet);
        DataEntityPropertyCollection tproperties = tEntityType.getProperties();
        HashSet<String> tfieldSet = new HashSet<String>(tproperties.size());
        BillArchiveHelper.getField(tproperties, tfieldSet);
        Iterator it = sfieldSet.iterator();
        while (it.hasNext()) {
            if (!tfieldSet.add((String)it.next())) continue;
            return false;
        }
        return true;
    }

    private static void getField(DataEntityPropertyCollection properties, Set<String> fieldSet) {
        for (IDataEntityProperty property : properties) {
            fieldSet.add(property.getName() + "|" + property.getClass().getSimpleName());
            if (!(property instanceof EntryProp)) continue;
            EntryProp entry = (EntryProp)property;
            DynamicObjectType type = entry.getDynamicCollectionItemPropertyType();
            BillArchiveHelper.getField(type.getProperties(), fieldSet);
        }
    }
}

