/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper;

import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.constant.table.EnterPriseBaseInfoConstant;
import kd.imc.bdm.common.dto.allele.AllEleRequestDTO;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;

public class EnterpriseHelper {
    public static DynamicObject queryTaxIssueChannel(String taxNo) {
        return QueryServiceHelper.queryOne((String)"bdm_enterprise_baseinfo", (String)"issuechannel", (QFilter[])new QFilter("number", "=", (Object)taxNo).toArray());
    }

    public static boolean isDirectLqptChannel(String taxNo) {
        QFilter qFilter = new QFilter("number", "=", (Object)taxNo).and("issuechannel", "in", EnterPriseBaseInfoConstant.LQPT_CHANNEL_DIRECT);
        return QueryServiceHelper.exists((String)"bdm_enterprise_baseinfo", (QFilter[])qFilter.toArray());
    }

    public static boolean isLqptChannel(String taxNo) {
        QFilter qFilter = new QFilter("number", "=", (Object)taxNo).and("issuechannel", "in", EnterPriseBaseInfoConstant.LQPT_CHANNEL_DIRECT);
        return QueryServiceHelper.exists((String)"bdm_enterprise_baseinfo", (QFilter[])qFilter.toArray());
    }

    public static boolean isRpaIssueChannel(String taxNo) {
        DynamicObject[] epInfos;
        QFilter qFilter = new QFilter("number", "=", (Object)taxNo);
        for (DynamicObject epInfo : epInfos = BusinessDataServiceHelper.load((String)"bdm_enterprise_baseinfo", (String)"issuechannel", (QFilter[])qFilter.toArray())) {
            String issueChannel = epInfo.getString("issuechannel");
            if (StringUtils.isBlank((CharSequence)issueChannel)) {
                return true;
            }
            if (!"0".equals(issueChannel) && !"3".equals(issueChannel)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLeqiCombineChannel(String taxNo) {
        QFilter qFilter = new QFilter("number", "=", (Object)taxNo).and("issuechannel", "=", (Object)"3");
        return QueryServiceHelper.exists((String)"bdm_enterprise_baseinfo", (QFilter[])qFilter.toArray());
    }

    public static boolean isLeqiCombineOrg(Long orgPk) {
        QFilter filter = new QFilter("id", "=", (Object)orgPk);
        DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bdm_org", (String)PropertieUtil.getAllPropertiesSplitByComma("bdm_org", true), (QFilter[])filter.toArray());
        if (orgs.length > 0) {
            Object epinfo = orgs[0].get("epinfo");
            long epInfoPk = DynamicObjectUtil.getDynamicObjectLongValue(epinfo);
            QFilter epFilter = new QFilter("id", "=", (Object)epInfoPk);
            DynamicObject[] epArray = BusinessDataServiceHelper.load((String)"bdm_enterprise_baseinfo", (String)PropertieUtil.getAllPropertiesSplitByComma("bdm_enterprise_baseinfo", true), (QFilter[])epFilter.toArray());
            if (epArray.length > 0) {
                return EnterpriseHelper.isLeqiCombineChannel(epArray[0].getString("number"));
            }
        }
        return false;
    }

    public static boolean isInputLqptChannel(String taxNo) {
        QFilter qFilter = new QFilter("number", "=", (Object)taxNo).and("authtype", "=", (Object)"5");
        return QueryServiceHelper.exists((String)"bdm_enterprise_baseinfo", (QFilter[])qFilter.toArray());
    }

    public static DynamicObject queryEpInfo(String taxNo) {
        QFilter filter = new QFilter("number", "=", (Object)taxNo);
        return BusinessDataServiceHelper.load((String)"bdm_enterprise_baseinfo", (String)PropertieUtil.getAllPropertiesSplitByComma("bdm_enterprise_baseinfo", true), (QFilter[])filter.toArray())[0];
    }

    public static void fillLeqiInfo(String taxNo, AllEleRequestDTO requestDTO) {
        String leqiId;
        String accessLeqiId;
        if (AllEleInterfaceTypeEnum.QUERY_INVOICE_BY_ORDERNO.getRequestPath().equals(requestDTO.getRequest_path())) {
            return;
        }
        String key = taxNo + "fillCombineLeqiInfo";
        String leqiInfoStr = CacheHelper.get(key);
        requestDTO.setChannelType("2");
        if (StringUtils.isNotBlank((CharSequence)leqiInfoStr)) {
            JSONObject json = JSONObject.parseObject((String)leqiInfoStr);
            accessLeqiId = json.getString("accessleqiid");
            leqiId = json.getString("leqiid");
        } else {
            DynamicObject epInfo = EnterpriseHelper.queryEpInfo(taxNo);
            JSONObject leqiInfo = new JSONObject();
            accessLeqiId = epInfo.getString("accessleqiid");
            leqiId = epInfo.getString("leqiid");
            if (StringUtils.isBlank((CharSequence)accessLeqiId)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:%s\u672a\u914d\u7f6e\u76f4\u8fde\u4e50\u4f01Id", (String)"EnterpriseHelper_1", (String)"imc-bdm-common", (Object[])new Object[0]), accessLeqiId));
            }
            if (StringUtils.isBlank((CharSequence)leqiId)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:%s\u672a\u914d\u7f6e\u4f7f\u7528\u5355\u4f4d\u4e50\u4f01Id", (String)"EnterpriseHelper_2", (String)"imc-bdm-common", (Object[])new Object[0]), leqiId));
            }
            leqiInfo.put("accessleqiid", (Object)accessLeqiId);
            leqiInfo.put("leqiid", (Object)leqiId);
            CacheHelper.put(key, leqiInfo.toJSONString(), 86400);
        }
        requestDTO.setDirectConnectNaturalId(accessLeqiId);
        requestDTO.setCompanyNaturalId(leqiId);
        if (StringUtils.isBlank((CharSequence)requestDTO.getCombinePatch())) {
            requestDTO.setCombinePatch(AllEleInterfaceTypeEnum.getLeqiCombinePatchByRequestPath(requestDTO.getRequest_path()));
        }
    }
}

