/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.HttpClientUtils;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.OpenApiCallbackInterfaceCodeEnum;
import kd.imc.bdm.common.dto.CallbackLogVo;
import kd.imc.bdm.common.dto.TokenDto;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.RelationHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.openapi.CallbackResponseVo;
import kd.imc.bdm.common.openapi.FindOrderOpenVo;
import kd.imc.bdm.common.openapi.InvoiceDataDetailVo;
import kd.imc.bdm.common.openapi.InvoiceDataVo;
import kd.imc.bdm.common.openapi.InvoiceDetailVo;
import kd.imc.bdm.common.openapi.OrderDetailVo;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.CallbackHelperUtil;
import kd.imc.bdm.common.util.ConvertUpMoneyUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceQueryUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;

public class FiInvoiceCallbackHelper {
    private static final Log LOGGER = LogFactory.getLog(FiInvoiceCallbackHelper.class);
    private static final String INVSM_SYNC_CALLBACK_ADDR = "invsm_callback_addr";
    private static final String SUCCESS = "success";
    private static final ImmutableSet<String> UN_SUCCESS = ImmutableSet.of((Object)"false", (Object)"error");
    private static final String ACCESSTOKEN_CACHE_KEY = "accesstoken_cache_key";
    private static final String INVOICE_OPEN = "INVOICE.OPEN";
    private static final String INVOICE_CANCEL = "INVOICE.CANCEL";

    public static CallbackResponseVo getOriBillByBillNo(DynamicObject billOrInvoice, CallbackLogVo callbackLog) {
        Set<Long> tBillIds;
        boolean isBillCallBack = "bill".equals(callbackLog.getCallbackType());
        String oriBillNos = isBillCallBack ? callbackLog.getCallbackBillNo() : FiInvoiceCallbackHelper.getOriginalBillNo(billOrInvoice);
        boolean isFromRedMatchBill = false;
        if (isBillCallBack && "-1".equals(billOrInvoice.getString("billproperties")) && (tBillIds = RelationHelper.queryTbillIds(new DynamicObject[]{billOrInvoice})).size() == 0) {
            isFromRedMatchBill = true;
        }
        if (StringUtils.isBlank((CharSequence)oriBillNos)) {
            return CallbackResponseVo.valueOfError(ResManager.loadKDString((String)"\u83b7\u53d6\u539f\u59cb\u5355\u636e\u7f16\u53f7\u4e3a\u7a7a", (String)"FiInvoiceCallbackHelper_30", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        QFilter qFilter = new QFilter("callbackbillno", "=", (Object)oriBillNos).and("callback_status", "=", (Object)"0");
        if (QueryServiceHelper.exists((String)"invsm_callback_log", (QFilter[])qFilter.toArray())) {
            return CallbackResponseVo.valueOfSuccess(String.format(ResManager.loadKDString((String)"\u5355\u636e[%s]\u5b58\u5728\u56de\u8c03\u6210\u529f\u7684\u8bb0\u5f55\uff0c\u8be5\u6761\u8bb0\u5f55\u6807\u8bb0\u4e3a\u6210\u529f", (String)"FiInvoiceCallbackHelper_31", (String)"imc-bdm-common", (Object[])new Object[0]), oriBillNos), null);
        }
        Map<String, List<OrderDetailVo>> rMap = isFromRedMatchBill ? FiInvoiceCallbackHelper.getInvoiceDataVoFromMatchInv(billOrInvoice, billOrInvoice) : InvoiceQueryUtil.getInvoiceDataByOriginalBillNo(new FindOrderOpenVo(isBillCallBack ? billOrInvoice.getString("salertaxno") : billOrInvoice.getString("salertaxno"), oriBillNos));
        if (rMap.isEmpty()) {
            return CallbackResponseVo.valueOfError(ResManager.loadKDString((String)"\u6839\u636e\u539f\u59cb\u5355\u636e\u7f16\u53f7\u83b7\u53d6\u53d1\u7968\u4fe1\u606f\u4e3a\u7a7a", (String)"FiInvoiceCallbackHelper_32", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format(ResManager.loadKDString((String)"\u5e94\u6536\u56de\u8c03\uff0c\u539f\u59cb\u5355\u636e\u7f16\u53f7\u662f\uff1a%1$s;\u6839\u636e\u539f\u59cb\u5355\u636e\u7f16\u53f7\u67e5\u8be2\u5230\u7684\u53d1\u7968\u662f\uff1a%2$s", (String)"FiInvoiceCallbackHelper_33", (String)"imc-bdm-common", (Object[])new Object[0]), oriBillNos, JSON.toJSONString(rMap)));
        }
        String[] originalBillNoArray = oriBillNos.split(",");
        ArrayList rList = Lists.newArrayListWithExpectedSize((int)originalBillNoArray.length);
        for (String originalBillNo : originalBillNoArray) {
            rList.addAll((Collection)rMap.get(originalBillNo));
        }
        if (rList.isEmpty()) {
            return CallbackResponseVo.valueOfError(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\u7f16\u53f7%s\u672a\u67e5\u8be2\u5230\u53d1\u7968\u6570\u636e", (String)"FiInvoiceCallbackHelper_34", (String)"imc-bdm-common", (Object[])new Object[0]), oriBillNos));
        }
        ArrayList<InvoiceDataVo> resultList = new ArrayList<InvoiceDataVo>(rList.size());
        for (OrderDetailVo invoiceVo : rList) {
            if (InvoiceUtils.isAllEInvoice(invoiceVo.getInvoiceType()) && StringUtils.isBlank((CharSequence)invoiceVo.getInvoiceNumber())) {
                return CallbackResponseVo.valueOfError(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\u7f16\u53f7%s\u5b58\u5728\u672a\u5f00\u5177\u7684\u53d1\u7968", (String)"FiInvoiceCallbackHelper_35", (String)"imc-bdm-common", (Object[])new Object[0]), oriBillNos));
            }
            if (!InvoiceUtils.isAllEInvoice(invoiceVo.getInvoiceType()) && (StringUtils.isBlank((CharSequence)invoiceVo.getInvoiceCode()) || StringUtils.isBlank((CharSequence)invoiceVo.getInvoiceNumber()))) {
                return CallbackResponseVo.valueOfError(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\u7f16\u53f7%s\u5b58\u5728\u672a\u5f00\u5177\u7684\u53d1\u7968", (String)"FiInvoiceCallbackHelper_35", (String)"imc-bdm-common", (Object[])new Object[0]), oriBillNos));
            }
            if (OpenApiCallbackInterfaceCodeEnum.INVOICE_CANCEL.getCode().equals(callbackLog.getBusinessType()) && invoiceVo.getInvoiceNumber().equals(callbackLog.getInvoiceNo())) {
                resultList = new ArrayList(1);
                resultList.add(FiInvoiceCallbackHelper.buildMainData(invoiceVo, oriBillNos));
                break;
            }
            resultList.add(FiInvoiceCallbackHelper.buildMainData(invoiceVo, oriBillNos));
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("\u5e94\u6536\u56de\u8c03\uff0c\u6784\u5efa\u7684\u5f85\u63a8\u9001\u6570\u636e\u662f\uff1a%s", JSON.toJSONString(resultList)));
        }
        if (resultList.isEmpty()) {
            return CallbackResponseVo.valueOfError(ResManager.loadKDString((String)"\u6784\u5efa\u63a8\u9001\u5e94\u6536\u6570\u636e\u4e3a\u7a7a", (String)"FiInvoiceCallbackHelper_36", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        return FiInvoiceCallbackHelper.pushDataForFi(billOrInvoice, callbackLog, resultList);
    }

    public static Map<String, List<OrderDetailVo>> getInvoiceDataVoFromMatchInv(DynamicObject bill, DynamicObject currentInvoice) {
        HashMap<String, List<OrderDetailVo>> result = new HashMap<String, List<OrderDetailVo>>(8);
        HashSet<Long> set = new HashSet<Long>(8);
        set.add(bill.getLong("id"));
        Set<Long> tBillPks = RelationHelper.getRedMatchBlueTBillIds(set);
        List<DynamicObject> invoiceList = FiInvoiceCallbackHelper.getAllInvoiceList(tBillPks, currentInvoice.getString("invoicetype"), currentInvoice);
        ArrayList<OrderDetailVo> list = new ArrayList<OrderDetailVo>();
        for (DynamicObject oneInvoice : invoiceList) {
            OrderDetailVo vo = DynamicObjectUtil.dynamicObject2Bean(OrderDetailVo.class, oneInvoice);
            DynamicObjectCollection items = oneInvoice.getDynamicObjectCollection("items");
            vo.setGoods(new ArrayList<InvoiceDetailVo>(items.size()));
            items.forEach(o -> vo.getGoods().add(DynamicObjectUtil.dynamicObject2Bean(InvoiceDetailVo.class, o)));
            vo.setOrgName(oneInvoice.getDynamicObject("orgid").getString("name"));
            String invoiceBillNo = oneInvoice.getString("billno");
            vo.setSerialNo(invoiceBillNo);
            vo.setInvoiceStatus(oneInvoice.getInt("invoicestatus"));
            String splitOrMergeFlag = bill.getString("splitormergeflag");
            vo.setSplitOrMergeFlag(splitOrMergeFlag);
            vo.setBillNo(bill.getString("billno"));
            vo.setResult(oneInvoice.getString("result"));
            list.add(vo);
            result.put(bill.getString("billno"), list);
        }
        return result;
    }

    public static List<DynamicObject> getAllInvoiceList(Set<Long> tBillPks, String invoiceType, DynamicObject bill) {
        long orgPk = DynamicObjectUtil.getDynamicObjectLongValue(bill.getDynamicObject("orgid"));
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>();
        if (InvoiceUtils.isAllEInvoice(invoiceType)) {
            DynamicObject[] redConfirms = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)"number,invoicecode,invoiceno", (QFilter[])new QFilter("id", "in", tBillPks).toArray());
            Set numbers = Arrays.stream(redConfirms).map(o -> o.getString("number")).collect(Collectors.toSet());
            QFilter filter = new QFilter("orgid", "=", (Object)orgPk).and("infocode", "in", numbers).and("issuestatus", "=", (Object)IssueStatusEnum.ok.getCode());
            DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_vatinvoice", true), (QFilter[])filter.toArray());
            Collections.addAll(result, invoices);
            return result;
        }
        if (InvoiceUtils.isSpecialInvoice(bill.getString("invoicetype"))) {
            DynamicObject[] redConfirms = BusinessDataServiceHelper.load((String)"sim_red_info", (String)"infocode,invoicecode,invoiceno", (QFilter[])new QFilter("id", "in", tBillPks).toArray());
            Set numbers = Arrays.stream(redConfirms).map(o -> o.getString("infocode")).collect(Collectors.toSet());
            QFilter filter = new QFilter("orgid", "=", (Object)orgPk).and("infocode", "in", numbers).and("issuestatus", "=", (Object)IssueStatusEnum.ok.getCode());
            DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_vatinvoice", true), (QFilter[])filter.toArray());
            Collections.addAll(result, invoices);
            return result;
        }
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_vatinvoice", true), (QFilter[])new QFilter("id", "in", tBillPks).toArray());
        Collections.addAll(result, invoices);
        return result;
    }

    public static CallbackResponseVo pushDataForFi(DynamicObject billOrInvoice, CallbackLogVo callbackLogVo, List<InvoiceDataVo> list) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("\u5e94\u6536\u56de\u8c03\uff0c\u53d1\u7968/\u5355\u636e\u8bb0\u5f55ID\u662f\uff1a%s", billOrInvoice.getString("id")));
        }
        String busType = OpenApiCallbackInterfaceCodeEnum.INVOICE_RED.getCode().equals(callbackLogVo.getBusinessType()) ? INVOICE_OPEN : callbackLogVo.getBusinessType();
        CallbackResponseVo responseVo = new CallbackResponseVo();
        JSONArray invoiceArr = JSON.parseArray((String)JSON.toJSONString(list));
        callbackLogVo.setCallbackContent(invoiceArr.toJSONString());
        String pushRs = "";
        if (FiInvoiceCallbackHelper.arBizServiceExist()) {
            try {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(String.format("\u8c03\u7528\u5e94\u6536\u5fae\u670d\u52a1\u8bf7\u6c42\u53c2\u6570 : [%s]", callbackLogVo.getCallbackContent()));
                }
                if (INVOICE_OPEN.equals(busType)) {
                    pushRs = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ar", (String)"IssueInvoiceService", (String)"issueInvoice", (Object[])new Object[]{callbackLogVo.getCallbackContent()});
                }
                if (INVOICE_CANCEL.equals(busType)) {
                    pushRs = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ar", (String)"AbandonInvoiceService", (String)"abandonInvoice", (Object[])new Object[]{callbackLogVo.getCallbackContent()});
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(String.format("\u8c03\u7528\u5e94\u6536\u5fae\u670d\u52a1\u8fd4\u56de : [%s]", pushRs));
                }
                responseVo.setData(JSON.toJSONString((Object)callbackLogVo));
            }
            catch (Exception e) {
                responseVo.setCode(ApiErrCodeEnum.ERROR.getCode());
                responseVo.setMessage(e.getMessage());
            }
        } else {
            Map<String, Object> rMap;
            String taxNo = billOrInvoice.getString("salertaxno");
            DynamicObject invsmSyncObj = FiInvoiceCallbackHelper.getFiCallbackConfig(taxNo);
            if (null == invsmSyncObj) {
                return CallbackResponseVo.valueOfError(ErrorType.FI_PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u5e94\u6536\u53d1\u7968\u56de\u8c03\u5730\u5740", (String)"FiInvoiceCallbackHelper_37", (String)"imc-bdm-common", (Object[])new Object[0]));
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u5e94\u6536\u7cfb\u7edf\u8c03\u7528AccessToken\u5931\u8d25", (String)"FiInvoiceCallbackHelper_38", (String)"imc-bdm-common", (Object[])new Object[0]), JSON.toJSONString((Object)DynamicObjectUtil.dynamicObject2Json(invsmSyncObj))));
            }
            if (StringUtils.isNotBlank((Object)(rMap = FiInvoiceCallbackHelper.getAccessToken(invsmSyncObj)).get("msg"))) {
                return CallbackResponseVo.valueOfError(ErrorType.FI_PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u8bf7\u6c42\u5e94\u6536\u7cfb\u7edf\u8c03\u7528AccessToken\u5931\u8d25", (String)"FiInvoiceCallbackHelper_38", (String)"imc-bdm-common", (Object[])new Object[0]));
            }
            String pushUrl = "";
            if (INVOICE_OPEN.equals(busType)) {
                pushUrl = invsmSyncObj.getString("issue");
            }
            if (INVOICE_CANCEL.equals(busType)) {
                pushUrl = invsmSyncObj.getString("abandon");
            }
            pushUrl = pushUrl.concat("?access_token=").concat(String.valueOf(rMap.get("accessToken")));
            try {
                JSONObject json = new JSONObject();
                json.put("datas", (Object)invoiceArr);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(String.format("\u5e94\u6536\u56de\u8c03\uff0c\u8bf7\u6c42\u62a5\u6587\u662f\uff1a%s,\u8bf7\u6c42\u5730\u5740\u662f\uff1a%s", json.toJSONString(), pushUrl));
                }
                pushRs = HttpClientUtils.postjson((String)pushUrl, null, (String)json.toJSONString());
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(String.format("\u5e94\u6536\u56de\u8c03\uff0c\u8fd4\u56de\u662f:%s", pushRs));
                }
                responseVo.setData(JSON.toJSONString((Object)callbackLogVo));
            }
            catch (Exception e) {
                responseVo.setCode(ApiErrCodeEnum.ERROR.getCode());
                responseVo.setMessage(e.getMessage());
            }
        }
        if (StringUtils.isBlank((CharSequence)pushRs)) {
            responseVo.setCode(ApiErrCodeEnum.ERROR.getCode());
            responseVo.setMessage(ResManager.loadKDString((String)"\u8c03\u7528\u63a5\u53e3\u5931\u8d25\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a", (String)"FiInvoiceCallbackHelper_39", (String)"imc-bdm-common", (Object[])new Object[0]));
            return responseVo;
        }
        JSONObject rObj = JSON.parseObject((String)pushRs);
        String code = !rObj.containsKey((Object)SUCCESS) ? "9999" : (Boolean.TRUE.equals(rObj.get((Object)SUCCESS)) ? "0" : "9999");
        responseVo.setCode(code);
        responseVo.setMessage(rObj.getString("message"));
        return responseVo;
    }

    public static Map<String, Object> getAccessToken(DynamicObject invsmAynObj) {
        HashMap<String, Object> rMap = new HashMap<String, Object>(2);
        rMap.put("msg", "");
        rMap.put("accessToken", "");
        String cacheAccessToken = CacheHelper.get(ACCESSTOKEN_CACHE_KEY);
        if (StringUtils.isNotBlank((CharSequence)cacheAccessToken)) {
            rMap.put("accessToken", cacheAccessToken);
            return rMap;
        }
        String appTokenUrl = invsmAynObj.getString("apptoken");
        String accessTokenUrl = invsmAynObj.getString("accesstoken");
        String appId = invsmAynObj.getString("appid");
        String appSecuret = invsmAynObj.getString("appsecuret");
        String tenantid = invsmAynObj.getString("tenantid");
        String accountId = invsmAynObj.getString("accountid");
        String language = invsmAynObj.getString("language");
        String user = invsmAynObj.getString("user");
        String appToken = "";
        String accToken = "";
        if (StringUtils.isBlank((CharSequence)appTokenUrl) || StringUtils.isBlank((CharSequence)accessTokenUrl)) {
            rMap.put("msg", ResManager.loadKDString((String)"\u5e94\u6536\u53d1\u7968\u56de\u8c03\u53c2\u6570--AppToken\u6216AccessToken\u914d\u7f6e\u5f02\u5e38", (String)"FiInvoiceCallbackHelper_17", (String)"imc-bdm-common", (Object[])new Object[0]));
            return rMap;
        }
        if (StringUtils.isBlank((CharSequence)appId) || StringUtils.isBlank((CharSequence)appSecuret)) {
            rMap.put("msg", ResManager.loadKDString((String)"\u5e94\u6536\u53d1\u7968\u56de\u8c03\u53c2\u6570--AppId\u6216appSecuret\u914d\u7f6e\u5f02\u5e38", (String)"FiInvoiceCallbackHelper_18", (String)"imc-bdm-common", (Object[])new Object[0]));
            return rMap;
        }
        if (StringUtils.isBlank((CharSequence)user)) {
            rMap.put("msg", ResManager.loadKDString((String)"\u5e94\u6536\u53d1\u7968\u56de\u8c03\u53c2\u6570--user\u914d\u7f6e\u5f02\u5e38", (String)"FiInvoiceCallbackHelper_19", (String)"imc-bdm-common", (Object[])new Object[0]));
            return rMap;
        }
        JSONObject appTokenJson = new JSONObject();
        appTokenJson.put("appId", (Object)appId);
        appTokenJson.put("appSecuret", (Object)appSecuret);
        appTokenJson.put("tenantid", (Object)tenantid);
        appTokenJson.put("accountId", (Object)accountId);
        appTokenJson.put("language", (Object)language);
        try {
            TokenDto appTokenDto;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("\u5e94\u6536\u56de\u8c03\uff0c\u83b7\u53d6AppToken\u7684\u8bf7\u6c42\u62a5\u6587\u662f\uff1a%s;\u8bf7\u6c42\u5730\u5740\u662f\uff1a%s", appTokenJson.toJSONString(), appTokenUrl));
            }
            String appTokenResult = HttpClientUtils.postjson((String)appTokenUrl, null, (String)appTokenJson.toJSONString());
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("\u5e94\u6536\u56de\u8c03\uff0c\u83b7\u53d6AppToken\u7684\u8fd4\u56de\u62a5\u6587\u662f\uff1a%s", appTokenResult));
            }
            if (null == (appTokenDto = (TokenDto)JSON.parseObject((String)appTokenResult, TokenDto.class)) || UN_SUCCESS.contains((Object)appTokenDto.getState())) {
                rMap.put("msg", ResManager.loadKDString((String)"\u83b7\u53d6APPToken\u5931\u8d25", (String)"FiInvoiceCallbackHelper_22", (String)"imc-bdm-common", (Object[])new Object[0]));
                return rMap;
            }
            if (SUCCESS.equals(appTokenDto.getState())) {
                appToken = appTokenDto.getData().getAppToken();
            }
            if (StringUtils.isBlank((CharSequence)appToken)) {
                rMap.put("msg", ResManager.loadKDString((String)"\u83b7\u53d6APPToken\u5931\u8d25", (String)"FiInvoiceCallbackHelper_22", (String)"imc-bdm-common", (Object[])new Object[0]));
                return rMap;
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("\u5e94\u6536\u56de\u8c03\uff0c\u83b7\u53d6AppToken\u53d1\u751f\u5f02\u5e38\uff1a%s;\u8bf7\u6c42\u5730\u5740\u662f\uff1a%s;\u8bf7\u6c42\u62a5\u6587\u662f\uff1a%s", e.getMessage(), appTokenUrl, appTokenJson.toJSONString()));
            rMap.put("msg", ResManager.loadKDString((String)"\u83b7\u53d6\u5e94\u6536\u7cfb\u7edfAPPToken\u5f02\u5e38", (String)"FiInvoiceCallbackHelper_24", (String)"imc-bdm-common", (Object[])new Object[0]));
            return rMap;
        }
        JSONObject accessJson = new JSONObject();
        accessJson.put("user", (Object)user);
        String userPass = invsmAynObj.getString("password");
        if (StringUtils.isNotBlank((CharSequence)userPass)) {
            accessJson.put("password", (Object)userPass);
            accessJson.put("logintype", (Object)"2");
        }
        accessJson.put("appSecuret", (Object)appSecuret);
        accessJson.put("tenantid", (Object)tenantid);
        accessJson.put("accountId", (Object)accountId);
        accessJson.put("usertype", (Object)invsmAynObj.getString("usertype"));
        accessJson.put("apptoken", (Object)appToken);
        try {
            TokenDto accessToken;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("\u5e94\u6536\u56de\u8c03\uff0c\u83b7\u53d6AccessToken\u7684\u8bf7\u6c42\u62a5\u6587\u662f\uff1a%s;\u8bf7\u6c42\u5730\u5740\u662f\uff1a%s", accessJson.toJSONString(), accessTokenUrl));
            }
            String accTokenResult = HttpClientUtils.postjson((String)accessTokenUrl, null, (String)accessJson.toJSONString());
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("\u5e94\u6536\u56de\u8c03\uff0c\u83b7\u53d6AccessToken\u7684\u8fd4\u56de\u62a5\u6587\u662f\uff1a%s", accTokenResult));
            }
            if (null == (accessToken = (TokenDto)JSON.parseObject((String)accTokenResult, TokenDto.class)) || UN_SUCCESS.contains((Object)accessToken.getState())) {
                rMap.put("msg", ResManager.loadKDString((String)"\u83b7\u53d6ACCEssToken\u5931\u8d25", (String)"FiInvoiceCallbackHelper_27", (String)"imc-bdm-common", (Object[])new Object[0]));
                return rMap;
            }
            if (SUCCESS.equals(accessToken.getState())) {
                accToken = accessToken.getData().getAccessToken();
            }
            if (StringUtils.isNotBlank((CharSequence)accToken)) {
                CacheHelper.put(ACCESSTOKEN_CACHE_KEY, accToken, 3600);
                rMap.put("accessToken", accToken);
                return rMap;
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("\u5e94\u6536\u56de\u8c03\uff0c\u83b7\u53d6\u5e94\u6536\u7cfb\u7edfAccessToken\u53d1\u751f\u5f02\u5e38\uff1a%s;\u8bf7\u6c42\u5730\u5740\u662f\uff1a%s;\u8bf7\u6c42\u62a5\u6587\u662f\uff1a%s", e.getMessage(), accessTokenUrl, accessJson.toJSONString()));
            CacheHelper.remove(ACCESSTOKEN_CACHE_KEY);
            rMap.put("msg", ResManager.loadKDString((String)"\u83b7\u53d6\u5e94\u6536\u7cfb\u7edfAccessToken\u5931\u8d25", (String)"FiInvoiceCallbackHelper_29", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        return rMap;
    }

    public static InvoiceDataVo buildMainData(OrderDetailVo vo, String oriBillNo) {
        String inventoryProjectName = "";
        if (1 == vo.getInventoryFlag() && 0 == vo.getInvoiceProperty()) {
            inventoryProjectName = "\u8be6\u89c1\u84dd\u5b57\u9500\u8d27\u6e05\u5355";
        }
        if (1 == vo.getInventoryFlag() && 1 == vo.getInvoiceProperty()) {
            inventoryProjectName = "\u8be6\u89c1\u9500\u8d27\u6e05\u5355";
        }
        String invoiceDate = "";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            invoiceDate = sdf.format(vo.getInvoiceDate());
        }
        catch (Exception e) {
            LOGGER.error(String.format("\u5e94\u6536\u5f00\u7968\u6570\u636e\u56de\u63a8\u65e5\u671f\u8f6c\u6362\u5f02\u5e38:%s", e.getMessage()));
        }
        String totalAmountCn = ConvertUpMoneyUtils.toChinese(vo.getIncludeTaxAmount().toPlainString());
        return FiInvoiceCallbackHelper.getInvoiceDataVo(vo, oriBillNo, inventoryProjectName, invoiceDate, totalAmountCn);
    }

    public static InvoiceDataVo getInvoiceDataVo(OrderDetailVo vo, String oriBillNo, String inventoryProjectName, String invoiceDate, String totalAmountCn) {
        InvoiceDataVo invoiceDataVo = new InvoiceDataVo();
        invoiceDataVo.setSalerName(vo.getSellerName());
        invoiceDataVo.setSalerTaxNo(vo.getSellerTaxpayerId());
        invoiceDataVo.setSalerAccount(vo.getSellerBankAndAccount());
        invoiceDataVo.setSalerAddressPhone(vo.getSellerAddressAndTel());
        invoiceDataVo.setBuyerName(vo.getBuyerName());
        invoiceDataVo.setBuyerTaxNo(vo.getBuyerTaxpayerId());
        invoiceDataVo.setBuyerAccount(vo.getBuyerBankAndAccount());
        invoiceDataVo.setBuyerAddressPhone(vo.getBuyerAddressAndTel());
        invoiceDataVo.setInvoiceAmount(vo.getTotalAmount());
        invoiceDataVo.setRemark(vo.getRemark());
        invoiceDataVo.setType(vo.getInvoiceProperty());
        invoiceDataVo.setPayee(vo.getPayee());
        invoiceDataVo.setDrawer(vo.getDrawer());
        invoiceDataVo.setReviewer(vo.getReviewer());
        invoiceDataVo.setInvoiceType(vo.getInvoiceType());
        invoiceDataVo.setInvoiceNo(vo.getInvoiceNumber());
        invoiceDataVo.setInvoiceCode(vo.getInvoiceCode());
        invoiceDataVo.setOriginalInvoiceNo(vo.getOriginalInvoiceNumber());
        invoiceDataVo.setOriginalInvoiceCode(vo.getOriginalInvoiceCode());
        invoiceDataVo.setBillNo(oriBillNo);
        invoiceDataVo.setInventoryFlag(vo.getInventoryFlag() + "");
        invoiceDataVo.setSerialNo(vo.getSerialNo());
        invoiceDataVo.setTotalAmount(vo.getIncludeTaxAmount());
        invoiceDataVo.setTotalTaxAmount(vo.getTotalTaxAmount());
        invoiceDataVo.setMergeDifferTaxAmount(vo.getMergeDifferTaxAmount());
        invoiceDataVo.setAutoOpen("0");
        invoiceDataVo.setWxCardBagUrl("");
        invoiceDataVo.setInventoryProjectName(inventoryProjectName);
        invoiceDataVo.setInvoiceStatus(CallbackHelperUtil.convertInvStatus(vo.getInvoiceStatus()));
        invoiceDataVo.setInvoiceType(CallbackHelperUtil.convertInvoiceType(vo.getInvoiceType()));
        invoiceDataVo.setSplitOrMergeFlag(vo.getSplitOrMergeFlag());
        invoiceDataVo.setTotalAmountCn(totalAmountCn);
        invoiceDataVo.setInvoiceDate(invoiceDate);
        invoiceDataVo.setPdfUrl(vo.getInvoiceFileUrl());
        ArrayList<InvoiceDataDetailVo> items = new ArrayList<InvoiceDataDetailVo>(vo.getGoods().size());
        for (InvoiceDetailVo item : vo.getGoods()) {
            InvoiceDataDetailVo detailVo = new InvoiceDataDetailVo();
            detailVo.setTaxFlag(StringUtils.isBlank((CharSequence)item.getTaxFlag()) ? Integer.valueOf(0) : Integer.valueOf(item.getTaxFlag()));
            detailVo.setUnitPrice(StringUtils.isBlank((CharSequence)item.getPrice()) ? BigDecimal.ZERO : new BigDecimal(item.getPrice()));
            detailVo.setNum(StringUtils.isBlank((CharSequence)item.getQuantity()) ? BigDecimal.ZERO : new BigDecimal(item.getQuantity()));
            detailVo.setPreferentialPolicy(item.getPrivilegeFlag() + "");
            detailVo.setZeroTaxRateFlag(item.getZeroTaxRateFlag());
            detailVo.setItemId(item.getBillSourceId());
            detailVo.setTaxRate(item.getTaxRate());
            detailVo.setUnit(item.getUnits());
            detailVo.setSpecModel(item.getSpecification());
            detailVo.setDiscountType(item.getLineProperty() + "");
            detailVo.setGoodsCode(item.getRevenueCode());
            detailVo.setGoodsName(item.getGoodsName());
            detailVo.setDetailAmount(item.getAmount());
            detailVo.setTaxAmount(item.getTaxAmount());
            items.add(detailVo);
        }
        invoiceDataVo.setTaxFlag(((InvoiceDataDetailVo)items.get(0)).getTaxFlag());
        invoiceDataVo.setItems(items);
        return invoiceDataVo;
    }

    public static String getOriginalBillNo(DynamicObject invoiceDynamic) {
        Object invoicePk = invoiceDynamic.getPkValue();
        if (StringUtils.isBlank((Object)invoicePk)) {
            return "";
        }
        QFilter filter = new QFilter("tbillid", "=", invoicePk);
        DynamicObjectCollection originalIdList = QueryServiceHelper.query((String)"sim_bill_inv_relation", (String)"sbillid", (QFilter[])filter.toArray());
        if (null == originalIdList || originalIdList.isEmpty()) {
            return "";
        }
        filter = new QFilter("id", "in", originalIdList.stream().map(o -> o.getLong("sbillid")).collect(Collectors.toSet()));
        DynamicObjectCollection originalList = QueryServiceHelper.query((String)"sim_original_bill", (String)"billno", (QFilter[])filter.toArray());
        return String.join((CharSequence)",", originalList.stream().map(o -> o.getString("billno")).collect(Collectors.toSet()));
    }

    public static DynamicObject getFiCallbackConfig(String taxNo) {
        QFilter filter = new QFilter("revenuenumber", "=", (Object)taxNo);
        String selFields = PropertieUtil.getAllPropertiesSplitByComma(INVSM_SYNC_CALLBACK_ADDR, true);
        return QueryServiceHelper.queryOne((String)INVSM_SYNC_CALLBACK_ADDR, (String)selFields, (QFilter[])filter.toArray());
    }

    public static boolean arBizServiceExist() {
        try {
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"ar", (String)"IssueInvoiceService", (String)"testMservice", (Object[])new Object[0]);
            return true;
        }
        catch (Exception e) {
            String message;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("\u68c0\u6d4b\u662f\u5426\u6709\u5f00\u7968\u5355\u5fae\u670d\u52a1 : ", (Object)e.getMessage());
            }
            return !(message = (String)StringUtils.defaultIfEmpty((CharSequence)e.getMessage(), (CharSequence)"")).contains("\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230") && message.contains("\u65b9\u6cd5testMservice");
        }
    }
}

