/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.AppMetadataCache;
import kd.bos.log.api.AppLogInfo;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;

public class ImcLogHelper {
    public static String compareDynamic(DynamicObject source, DynamicObject target) {
        DataEntityPropertyCollection properties = source.getDynamicObjectType().getProperties();
        ArrayList<String> nameList = new ArrayList<String>(properties.size());
        for (IDataEntityProperty property : properties) {
            String key = property.getName();
            Class clazz = property.getPropertyType();
            if (clazz == Date.class || clazz == ILocaleString.class) continue;
            if (clazz == DynamicObject.class) {
                if (DynamicObjectUtil.getDynamicObjectLongValue(source.get(key)) == DynamicObjectUtil.getDynamicObjectLongValue(target.get(key))) continue;
                ImcLogHelper.getDisplayName(property, nameList);
                continue;
            }
            if (Objects.equals(source.get(key), target.get(key))) continue;
            ImcLogHelper.getDisplayName(property, nameList);
        }
        return String.join((CharSequence)"\uff0c", nameList);
    }

    private static void getDisplayName(IDataEntityProperty property, List<String> nameList) {
        LocaleString displayName = property.getDisplayName();
        if (displayName != null) {
            nameList.add(displayName.getLocaleValue());
        }
    }

    public static void addLog(String appNumber, String entityNumber, String opName, String desc) {
        AppLogInfo appLogInfo = new AppLogInfo();
        appLogInfo.setBizAppID(AppMetadataCache.getAppInfo((String)appNumber).getId());
        appLogInfo.setBizObjID(entityNumber);
        appLogInfo.setOpName(opName);
        appLogInfo.setOpDescription(desc);
        LogServiceHelper.addLog((AppLogInfo)appLogInfo);
    }
}

