/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.imc.bdm.common.constant.issuepolicy.IssueChannelTypeEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.openapi.BizControlVo;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import org.apache.commons.collections.CollectionUtils;

public class IssuePolicyHelper {
    private static final Log LOG = LogFactory.getLog(IssuePolicyHelper.class);

    private static Object getIssueBizControl(String number, Long orgId) {
        QFilter qFilter = new QFilter("number", "=", (Object)number);
        DynamicObject bizType = BusinessDataServiceHelper.loadSingle((String)"bdm_issue_biz_type", (String)"id", (QFilter[])qFilter.toArray());
        if (bizType == null) {
            throw new MsgException(ResManager.loadKDString((String)"\u5f00\u7968\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728", (String)"IssuePolicyHelper_7", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        QFilter qFilter2 = new QFilter("issuebiztype", "=", bizType.getPkValue());
        qFilter2.and("org", "=", (Object)orgId);
        DynamicObject bizControl = BusinessDataServiceHelper.loadSingle((String)"bdm_biz_control", (String)"id", (QFilter[])qFilter2.toArray());
        if (bizControl == null) {
            throw new MsgException(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0d\u5b58\u5728\u4f01\u4e1a\u5f00\u7968\u4e1a\u52a1\u7ba1\u63a7", (String)"IssuePolicyHelper_8", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        return bizControl.getPkValue();
    }

    public static void makeIssuePolicy(DynamicObject invoice) {
        if (invoice.get("bizcontroltype") == null) {
            return;
        }
        DynamicObject issueBizControlDO = BusinessDataServiceHelper.loadSingle((Object)invoice.getDynamicObject("bizcontroltype").getPkValue(), (String)"bdm_biz_control");
        if (issueBizControlDO == null) {
            return;
        }
        DynamicObjectCollection channelList = issueBizControlDO.getDynamicObjectCollection("entrychannel");
        boolean hasLQ = false;
        boolean hasRPA = false;
        boolean hasPAN = false;
        boolean allChannelEnable = issueBizControlDO.getBoolean("channelenable");
        ArrayList<String> devList = new ArrayList<String>();
        JSONArray accountList = new JSONArray();
        for (DynamicObject channel : channelList) {
            if (IssueChannelTypeEnum.LQ.getCode().equals(channel.getString("channeltype"))) {
                hasLQ = true;
                continue;
            }
            if (IssueChannelTypeEnum.RPA.getCode().equals(channel.getString("channeltype"))) {
                hasRPA = true;
                HashMap<String, String> hashMap = new HashMap<String, String>(4);
                hashMap.put("account", channel.getString("account"));
                hashMap.put("drawer", channel.getString("drawer"));
                accountList.add(hashMap);
                continue;
            }
            if (!IssueChannelTypeEnum.PAN.getCode().equals(channel.getString("channeltype"))) continue;
            hasPAN = true;
            devList.add(channel.getString("devno"));
        }
        IssuePolicyHelper.checkIssueBizType(issueBizControlDO, invoice);
        boolean isAllE = Boolean.TRUE;
        if (InvoiceUtils.isAllEInvoice(invoice.getString("invoicetype")) || AllEleAuthHelper.isElePaper(invoice.getString("iselepaper"))) {
            if (!allChannelEnable) {
                if (EnterpriseHelper.isLqptChannel(invoice.getString("salertaxno")) && !hasLQ) {
                    throw new MsgException(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u4f01\u4e1a\u5f00\u7968\u4e1a\u52a1\u7ba1\u63a7\uff0c\u4e50\u4f01\u901a\u9053\u672a\u914d\u7f6e", (String)"IssuePolicyHelper_0", (String)"imc-bdm-common", (Object[])new Object[0]));
                }
                if (!hasRPA) {
                    throw new MsgException(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u4f01\u4e1a\u5f00\u7968\u4e1a\u52a1\u7ba1\u63a7\uff0cRPA\u901a\u9053\u672a\u914d\u7f6e", (String)"IssuePolicyHelper_1", (String)"imc-bdm-common", (Object[])new Object[0]));
                }
            }
        } else {
            isAllE = Boolean.FALSE;
            if (!hasPAN && !allChannelEnable) {
                throw new MsgException(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u4f01\u4e1a\u5f00\u7968\u4e1a\u52a1\u7ba1\u63a7\uff0c\u7a0e\u63a7\u901a\u9053\u672a\u914d\u7f6e", (String)"IssuePolicyHelper_2", (String)"imc-bdm-common", (Object[])new Object[0]));
            }
            if (!devList.contains(invoice.getString("jqbh")) && !allChannelEnable) {
                throw new MsgException(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u4f01\u4e1a\u5f00\u7968\u4e1a\u52a1\u7ba1\u63a7\uff0c\u7a0e\u63a7\u901a\u9053\u672a\u914d\u7f6e\u8be5\u7a0e\u76d8\u8bbe\u5907", (String)"IssuePolicyHelper_3", (String)"imc-bdm-common", (Object[])new Object[0]));
            }
        }
        BigDecimal dayUseAmount = IssuePolicyHelper.getDayUse(issueBizControlDO).add(invoice.getBigDecimal("invoiceamount"));
        BigDecimal monthUseAmount = IssuePolicyHelper.getMonthUse(issueBizControlDO).add(invoice.getBigDecimal("invoiceamount"));
        IssuePolicyHelper.checkDayLimit(issueBizControlDO.getBigDecimal("daylimt"), dayUseAmount);
        IssuePolicyHelper.checkMonthLimit(issueBizControlDO.getBigDecimal("monthlimit"), monthUseAmount);
        IssuePolicyHelper.checkRoleLimit(invoice, issueBizControlDO, dayUseAmount, monthUseAmount);
        IssuePolicyHelper.doChannelPolicy(issueBizControlDO, accountList, invoice, isAllE);
        IssuePolicyHelper.addIssueLimitLog(invoice, issueBizControlDO);
    }

    private static void doChannelPolicy(DynamicObject issueBizControlDO, JSONArray accountList, DynamicObject invoice, Boolean isAllE) {
        if (!isAllE.booleanValue()) {
            return;
        }
        DynamicObject channelPolicy = issueBizControlDO.getDynamicObject("channelpolicy");
        if (channelPolicy == null) {
            return;
        }
        channelPolicy = BusinessDataServiceHelper.loadSingle((Object)channelPolicy.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bdm_channel_policy"));
        DynamicObjectCollection dynamicObjectCollection = channelPolicy.getDynamicObjectCollection("item");
        for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
            boolean isMatch;
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(i);
            if ("003".equals(dynamicObject.getString("rulenumber"))) {
                IssuePolicyHelper.goChannel003(accountList, invoice);
                continue;
            }
            if ("002".equals(dynamicObject.getString("rulenumber"))) {
                isMatch = IssuePolicyHelper.matchDrawer(accountList, invoice);
                if (isMatch) continue;
                IssuePolicyHelper.goChannel003(accountList, invoice);
                continue;
            }
            if (!"001".equals(dynamicObject.getString("rulenumber")) || (isMatch = IssuePolicyHelper.matchDrawer(accountList, invoice)) || i != dynamicObjectCollection.size() - 1) continue;
            throw new MsgException(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u5355\u636e\u6307\u5b9a\u901a\u9053\u7b56\u7565\uff0c\u5f00\u7968\u4eba\u672a\u5339\u914d\u5230\u5bf9\u5e94\u8d26\u53f7", (String)"IssuePolicyHelper_9", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
    }

    private static boolean matchDrawer(JSONArray accountList, DynamicObject invoice) {
        boolean isMatch = false;
        for (Object o : accountList) {
            HashMap hashMap = (HashMap)o;
            if (!invoice.getString("drawer").equals(hashMap.get("drawer"))) continue;
            isMatch = true;
            invoice.set("account", hashMap.get("account"));
        }
        return isMatch;
    }

    private static void goChannel003(JSONArray accountList, DynamicObject invoice) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object o : accountList) {
            HashMap hashMap = (HashMap)o;
            stringBuilder.append(hashMap.get("account")).append(",");
        }
        CacheHelper.put("accountList_" + invoice.getString("orderno"), stringBuilder.toString(), 60);
    }

    private static void addIssueLimitLog(DynamicObject invoice, DynamicObject issueBizControlDO) {
        if (invoice.getLong("id") == 0L) {
            return;
        }
        QFilter qFilter = new QFilter("invoiceid", "=", invoice.getPkValue());
        boolean exists = QueryServiceHelper.exists((String)"bdm_issue_policy_log", (QFilter[])qFilter.toArray());
        if (!exists) {
            DynamicObject dynamicObject = IssuePolicyHelper.newBizLog(invoice, issueBizControlDO);
            ImcSaveServiceHelper.save(dynamicObject);
        }
    }

    public static void updateUseAmountLog(DynamicObject invoiceDynamicObject) {
    }

    private static DynamicObject newBizLog(DynamicObject invoice, DynamicObject issueBizControlDO) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bdm_issue_policy_log");
        dynamicObject.set("bizcontroltype", (Object)issueBizControlDO);
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("useamount", (Object)invoice.getBigDecimal("invoiceamount"));
        dynamicObject.set("invoiceid", invoice.getPkValue());
        dynamicObject.set("issuestatus", (Object)"0");
        dynamicObject.set("epname", (Object)invoice.getString("salername"));
        dynamicObject.set("taxno", (Object)invoice.getString("salertaxno"));
        dynamicObject.set("billno", (Object)invoice.getString("billno"));
        dynamicObject.set("orgid", invoice.get("orgid"));
        return dynamicObject;
    }

    public static void deleteUseAmountLog(DynamicObject invoiceDynamicObject) {
        try {
            if (invoiceDynamicObject.get("bizcontroltype") == null) {
                return;
            }
            QFilter qFilter = new QFilter("invoiceid", "=", invoiceDynamicObject.getPkValue());
            int update = DeleteServiceHelper.delete((String)"bdm_issue_policy_log", (QFilter[])qFilter.toArray());
            if (update > 0) {
                LOG.info(String.format(ResManager.loadKDString((String)"\u91ca\u653e\u6388\u4fe1\u989d\u5ea6\u6210\u529f:%s", (String)"IssuePolicyHelper_10", (String)"imc-bdm-common", (Object[])new Object[0]), invoiceDynamicObject.get("invoiceno")));
            }
        }
        catch (Exception e) {
            LOG.error("IssuePolicyHelper updateUseAmountLog error", (Throwable)e);
        }
    }

    public static void updateLogIssueSuccess(DynamicObject invoice) {
        if (invoice.get("bizcontroltype") == null) {
            return;
        }
        try {
            QFilter qFilter = new QFilter("invoiceid", "=", invoice.getPkValue());
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bdm_issue_policy_log", (String)"id,invoicecode,invoiceno,issuetime,issuestatus,invoiceamount,usemonth", (QFilter[])qFilter.toArray());
            if (dynamicObject == null) {
                DynamicObject logDO = IssuePolicyHelper.newBizLog(invoice, invoice.getDynamicObject("bizcontroltype"));
                IssuePolicyHelper.updateLog(invoice, logDO);
                ImcSaveServiceHelper.save(logDO);
            } else {
                IssuePolicyHelper.updateLog(invoice, dynamicObject);
                ImcSaveServiceHelper.update((DynamicObject)dynamicObject);
            }
        }
        catch (Exception e) {
            LOG.error("IssuePolicyHelper updateLogIssueSuccess error", (Throwable)e);
        }
    }

    private static void updateLog(DynamicObject invoice, DynamicObject log) {
        log.set("invoicecode", invoice.get("invoicecode"));
        log.set("invoiceno", invoice.get("invoiceno"));
        log.set("issuetime", invoice.get("issuetime"));
        log.set("issuestatus", (Object)"1");
        log.set("invoiceamount", invoice.get("invoiceamount"));
        log.set("usemonth", (Object)DateUtils.format(new Date(), "yyyy-MM"));
    }

    private static void checkMonthLimit(BigDecimal monthLimit, BigDecimal monthUseAmount) {
        if (monthLimit.subtract(monthUseAmount).compareTo(BigDecimal.ZERO) < 0) {
            throw new MsgException(ErrorType.FAIL.getCode(), String.format(ResManager.loadKDString((String)"\u4f01\u4e1a\u5f00\u7968\u4e1a\u52a1\u7ba1\u63a7\uff0c\u5df2\u8d85\u8fc7\u5f53\u6708\u6388\u4fe1\u989d\u5ea6\u9650\u5236%s\u5143", (String)"IssuePolicyHelper_11", (String)"imc-bdm-common", (Object[])new Object[0]), monthLimit.setScale(2, 4).toString()));
        }
    }

    public static BigDecimal getMonthUse(DynamicObject issueBizControlDO) {
        LocalDate currentDate = LocalDate.now();
        LocalDate firstDayOfMonth = currentDate.withDayOfMonth(1);
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = firstDayOfMonth.atStartOfDay().atZone(zone).toInstant();
        QFilter qFilter = new QFilter("bizcontroltype", "=", issueBizControlDO.getPkValue());
        qFilter.and("createtime", ">=", (Object)DateUtils.trunc(Date.from(instant))).and("createtime", "<=", (Object)new Date());
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bdm_issue_policy_log", (String)PropertieUtil.getAllPropertiesSplitByComma("bdm_issue_policy_log"), (QFilter[])qFilter.toArray());
        BigDecimal totalUseAmount = BigDecimal.ZERO;
        if (dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                totalUseAmount = totalUseAmount.add(dynamicObject.getBigDecimal("useamount"));
            }
        }
        return totalUseAmount;
    }

    private static BigDecimal getDayUse(DynamicObject issueBizControlDO) {
        Date today = new Date();
        QFilter qFilter = new QFilter("bizcontroltype", "=", issueBizControlDO.getPkValue());
        qFilter.and("createtime", ">=", (Object)DateUtils.trunc(today)).and("createtime", "<", (Object)DateUtils.trunc(DateUtils.addDay(today, 1)));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bdm_issue_policy_log", (String)PropertieUtil.getAllPropertiesSplitByComma("bdm_issue_policy_log"), (QFilter[])qFilter.toArray());
        BigDecimal totalUseAmount = BigDecimal.ZERO;
        if (dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                totalUseAmount = totalUseAmount.add(dynamicObject.getBigDecimal("useamount"));
            }
        }
        return totalUseAmount;
    }

    private static void checkSingleLimit(BigDecimal singleLimit, BigDecimal invoiceAmount) {
        if (singleLimit == null) {
            singleLimit = BigDecimal.ZERO;
        }
        if (singleLimit.subtract(invoiceAmount).compareTo(BigDecimal.ZERO) < 0) {
            throw new MsgException(ErrorType.FAIL.getCode(), String.format(ResManager.loadKDString((String)"\u4e0d\u542b\u7a0e\u91d1\u989d\u8d85\u8fc7\u5f00\u7968\u4e1a\u52a1\u7c7b\u578b\u5355\u5f20\u9650\u989d%s\u5143", (String)"IssuePolicyHelper_13", (String)"imc-bdm-common", (Object[])new Object[0]), singleLimit.setScale(2, 4).toString()));
        }
    }

    private static void checkDayLimit(BigDecimal dayLimit, BigDecimal dayUseAmount) {
        if (dayLimit.subtract(dayUseAmount).compareTo(BigDecimal.ZERO) < 0) {
            throw new MsgException(ErrorType.FAIL.getCode(), String.format(ResManager.loadKDString((String)"\u4f01\u4e1a\u5f00\u7968\u4e1a\u52a1\u7ba1\u63a7\uff0c\u5df2\u8d85\u8fc7\u6bcf\u65e5\u6388\u4fe1\u989d\u5ea6\u9650\u5236%s\u5143", (String)"IssuePolicyHelper_12", (String)"imc-bdm-common", (Object[])new Object[0]), dayLimit.setScale(2, 4).toString()));
        }
    }

    private static void checkRoleLimit(DynamicObject invoice, DynamicObject issueBizControlDO, BigDecimal dayUseAmount, BigDecimal monthUseAmount) {
        DynamicObjectCollection roleLimits = issueBizControlDO.getDynamicObjectCollection("rolelimit");
        if (CollectionUtils.isEmpty((Collection)roleLimits)) {
            LOG.info("\u672a\u914d\u7f6e\u89d2\u8272\u6388\u4fe1\u989d\u5ea6\u9650\u5236\uff0c\u4e0d\u7ba1\u63a7");
            return;
        }
        long invoicingOperator = DynamicObjectUtil.getDynamicObjectLongValue(invoice.get("invoicingoperator"));
        if (invoicingOperator == 0L) {
            LOG.info("\u5f00\u7968\u64cd\u4f5c\u4eba\u4e3a\u7a7a\uff0c\u4e0d\u7ba1\u63a7");
            return;
        }
        Set roleIds = PermissionServiceHelper.getRolesByUser((Long)invoicingOperator);
        if (CollectionUtils.isEmpty((Collection)roleIds)) {
            LOG.info("\u7528\u6237\u5173\u8054\u901a\u7528\u89d2\u8272\u4e3a\u7a7a\uff0c\u4e0d\u7ba1\u63a7");
            return;
        }
        List roleLimitList = roleLimits.stream().filter(role -> role != null && roleIds.contains(role.getDynamicObject("role").getPkValue().toString())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(roleLimitList)) {
            return;
        }
        DynamicObject roleLimitOne = (DynamicObject)roleLimitList.get(0);
        BigDecimal singleLimit = roleLimitOne.getBigDecimal("singleinvoicelimit");
        BigDecimal dayLimit = roleLimitOne.getBigDecimal("dayinvoicelimit");
        BigDecimal monthLimit = roleLimitOne.getBigDecimal("monthinvoicelimit");
        String roleLimitRule = issueBizControlDO.getString("rolelimitrule");
        if ("1".equals(roleLimitRule)) {
            for (int i = 1; i < roleLimitList.size(); ++i) {
                DynamicObject roleLimit = (DynamicObject)roleLimitList.get(i);
                if (roleLimit.getBigDecimal("singleinvoicelimit").compareTo(singleLimit) > 0) {
                    singleLimit = roleLimit.getBigDecimal("singleinvoicelimit");
                }
                if (roleLimit.getBigDecimal("dayinvoicelimit").compareTo(dayLimit) > 0) {
                    dayLimit = roleLimit.getBigDecimal("dayinvoicelimit");
                }
                if (roleLimit.getBigDecimal("monthinvoicelimit").compareTo(monthLimit) <= 0) continue;
                monthLimit = roleLimit.getBigDecimal("monthinvoicelimit");
            }
        } else {
            for (int i = 1; i < roleLimitList.size(); ++i) {
                DynamicObject roleLimit = (DynamicObject)roleLimitList.get(i);
                if (roleLimit.getBigDecimal("singleinvoicelimit").compareTo(singleLimit) < 0) {
                    singleLimit = roleLimit.getBigDecimal("singleinvoicelimit");
                }
                if (roleLimit.getBigDecimal("dayinvoicelimit").compareTo(dayLimit) < 0) {
                    dayLimit = roleLimit.getBigDecimal("dayinvoicelimit");
                }
                if (roleLimit.getBigDecimal("monthinvoicelimit").compareTo(monthLimit) >= 0) continue;
                monthLimit = roleLimit.getBigDecimal("monthinvoicelimit");
            }
        }
        IssuePolicyHelper.checkSingleLimit(singleLimit, invoice.getBigDecimal("invoiceamount"));
        IssuePolicyHelper.checkDayLimit(dayLimit, dayUseAmount);
        IssuePolicyHelper.checkMonthLimit(monthLimit, monthUseAmount);
    }

    private static void checkIssueBizType(DynamicObject issueBizControlDO, DynamicObject invoice) {
        boolean taxCodeEnable;
        DynamicObject issueBizTypeDO = issueBizControlDO.getDynamicObject("issuebiztype");
        issueBizTypeDO = BusinessDataServiceHelper.loadSingle((Object)issueBizTypeDO.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bdm_issue_biz_type"));
        IssuePolicyHelper.checkSingleLimit(issueBizTypeDO.getBigDecimal("invoicelimit"), invoice.getBigDecimal("invoiceamount"));
        boolean issueTimeEnable = issueBizTypeDO.getBoolean("issuetimeallenable");
        if (!issueTimeEnable) {
            DynamicObjectCollection timeItems = issueBizTypeDO.getDynamicObjectCollection("items");
            for (DynamicObject timeItem : timeItems) {
                int startTime = timeItem.getInt("starttime");
                int endTime = timeItem.getInt("endtime");
                String format = new SimpleDateFormat("HH:mm:ss").format(new Date());
                int s = LocalTime.parse(format).toSecondOfDay();
                if (s <= startTime || s >= endTime) continue;
                issueTimeEnable = true;
            }
            if (!issueTimeEnable) {
                throw new MsgException(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u5f00\u7968\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5728\u5f00\u7968\u65f6\u95f4\u6bb5\u5185", (String)"IssuePolicyHelper_14", (String)"imc-bdm-common", (Object[])new Object[0]));
            }
        }
        if (!(taxCodeEnable = issueBizTypeDO.getBoolean("taxcodeenable"))) {
            DynamicObjectCollection taxCodeItems = issueBizTypeDO.getDynamicObjectCollection("itemtaxcode");
            DynamicObjectCollection items = invoice.getDynamicObjectCollection("items");
            for (int i = 0; i < items.size(); ++i) {
                DynamicObject taxCodeItem;
                String taxCode;
                String goodsCode = ((DynamicObject)items.get(i)).getString("goodscode");
                boolean taxOk = true;
                Iterator iterator = taxCodeItems.iterator();
                while (iterator.hasNext() && !goodsCode.equals(taxCode = (taxCodeItem = (DynamicObject)iterator.next()).getString("taxcode"))) {
                    taxOk = false;
                }
                if (taxOk) continue;
                throw new MsgException(ErrorType.FAIL.getCode(), String.format(ResManager.loadKDString((String)"\u5f00\u7968\u4e1a\u52a1\u7c7b\u578b\uff0c\u7b2c%1$s\u884c\u660e\u7ec6\uff0c\u7a0e\u6536\u5206\u7c7b\u7f16\u7801%2$s\u672a\u914d\u7f6e\u53ef\u7528", (String)"IssuePolicyHelper_15", (String)"imc-bdm-common", (Object[])new Object[0]), i + 1, goodsCode));
            }
        }
    }

    public static boolean isZero(BigDecimal sourceBigDecimal) {
        if (sourceBigDecimal == null) {
            return true;
        }
        return sourceBigDecimal.compareTo(BigDecimal.ZERO) == 0;
    }

    public static BizControlVo getBizControlVo(DynamicObject invoice) {
        if (invoice.get("bizcontroltype") == null) {
            return null;
        }
        BizControlVo bizControlVo = new BizControlVo();
        DynamicObject issueBizControlDO = BusinessDataServiceHelper.loadSingle((Object)invoice.getDynamicObject("bizcontroltype").getPkValue(), (String)"bdm_biz_control");
        DynamicObject issueBizTypeDO = issueBizControlDO.getDynamicObject("issuebiztype");
        BigDecimal monthLimit = issueBizControlDO.getBigDecimal("monthlimit");
        BigDecimal monthUse = IssuePolicyHelper.getMonthUse(issueBizControlDO);
        BigDecimal monthWarningLimit = issueBizControlDO.getBigDecimal("warninglimit");
        BigDecimal dayLimit = issueBizControlDO.getBigDecimal("daylimt");
        BigDecimal dayUse = IssuePolicyHelper.getDayUse(issueBizControlDO);
        bizControlVo.setMonthSurplusLimit(monthLimit.subtract(monthUse).setScale(2, RoundingMode.HALF_UP));
        bizControlVo.setDaySurplusLimit(dayLimit.subtract(dayUse).setScale(2, RoundingMode.HALF_UP));
        bizControlVo.setIssueBizType(issueBizControlDO.getString("number"));
        bizControlVo.setBizType(issueBizTypeDO.getString("number"));
        boolean isWarning = false;
        if (bizControlVo.getMonthSurplusLimit().subtract(monthWarningLimit).compareTo(BigDecimal.ZERO) <= 0) {
            isWarning = true;
        }
        bizControlVo.setWarning(isWarning);
        return bizControlVo;
    }

    public static void setBizControl(String issueBizType, DynamicObject dynamicBill) {
        Object bizControlId;
        block3: {
            boolean isThrowError = true;
            if (StringUtils.isEmpty((CharSequence)issueBizType)) {
                issueBizType = "0001";
                isThrowError = false;
            }
            bizControlId = null;
            try {
                bizControlId = IssuePolicyHelper.getIssueBizControl(issueBizType, DynamicObjectUtil.getDynamicObjectLongValue(dynamicBill.get("orgid")));
            }
            catch (MsgException e) {
                if (!isThrowError) break block3;
                throw e;
            }
        }
        dynamicBill.set("bizcontroltype", bizControlId);
    }
}

