/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.control.FilterGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.sdk.annotation.SdkDeprecated;

public class SchemeHelper {
    public static final String SALESORGBASE_NAME = "salesorgbase.name";
    public static final String SETTLEMENTORGBASE_NAME = "settlementorgbase.name";
    public static final String CAPITALORGBASE_NAME = "capitalorgbase.name";
    public static final String CUSTOMNAMEID_NAME = "customnameid.name";
    public static final String MATERIALTYPE_NAME = "materialtype.name";
    public static final String BILLTYPEBASE_NAME = "billtypebase.name";
    public static final String USER_NAME = "creator.name";
    private static ThreadLocal<String> SCHEME_LOCAL = new ThreadLocal();

    public static void setLocal(String jsonStr) {
        SCHEME_LOCAL.set(jsonStr);
    }

    public static String getLocal() {
        String jsonStr;
        try {
            jsonStr = SCHEME_LOCAL.get();
            SCHEME_LOCAL.remove();
        }
        catch (Exception e) {
            jsonStr = "";
        }
        return jsonStr;
    }

    public static FilterCondition getFilterByLocal() {
        FilterCondition filterCondition = null;
        String s = SchemeHelper.getLocal();
        if (StringUtils.isNotBlank((CharSequence)s)) {
            filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)s, FilterCondition.class);
        }
        return filterCondition;
    }

    public static void initializeFilterGrid(FilterGrid filterGrid, List<String> list, String entityName) {
        filterGrid.setEntityNumber(entityName);
        filterGrid.setFilterFieldKeys(list);
    }

    public static String getFilterStr(FilterGrid filterGrid) {
        String filterStr = "";
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        if (filterCondition != null && filterCondition.getFilterRow().size() > 0) {
            filterStr = SerializationUtils.toJsonString((Object)filterCondition);
        }
        return filterStr;
    }

    @SdkDeprecated
    public static Object getDefaultMergeRuleByOrg(long orgId) {
        QFilter qFilter = ImcBaseDataHelper.getMergeRuleFilter(orgId).and("ctrlstrategy", "=", (Object)"7");
        DynamicObject[] defaultMergeRules = BusinessDataServiceHelper.load((String)"bdm_merge_rule_strategy", (String)"", (QFilter[])qFilter.toArray(), (String)"systempreset asc");
        DynamicObject defaultMergeRule = defaultMergeRules.length == 0 ? BusinessDataServiceHelper.loadSingle((String)"bdm_merge_rule_strategy", (String)"", (QFilter[])new QFilter("id", "=", (Object)1610822718469790720L).toArray()) : defaultMergeRules[0];
        if (defaultMergeRule == null) {
            return 0L;
        }
        return defaultMergeRule.getPkValue();
    }

    public static List<String> getFieldKeys() {
        ArrayList list = Lists.newArrayList();
        list.add(SALESORGBASE_NAME);
        list.add(SETTLEMENTORGBASE_NAME);
        list.add(CAPITALORGBASE_NAME);
        list.add(CUSTOMNAMEID_NAME);
        list.add(MATERIALTYPE_NAME);
        list.add(BILLTYPEBASE_NAME);
        list.add(USER_NAME);
        list.add("textfield1");
        list.add("textfield2");
        list.add("textfield3");
        list.add("textfield4");
        list.add("textfield5");
        list.add("invoicetype");
        list.add("billsource");
        try {
            String extFilterField = ImcConfigUtil.getValue("filter_config", "ext_fields");
            if (StringUtils.isNotBlank((CharSequence)extFilterField)) {
                list.addAll(Arrays.asList(extFilterField.split(",")));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public static void addFields(List<String> fieldKeys) {
        try {
            String extFilterField = ImcConfigUtil.getValue("filter_config", "ext_title_fields");
            if (StringUtils.isNotBlank((CharSequence)extFilterField)) {
                fieldKeys.addAll(Arrays.asList(extFilterField.split(",")));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static List<String> getBuyerFieldKeys() {
        ArrayList list = Lists.newArrayList();
        list.add(SALESORGBASE_NAME);
        return list;
    }

    public static QFilter getQFilerByTag(String filterTag, String EntityType) {
        if (StringUtils.isBlank((CharSequence)filterTag)) {
            return null;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterTag, FilterCondition.class);
        FilterBuilder builder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)EntityType), filterCondition);
        builder.buildFilter();
        return builder.getQFilter();
    }
}

