/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.InvoiceSplitRuleElement;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.util.ComboEditUtil;

public class SplitRuleHelper {
    public static void bindSplitRuleByOrg(AbstractFormPlugin formPlugin, String propertyName) {
        SplitRuleHelper.bindSplitRuleByOrg(formPlugin, propertyName, RequestContext.get().getOrgId(), false);
    }

    public static void bindSplitRuleByOrg(AbstractFormPlugin formPlugin, String propertyName, Long orgId, boolean fillInDefault) {
        String splitRule;
        QFilter baseDataFilter = ImcBaseDataHelper.getSplitRuleFilter(orgId);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"bdm_inv_split_rule_strate", (String)"name,number", (QFilter[])baseDataFilter.toArray(), (String)"ctrlstrategy desc, createtime desc");
        if (objs.length == 0) {
            objs = BusinessDataServiceHelper.load((Object[])new Long[]{InvoiceSplitRuleElement.DEFAULT_RULE_ID}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bdm_inv_split_rule_strate"));
        }
        LinkedHashMap comboItems = Maps.newLinkedHashMapWithExpectedSize((int)10);
        for (DynamicObject obj : objs) {
            comboItems.put(obj.getString("name"), obj.getString("number"));
        }
        ComboEdit comboEdit = (ComboEdit)formPlugin.getControl(propertyName);
        if (comboEdit != null) {
            ComboEditUtil.fillComboEdit((ComboEdit)formPlugin.getControl(propertyName), comboItems, fillInDefault);
        }
        if (StringUtils.isBlank((CharSequence)(splitRule = (String)formPlugin.getView().getModel().getValue(propertyName))) && objs.length != 0) {
            formPlugin.getView().getModel().setValue(propertyName, objs[0].get("number"));
        }
    }

    public static DynamicObject getRuleByCode(Long orgId, String ruleCode) {
        DynamicObject ruleObj;
        QFilter ruleCodeFilter = new QFilter("number", "=", (Object)ruleCode);
        QFilter baseDataFilter = ImcBaseDataHelper.getSplitRuleFilter(orgId);
        DynamicObject ruleObjPk = BusinessDataServiceHelper.loadSingle((String)"bdm_inv_split_rule_strate", (String)"id", (QFilter[])new QFilter[]{ruleCodeFilter, baseDataFilter});
        if (null != ruleObjPk) {
            ruleObj = BusinessDataServiceHelper.loadSingle((Object)ruleObjPk.getPkValue(), (String)"bdm_inv_split_rule_strate");
        } else {
            ruleCodeFilter = new QFilter("number", "=", (Object)"000000_s");
            ruleObjPk = BusinessDataServiceHelper.loadSingle((String)"bdm_inv_split_rule_strate", (String)"id", (QFilter[])new QFilter[]{ruleCodeFilter});
            ruleObj = null != ruleObjPk ? BusinessDataServiceHelper.loadSingle((Object)ruleObjPk.getPkValue(), (String)"bdm_inv_split_rule_strate") : BusinessDataServiceHelper.loadSingle((Object)InvoiceSplitRuleElement.DEFAULT_RULE_ID, (String)"bdm_inv_split_rule_strate");
        }
        return ruleObj;
    }

    public static DynamicObjectCollection getRuleByOrg(long orgId) {
        QFilter baseDataFilter = ImcBaseDataHelper.getSplitRuleFilter(orgId);
        return QueryServiceHelper.query((String)"bdm_inv_split_rule_strate", (String)String.join((CharSequence)",", "number", "name"), (QFilter[])baseDataFilter.toArray());
    }
}

