/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper.callback;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.constant.OpenApiCallbackInterfaceCodeEnum;
import kd.imc.bdm.common.dto.CallBackProcessVo;
import kd.imc.bdm.common.enums.CallBackLogTypeEnum;
import kd.imc.bdm.common.util.CallbackHelperUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;

public class CallBackLogHelper {
    private static final Log LOGGER = LogFactory.getLog(CallBackLogHelper.class);

    public static DynamicObject addCallbackLog(CallBackProcessVo processVo) {
        return CallBackLogHelper.addCallbackLog(processVo, true);
    }

    public static DynamicObject addCallbackLog(CallBackProcessVo processVo, boolean isSuccess) {
        try {
            DynamicObject invObj = processVo.getInvoice();
            String businessType = processVo.getBusinessType();
            String issueType = invObj.getString("issuetype");
            if (OpenApiCallbackInterfaceCodeEnum.INVOICE_OPEN.getCode().equals(businessType)) {
                businessType = IssueType.RED_INVOICE.getTypeCode().equals(issueType) ? OpenApiCallbackInterfaceCodeEnum.INVOICE_RED.getCode() : OpenApiCallbackInterfaceCodeEnum.INVOICE_OPEN.getCode();
                processVo.setBusinessType(businessType);
            }
            DynamicObject[] callBackLogs = new DynamicObject[]{};
            if (isSuccess && !CallBackLogTypeEnum.invoiceError.getValue().equals(processVo.getCallbackType())) {
                callBackLogs = CallBackLogHelper.queryDBLogObj(processVo);
            }
            if (callBackLogs.length > 0) {
                LOGGER.info("addCallbackLogFromQuery");
                return callBackLogs[0];
            }
            DynamicObject callBackObj = CallBackLogHelper.createCallBackObj(processVo, issueType, isSuccess);
            if (null != callBackObj) {
                try (TXHandle tx = TX.requiresNew();){
                    try {
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{callBackObj});
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        throw e;
                    }
                }
            }
            return callBackObj;
        }
        catch (Exception e) {
            LOGGER.error("\u751f\u6210\u56de\u8c03\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static DynamicObject createCallBackObj(CallBackProcessVo processVo, String issueType, boolean isSuccess) {
        Date time = new Date();
        DynamicObject callbackDynamic = BusinessDataServiceHelper.newDynamicObject((String)"invsm_callback_log");
        String businessType = processVo.getBusinessType();
        String businessSystemCode = processVo.getBusinessSystemCode();
        DynamicObject invObj = processVo.getInvoice();
        String callbackUrl = processVo.getUrl();
        String batchNoFromRedMatchBill = processVo.getBatchNoFromRedMatchBill();
        callbackDynamic.set("callbackno", (Object)processVo.getCallbackno());
        callbackDynamic.set("business_type", (Object)businessType);
        callbackDynamic.set("business_system_code", (Object)businessSystemCode);
        if (CallbackHelperUtil.isFromArIssueBill(businessSystemCode)) {
            callbackDynamic.set("callbacktype", (Object)"bill");
            if (StringUtils.isNotBlank((CharSequence)batchNoFromRedMatchBill)) {
                callbackDynamic.set("callbackbillno", (Object)batchNoFromRedMatchBill);
                callbackDynamic.set("business_fid", (Object)processVo.getBillPkFromRedMatchBill());
            } else {
                DynamicObject billRelation = CallBackLogHelper.getFiBillRelation(invObj);
                if (billRelation == null) {
                    return null;
                }
                callbackDynamic.set("business_fid", (Object)billRelation.getLong("sbillid"));
                callbackDynamic.set("callbackbillno", (Object)billRelation.getString("sbillno"));
            }
        } else {
            callbackDynamic.set("callbacktype", (Object)"invoice");
            callbackDynamic.set("business_fid", invObj.get("id"));
        }
        if (!isSuccess) {
            callbackDynamic.set("callbacktype", (Object)CallBackLogTypeEnum.invoiceError.getValue());
        }
        callbackDynamic.set("retry_times", (Object)0);
        callbackDynamic.set("create_time", (Object)time);
        callbackDynamic.set("update_time", (Object)time);
        callbackDynamic.set("callback_result", (Object)"");
        callbackDynamic.set("callback_url", (Object)callbackUrl);
        callbackDynamic.set("invoicetype", invObj.get("invoicetype"));
        callbackDynamic.set("invoicecode", invObj.get("invoicecode"));
        callbackDynamic.set("invoiceno", invObj.get("invoiceno"));
        callbackDynamic.set("invoicestatus", invObj.get("invoicestatus"));
        callbackDynamic.set("issuetype", (Object)issueType);
        callbackDynamic.set("callback_message", (Object)"");
        callbackDynamic.set("callback_status", (Object)"2");
        callbackDynamic.set("org", invObj.get("orgid"));
        callbackDynamic.set("targetsystem", (Object)"systemsource");
        if (StringUtils.isNotBlank((CharSequence)processVo.getCallbackType())) {
            callbackDynamic.set("callbacktype", (Object)processVo.getCallbackType());
        }
        return callbackDynamic;
    }

    private static DynamicObject[] queryDBLogObj(CallBackProcessVo processVo) {
        QFilter qFilter;
        String businessSystemCode = processVo.getBusinessSystemCode();
        DynamicObject invObj = processVo.getInvoice();
        String businessType = processVo.getBusinessType();
        String callbackUrl = processVo.getUrl();
        String batchNoFromRedMatchBill = processVo.getBatchNoFromRedMatchBill();
        if (CallbackHelperUtil.isFromArIssueBill(businessSystemCode)) {
            String batchLong;
            if (StringUtils.isNotBlank((CharSequence)batchNoFromRedMatchBill)) {
                batchLong = batchNoFromRedMatchBill;
            } else {
                DynamicObject billRelation = CallBackLogHelper.getFiBillRelation(invObj);
                if (billRelation == null) {
                    return new DynamicObject[0];
                }
                batchLong = billRelation.getString("sbillno");
            }
            qFilter = new QFilter("callbackbillno", "=", (Object)batchLong);
            if (StringUtils.isNotEmpty((CharSequence)businessType)) {
                qFilter.and("business_type", "=", (Object)businessType);
            }
        } else {
            qFilter = new QFilter("callbacktype", "not in", (Object)new String[]{CallBackLogTypeEnum.billError.getValue(), CallBackLogTypeEnum.invoiceError.getValue()}).and("invoicecode", "=", invObj.get("invoicecode")).and("invoiceno", "=", invObj.get("invoiceno")).and("callback_url", "=", (Object)callbackUrl).and("business_system_code", "=", (Object)businessSystemCode).and("business_type", "=", (Object)businessType).and("targetsystem", "!=", (Object)"originalbill");
        }
        return BusinessDataServiceHelper.load((String)"invsm_callback_log", (String)PropertieUtil.getAllPropertiesSplitByComma("invsm_callback_log", true), (QFilter[])qFilter.toArray());
    }

    public static DynamicObject getFiBillRelation(DynamicObject invObj) {
        DynamicObject billRelation = CallBackLogHelper.getOriginalBillFromVatInvoiceId(invObj.get("id"));
        if (billRelation == null && IssueType.RED_INVOICE.getTypeCode().equals(invObj.getString("issuetype"))) {
            String invoiceType = invObj.getString("invoicetype");
            if (InvoiceUtils.isSpecialInvoice(invoiceType)) {
                DynamicObject redInfo = BusinessDataServiceHelper.loadSingle((String)"sim_red_info", (String)"", (QFilter[])new QFilter("invoicecode", "=", (Object)invObj.getString("invoicecode")).and("invoiceno", "=", (Object)invObj.getString("invoiceno")).toArray());
                if (redInfo == null) {
                    return null;
                }
                billRelation = CallBackLogHelper.getOriginalBillFromVatInvoiceId(redInfo.getPkValue());
            } else if (InvoiceUtils.isAllEInvoice(invoiceType)) {
                QFilter qFilter = StringUtils.isNotBlank((CharSequence)invObj.getString("infocode")) ? new QFilter("number", "=", (Object)invObj.getString("infocode")) : new QFilter("invoiceno", "=", (Object)invObj.getString("invoiceno"));
                DynamicObject redConfirm = BusinessDataServiceHelper.loadSingle((String)"sim_red_confirm_bill", (String)"", (QFilter[])qFilter.toArray());
                if (redConfirm == null) {
                    return null;
                }
                billRelation = CallBackLogHelper.getOriginalBillFromVatInvoiceId(redConfirm.getPkValue());
            } else {
                QFilter qFilter = new QFilter("invoicecode", "=", (Object)invObj.getString("originalinvoicecode")).and("invoiceno", "=", (Object)invObj.getString("originalinvoiceno"));
                DynamicObject blueInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"", (QFilter[])qFilter.toArray());
                if (blueInvoice == null) {
                    return null;
                }
                billRelation = CallBackLogHelper.getOriginalBillFromVatInvoiceId(blueInvoice.getPkValue());
            }
        }
        return billRelation;
    }

    private static DynamicObject getOriginalBillFromVatInvoiceId(Object invoiceId) {
        return BusinessDataServiceHelper.loadSingle((String)"sim_bill_inv_relation", (String)String.join((CharSequence)",", "sbillid", "sbillno"), (QFilter[])new QFilter("tbillid", "=", invoiceId).and("isdelete", "!=", (Object)"Y").toArray());
    }

    public static DynamicObject createCallBackObj(DynamicObject invoice, String systemSource, String s, String url, String string, boolean b) {
        return null;
    }
}

