/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.invoicecallback;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.OpenApiCallbackInterfaceCodeEnum;
import kd.imc.bdm.common.dto.CallbackLogVo;
import kd.imc.bdm.common.enums.CallBackLogTypeEnum;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.invoicecallback.IInvoiceCallBackService;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;

public abstract class AbstractInvoiceCallBackServiceImpl
implements IInvoiceCallBackService {
    protected static final Log LOGGER = LogFactory.getLog(AbstractInvoiceCallBackServiceImpl.class);

    @Override
    public DynamicObject getInvoiceForCallBack(CallbackLogVo callbackLog) {
        boolean isBillCallBack = CallBackLogTypeEnum.bill.getValue().equals(callbackLog.getCallbackType()) || CallBackLogTypeEnum.allCallback.getValue().equals(callbackLog.getCallbackType());
        DynamicObject billOrInvoice = BusinessDataServiceHelper.loadSingle((Object)callbackLog.getBusinessFid(), (String)(isBillCallBack ? "sim_original_bill" : "sim_vatinvoice"));
        if (null == billOrInvoice) {
            throw new MsgException(ApiErrCodeEnum.OK.getCode(), String.format(ResManager.loadKDString((String)"\u65e0\u6b64%s\u4fe1\u606f\uff0c\u7ed3\u675f\u4efb\u52a1", (String)"AbstractInvoiceCallBackServiceImpl_0", (String)"imc-bdm-common", (Object[])new Object[0]), isBillCallBack ? ResManager.loadKDString((String)"\u5355\u636e", (String)"AbstractInvoiceCallBackServiceImpl_1", (String)"imc-bdm-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53d1\u7968", (String)"AbstractInvoiceCallBackServiceImpl_2", (String)"imc-bdm-common", (Object[])new Object[0])));
        }
        if (OpenApiCallbackInterfaceCodeEnum.INVOICE_CANCEL.getCode().equals(callbackLog.getBusinessType())) {
            QFilter filter = new QFilter("business_fid", "=", (Object)callbackLog.getBusinessFid()).and("business_type", "in", (Object)new String[]{OpenApiCallbackInterfaceCodeEnum.INVOICE_OPEN.getCode(), OpenApiCallbackInterfaceCodeEnum.INVOICE_RED.getCode()}).and("callback_url", "=", (Object)callbackLog.getCallbackUrl());
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"invsm_callback_log", (String)PropertieUtil.getAllPropertiesSplitByComma("invsm_callback_log", true), (QFilter[])filter.toArray());
            if (!InvoiceUtils.isVolumeInvCreatePdf(billOrInvoice)) {
                if (null == obj) {
                    throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), ResManager.loadKDString((String)"\u672a\u627e\u5230\u5f00\u7968\u4e1a\u52a1\u7c7b\u578b\u8bb0\u5f55\uff0c\u65e0\u6cd5\u540c\u6b65", (String)"AbstractInvoiceCallBackServiceImpl_3", (String)"imc-bdm-common", (Object[])new Object[0]));
                }
                if (!"0".equals(obj.getString("callback_status"))) {
                    String message = String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u624b\u52a8\u56de\u63a8%1$s\u4e3a%2$s\u7684\u5f00\u7968\u4e1a\u52a1", (String)"AbstractInvoiceCallBackServiceImpl_9", (String)"imc-bdm-common", (Object[])new Object[0]), isBillCallBack ? ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"AbstractInvoiceCallBackServiceImpl_5", (String)"imc-bdm-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"AbstractInvoiceCallBackServiceImpl_6", (String)"imc-bdm-common", (Object[])new Object[0]), isBillCallBack ? callbackLog.getCallbackBillNo() : callbackLog.getInvoiceNo());
                    throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), message);
                }
            }
        }
        if (LOGGER.isInfoEnabled()) {
            if (isBillCallBack) {
                LOGGER.info(String.format("\u5f53\u524d\u5355\u636e\u7f16\u53f7\u662f\uff1a%s;ID\u662f\uff1a%s;\u7cfb\u7edf\u6765\u6e90\u662f\uff1a%s", billOrInvoice.getString("billno"), billOrInvoice.getString("id"), billOrInvoice.getString("systemsource")));
            } else {
                LOGGER.info(String.format("\u5f53\u524d\u53d1\u7968\u53f7\u7801\u662f\uff1a%s;ID\u662f\uff1a%s;\u7cfb\u7edf\u6765\u6e90\u662f\uff1a%s", billOrInvoice.getString("invoiceno"), billOrInvoice.getString("id"), billOrInvoice.getString("systemsource")));
            }
        }
        return billOrInvoice;
    }

    protected void updateCallbackLogFileNotCreate(CallbackLogVo callbackLogVo) {
        try {
            if (null == callbackLogVo.getId()) {
                return;
            }
            DynamicObject callbackLog = BusinessDataServiceHelper.loadSingle((String)"invsm_callback_log", (String)String.join((CharSequence)",", "callback_message", "callback_content", "update_time"), (QFilter[])new QFilter("id", "=", (Object)callbackLogVo.getId()).toArray());
            if (null == callbackLog) {
                return;
            }
            callbackLog.set("callback_message", (Object)ResManager.loadKDString((String)"\u914d\u7f6e\u4e3a\u6570\u7535\u7968\u6587\u4ef6\u751f\u6210\u540e\u56de\u8c03\uff0c\u5bf9\u5e94\u6587\u4ef6\u672a\u751f\u6210\u3002", (String)"AbstractInvoiceCallBackServiceImpl_10", (String)"imc-bdm-common", (Object[])new Object[0]));
            callbackLog.set("callback_content", (Object)RequestContext.get().getTraceId());
            callbackLog.set("update_time", (Object)new Date());
            ImcSaveServiceHelper.update((DynamicObject)callbackLog);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

