/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.invoicecallback.impl;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.imc.bdm.common.constant.FiBotpReplayEnum;
import kd.imc.bdm.common.dto.AutoBotpConfigVo;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.bdm.common.dto.CallbackLogVo;
import kd.imc.bdm.common.dto.Relations;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.enums.CallBackLogTypeEnum;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.RelationHelper;
import kd.imc.bdm.common.invoicecallback.AbstractInvoiceCallBackServiceImpl;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.openapi.CallbackResponseVo;
import kd.imc.bdm.common.util.ImcConfigUtil;

public class BlankItemsCallBackServiceImpl
extends AbstractInvoiceCallBackServiceImpl {
    private static final Log LOGGER = LogFactory.getLog(BlankItemsCallBackServiceImpl.class);

    @Override
    public boolean support(CallbackLogVo callbackLogVo) {
        String businessSystemCode = callbackLogVo.getBusinessSystemCode();
        AutoBotpConfigVo configVO = BotpHelper.getSystemConfigVo(businessSystemCode);
        return configVO.isAutoBotpSystem();
    }

    @Override
    public CallbackResponseVo callBack(CallbackLogVo callbackLogVo, DynamicObject invoice) {
        try {
            String invoiceInfo = invoice.getString("invoicecode") + invoice.getString("invoiceno");
            LOGGER.info(invoiceInfo + "startCallBack");
            DynamicObject[] relations = RelationHelper.getRelationByInvoice(invoice);
            boolean isOriBlueRelation = false;
            String invoiceStatus = invoice.getString("invoicestatus");
            boolean isCancel = "6".equals(invoiceStatus);
            BigDecimal reverse = BigDecimal.ONE;
            List<Object> redBillRelations = new ArrayList();
            String buyerRedInfoSystemSource = null;
            if (relations.length == 0 && RelationHelper.isRedInvoice(invoice)) {
                boolean isFromMatchBill = RelationHelper.isInvoiceFromRedMatchBill(invoice);
                if (isFromMatchBill) {
                    Long tBillPk = RelationHelper.getRedTBillId(invoice);
                    redBillRelations = RelationHelper.getMatchInvRelation(tBillPk);
                } else {
                    relations = RelationHelper.getOriBlueInvoiceRelation(invoice);
                    if (relations.length > 0) {
                        isOriBlueRelation = true;
                    }
                }
                LOGGER.info("getRelationFromTuiShuiTuiHuoZhengMingVersion");
                if (redBillRelations.size() == 0 && "1".equals(ImcConfigUtil.getValue(CacheKeyEnum.INVOICE_SYSTEMSOURCE_FROM_BUYER_RED_INFO))) {
                    redBillRelations = RelationHelper.getRelationFromTuiShuiTuiHuoZhengMing(invoice);
                    buyerRedInfoSystemSource = RelationHelper.getSystemSourceFromBuyerDownloadRedInfo(invoice);
                }
            }
            if (isOriBlueRelation) {
                reverse = reverse.negate();
            }
            if (isCancel) {
                reverse = reverse.negate();
            }
            if (relations.length == 0 && redBillRelations.size() == 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\uff1a%1$s,\u53d1\u7968\u53f7\u7801\uff1a%2$s\u5728\u5173\u7cfb\u8868\u672a\u67e5\u8be2\u5230\u5173\u7cfb\uff0c\u65e0\u6cd5\u5b8c\u6210\u56de\u8c03", (String)"BlankItemsCallBackServiceImpl_2", (String)"imc-bdm-common", (Object[])new Object[0]), invoice.getString("invoicecode"), invoice.getString("invoiceno")));
            }
            boolean isReverse = BigDecimal.ONE.compareTo(reverse) != 0;
            Relations relation = null;
            if (redBillRelations.size() == 0) {
                relation = RelationHelper.countRelation(relations, isReverse);
            }
            JSONObject param = this.creatParam(invoice, relation, redBillRelations);
            if (CallBackLogTypeEnum.invoiceError.getValue().equals(callbackLogVo.getCallbackType())) {
                param.put("errorcode", (Object)ErrorType.FAIL.getCode());
            } else {
                param.put("errorcode", (Object)ErrorType.SUCCESS.getCode());
            }
            param.put("issuetype", (Object)invoice.getString("issuetype"));
            param.put("invoicestatus", (Object)invoice.getString("invoicestatus"));
            LOGGER.info(String.format(invoiceInfo + "callBackParam:%s", param.toJSONString()));
            JSONObject response = this.invokeMethod(invoice, param, buyerRedInfoSystemSource);
            if (ErrorType.SUCCESS.getCode().equals(response.get((Object)"errorCode"))) {
                return CallbackResponseVo.valueOfSuccess(ResManager.loadKDString((String)"\u6210\u529f", (String)"CallbackResponseVo_0", (String)"imc-bdm-common", (Object[])new Object[0]), FiBotpReplayEnum.Success.getStatus());
            }
            return CallbackResponseVo.valueOfError(String.valueOf(FiBotpReplayEnum.fail.getCode()), response.getString("errorMessage"));
        }
        catch (MsgException e) {
            LOGGER.error("BlankItemsCallBackServiceImplFail:" + e.getErrorMsg(), (Throwable)e);
            return CallbackResponseVo.valueOfError(String.valueOf(FiBotpReplayEnum.fail.getCode()), e.getErrorMsg());
        }
        catch (Exception e) {
            LOGGER.error("BlankItemsCallBackServiceImplFail:" + e.getMessage(), (Throwable)e);
            return CallbackResponseVo.valueOfError(String.valueOf(FiBotpReplayEnum.fail.getCode()), e.getMessage());
        }
        catch (Throwable t) {
            LOGGER.error("BlankItemsCallBackServiceImplFail:" + t.getMessage(), t);
            throw t;
        }
    }

    private JSONObject invokeMethod(DynamicObject invoice, JSONObject param, String systemSource) {
        AutoBotpConfigVo configVO;
        JSONObject config;
        String factoryQualifidPrefix;
        if (StringUtils.isBlank((CharSequence)systemSource)) {
            systemSource = invoice.getString("systemsource");
        }
        if (StringUtils.isNotBlank((CharSequence)(factoryQualifidPrefix = (config = (configVO = BotpHelper.getSystemConfigVo(systemSource)).getCallBackConfig()).getString("factoryQualifiedPrefix")))) {
            return (JSONObject)DispatchServiceHelper.invokeService((String)factoryQualifidPrefix, (String)config.getString("appid"), (String)config.getString("servicename"), (String)config.getString("methodname"), (Object[])new Object[]{param});
        }
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)config.getString("cloudid"), (String)config.getString("appid"), (String)config.getString("servicename"), (String)config.getString("methodname"), (Object[])new Object[]{param});
    }

    private JSONObject creatParam(DynamicObject invoice, Relations relation, List<BillRelationDTO> redBillRelations) {
        String invoiceStr = SerializationUtils.toJsonString((Object)invoice);
        JSONObject param = new JSONObject();
        param.put("invoice", (Object)JSONObject.parseObject((String)invoiceStr));
        if (redBillRelations.size() > 0) {
            param.put("relation", (Object)JSONObject.parseArray((String)JSONObject.toJSONString(redBillRelations)));
            return param;
        }
        List<BillRelationDTO> relationDTOS = relation.getRelationDTOS();
        List bfRowLinkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)"sim_original_bill", (Long[])relation.gettBillPks().toArray(new Long[0]), null);
        for (BFRowLinkUpNode node : bfRowLinkUpNodes) {
            Map sNodes = node.getSNodes();
            for (Map.Entry entry : sNodes.entrySet()) {
                BFRowId rowId = node.getRowId();
                Long tgtBillId = rowId.getBillId();
                BFRowId key = (BFRowId)entry.getKey();
                Long arBillPk = key.getBillId();
                BillRelationDTO currentRelation = this.getRelation(relationDTOS, tgtBillId);
                if (null == currentRelation) continue;
                currentRelation.setsBillId(arBillPk);
            }
        }
        param.put("relation", (Object)JSONObject.parseArray((String)JSONObject.toJSONString(relationDTOS)));
        return param;
    }

    private BillRelationDTO getRelation(List<BillRelationDTO> relationDTOS, Long tgtBillId) {
        for (BillRelationDTO relationDTO : relationDTOS) {
            if (tgtBillId.compareTo(relationDTO.gettBillId()) != 0) continue;
            return relationDTO;
        }
        return null;
    }
}

