/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.invoicecallback.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.imc.bdm.common.constant.FiBotpReplayEnum;
import kd.imc.bdm.common.dto.CallbackLogVo;
import kd.imc.bdm.common.helper.callback.ApiCallBackHelper;
import kd.imc.bdm.common.invoicecallback.AbstractInvoiceCallBackServiceImpl;
import kd.imc.bdm.common.openapi.CallbackResponseVo;
import kd.imc.bdm.common.openapi.InvoiceVo;

public class CqomsCallBackServiceImpl
extends AbstractInvoiceCallBackServiceImpl {
    private static Log LOGGER = LogFactory.getLog(CqomsCallBackServiceImpl.class);

    @Override
    public boolean support(CallbackLogVo callbackLogVo) {
        String businessSystemCode = callbackLogVo.getBusinessSystemCode();
        return "CQOMS".equals(businessSystemCode);
    }

    @Override
    public CallbackResponseVo callBack(CallbackLogVo callbackLogVo, DynamicObject invoice) {
        try {
            Map<String, Object> invoiceMap = this.convertToParam(callbackLogVo.getBusinessType(), invoice);
            JSONObject invokeResult = (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"oeoms", (String)"InvoiceCallBackService", (String)"invoiceYunCallBack", (Object[])new Object[]{invoiceMap});
            if (invokeResult.getBoolean("success").booleanValue()) {
                LOGGER.info("callBack sendCallBackMsgToCQOMS  success");
                return CallbackResponseVo.valueOfSuccess(String.valueOf(FiBotpReplayEnum.Success.getCode()), invokeResult.getString("message"));
            }
            LOGGER.info(String.format("\u56de\u8c03\u5931\u8d25:%s,invoiceMap,apiResult:%s", SerializationUtils.toJsonString(invoiceMap), SerializationUtils.toJsonString((Object)invokeResult)));
            return CallbackResponseVo.valueOfError(String.valueOf(FiBotpReplayEnum.fail.getCode()), invokeResult.getString("message"));
        }
        catch (Exception e) {
            LOGGER.error("CqomsCallBackServiceImpl sendCallBackMsg:" + e.getMessage(), (Throwable)e);
            return CallbackResponseVo.valueOfError(String.valueOf(FiBotpReplayEnum.fail.getCode()), e.getMessage());
        }
    }

    public Map<String, Object> convertToParam(String businessType, DynamicObject invoice) {
        HashMap invoiceMap = Maps.newHashMapWithExpectedSize((int)2);
        invoiceMap.put("interfaceCode", businessType);
        InvoiceVo invoiceVo = ApiCallBackHelper.invoiceDynamicConvert2InvoiceVo(invoice, businessType);
        invoiceVo.setBillNo(ApiCallBackHelper.getOriBillNoByBillInvRelation(invoice));
        Object data = JSONObject.toJSON((Object)invoiceVo);
        invoiceMap.put("data", data);
        LOGGER.info(String.format("sendCallBackMsgToCQOMS  invoice:%s", SerializationUtils.toJsonString((Object)data)));
        return invoiceMap;
    }

    public CallbackResponseVo errorCallBack(String businessType, DynamicObject invoice, String errorMsg) {
        try {
            Map<String, Object> invoiceMap = this.convertToParam(businessType, invoice);
            invoiceMap.put("errorMsg", errorMsg);
            JSONObject invokeResult = (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"oeoms", (String)"InvoiceCallBackService", (String)"invoiceYunCallBack", (Object[])new Object[]{invoiceMap});
            if (invokeResult.getBoolean("success").booleanValue()) {
                LOGGER.info("errorCallBack sendCallBackMsgToCQOMS  success");
                return CallbackResponseVo.valueOfSuccess(String.valueOf(FiBotpReplayEnum.Success.getCode()), invokeResult.getString("message"));
            }
            LOGGER.info(String.format("errorCallBack \u56de\u8c03\u5931\u8d25:%s,invoiceMap,apiResult:%s", SerializationUtils.toJsonString(invoiceMap), SerializationUtils.toJsonString((Object)invokeResult)));
            return CallbackResponseVo.valueOfError(String.valueOf(FiBotpReplayEnum.fail.getCode()), invokeResult.getString("message"));
        }
        catch (Exception e) {
            LOGGER.error("errorCallBack CqomsCallBackServiceImpl sendCallBackMsg:" + e.getMessage(), (Throwable)e);
            return CallbackResponseVo.valueOfError(String.valueOf(FiBotpReplayEnum.fail.getCode()), e.getMessage());
        }
    }
}

