/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.invoicecallback.impl;

import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.imc.bdm.common.dto.CallbackLogVo;
import kd.imc.bdm.common.helper.InvoiceFileUrlInfoHelper;
import kd.imc.bdm.common.helper.callback.ApiCallBackHelper;
import kd.imc.bdm.common.invoicecallback.AbstractInvoiceCallBackServiceImpl;
import kd.imc.bdm.common.model.InvoiceFileUrlInfo;
import kd.imc.bdm.common.openapi.CallbackResponseVo;
import kd.imc.bdm.common.util.RegexUtil;

public class OcposInvoiceCallBackServiceImpl
extends AbstractInvoiceCallBackServiceImpl {
    @Override
    public boolean support(CallbackLogVo callbackLogVo) {
        String businessSystemCode = callbackLogVo.getBusinessSystemCode();
        return "OCPOS_SALEORDER".equals(businessSystemCode) || "OCPOS_SALEORDER_RETURN".equals(businessSystemCode);
    }

    @Override
    public CallbackResponseVo callBack(CallbackLogVo callbackLogVo, DynamicObject invoice) {
        JSONObject json = new JSONObject();
        json.put("billno", (Object)ApiCallBackHelper.getOriBillNoByBillInvRelation(invoice));
        json.put("invoicetype", (Object)this.getBuyerProperty(invoice));
        json.put("invoicedatetime", (Object)invoice.getDate("issuetime"));
        json.put("invoicetitle", (Object)invoice.getString("buyername"));
        json.put("invoiceamount", (Object)invoice.getBigDecimal("invoiceamount"));
        json.put("invoicenumber", (Object)invoice.getString("invoiceno"));
        json.put("invoicecode", (Object)invoice.getString("invoicecode"));
        json.put("companytaxno", (Object)invoice.getString("buyertaxno"));
        json.put("bankcardno", (Object)invoice.getString("buyerbank"));
        json.put("customeraddr", (Object)invoice.getString("buyeraddr"));
        InvoiceFileUrlInfo fileUrlInfo = InvoiceFileUrlInfoHelper.getFileUrlInfo(invoice.getString("orderno"));
        json.put("invoicepdfurl", (Object)fileUrlInfo.getFileUrl());
        String errMsg = (String)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocpos", (String)"InvoiceService", (String)"addInvoiceEntry", (Object[])new Object[]{json});
        if (StringUtils.isBlank((CharSequence)errMsg)) {
            return CallbackResponseVo.valueOfSuccess(ResManager.loadKDString((String)"\u56de\u8c03\u6210\u529f", (String)"OcposInvoiceCallBackServiceImpl_0", (String)"imc-bdm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u56de\u8c03\u6210\u529f", (String)"OcposInvoiceCallBackServiceImpl_0", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        return CallbackResponseVo.valueOfError(errMsg);
    }

    private String getBuyerProperty(DynamicObject invoice) {
        String buyerProperty = invoice.getString("buyerproperty");
        if (StringUtils.isNotBlank((CharSequence)buyerProperty)) {
            return "0".equals(buyerProperty) ? "B" : "A";
        }
        String buyerTaxNo = invoice.getString("buyertaxno");
        if (StringUtils.isNotBlank((CharSequence)buyerTaxNo) && RegexUtil.isNsrsbh(buyerTaxNo)) {
            return "B";
        }
        return "A";
    }
}

