/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.message.constant;

import java.util.Arrays;
import kd.bos.dataentity.utils.StringUtils;
import kd.imc.bdm.common.constant.MultiLangEnumBridge;
import kd.imc.bdm.common.message.constant.ErrorType;

public enum RpaErrorType {
    RPA_91338_INV_NO_MATCH("91338", new MultiLangEnumBridge("\u5f00\u7968\u5931\u8d25\uff0c\u53d1\u7968\u4fe1\u606f\u672a\u5339\u914d\uff0c\u8bf7\u70b9\u51fb\u5f00\u7968\u5173\u8054\u5bf9\u5e94\u53d1\u7968", "RpaErrorType_0", "imc-bdm-common")),
    RPA_91339_INV_SUCCESS_NO_RESULT("91339", new MultiLangEnumBridge("\u7a0e\u5c40\u5f00\u7968\u6210\u529f\uff0c\u672a\u83b7\u53d6\u5230\u7a0e\u5c40\u5f00\u7968\u7ed3\u679c\uff0c\u8bf7\u70b9\u51fb\u5f00\u7968\u5173\u8054\u5bf9\u5e94\u53d1\u7968", "RpaErrorType_1", "imc-bdm-common")),
    RPA_91300_NOT_LOGIN("91300", new MultiLangEnumBridge("\u7535\u5b50\u7a0e\u5c40\u767b\u5f55\u72b6\u6001\u5df2\u5931\u6548\uff0c\u53ef\u53d1\u8d77\u91cd\u65b0\u5f00\u7968\u5e76\u5b8c\u6210\u767b\u5f55\u9a8c\u8bc1\u64cd\u4f5c", "RpaErrorType_2", "imc-bdm-common")),
    RPA_91400_NOT_AUTH("91400", new MultiLangEnumBridge("\u7535\u5b50\u7a0e\u5c40\u5b9e\u4eba\u8ba4\u8bc1\u5df2\u5931\u6548\uff0c\u53ef\u53d1\u8d77\u91cd\u65b0\u5f00\u7968\u5e76\u5b8c\u6210\u5b9e\u4eba\u8ba4\u8bc1\u64cd\u4f5c", "RpaErrorType_3", "imc-bdm-common"));

    private String code;
    private MultiLangEnumBridge message;

    private RpaErrorType(String code, MultiLangEnumBridge message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message.loadKDString();
    }

    public static boolean issueFail(String message) {
        return RPA_91338_INV_NO_MATCH.getMessage().equals(message) || RPA_91339_INV_SUCCESS_NO_RESULT.getMessage().equals(message);
    }

    public static String getMessageByCode(String code) {
        for (RpaErrorType c : RpaErrorType.values()) {
            if (!c.code.equals(code)) continue;
            return c.getMessage();
        }
        return "";
    }

    public static boolean containError(String code) {
        if (StringUtils.isBlank((CharSequence)code) || ErrorType.SUCCESS.getCode().equals(code)) {
            return false;
        }
        return Arrays.stream(RpaErrorType.values()).anyMatch(enums -> enums.getCode().equals(code));
    }
}

