/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.message.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.HttpUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.sdk.annotation.SdkDeprecated;

public class IsmcToken {
    private static Log LOGGER = LogFactory.getLog(IsmcToken.class);
    public static final String getAppTokenUrl = "/api/getAppToken.do";
    public static final String loginUrl = "/api/login.do";
    public static final String TOKEN_KEY = "ismc_token";
    private Map<String, String> paramMap = ImcConfigUtil.getValue("bdm_ismc_config");

    public String getProxy() {
        return this.paramMap.get("bdm_ismc_config_url_proxy");
    }

    public String getConfig(String key) {
        return this.paramMap.get(key);
    }

    @SdkDeprecated
    public String getRequestUrl(String url) {
        return this.paramMap.get("bdm_ismc_config_url") + url;
    }

    public String getToken() {
        String tokenCache = CacheHelper.get(TOKEN_KEY);
        if (tokenCache != null) {
            return tokenCache;
        }
        return this.putToken();
    }

    public String putToken() {
        this.paramMap = ImcConfigUtil.getValue("bdm_ismc_config");
        if (this.paramMap.isEmpty()) {
            throw new MsgException(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u7a0e\u63a7\u7cfb\u7edf\u4e91\u4fe1\u606f,\u8bf7\u524d\u5f80\u53d1\u7968\u4e91=\u300b\u7cfb\u7edf\u7ba1\u7406=\u300b\u4e91\u5e94\u7528\u53c2\u6570\u914d\u7f6e\u83dc\u5355\u8fdb\u884c\u76f8\u5173\u914d\u7f6e", (String)"IsmcToken_1", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        String token = IsmcToken.login(this.paramMap.get("bdm_ismc_config_url"), this.paramMap.get("bdm_ismc_config_url_proxy"), this.paramMap.get("bdm_ismc_config_appid"), this.paramMap.get("bdm_ismc_config_appsecuret"), this.paramMap.get("bdm_ismc_config_accountid"), this.paramMap.get("bdm_ismc_config_user"));
        CacheHelper.put(TOKEN_KEY, token, 3600);
        return token;
    }

    public void removeCache() {
        CacheHelper.remove(TOKEN_KEY);
    }

    public static String login(String baseUrl, String proxy, String appId, String appSecuret, String accountId, String user) {
        return IsmcToken.login(baseUrl, proxy, appId, appSecuret, accountId, user, "UserName");
    }

    public static String login(String baseUrl, String proxy, String appId, String appSecuret, String accountId, String user, String userType) {
        String app_token = IsmcToken.getAppToken(baseUrl, proxy, appId, appSecuret, accountId);
        JSONObject params = new JSONObject();
        params.put("user", (Object)user);
        params.put("usertype", (Object)userType);
        params.put("apptoken", (Object)app_token);
        params.put("accountId", (Object)accountId);
        try {
            String data = HttpUtil.doPostJson(baseUrl + loginUrl, proxy, null, params.toJSONString());
            JSONObject json = JSONObject.parseObject((String)data);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("getToken_result:" + data);
            }
            if ("success".equals(json.getString("state"))) {
                JSONObject respData = json.getJSONObject("data");
                return respData.getString("access_token");
            }
            throw new MsgException(String.format(ResManager.loadKDString((String)"\u767b\u5f55\u7a0e\u63a7\u7cfb\u7edf\u4e91\u5931\u8d25\uff1a%s", (String)"IsmcToken_10", (String)"imc-bdm-common", (Object[])new Object[0]), json.getString("errorMsg")));
        }
        catch (IOException e) {
            throw new MsgException(e, ResManager.loadKDString((String)"\u767b\u5f55\u7a0e\u63a7\u7cfb\u7edf\u4e91\u5f02\u5e38", (String)"IsmcToken_4", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
    }

    private static String getAppToken(String baseUrl, String proxy, String appId, String appSecuret, String accountId) {
        JSONObject map = new JSONObject();
        map.put("appId", (Object)appId);
        map.put("appSecuret", (Object)appSecuret);
        map.put("accountId", (Object)accountId);
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("\u8bf7\u6c42\u5730\u5740\u662f\uff1a%s,\u8bf7\u6c42appId\u662f:%s,accountId\u662f:%s", baseUrl + getAppTokenUrl, appId, accountId));
            }
            String data = HttpUtil.doPostJson(baseUrl + getAppTokenUrl, proxy, null, map.toJSONString());
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("\u8bf7\u6c42\u8fd4\u56de\u7684data\u662f\uff1a%s", data));
            }
            if (StringUtils.isBlank((String)data)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6c42\u7a0e\u63a7\u4e91AppToken\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a", (String)"IsmcToken_7", (String)"imc-bdm-common", (Object[])new Object[0]));
            }
            JSONObject json = JSON.parseObject((String)data);
            if ("success".equals(json.getString("state"))) {
                JSONObject respData = json.getJSONObject("data");
                return respData.getString("app_token");
            }
            throw new MsgException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u7a0e\u63a7\u7cfb\u7edf\u4e91app_token\u5931\u8d25\uff1a%s", (String)"IsmcToken_8", (String)"imc-bdm-common", (Object[])new Object[0]), json.getString("errorMsg")));
        }
        catch (IOException e) {
            throw new MsgException(e, String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u7a0e\u63a7\u7cfb\u7edf\u4e91app_token\u5f02\u5e38:%s", (String)"IsmcToken_9", (String)"imc-bdm-common", (Object[])new Object[0]), e.getMessage()));
        }
    }
}

