/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.service;

import java.util.Collections;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.helper.ThreadPoolsHelper;
import kd.imc.bdm.common.util.ImcConfigUtil;

public class ApiLogService {
    private static final Log LOGGER = LogFactory.getLog(ApiLogService.class);
    private DynamicObject apiLog;
    private long startTime;
    private boolean saveLog = true;

    public ApiLogService(String request, String requestUrl, String requestStr) {
        try {
            if ("0".equals(ImcConfigUtil.getValue("bdm_api_log", "save"))) {
                this.saveLog = false;
                return;
            }
            this.startTime = System.currentTimeMillis();
            this.apiLog = BusinessDataServiceHelper.newDynamicObject((String)"bdm_api_log_new");
            RequestContext context = RequestContext.get();
            this.apiLog.set("username", (Object)context.getUserName());
            this.apiLog.set("opdate", (Object)new Date());
            this.apiLog.set("opname", (Object)request);
            this.apiLog.set("request", (Object)request);
            this.apiLog.set("request_tag", (Object)requestStr);
            this.apiLog.set("response", (Object)context.getTraceId());
            this.apiLog.set("opdesc", (Object)requestUrl.replaceAll("access_token=[0-9a-zA-Z]*&", ""));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void saveLog(String response) {
        try {
            if (!this.saveLog) {
                return;
            }
            ThreadPoolsHelper.addApiLogThreadPool.execute(() -> {
                this.apiLog.set("taketime", (Object)(System.currentTimeMillis() - this.startTime));
                this.apiLog.set("response_tag", (Object)response);
                LogORM.create().insert(Collections.singletonList(this.apiLog));
            });
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }
}

