/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.service;

public abstract class RetryService {
    private static final int DEFAULT_RETRY_TIME = 1;
    private int retryTime = 1;
    private int sleepTime = 0;

    public int getSleepTime() {
        return this.sleepTime;
    }

    public RetryService setSleepTime(int sleepTime) {
        if (sleepTime < 0) {
            throw new IllegalArgumentException("sleepTime should equal or bigger than 0");
        }
        this.sleepTime = sleepTime;
        return this;
    }

    public int getRetryTime() {
        return this.retryTime;
    }

    public RetryService setRetryTime(int retryTime) {
        if (retryTime <= 0) {
            throw new IllegalArgumentException("retryTime should bigger than 0");
        }
        this.retryTime = retryTime;
        return this;
    }

    protected abstract Object doBiz() throws Exception;

    public Object execute() {
        for (int i = 0; i < this.retryTime; ++i) {
            try {
                return this.doBiz();
            }
            catch (Exception e) {
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
        }
        return null;
    }
}

