/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.model.GoodsInfo;
import kd.imc.bdm.common.service.OpenInvoiceService;

public class GoodsUtil {
    public static void queryByGoodsName(String goodsName, ListShowParameter showParameter) {
        List filters = showParameter.getListFilterParameter().getQFilters();
        if (StringUtils.isNotBlank((CharSequence)goodsName)) {
            OpenInvoiceService service = new OpenInvoiceService();
            List<GoodsInfo> goodsList = service.queryGoodsInfoByFpy(goodsName);
            ArrayList<String> codeList = new ArrayList<String>();
            if (!CollectionUtils.isEmpty(goodsList)) {
                for (GoodsInfo info : goodsList) {
                    codeList.add(info.getGoodsCode());
                }
                QFilter codeFilter = new QFilter("mergecode", "in", codeList);
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"er_taxclasscode", (String)"id,name,number,taxrate,mergecode", (QFilter[])new QFilter[]{codeFilter});
                if (CollectionUtils.isEmpty((Collection)collection)) {
                    codeList.clear();
                }
            }
            if (!codeList.isEmpty()) {
                QFilter statusFilter = new QFilter("mergecode", "in", codeList);
                filters.add(statusFilter);
            } else {
                QFilter filter = new QFilter("key", "like", (Object)("%" + goodsName + "%"));
                filter.or("name", "like", (Object)("%" + goodsName + "%"));
                if (QueryServiceHelper.exists((String)"er_taxclasscode", (QFilter[])filter.toArray())) {
                    filters.add(filter);
                }
            }
        }
    }

    public static BigDecimal calcPrices(BigDecimal price, String rateStr, boolean isTaxInclusive) {
        BigDecimal rate = new BigDecimal(rateStr).add(new BigDecimal("1"));
        BigDecimal bPrices = isTaxInclusive ? price.divide(rate, 13, 4) : price.multiply(rate);
        int scale = 15 - bPrices.setScale(0, 1).toPlainString().length();
        if (scale > 13) {
            scale = 13;
        }
        return bPrices.setScale(scale, 4);
    }
}

