/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Charsets;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.sdk.annotation.SdkDeprecated;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;

public class HttpUtil {
    private static Log logger = LogFactory.getLog(HttpUtil.class);
    private static int connectTimeout = 600000;
    private static int socketTimeout = 600000;

    public static CloseableHttpClient getConnection(String proxy) {
        return HttpUtil.getConnection(proxy, connectTimeout, socketTimeout);
    }

    private static CloseableHttpClient getConnection(String proxy, int connectTime, int readTime) {
        return HttpUtil.getConnection(proxy, connectTime, readTime, true);
    }

    private static CloseableHttpClient getConnection(String proxy, int connectTime, int readTime, boolean redirectsEnabled) {
        int connectionRequestTimeout = 1200000;
        RequestConfig.Builder builder = RequestConfig.custom().setConnectionRequestTimeout(connectionRequestTimeout).setConnectTimeout(connectTime).setSocketTimeout(readTime);
        if (!redirectsEnabled) {
            builder.setRedirectsEnabled(redirectsEnabled);
        }
        RequestConfig requestConfig = builder.build();
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setDefaultRequestConfig(requestConfig);
        HttpUtil.setSslIgnore(httpClientBuilder);
        if (StringUtils.isNotBlank((CharSequence)proxy)) {
            String[] values = proxy.trim().split(":");
            if (values.length < 2) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4ee3\u7406\u914d\u7f6e\u683c\u5f0f\u9519\u8bef", (String)"HttpUtil_0", (String)"imc-bdm-common", (Object[])new Object[0]));
            }
            HttpHost httpHost = new HttpHost(values[0], Integer.parseInt(values[1]));
            httpClientBuilder.setProxy(httpHost);
        }
        return httpClientBuilder.build();
    }

    public static void setSslIgnore(HttpClientBuilder httpClientBuilder) {
        try {
            SSLContext sslContexts = new SSLContextBuilder().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)((TrustStrategy)(x509Certificates, s) -> true)).build();
            httpClientBuilder.setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).setSSLContext(sslContexts);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            logger.info("\u521b\u5efahttp\u8fde\u63a5\u5931\u8d25" + e);
        }
    }

    public static String doPostForm(String url, List<NameValuePair> data, Map<String, String> headerMap) {
        String proxy = HttpUtil.getProxy(url, null);
        CloseableHttpClient httpclient = HttpUtil.getConnection(proxy);
        String resultString = "";
        CloseableHttpResponse response = null;
        HttpPost httpPost = null;
        try {
            URI uri = new URI(url);
            httpPost = new HttpPost();
            httpPost.setURI(uri);
            if (null != headerMap && 0 != headerMap.size()) {
                for (Map.Entry<String, String> head : headerMap.entrySet()) {
                    httpPost.setHeader(head.getKey(), head.getValue());
                }
            }
            HttpUtil.setConfigHeader((HttpRequestBase)httpPost);
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(data, Charsets.UTF_8.name());
            logger.info("\u8bf7\u6c42\u63a5\u53e3doPostForm\u4e3a\uff1a{}", (Object)url);
            logger.info("\u8bf7\u6c42\u63a5\u53e3doPostForm\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)entity));
            httpPost.setEntity((HttpEntity)entity);
            response = httpclient.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() == 200) {
                resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)Charsets.UTF_8.name());
                logger.info("\u8bf7\u6c42\u63a5\u53e3doPostForm\u8fd4\u56de\u6570\u636e\u4e3a\uff1a{}", (Object)resultString);
            }
            String string = resultString;
            return string;
        }
        catch (ConnectTimeoutException e) {
            logger.error("do component request error,caused by \u8fde\u63a5\u8d85\u65f6url:{}-proxy:{}", new Object[]{url, proxy, e});
            throw new MsgException(ResManager.loadKDString((String)"\u8fde\u63a5\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"HttpUtil_1", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        catch (SocketTimeoutException e) {
            logger.error("do component request error,caused by \u54cd\u5e94\u8d85\u65f6url:{}-proxy:{}", new Object[]{url, proxy, e});
            throw new MsgException(ResManager.loadKDString((String)"\u54cd\u5e94\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"HttpUtil_2", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42\u9519\u8befdoPostForm:url:{}-proxy:{}", new Object[]{url, proxy, e});
            throw new MsgException(ResManager.loadKDString((String)"http\u8bf7\u6c42\u5f02\u5e38", (String)"HttpUtil_3", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        finally {
            try {
                if (null != response) {
                    response.close();
                }
                httpclient.close();
                if (null != httpPost) {
                    httpPost.releaseConnection();
                }
            }
            catch (IOException e) {
                logger.error("do post form exception", (Throwable)e);
            }
        }
    }

    public static String doGet(String url, Map<String, String> param) {
        return HttpUtil.doGet(url, null, param, null);
    }

    @SdkDeprecated
    public static String doGet(String url, String proxy, Map<String, String> param, Map<String, String> headers) {
        logger.info("HttpUtil url " + url);
        proxy = HttpUtil.getProxy(url, proxy);
        CloseableHttpClient httpclient = HttpUtil.getConnection(proxy, 20000, 20000);
        String resultString = "";
        CloseableHttpResponse response = null;
        try {
            URIBuilder builder = new URIBuilder(url);
            if (param != null) {
                Set<Map.Entry<String, String>> entries = param.entrySet();
                for (Map.Entry<String, String> entry : entries) {
                    builder.addParameter(entry.getKey(), entry.getValue());
                }
            }
            URI uri = builder.build();
            HttpGet httpGet = new HttpGet(uri);
            if (!CollectionUtils.isEmpty(headers)) {
                headers.forEach((arg_0, arg_1) -> ((HttpGet)httpGet).setHeader(arg_0, arg_1));
            }
            HttpUtil.setConfigHeader((HttpRequestBase)httpGet);
            response = httpclient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200) {
                resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            }
        }
        catch (ConnectTimeoutException e) {
            logger.error("do component request error,caused by \u8fde\u63a5\u8d85\u65f6url:{}-proxy:{}", new Object[]{url, proxy, e});
            throw new MsgException(ResManager.loadKDString((String)"\u8fde\u63a5\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"HttpUtil_1", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        catch (SocketTimeoutException e) {
            logger.error("do component request error,caused by \u54cd\u5e94\u8d85\u65f6url:{}-proxy:{}", new Object[]{url, proxy, e});
            throw new MsgException(ResManager.loadKDString((String)"\u54cd\u5e94\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"HttpUtil_2", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        catch (Exception e) {
            logger.error("get\u8bf7\u6c42\u9519\u8befurl:{}-proxy:{}", new Object[]{url, proxy, e});
            throw new MsgException(ResManager.loadKDString((String)"http\u8bf7\u6c42\u5f02\u5e38", (String)"HttpUtil_3", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                httpclient.close();
            }
            catch (IOException e) {
                logger.error("doget exception", (Throwable)e);
            }
        }
        return resultString;
    }

    public static String doPost(String url, String proxy, Map<String, String> headers, HttpEntity httpEntity, int connectTimeout, int socketTimeout) throws IOException {
        String rs;
        String redirectsEnabled;
        logger.info("HttpUtil url " + url);
        proxy = HttpUtil.getProxy(url, proxy);
        if (headers == null) {
            headers = new HashMap<String, String>(1);
        }
        CloseableHttpClient client = HttpUtil.getConnection(proxy, connectTimeout, socketTimeout, !"false".equals(redirectsEnabled = headers.get("redirectsEnabled")));
        headers.remove("redirectsEnabled");
        HttpPost post = new HttpPost(url);
        CloseableHttpResponse response = null;
        InputStream is = null;
        try {
            if (headers.size() != 0) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    String k = entry.getKey();
                    String v = entry.getValue();
                    post.setHeader(k, v);
                }
            } else {
                post.setHeader("Connection", "close");
            }
            HttpUtil.setConfigHeader((HttpRequestBase)post);
            logger.info("HttpUtil headers " + SerializationUtils.toJsonString(headers));
            post.setEntity(httpEntity);
            response = (CloseableHttpResponse)client.execute((HttpUriRequest)post);
            HttpEntity entity = response.getEntity();
            if ("gzip".equals(ImcConfigUtil.getValue("bdm_lqpt", "gzip"))) {
                Header[] responseHeaders = response.getHeaders("content-encoding");
                if (responseHeaders != null && Arrays.stream(responseHeaders).anyMatch(header -> header.getValue().contains("gzip"))) {
                    if ("compress".equals(ImcConfigUtil.getValue("bdm_lqpt", "gzip_type"))) {
                        int n;
                        is = new GZIPInputStream(new BufferedInputStream(response.getEntity().getContent()));
                        StringBuilder out = new StringBuilder();
                        byte[] b = new byte[4096];
                        while ((n = is.read(b)) != -1) {
                            out.append(new String(b, 0, n));
                        }
                        rs = out.toString();
                    } else {
                        rs = EntityUtils.toString((HttpEntity)new GzipDecompressingEntity(entity), (String)"UTF-8");
                    }
                } else {
                    rs = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                }
            } else {
                rs = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (ConnectTimeoutException e) {
            logger.error("do component request error,caused by \u8fde\u63a5\u8d85\u65f6url:{}-proxy:{}", new Object[]{url, proxy, e});
            throw new MsgException(e, ResManager.loadKDString((String)"\u8fde\u63a5\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"HttpUtil_1", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        catch (SocketTimeoutException e) {
            logger.error("do component request error,caused by \u54cd\u5e94\u8d85\u65f6url:{}-proxy:{}", new Object[]{url, proxy, e});
            throw new MsgException(e, ResManager.loadKDString((String)"\u54cd\u5e94\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"HttpUtil_2", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        catch (Exception e) {
            logger.error("post\u8bf7\u6c42\u9519\u8befurl:{}-proxy:{}", new Object[]{url, proxy, e});
            throw new MsgException(e, ResManager.loadKDString((String)"http\u8bf7\u6c42\u5f02\u5e38", (String)"HttpUtil_3", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
            }
            try {
                post.abort();
                post.releaseConnection();
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        return rs;
    }

    public static String doPostJson(String url, String proxy, Map<String, String> headers, String body) throws IOException {
        return HttpUtil.doPostJson(url, proxy, headers, body, connectTimeout, socketTimeout);
    }

    public static String doPostJson(String url, Map<String, String> headers, String body, int connectTimeout, int socketTimeout) throws IOException {
        return HttpUtil.doPostJson(url, "", headers, body, connectTimeout, socketTimeout);
    }

    @SdkDeprecated
    public static String doPostJson(String url, String proxy, Map<String, String> headers, String body, int connectTimeout, int socketTimeout) throws IOException {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        if (StringUtils.isBlank((CharSequence)body)) {
            body = "";
        }
        return HttpUtil.doPost(url, proxy, headers, (HttpEntity)new StringEntity(body, "UTF-8"), connectTimeout, socketTimeout);
    }

    public static JSONObject uploadInvoiceFile2S3(String url, String proxy, InputStream is, String fileName) throws Exception {
        Object errcode;
        proxy = HttpUtil.getProxy(url, proxy);
        CloseableHttpClient httpClient = HttpUtil.getConnection(proxy);
        String result = "";
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("errcode", (Object)"9999");
        HttpPost httpPost = new HttpPost(url);
        RequestConfig config = RequestConfig.custom().setConnectTimeout(60000).setConnectionRequestTimeout(60000).setSocketTimeout(60000).build();
        httpPost.setConfig(config);
        HttpUtil.setConfigHeader((HttpRequestBase)httpPost);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setCharset(Charset.forName("utf-8"));
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.addBinaryBody("file", is, ContentType.MULTIPART_FORM_DATA, fileName);
        HttpEntity httpEntity = builder.build();
        httpPost.setEntity(httpEntity);
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        HttpEntity responseEntity = response.getEntity();
        if (responseEntity != null) {
            result = EntityUtils.toString((HttpEntity)responseEntity, (Charset)Charset.forName("UTF-8"));
        }
        if (logger.isInfoEnabled()) {
            logger.info("\u4e0a\u4f20S3\u8fd4\u56de\u6570\u636e\uff1a" + JSONObject.toJSONString((Object)result));
        }
        if (!"0000".equals(errcode = (jsonObject = JSONObject.parseObject((String)result)).get((Object)"errcode"))) {
            throw new Exception(result);
        }
        return jsonObject;
    }

    public static JSONObject uploadZipFile(String url, String proxy, InputStream is, String fileName, Map<String, String> headers, String clientId, boolean needDelete) throws Exception {
        Object errcode;
        proxy = HttpUtil.getProxy(url, proxy);
        CloseableHttpClient httpClient = HttpUtil.getConnection(proxy);
        String result = "";
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("errcode", (Object)"9999");
        HttpPost httpPost = new HttpPost(url);
        RequestConfig config = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
        httpPost.setConfig(config);
        HttpUtil.setConfigHeader((HttpRequestBase)httpPost);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setCharset(Charset.forName("utf-8"));
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.addBinaryBody("file", is, ContentType.MULTIPART_FORM_DATA, fileName);
        if (null != headers) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpPost.setHeader(entry.getKey(), entry.getValue());
            }
        }
        builder.addTextBody("appGroup", "imc");
        builder.addTextBody("clientId", clientId);
        if (needDelete) {
            builder.addTextBody("delayDelMinuteTime", "133920");
        } else {
            builder.addTextBody("delayDelMinuteTime", "0");
        }
        if (fileName.contains(".pdf")) {
            builder.addTextBody("snapshotFlag", "true");
        }
        HttpEntity httpEntity = builder.build();
        httpPost.setEntity(httpEntity);
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        HttpEntity responseEntity = response.getEntity();
        if (responseEntity != null) {
            result = EntityUtils.toString((HttpEntity)responseEntity, (Charset)Charset.forName("UTF-8"));
        }
        if (logger.isInfoEnabled()) {
            logger.info("\u4e0a\u4f20\u8fd4\u56de\u6570\u636e\uff1a" + JSONObject.toJSONString((Object)result));
        }
        if (!"0000".equals(errcode = (jsonObject = JSONObject.parseObject((String)result)).get((Object)"errcode"))) {
            throw new Exception(result);
        }
        return jsonObject;
    }

    private static void setConfigHeader(HttpRequestBase message) {
        try {
            URI uri = message.getURI();
            if (uri == null) {
                return;
            }
            String url = uri.toString();
            Map<String, String> requestHeader = ImcConfigUtil.getValue("request_header_config");
            if (!CollectionUtils.isEmpty(requestHeader)) {
                requestHeader.forEach((urlCotain, headerStr) -> {
                    if (url.contains((CharSequence)urlCotain)) {
                        JSONObject json = JSONObject.parseObject((String)headerStr);
                        json.forEach((k, v) -> message.setHeader(k, (String)v));
                    }
                });
            }
        }
        catch (Exception e) {
            logger.error(String.format("\u8bbe\u7f6e\u8bf7\u6c42\u5934\u5931\u8d25\uff0c\u8bf7\u6c42\u5730\u5740\u4e3a[%s]", message.getURI().toString()));
        }
    }

    private static String getProxy(String url, String proxy) {
        if (!StringUtils.isEmpty((CharSequence)proxy)) {
            return proxy;
        }
        try {
            URI uri = new URI(url);
            String domain = uri.getHost();
            int port = uri.getPort();
            proxy = HttpUtil.getProxy(domain, port);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return proxy;
    }

    public static String getProxy(String domain, int port) {
        Map<String, String> proxyMap = ImcConfigUtil.getValue("bdm_http_proxy");
        String proxy = null;
        if (port > 0) {
            proxy = proxyMap.get(domain + ':' + port);
        }
        if (StringUtils.isEmpty(proxy)) {
            proxy = proxyMap.get(domain);
        }
        return proxy;
    }
}

