/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.util.CacheHelper;
import kd.sdk.annotation.SdkDeprecated;

public class ImcConfigUtil {
    public static void removeCache(String configType) {
        CacheHelper.remove(configType);
        CacheHelper.removeLocalCache(configType);
    }

    @SdkDeprecated
    public static Map<String, String> getValue(String configType) {
        String configCache = CacheHelper.get(configType, true);
        if (configCache != null) {
            HashMap<String, String> map = new HashMap();
            map = (Map)SerializationUtils.fromJsonString((String)configCache, map.getClass());
            return map;
        }
        return ImcConfigUtil.putCache(configType);
    }

    public static String getValue(String configType, String configKey) {
        Map<String, String> map = ImcConfigUtil.getValue(configType);
        return map.get(configKey);
    }

    public static String getValue(CacheKeyEnum cacheKeyEnum) {
        Map<String, String> map = ImcConfigUtil.getValue(cacheKeyEnum.getConfigType());
        String value = map.get(cacheKeyEnum.getConfigKey());
        if (StringUtils.isBlank((CharSequence)value)) {
            value = cacheKeyEnum.getDefaultValue();
        }
        return value;
    }

    public static Map<String, String> putCache(String configType) {
        QFilter filter = new QFilter("config_type", "=", (Object)configType);
        DynamicObject[] collection = BusinessDataServiceHelper.load((String)"invsm_param_configuration", (String)"config_type,config_key,config_value", (QFilter[])new QFilter[]{filter});
        HashMap<String, String> map = new HashMap<String, String>(collection.length);
        for (DynamicObject obj : collection) {
            map.put(obj.getString("config_key"), obj.getString("config_value"));
        }
        if (!map.isEmpty()) {
            String cacheStr = SerializationUtils.toJsonString(map);
            CacheHelper.put(configType, cacheStr, 86400);
            CacheHelper.putLocalCache(configType, cacheStr);
        } else {
            CacheHelper.putLocalCache(configType, "\u25cf\u25c6\u25a0");
        }
        return map;
    }

    public static String getValue(Map<String, String> map, String ... keys) {
        for (String key : keys) {
            String value = map.get(key);
            if (value == null) continue;
            return value;
        }
        return "";
    }

    public static Set<String> getConfigStringArray(String configType, String configKey) {
        try {
            String configStrs = ImcConfigUtil.getValue(configType, configKey);
            if (StringUtils.isBlank((CharSequence)configStrs)) {
                return new HashSet<String>();
            }
            String[] itemKeys = configStrs.split(",");
            return Arrays.stream(itemKeys).collect(Collectors.toSet());
        }
        catch (Exception ignore) {
            return new HashSet<String>();
        }
    }
}

