/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.InvoiceFormsEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.constant.table.BdmIssueInvSettingConstant;
import kd.imc.bdm.common.constant.table.RedReasonEnum;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.IssueInvSettingHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.RequestUtils;
import kd.sdk.annotation.SdkDeprecated;
import org.apache.commons.lang.ObjectUtils;

public class InvoiceUtils {
    private static final Log LOGGER = LogFactory.getLog(InvoiceUtils.class);
    private static int ggxh_len = 120;
    private static final String[] code = new String[]{"144031539110", "131001570151", "133011501118", "111001571071"};
    private static final Set<String> errorNameSet = new HashSet<String>(Arrays.asList(ResManager.loadKDString((String)"(\u8be6\u89c1\u9500\u8d27\u6e05\u5355)", (String)"InvoiceUtils_49", (String)"imc-bdm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u539f\u4ef7\u5408\u8ba1", (String)"InvoiceUtils_50", (String)"imc-bdm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6298\u6263\u989d\u5408\u8ba1", (String)"InvoiceUtils_51", (String)"imc-bdm-common", (Object[])new Object[0])));
    public static final String PURCHASE = "02";
    private static final String ISSUE_SOURCE_LEQI = "13";
    private static final String sql = "select fuseorgid from %s where FDATAID =%s";

    public static String getInvoiceTypeCode(String a) {
        String c = "99";
        if (a.length() == 12) {
            String b = a.substring(7, 8);
            for (String s : code) {
                if (!a.equals(s)) continue;
                c = "10";
                break;
            }
            if ("99".equals(c)) {
                if (a.charAt(0) == '0' && a.startsWith("11", 10)) {
                    c = "10";
                }
                if (a.charAt(0) == '0' && (a.startsWith("04", 10) || a.startsWith("05", 10))) {
                    c = "04";
                }
                if (a.charAt(0) == '0' && (a.startsWith("06", 10) || a.startsWith("07", 10))) {
                    c = "11";
                }
                if (a.charAt(0) == '0' && a.startsWith("12", 10)) {
                    c = "14";
                }
            }
            if ("99".equals(c)) {
                if (a.startsWith("17", 10) && a.charAt(0) == '0') {
                    c = "15";
                }
                if (c.equals("99") && "2".equals(b) && a.charAt(0) != '0') {
                    c = "03";
                }
            }
        } else if (a.length() == 10) {
            String b;
            switch (b = a.substring(7, 8)) {
                case "1": 
                case "5": {
                    c = "01";
                    break;
                }
                case "6": 
                case "3": {
                    c = "04";
                    break;
                }
                case "7": 
                case "2": {
                    c = PURCHASE;
                }
            }
        }
        return c;
    }

    public static String getInvoiceProvince(String taxno) {
        String sfdm = taxno.substring(2, 6);
        String code = "2102".equals(sfdm) || "3302".equals(sfdm) || "3502".equals(sfdm) || "3702".equals(sfdm) || "4403".equals(sfdm) ? sfdm : sfdm.substring(0, 2) + "00";
        String data = "[{  'code': '1100',   'sfmc': '\u5317\u4eac',  'Ip': 'https://fpcy.beijing.chinatax.gov.cn:443/NWebQuery',  'address': 'https://fpcy.beijing.chinatax.gov.cn:443'}, {  'code': '1200',   'sfmc': '\u5929\u6d25',  'Ip': 'https://fpcy.tjsat.gov.cn:443/NWebQuery',  'address': 'https://fpcy.tjsat.gov.cn:443'}, {  'code': '1300',   'sfmc': '\u6cb3\u5317',  'Ip': 'https://fpcy.hebei.chinatax.gov.cn/NWebQuery',  'address': 'https://fpcy.hebei.chinatax.gov.cn'}, {  'code': '1400',   'sfmc': '\u5c71\u897f',  'Ip': 'https://fpcy.shanxi.chinatax.gov.cn:443/NWebQuery',  'address': 'https://fpcy.shanxi.chinatax.gov.cn:443'}, {  'code': '1500',   'sfmc': '\u5185\u8499\u53e4',  'Ip': 'https://fpcy.neimenggu.chinatax.gov.cn:443/NWebQuery',  'address': 'https://fpcy.neimenggu.chinatax.gov.cn:443'}, {  'code': '2100',   'sfmc': '\u8fbd\u5b81',  'Ip': 'https://fpcy.liaoning.chinatax.gov.cn:443/NWebQuery',  'address': 'https://fpcy.liaoning.chinatax.gov.cn:443'}, {  'code': '2102',   'sfmc': '\u5927\u8fde',  'Ip': 'https://fpcy.dlntax.gov.cn:443/NWebQuery',  'address': 'https://fpcy.dlntax.gov.cn:443'}, {  'code': '2200',   'sfmc': '\u5409\u6797',  'Ip': 'https://fpcy.jilin.chinatax.gov.cn:4432/NWebQuery',  'address': 'https://fpcy.jilin.chinatax.gov.cn:4432'}, {  'code': '2300',   'sfmc': '\u9ed1\u9f99\u6c5f',  'Ip': 'https://fpcy.hl-n-tax.gov.cn:443/NWebQuery',  'address': 'https://fpcy.hl-n-tax.gov.cn:443'}, {  'code': '3100',   'sfmc': '\u4e0a\u6d77',  'Ip': 'https://fpcy.shanghai.chinatax.gov.cn:1001/NWebQuery',  'address': 'https://fpcy.shanghai.chinatax.gov.cn:1001'}, {  'code': '3200',   'sfmc': '\u6c5f\u82cf',  'Ip': 'https://fpcy.jiangsu.chinatax.gov.cn:80/NWebQuery',  'address': 'https://fpcy.jiangsu.chinatax.gov.cn:80'}, {  'code': '3300',   'sfmc': '\u6d59\u6c5f',  'Ip': 'https://fpcy.zhejiang.chinatax.gov.cn:443/NWebQuery',  'address': 'https://fpcy.zhejiang.chinatax.gov.cn:443'}, {  'code': '3302',   'sfmc': '\u5b81\u6ce2',  'Ip': 'https://fpcy.ningbo.chinatax.gov.cn:443/NWebQuery',  'address': 'https://fpcy.ningbo.chinatax.gov.cn:443'}, {  'code': '3400',   'sfmc': '\u5b89\u5fbd',  'Ip': 'https://fpcy.anhui.chinatax.gov.cn:443/NWebQuery',  'address': 'https://fpcy.anhui.chinatax.gov.cn:443'}, {  'code': '3500',   'sfmc': '\u798f\u5efa',  'Ip': 'https://fpcy.fujian.chinatax.gov.cn:443/NWebQuery',  'address': 'https://fpcy.fujian.chinatax.gov.cn:443'}, {  'code': '3502',   'sfmc': '\u53a6\u95e8',  'Ip': 'https://fpcy.xiamen.chinatax.gov.cn/NWebQuery',  'address': 'https://fpcy.xiamen.chinatax.gov.cn'}, {  'code': '3600',   'sfmc': '\u6c5f\u897f',  'Ip': 'https://fpcy.jiangxi.chinatax.gov.cn:82/NWebQuery',  'address': 'https://fpcy.jiangxi.chinatax.gov.cn:82'}, {  'code': '3700',   'sfmc': '\u5c71\u4e1c',  'Ip': 'https://fpcy.shandong.chinatax.gov.cn:443/NWebQuery',  'address': 'https://fpcy.shandong.chinatax.gov.cn:443'}, {  'code': '3702',   'sfmc': '\u9752\u5c9b',  'Ip': 'https://fpcy.qingdao.chinatax.gov.cn:443/NWebQuery',  'address': 'https://fpcy.qingdao.chinatax.gov.cn:443'}, {  'code': '4100',   'sfmc': '\u6cb3\u5357',  'Ip': 'https://fpcy.henan.chinatax.gov.cn/NWebQuery',  'address': 'https://fpcy.henan.chinatax.gov.cn'}, {  'code': '4200',   'sfmc': '\u6e56\u5317',  'Ip': 'https://fpcy.hubei.chinatax.gov.cn:443/NWebQuery',  'address': 'https://fpcy.hubei.chinatax.gov.cn:443'}, {  'code': '4300',   'sfmc': '\u6e56\u5357',  'Ip': 'https://fpcy.hunan.chinatax.gov.cn:8083/NWebQuery',  'address': 'https://fpcy.hunan.chinatax.gov.cn:8083'}, {  'code': '4400',   'sfmc': '\u5e7f\u4e1c',  'Ip': 'https://fpcy.guangdong.chinatax.gov.cn:443/NWebQuery',  'address': 'https://fpcy.guangdong.chinatax.gov.cn:443'}, {  'code': '4403',   'sfmc': '\u6df1\u5733',  'Ip': 'https://fpcy.shenzhen.chinatax.gov.cn:443/NWebQuery',  'address': 'https://fpcy.shenzhen.chinatax.gov.cn:443'}, {  'code': '4500',   'sfmc': '\u5e7f\u897f',  'Ip': 'https://fpcy.guangxi.chinatax.gov.cn:8200/NWebQuery',  'address': 'https://fpcy.guangxi.chinatax.gov.cn:8200'}, {  'code': '4600',   'sfmc': '\u6d77\u5357',  'Ip': 'https://fpcy.hainan.chinatax.gov.cn:443/NWebQuery',  'address': 'https://fpcy.hainan.chinatax.gov.cn:443'}, {  'code': '5000',   'sfmc': '\u91cd\u5e86',  'Ip': 'https://fpcy.chongqing.chinatax.gov.cn:80/NWebQuery',  'address': 'https://fpcy.chongqing.chinatax.gov.cn:80'}, {  'code': '5100',   'sfmc': '\u56db\u5ddd',  'Ip': 'https://fpcy.sichuan.chinatax.gov.cn:443/NWebQuery',  'address': 'https://fpcy.sichuan.chinatax.gov.cn:443'}, {  'code': '5200',   'sfmc': '\u8d35\u5dde',  'Ip': 'https://fpcy.guizhou.chinatax.gov.cn:80/NWebQuery',  'address': 'https://fpcy.guizhou.chinatax.gov.cn:80'}, {  'code': '5300',   'sfmc': '\u4e91\u5357',  'Ip': 'https://fpcy.yngs.gov.cn:443/NWebQuery',  'address': 'https://fpcy.yngs.gov.cn:443'}, {  'code': '5400',   'sfmc': '\u5c71\u897f',  'Ip': 'https://fpcy.xztax.gov.cn:81/NWebQuery',  'address': 'https://fpcy.xztax.gov.cn:81'}, {  'code': '6100',   'sfmc': '\u9655\u897f',  'Ip': 'https://fpcy.shaanxi.chinatax.gov.cn:443/NWebQuery',  'address': 'https://fpcy.shaanxi.chinatax.gov.cn:443'}, {  'code': '6200',   'sfmc': '\u7518\u8083',  'Ip': 'https://fpcy.gansu.chinatax.gov.cn:443/NWebQuery',  'address': 'https://fpcy.gansu.chinatax.gov.cn:443'}, {  'code': '6300',   'sfmc': '\u9752\u6d77',  'Ip': 'https://fpcy.qinghai.chinatax.gov.cn:443/NWebQuery',  'address': 'https://fpcy.qinghai.chinatax.gov.cn:443'}, {  'code': '6400',   'sfmc': '\u5b81\u590f',  'Ip': 'https://fpcy.ningxia.chinatax.gov.cn:443/NWebQuery',  'address': 'https://fpcy.ningxia.chinatax.gov.cn:443'}, {  'code': '6500',   'sfmc': '\u65b0\u7586',  'Ip': 'https://fpcy.xj-n-tax.gov.cn:443/NWebQuery',  'address': 'https://fpcy.xj-n-tax.gov.cn:443'}]";
        JSONArray jsonArray = JSONArray.parseArray((String)data);
        for (Object o : jsonArray) {
            JSONObject jsonObject = (JSONObject)o;
            if (!code.equals(jsonObject.getString("code"))) continue;
            return jsonObject.getString("sfmc");
        }
        return "";
    }

    public static InvoiceFormsEnum getInvoiceFormsType(String invoiceCode) {
        String code = InvoiceUtils.getInvoiceTypeCode(invoiceCode);
        if ("01".equals(code)) {
            return InvoiceFormsEnum.THREEFORMS;
        }
        if ("04".equals(code)) {
            if (invoiceCode.length() == 12) {
                String invType = invoiceCode.substring(10, 11);
                String fromsType = invoiceCode.substring(11, 12);
                if ("0".equals(invType)) {
                    if ("4".equals(fromsType)) {
                        return InvoiceFormsEnum.TWOFORMS;
                    }
                    if ("5".equals(fromsType)) {
                        return InvoiceFormsEnum.FIVEFORMS;
                    }
                }
            } else if (invoiceCode.length() == 10) {
                String invType = invoiceCode.substring(7, 8);
                String fromsType = invoiceCode.substring(8, 9);
                if ("6".equals(invType)) {
                    if ("2".equals(fromsType)) {
                        return InvoiceFormsEnum.TWOFORMS;
                    }
                    if ("5".equals(fromsType)) {
                        return InvoiceFormsEnum.FIVEFORMS;
                    }
                }
            }
        }
        return InvoiceFormsEnum.OTHER;
    }

    public static Set<String> getPaperInvoiceType() {
        return ImmutableSet.of((Object)InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode(), (Object)InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode(), (Object)InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode());
    }

    @SdkDeprecated
    public static boolean isPaperInvoice(String invoiceType) {
        return InvoiceUtils.getPaperInvoiceType().contains(invoiceType);
    }

    public static Set<String> getEtcInvoiceType() {
        return ImmutableSet.of((Object)InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode(), (Object)InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode(), (Object)InvoiceType.ALL_E_NORMAL.getTypeCode(), (Object)InvoiceType.ALL_E_SPECIAL.getTypeCode(), (Object)InvoiceType.ALL_E_PAPER_USED_CAR_ELE.getTypeCode(), (Object)InvoiceType.ALL_E_VEHICLE_NORMAL_ELE.getTypeCode(), (Object[])new String[0]);
    }

    public static boolean isEtcInvoice(String invoiceType) {
        return InvoiceUtils.getEtcInvoiceType().contains(invoiceType);
    }

    public static Set<String> getNormalInvoiceType() {
        return ImmutableSet.of((Object)InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode(), (Object)InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode());
    }

    public static boolean isNormalInvoice(String invoiceType) {
        return InvoiceUtils.getNormalInvoiceType().contains(invoiceType);
    }

    public static Set<String> getSpecialInvoiceType() {
        return ImmutableSet.of((Object)InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode(), (Object)InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode());
    }

    public static boolean isAllEInvoice(Object invoiceType) {
        return InvoiceUtils.getAllEInvoiceType().contains(invoiceType);
    }

    public static boolean isAllEVehicleInv(String invoiceType) {
        return InvoiceType.ALL_E_VEHICLE_NORMAL.getTypeCode().equals(invoiceType) || InvoiceType.ALL_E_VEHICLE_NORMAL_ELE.getTypeCode().equals(invoiceType);
    }

    public static boolean isAllESpecialInvoice(String invoiceType) {
        return InvoiceType.ALL_E_SPECIAL.getTypeCode().equals(invoiceType);
    }

    public static boolean isAllESpecialType(String specialType) {
        return "E03".equals(specialType) || "E06".equals(specialType);
    }

    public static Set<String> getAllEInvoiceType() {
        return ImmutableSet.of((Object)InvoiceType.ALL_E_NORMAL.getTypeCode(), (Object)InvoiceType.ALL_E_VEHICLE_NORMAL.getTypeCode(), (Object)InvoiceType.ALL_E_PAPER_USED_CAR.getTypeCode(), (Object)InvoiceType.ALL_E_SPECIAL.getTypeCode());
    }

    public static boolean isSpecialInvoice(String invoiceType) {
        return InvoiceUtils.getSpecialInvoiceType().contains(invoiceType);
    }

    public static DynamicObject checkInvoice(String invoiceCode, String invoiceNo) {
        if (StringUtils.isBlank((CharSequence)invoiceCode)) {
            throw new MsgException(ErrorType.FI_PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceUtils_36", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)invoiceNo)) {
            throw new MsgException(ErrorType.FI_PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceUtils_37", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_vatinvoice"), (QFilter[])new QFilter("invoicecode", "=", (Object)invoiceCode).and("invoiceno", "=", (Object)invoiceNo).toArray());
        if (invoice == null) {
            throw new MsgException(ErrorType.FI_PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u6570\u636e\u4e0d\u5b58\u5728", (String)"InvoiceUtils_38", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        return invoice;
    }

    public static boolean isRedInfo(DynamicObject dynamicObject) {
        return IssueType.RED_INVOICE.getTypeCode().equals(dynamicObject.get("issuetype")) && InvoiceUtils.isSpecialInvoice(dynamicObject.getString("invoicetype"));
    }

    public static boolean isRedInfo(BigDecimal invoiceAmount, String invoiceType) {
        return invoiceAmount.compareTo(BigDecimal.ZERO) < 0 && InvoiceUtils.isSpecialInvoice(invoiceType);
    }

    public static boolean isRed(String issueType) {
        return IssueType.RED_INVOICE.getTypeCode().equals(issueType);
    }

    public static boolean isRedInfoInvoice(String issueType, String invoiceType) {
        if (StringUtils.isBlank((CharSequence)issueType) || StringUtils.isBlank((CharSequence)invoiceType)) {
            return false;
        }
        if (!InvoiceUtils.isSpecialInvoice(invoiceType)) {
            return false;
        }
        return IssueType.RED_INVOICE.getTypeCode().equals(issueType);
    }

    public static Map<String, String> getRedInvoiceType() {
        HashMap<String, String> invTypeSelectMap = new HashMap<String, String>();
        invTypeSelectMap.put(ResManager.loadKDString((String)"\u7535\u5b50\u666e\u901a\u53d1\u7968", (String)"InvoiceUtils_39", (String)"imc-bdm-common", (Object[])new Object[0]), "026");
        invTypeSelectMap.put(ResManager.loadKDString((String)"\u7eb8\u8d28\u666e\u901a\u53d1\u7968", (String)"InvoiceUtils_41", (String)"imc-bdm-common", (Object[])new Object[0]), "007");
        invTypeSelectMap.put(ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\uff08\u5377\u7968\uff09", (String)"InvoiceUtils_43", (String)"imc-bdm-common", (Object[])new Object[0]), "025");
        return invTypeSelectMap;
    }

    public static QFilter getInvoiceFilter(Object invoiceCode, Object invoiceNo) {
        return new QFilter("invoiceno", "=", invoiceNo).and(new QFilter("invoicecode", "=", invoiceCode));
    }

    public static DynamicObject[] queryInvoiceRelateOriBill(DynamicObject invoice, boolean fromBlueInvoice) {
        String issueType = invoice.getString("issuetype");
        String invoiceType = invoice.getString("invoicetype");
        String oriInvoiceCode = invoice.getString("originalinvoicecode");
        String oriInvoiceNo = invoice.getString("originalinvoiceno");
        String sellerTaxNo = invoice.getString("salertaxno");
        DynamicObject[] result = new DynamicObject[]{};
        if (InvoiceUtils.isRedInfoInvoice(issueType, invoiceType)) {
            QFilter filter = new QFilter("org", "=", invoice.getDynamicObject("orgid").getPkValue()).and(new QFilter("infocode", "=", invoice.get("infocode")));
            DynamicObject[] redInfos = BusinessDataServiceHelper.load((String)"sim_red_info", (String)"id", (QFilter[])filter.toArray());
            if (redInfos.length == 0) {
                LOGGER.info("\u672a\u627e\u5230\u7ea2\u5b57\u4fe1\u606f\u8868\u4fe1\u606f");
                return result;
            }
            QFilter relationFilter = new QFilter("tbillid", "=", redInfos[0].getPkValue()).and("isdelete", "!=", (Object)"Y");
            if (QueryServiceHelper.exists((String)"sim_bill_inv_relation", (QFilter[])relationFilter.toArray())) {
                Object tBillId = redInfos[0].getPkValue();
                return InvoiceUtils.getOriBillArray(tBillId);
            }
            if (fromBlueInvoice) {
                DynamicObject[] oriInvoice = InvoiceUtils.getInvoice(sellerTaxNo, oriInvoiceCode, oriInvoiceNo);
                if (oriInvoice != null && oriInvoice.length > 0) {
                    Object tBillId = oriInvoice[0].getPkValue();
                    return InvoiceUtils.getOriBillArray(tBillId);
                }
                LOGGER.info("\u7ea2\u5b57\u4fe1\u606f\u8868\u5bf9\u5e94\u539f\u84dd\u7968\u4e0d\u5728\u7cfb\u7edf\u4e2d");
                return result;
            }
        } else {
            QFilter relationFilter = new QFilter("tbillid", "=", invoice.getPkValue()).and("isdelete", "!=", (Object)"Y");
            if (QueryServiceHelper.exists((String)"sim_bill_inv_relation", (QFilter[])relationFilter.toArray())) {
                Object tBillId = invoice.getPkValue();
                return InvoiceUtils.getOriBillArray(tBillId);
            }
            if (fromBlueInvoice) {
                DynamicObject[] oriBlueInvoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)"id", (QFilter[])InvoiceUtils.getInvoiceFilter(oriInvoiceCode, oriInvoiceNo).toArray());
                if (oriBlueInvoices.length == 0) {
                    LOGGER.info("\u7ea2\u5b57\u53d1\u7968\u5bf9\u5e94\u7684\u539f\u84dd\u7968\u4e0d\u5728\u7cfb\u7edf\u4e2d");
                    return result;
                }
                Object tBillId = oriBlueInvoices[0].getPkValue();
                return InvoiceUtils.getOriBillArray(tBillId);
            }
        }
        return result;
    }

    private static DynamicObject[] getOriBillArray(Object tBillId) {
        QFilter deleteFilter = new QFilter("isdelete", "!=", (Object)"Y");
        QFilter filter1 = deleteFilter.and("tbillid", "=", tBillId);
        DynamicObject[] relationArray = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)"sbillid", (QFilter[])filter1.toArray());
        if (relationArray.length == 0) {
            LOGGER.info("\u5173\u7cfb\u8868\u6ca1\u6709\u5173\u7cfb");
            return new DynamicObject[0];
        }
        HashSet<Object> oriPks = new HashSet<Object>();
        for (DynamicObject relation : relationArray) {
            oriPks.add(relation.get("sbillid"));
        }
        return BusinessDataServiceHelper.load((String)"sim_original_bill", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_original_bill", true), (QFilter[])new QFilter("id", "in", (Object)oriPks.toArray(new Object[0])).toArray());
    }

    public static DynamicObject[] getInvoice(Object salerTaxNo, Object oriInvoiceCode2, Object oriInvoiceNo2) {
        return InvoiceUtils.getInvoice(salerTaxNo, oriInvoiceCode2, oriInvoiceNo2, true);
    }

    public static DynamicObject[] getInvoice(Object salerTaxNo, Object oriInvoiceCode2, Object oriInvoiceNo2, boolean containsItems) {
        QFilter invoiceFilter = InvoiceUtils.getInvoiceFilter(oriInvoiceCode2, oriInvoiceNo2);
        QFilter filter = StringUtils.isNotBlank((Object)salerTaxNo) ? new QFilter("salertaxno", "=", salerTaxNo).and(invoiceFilter) : invoiceFilter;
        return BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_vatinvoice", containsItems), (QFilter[])filter.toArray());
    }

    public static DynamicObject[] getInvoice(Object oriInvoiceCode2, Object oriInvoiceNo2) {
        QFilter[] oriFilters = InvoiceUtils.getInvoiceFilter(oriInvoiceCode2, oriInvoiceNo2).toArray();
        return BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_vatinvoice", true), (QFilter[])oriFilters);
    }

    public static Object[] getNormalInvoiceCanRedInvoiceType() {
        return new Object[]{InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode(), InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode(), InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode()};
    }

    public static boolean isUseSpecificationInvoiceItemsRule(String salerTaxNo, String buyerTaxNo, String specialType) {
        String taxNo = salerTaxNo;
        if (PURCHASE.equalsIgnoreCase(specialType)) {
            taxNo = buyerTaxNo;
        }
        String listConfig = ImcConfigUtil.getValue("sim_invoice_list_config", taxNo);
        return "1".equals(listConfig);
    }

    public static void dealInvoicesListMark(Map<String, Boolean> invoiceListLableMap, List<DynamicObject> invoices) {
        for (DynamicObject invoice : invoices) {
            Boolean itemRule;
            if ("1".equals(invoice.getString("inventorymark"))) {
                LOGGER.info("invoiceRemarkNotChanged,\u5df2\u6709\u6e05\u5355\u6807\u8bc6\uff1a" + invoice.get("billno"));
                continue;
            }
            BigDecimal totalAmount = invoice.getBigDecimal("totalamount");
            if (BigDecimalUtil.lessZero(totalAmount)) continue;
            String sellerTaxNo = invoice.getString("salertaxno");
            String buyerTaxNo = invoice.getString("buyertaxno");
            String specialType = invoice.getString("specialtype");
            if (PURCHASE.equals(specialType)) {
                itemRule = invoiceListLableMap.get(buyerTaxNo + specialType);
                if (null == itemRule) {
                    itemRule = InvoiceUtils.isUseSpecificationInvoiceItemsRule(sellerTaxNo, buyerTaxNo, specialType);
                    invoiceListLableMap.put(buyerTaxNo + specialType, itemRule);
                }
            } else {
                itemRule = invoiceListLableMap.get(sellerTaxNo);
                if (null == itemRule) {
                    itemRule = InvoiceUtils.isUseSpecificationInvoiceItemsRule(sellerTaxNo, buyerTaxNo, specialType);
                    invoiceListLableMap.put(sellerTaxNo, itemRule);
                }
            }
            if (itemRule.booleanValue()) {
                LOGGER.info("invoiceRemarkChanged\uff0c\u6839\u636e\u914d\u7f6e\u52a0\u6e05\u5355\u6807\u8bc6" + invoice.get("billno"));
                invoice.set("inventorymark", (Object)InvoiceUtils.getInvoiceMark(invoice));
                continue;
            }
            LOGGER.info("invoiceRemarkNotChanged\uff0c\u914d\u7f6e\u662f\u4e0d\u52a0\u6e05\u5355\u6807\u8bc6" + invoice.get("billno"));
        }
    }

    public static String getInvoiceMark(DynamicObject invoice) {
        DynamicObjectCollection items = invoice.getDynamicObjectCollection("items");
        String invoiceRemark = invoice.getString("inventorymark");
        if ("1".equals(invoiceRemark)) {
            return "1";
        }
        if (items.size() > 8) {
            return "1";
        }
        ArrayList reBuildedList = new ArrayList();
        for (DynamicObject item : items) {
            String ggxh = item.getString("specification");
            Integer ggxhLength = GBKUtils.getImageLength(ggxh);
            if (ggxhLength <= ggxh_len) {
                Collections.addAll(reBuildedList, ggxh);
                continue;
            }
            List<String> cutGGXHs = InvoiceUtils.cutGGXH(ggxh);
            Collections.addAll(reBuildedList, cutGGXHs.toArray(new String[0]));
        }
        if (reBuildedList.size() > 8) {
            return "1";
        }
        return "0";
    }

    public static List<String> cutGGXH(String ggxh) {
        ArrayList<String> result = new ArrayList<String>();
        int builderLength = 0;
        int addLength = 0;
        StringBuilder builder = new StringBuilder();
        ArrayList list = new ArrayList();
        Collections.addAll(list, Character.valueOf('m'), Character.valueOf('w'));
        ArrayList list2 = new ArrayList();
        Collections.addAll(list2, Character.valueOf('M'), Character.valueOf('W'));
        for (int i = 0; i < ggxh.length(); ++i) {
            char str = ggxh.charAt(i);
            addLength = str > '\u0100' ? builderLength + 20 : (list2.contains(Character.valueOf(str)) ? builderLength + 20 : (str >= 'A' && str <= 'Z' ? builderLength + 15 : (list.contains(Character.valueOf(str)) ? builderLength + 15 : (addLength += 10))));
            if (addLength > ggxh_len) {
                result.add(builder.toString());
                builder = new StringBuilder();
                builder.append(str);
                addLength -= builderLength;
            } else {
                builder.append(str);
            }
            builderLength = addLength;
        }
        if (builder.length() > 0) {
            String cutGGXH = builder.toString();
            result.add(cutGGXH);
        }
        ArrayList<String> newResult = new ArrayList<String>();
        for (String s : result) {
            newResult.add(s);
        }
        return newResult;
    }

    public static boolean normalRowCheck() {
        String key = "sim_discount_row_check";
        Map<String, String> map = ImcConfigUtil.getValue(key);
        String value = map.get(key);
        return !"1".equalsIgnoreCase(value);
    }

    public static boolean isRedConfirmInvoice(String issueType, String invoiceType) {
        return InvoiceUtils.isAllEInvoice(invoiceType) && IssueType.RED_INVOICE.getTypeCode().equals(issueType);
    }

    public static boolean isFromLeqi(DynamicObject invoice) {
        return ISSUE_SOURCE_LEQI.equals(invoice.getString("issuesource"));
    }

    public static Set<String> getCommonInvoiceType() {
        return ImmutableSet.of((Object)InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode(), (Object)InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode(), (Object)InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode(), (Object)InvoiceType.ALL_E_NORMAL.getTypeCode());
    }

    public static boolean isCommonInvoice(String invoiceType) {
        return InvoiceUtils.getCommonInvoiceType().contains(invoiceType);
    }

    public static void setSpecialItemToInvoiceByBill(DynamicObject bill, DynamicObject invoice) {
        if (bill == null || invoice == null) {
            return;
        }
        DynamicObjectCollection freightsItem = bill.getDynamicObjectCollection("freights");
        if (freightsItem != null && !freightsItem.isEmpty()) {
            invoice.set("freights", (Object)freightsItem);
        }
    }

    public static boolean isTaxControlNormalInvoice(Object invoiceType, Object isElePaperValue) {
        boolean normalInvoice = InvoiceUtils.isNormalInvoice((String)invoiceType);
        boolean isElePaper = AllEleAuthHelper.isElePaper(isElePaperValue);
        return normalInvoice && !isElePaper;
    }

    public static boolean isVehicleInvoice(String invoiceType) {
        return InvoiceType.ALL_E_VEHICLE_NORMAL.getTypeCode().equals(invoiceType) || InvoiceType.PAPER_VEHICLE_INVOICE.getTypeCode().equals(invoiceType) || InvoiceType.ALL_E_VEHICLE_NORMAL_ELE.getTypeCode().equals(invoiceType);
    }

    public static boolean isAllEPaperVehicleInvoice(String invoiceType) {
        return InvoiceType.ALL_E_VEHICLE_NORMAL.getTypeCode().equals(invoiceType);
    }

    public static boolean isAllEPapperUsedCarInvoice(String invoiceType) {
        return InvoiceType.ALL_E_PAPER_USED_CAR.getTypeCode().equals(invoiceType);
    }

    public static boolean isUsedCarInvoice(Object invoiceType) {
        return InvoiceType.ALL_E_PAPER_USED_CAR.getTypeCode().equals(invoiceType) || InvoiceType.ALL_E_PAPER_USED_CAR_ELE.getTypeCode().equals(invoiceType) || InvoiceType.PAPER_USED_CAR_INVOICE.getTypeCode().equals(invoiceType);
    }

    public static boolean isRedReasonDiscount(String redReason) {
        return RedReasonEnum.SALES_DISCOUNTS.getTypeCode().equals(redReason) || RedReasonEnum.SALES_DISCOUNTS.getEleTypeCode().equals(redReason);
    }

    public static String matchRedConfirmRedReason(String redReason) {
        for (RedReasonEnum value : RedReasonEnum.values()) {
            if (!value.getEleTypeCode().equals(redReason) && !value.getTypeCode().equals(redReason)) continue;
            return value.getEleTypeCode();
        }
        return null;
    }

    public static boolean isVolumeInvCreatePdf(DynamicObject invoice) {
        boolean volumeCreatePdf = "1".equals(ImcConfigUtil.getValue(CacheKeyEnum.VOLUME_INVOICE_CREATE_PDF));
        boolean isVolumeInv = InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode().equals(invoice.getString("invoicetype"));
        return volumeCreatePdf && isVolumeInv;
    }

    public static String calculateRedNum(DynamicObject item, DynamicObjectCollection items) {
        BigDecimal amount = item.getBigDecimal("amount");
        BigDecimal num = item.getBigDecimal("num");
        BigDecimal redAmount = item.getBigDecimal("itemremainredamount");
        String rowType = item.getString("rowtype");
        BigDecimal redPrice = item.getBigDecimal("redprice");
        BigDecimal redNum = item.getBigDecimal("itemremainrednum");
        BigDecimal unitPrice = item.getBigDecimal("unitprice");
        if ("1".equals(rowType) || redAmount.compareTo(BigDecimal.ZERO) == 0) {
            return "0";
        }
        if (redNum.compareTo(BigDecimal.ZERO) != 0) {
            return redNum.toPlainString();
        }
        try {
            if (num.compareTo(BigDecimal.ZERO) != 0 && redNum.compareTo(BigDecimal.ZERO) == 0) {
                DynamicObject nextItem = items.stream().filter(oneItem -> oneItem.getInt("seq") == item.getInt("seq") + 1).findAny().orElse(null);
                if (redAmount.compareTo(amount) == 0 || amount.add(nextItem.getBigDecimal("amount")).compareTo(redAmount) == 0) {
                    return num.toPlainString();
                }
                if (redAmount.compareTo(amount) < 0 || amount.add(nextItem.getBigDecimal("amount")).compareTo(redAmount) > 0) {
                    if (redPrice.compareTo(BigDecimal.ZERO) == 0) {
                        return redAmount.divide(unitPrice, 16, RoundingMode.HALF_UP).toPlainString();
                    }
                    return redAmount.divide(redPrice, 16, RoundingMode.HALF_UP).toPlainString();
                }
            }
        }
        catch (Exception e) {
            LOGGER.info("\u8ba1\u7b97\u53ef\u7ea2\u51b2\u6570\u91cf\u5931\u8d25" + e.getMessage());
            return "";
        }
        return "0";
    }

    public static String calculateRedPrice(DynamicObject item, DynamicObjectCollection items) {
        BigDecimal amount = item.getBigDecimal("amount");
        if (amount.compareTo(BigDecimal.ZERO) <= 0) {
            return "";
        }
        String rowType = item.getString("rowtype");
        if ("1".equals(rowType)) {
            return "";
        }
        BigDecimal redPrice = item.getBigDecimal("redprice");
        if (redPrice.compareTo(BigDecimal.ZERO) > 0) {
            return redPrice.stripTrailingZeros().toPlainString();
        }
        BigDecimal num = item.getBigDecimal("num");
        BigDecimal redAmount = item.getBigDecimal("itemremainredamount");
        BigDecimal redNum = item.getBigDecimal("itemremainrednum");
        BigDecimal unitPrice = item.getBigDecimal("unitprice");
        try {
            if ("0".equals(rowType) && redAmount.compareTo(amount) == 0) {
                return BigDecimalUtil.formatNumOrUnitPrice(unitPrice, 16).stripTrailingZeros().toPlainString();
            }
            if (redAmount.compareTo(BigDecimal.ZERO) != 0 && redNum.compareTo(BigDecimal.ZERO) != 0 && num.compareTo(BigDecimal.ZERO) != 0 && unitPrice.compareTo(BigDecimal.ZERO) != 0) {
                DynamicObject nextItem;
                if ("2".equals(rowType) && (nextItem = (DynamicObject)items.stream().filter(oneItem -> oneItem.getInt("seq") == item.getInt("seq") + 1).findAny().orElse(null)) != null) {
                    unitPrice = amount.add(nextItem.getBigDecimal("amount")).divide(num, 16, RoundingMode.HALF_UP);
                }
                return redNum.multiply(unitPrice).setScale(2, RoundingMode.HALF_UP).subtract(redAmount).abs().compareTo(new BigDecimal("0.01")) <= 0 ? BigDecimalUtil.formatNumOrUnitPrice(unitPrice, 16).stripTrailingZeros().toPlainString() : BigDecimalUtil.formatNumOrUnitPrice(redAmount.divide(redNum, 16, RoundingMode.HALF_UP), 16).stripTrailingZeros().toPlainString();
            }
        }
        catch (Exception e) {
            LOGGER.info("\u8ba1\u7b97\u53ef\u7ea2\u51b2\u5355\u4ef7\u5931\u8d25" + e.getMessage());
            return "";
        }
        return "0";
    }

    @Deprecated
    public static boolean isCutStr(Long orgPk) {
        DynamicObject issueConfig = IssueInvSettingHelper.getIssueInvSetting(orgPk);
        return BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_SPLIT.getValue().equals(issueConfig.getString("fieldtolong"));
    }

    public static boolean isCutRemark(Long orgPk) {
        DynamicObject issueConfig = IssueInvSettingHelper.getIssueInvSetting(orgPk);
        return BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_SPLIT.getValue().equals(issueConfig.getString("remarktolong"));
    }

    public static String cutRemarkChar(String remark, int allELeqiRemarkLength) {
        if (String.valueOf(remark).length() > allELeqiRemarkLength) {
            return remark.substring(0, allELeqiRemarkLength);
        }
        return remark;
    }

    public static void cutTaxControlRemark(DynamicObject invoice) {
        try {
            String remark = invoice.getString("remark");
            if (String.valueOf(remark).length() > 230) {
                remark = GBKUtils.cutGBKString(remark, 230);
                invoice.set("remark", (Object)remark);
            }
        }
        catch (Exception e) {
            LOGGER.error("cutTaxControlRemark" + e.getMessage(), (Throwable)e);
        }
    }

    public static boolean isBothEpExist(DynamicObject redConfirm) {
        DynamicObject[] epInfos;
        if (StringUtils.isBlank((CharSequence)redConfirm.getString("salertaxno")) || StringUtils.isBlank((CharSequence)redConfirm.getString("buyertaxno"))) {
            return false;
        }
        String buyerName = redConfirm.getString("buyername");
        String sellerName = redConfirm.getString("salername");
        if (StringUtils.isBlank((CharSequence)buyerName) || StringUtils.isBlank((CharSequence)sellerName)) {
            return false;
        }
        boolean isBuyerExist = false;
        boolean isSellerExist = false;
        QFilter filter = new QFilter("number", "=", (Object)redConfirm.getString("salertaxno")).or("number", "=", (Object)redConfirm.getString("buyertaxno"));
        for (DynamicObject epInfo : epInfos = BusinessDataServiceHelper.load((String)"bdm_enterprise_baseinfo", (String)"name,number", (QFilter[])filter.toArray())) {
            if (buyerName.equals(epInfo.getString("name"))) {
                isBuyerExist = true;
            }
            if (!sellerName.equals(epInfo.getString("name"))) continue;
            isSellerExist = true;
        }
        return isBuyerExist && isSellerExist;
    }

    public static boolean isPriceTip(DynamicObject issueSetting) {
        if (issueSetting == null) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)issueSetting.getString("pricetolong"))) {
            return true;
        }
        return BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_HINT.getValue().equals(issueSetting.getString("pricetolong"));
    }

    public static String calculateRedPrice(DynamicObject item, DynamicObject invoice) {
        DynamicObjectCollection items = invoice.getDynamicObjectCollection("items");
        BigDecimal amount = item.getBigDecimal("amount");
        if (amount.compareTo(BigDecimal.ZERO) <= 0) {
            return "";
        }
        String rowType = item.getString("rowtype");
        if ("1".equals(rowType)) {
            return "";
        }
        BigDecimal redPrice = item.getBigDecimal("redprice");
        if (redPrice.compareTo(BigDecimal.ZERO) > 0) {
            return redPrice.stripTrailingZeros().toPlainString();
        }
        BigDecimal num = item.getBigDecimal("num");
        BigDecimal redAmount = item.getBigDecimal("itemremainredamount");
        BigDecimal redNum = item.getBigDecimal("itemremainrednum");
        BigDecimal unitPrice = item.getBigDecimal("unitprice");
        try {
            if ("0".equals(rowType) && redAmount.compareTo(amount) == 0) {
                return BigDecimalUtil.formatNumOrUnitPrice(unitPrice, 16).stripTrailingZeros().toPlainString();
            }
            if (redAmount.compareTo(BigDecimal.ZERO) != 0 && redNum.compareTo(BigDecimal.ZERO) != 0 && num.compareTo(BigDecimal.ZERO) != 0 && unitPrice.compareTo(BigDecimal.ZERO) != 0) {
                DynamicObject nextItem;
                if ("2".equals(rowType) && (nextItem = (DynamicObject)items.stream().filter(oneItem -> oneItem.getInt("seq") == item.getInt("seq") + 1).findAny().orElse(null)) != null) {
                    unitPrice = amount.add(nextItem.getBigDecimal("amount")).divide(num, 16, RoundingMode.HALF_UP);
                }
                if (InvoiceUtils.checkItemSalesDiscounts(item, invoice)) {
                    unitPrice = BigDecimalUtil.formatNumOrUnitPrice(redAmount.divide(redNum, 16, RoundingMode.HALF_UP), 16);
                }
                item.set("redprice", (Object)unitPrice);
                SaveServiceHelper.update((DynamicObject)item);
                return BigDecimalUtil.formatNumOrUnitPrice(unitPrice, 16).stripTrailingZeros().toPlainString();
            }
        }
        catch (Exception e) {
            LOGGER.info("\u8ba1\u7b97\u53ef\u7ea2\u51b2\u5355\u4ef7\u5931\u8d25" + e.getMessage());
            return "";
        }
        return "0";
    }

    public static DynamicObject getNation(String cardType, String buyerTaxNo) {
        String nationCode = null;
        if ("201".equals(cardType)) {
            nationCode = "156";
        }
        if ("210".equals(cardType)) {
            if (buyerTaxNo.startsWith("H")) {
                nationCode = "344";
            }
            if (buyerTaxNo.startsWith("M")) {
                nationCode = "446";
            }
        }
        if ("213".equals(cardType)) {
            nationCode = "158";
        }
        if ("227".equals(cardType)) {
            nationCode = "156";
        }
        if ("237".equals(cardType)) {
            if (buyerTaxNo.startsWith("810000")) {
                nationCode = "344";
            }
            if (buyerTaxNo.startsWith("820000")) {
                nationCode = "446";
            }
        }
        if ("238".equals(cardType)) {
            nationCode = "158";
        }
        if (StringUtils.isNotBlank((CharSequence)nationCode)) {
            DynamicObject[] nations = InvoiceUtils.queryNations(nationCode);
            return nations[0];
        }
        return null;
    }

    public static DynamicObject[] queryNations(String nationCode) {
        String fields = String.join((CharSequence)",", "fullname", "name", "number");
        DynamicObject[] nations = BusinessDataServiceHelper.load((String)"bdm_nation_code", (String)fields, (QFilter[])new QFilter("number", "=", (Object)nationCode).toArray());
        if (nations.length == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u56fd\u7c4d\uff08\u5730\u533a\uff09\u4ee3\u7801%s\u672a\u67e5\u8be2\u5230\u56fd\u7c4d\uff08\u5730\u533a\uff09\u4fe1\u606f", (String)"InvoiceUtils_48", (String)"imc-bdm-common", (Object[])new Object[0]), nationCode));
        }
        return nations;
    }

    private static boolean checkItemSalesDiscounts(DynamicObject item, DynamicObject invoice) {
        String originalInvoiceCode = invoice.getString("invoicecode");
        String originalInvoiceNo = invoice.getString("invoiceno");
        DynamicObjectCollection items = invoice.getDynamicObjectCollection("items");
        boolean blueItemStartZero = items.stream().anyMatch(oriItem -> 0 == oriItem.getInt("seq"));
        int itemSeq = item.getInt("seq");
        if (blueItemStartZero) {
            ++itemSeq;
        }
        QFilter redInvoiceQFilter = new QFilter("originalinvoicecode", "=", ObjectUtils.defaultIfNull((Object)originalInvoiceCode, (Object)"")).and("originalinvoiceno", "=", (Object)originalInvoiceNo).and("redreason", "=", (Object)"04").and("items.originseq", "=", (Object)itemSeq);
        DynamicObject[] redInvoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)"id", (QFilter[])redInvoiceQFilter.toArray());
        QFilter redConfirmQFilter = new QFilter("originalinvoicecode", "=", ObjectUtils.defaultIfNull((Object)originalInvoiceCode, (Object)"")).and("originalinvoiceno", "=", (Object)originalInvoiceNo).and("issuestatus", "=", (Object)"0").and("redreason", "=", (Object)"04").and("items.originseq", "=", (Object)itemSeq);
        DynamicObject[] redConfirms = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)"id", (QFilter[])redConfirmQFilter.toArray());
        if (redInvoices != null && redInvoices.length > 0) {
            return true;
        }
        return redConfirms != null && redConfirms.length > 0;
    }

    public static void filterOneInvoiceIllegalItems(DynamicObject invoice) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        list.add(invoice);
        InvoiceUtils.filterNewInvoiceIllegalItems(list);
    }

    public static void filterNewInvoiceIllegalItems(List<DynamicObject> invoices) {
        String configErrorGoodsName = ImcConfigUtil.getValue(CacheKeyEnum.ERROR_GOODSNAME);
        HashSet<String> configErrorSet = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)configErrorGoodsName)) {
            String[] names;
            for (String name : names = configErrorGoodsName.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)name)) continue;
                configErrorSet.add(name);
            }
        }
        for (DynamicObject invoice : invoices) {
            if (StringUtils.isNotBlank((CharSequence)invoice.getString("issuetype")) && IssueType.RED_INVOICE.getTypeCode().equals(invoice.getString("issuetype")) || invoice.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0) continue;
            DynamicObjectCollection items = invoice.getDynamicObjectCollection("items");
            Iterator it = items.iterator();
            boolean isRemoved = false;
            while (it.hasNext()) {
                DynamicObject item = (DynamicObject)it.next();
                String goodsName = item.getString("goodsname");
                if (configErrorSet.size() <= 0 || !configErrorSet.contains(goodsName)) continue;
                isRemoved = true;
                it.remove();
            }
            if (!isRemoved) continue;
            for (int i = 0; i < items.size(); ++i) {
                ((DynamicObject)items.get(i)).set("seq", (Object)i);
            }
        }
    }

    public static JSONArray convertField2String(JSONArray array) {
        if (null == array) {
            return array;
        }
        for (int i = 0; i < array.size(); ++i) {
            Object xmsl;
            Object xmjehs;
            Object xmje;
            Object xmdjhs;
            JSONObject jsonObject = array.getJSONObject(i);
            Object xmdj = jsonObject.get((Object)"xmdj");
            if (xmdj instanceof BigDecimal) {
                jsonObject.put("xmdj", (Object)jsonObject.getBigDecimal("xmdj").stripTrailingZeros().toPlainString());
            }
            if ((xmdjhs = jsonObject.get((Object)"xmdjhs")) instanceof BigDecimal) {
                jsonObject.put("xmdjhs", (Object)jsonObject.getBigDecimal("xmdjhs").stripTrailingZeros().toPlainString());
            }
            if ((xmje = jsonObject.get((Object)"xmje")) instanceof BigDecimal) {
                jsonObject.put("xmje", (Object)jsonObject.getBigDecimal("xmje").stripTrailingZeros().toPlainString());
            }
            if ((xmjehs = jsonObject.get((Object)"xmjehs")) instanceof BigDecimal) {
                jsonObject.put("xmjehs", (Object)jsonObject.getBigDecimal("xmjehs").stripTrailingZeros().toPlainString());
            }
            if (!((xmsl = jsonObject.get((Object)"xmsl")) instanceof BigDecimal)) continue;
            jsonObject.put("xmsl", (Object)jsonObject.getBigDecimal("xmsl").stripTrailingZeros().toPlainString());
        }
        return array;
    }

    public static HashSet<Long> queryUseOrgIds(String table, Object dataPk) {
        String fullSql = String.format(sql, table, dataPk);
        HashSet<Long> orgs = new HashSet<Long>();
        try (DataSet ds = DB.queryDataSet((String)"getSyncInvoiceStSuccessNum", (DBRoute)new DBRoute("taxc"), (String)fullSql);){
            if (null != ds) {
                while (ds.hasNext()) {
                    Row next = ds.next();
                    if (null == next) continue;
                    orgs.add(next.getLong("fuseorgid"));
                }
            }
        }
        return orgs;
    }

    public static Set<Long> getAllAuthedOrgs() {
        DynamicObject[] epInfos = BusinessDataServiceHelper.load((String)"bdm_enterprise_baseinfo", (String)"id", null);
        Set epPks = Arrays.stream(epInfos).map(o -> o.getLong("id")).collect(Collectors.toSet());
        QFilter filter = new QFilter("authstate", "=", (Object)"1").and("epinfo", "in", epPks).and("servergroup", "=", (Object)"0");
        DynamicObject[] permissions = BusinessDataServiceHelper.load((String)"bdm_invoice_permission", (String)"epinfo", (QFilter[])filter.toArray());
        epPks = Arrays.stream(permissions).map(o -> DynamicObjectUtil.getDynamicObjectLongValue(o.getDynamicObject("epinfo"))).collect(Collectors.toSet());
        DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bdm_org", (String)"id", (QFilter[])new QFilter("epinfo", "in", epPks).toArray());
        return Arrays.stream(orgs).map(o -> o.getLong("id")).collect(Collectors.toSet());
    }

    public static boolean isAllEVehicleOrAllEUsedCar(String invoiceType) {
        return InvoiceType.ALL_E_PAPER_USED_CAR_ELE.getTypeCode().equals(invoiceType) || InvoiceType.ALL_E_VEHICLE_NORMAL_ELE.getTypeCode().equals(invoiceType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean reCreateVolumeInvoicePdf(DynamicObject invoiceDynamicObject) {
        if (!"3".equals(invoiceDynamicObject.getString("issuesource"))) return false;
        if (!InvoiceUtils.isVolumeInvCreatePdf(invoiceDynamicObject)) return false;
        boolean bl = true;
        boolean isVolumeCreatePdf = bl;
        if (!isVolumeCreatePdf) {
            return false;
        }
        try {
            invoiceDynamicObject.set("ofdstatus", (Object)"0");
            LOGGER.info("juanpiaocanceljuanpiaocancel,mark Ismc OfdStatus Fail, send consumer message");
            MsgResponse response = RequestUtils.doRequest(invoiceDynamicObject.getString("orderno"), "RepairInvoice", Collections.singletonList(invoiceDynamicObject));
            LOGGER.info("reCreatePdfResponse:" + JSONObject.toJSONString((Object)response));
            if (!ErrorType.SUCCESS.getCode().equals(response.getErrorCode())) return false;
            invoiceDynamicObject.set("ofdstatus", (Object)"2");
            boolean bl2 = true;
            return bl2;
        }
        catch (Exception e) {
            LOGGER.error("juanpiaocancelError:" + e.getMessage(), (Throwable)e);
            return false;
        }
        finally {
            try (TXHandle txHandle = TX.requiresNew();){
                ImcSaveServiceHelper.save(invoiceDynamicObject);
            }
        }
    }

    public static boolean isExecuteInvoiceRule(String invoiceType) {
        boolean isVolumeInv = InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode().equals(invoiceType);
        if (!isVolumeInv) {
            return true;
        }
        return !"paperVolumeInvoice".equals(ImcConfigUtil.getValue("paperVolumeInvoice", "paperVolumeInvoice"));
    }

    public static boolean isVehicleOrUsedCarInvoice(String oldInvoiceType) {
        return InvoiceUtils.isUsedCarInvoice(oldInvoiceType) || InvoiceUtils.isVehicleInvoice(oldInvoiceType);
    }
}

