/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.util;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.table.GoodsInfoConstant;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.sdk.annotation.SdkDeprecated;
import org.apache.commons.collections.CollectionUtils;

public class MaterialInfoUtil {
    private static final Log LOGGER = LogFactory.getLog(MaterialInfoUtil.class);
    private static ThreadLocal<MaterialInfoUtil> materialInfoUtilThreadLocal = new ThreadLocal();
    private Map<String, Set<String>> materialNameMap;
    private Map<String, Set<String>> materialCodeMap;
    private Map<String, Set<DynamicObject>> materialMap;
    private Map<String, Set<String>> materialTypeNameMap;
    private Map<String, Set<String>> materialTypeCodeMap;
    private Map<String, Set<DynamicObject>> materialTypeMap;
    private Map<String, Set<DynamicObject>> expenseItemlMap;

    public static Set<DynamicObject> getGoodsByMater(String code, String name) {
        MaterialInfoUtil miUtil = materialInfoUtilThreadLocal.get();
        if (miUtil == null) {
            return Sets.newHashSet();
        }
        if (StringUtils.isNotBlank((CharSequence)code) && StringUtils.isNotBlank((CharSequence)name)) {
            HashSet set = miUtil.materialMap.get(code + "&" + name);
            return set != null ? set : Sets.newHashSet();
        }
        Set<String> keySet = null;
        if (StringUtils.isNotBlank((CharSequence)code)) {
            keySet = miUtil.materialCodeMap.get(code);
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            keySet = miUtil.materialNameMap.get(name);
        }
        if (keySet == null) {
            return Sets.newHashSet();
        }
        HashSet goodsSet = Sets.newHashSet();
        for (String key : keySet) {
            goodsSet.addAll((Collection)miUtil.materialMap.get(key));
        }
        return goodsSet;
    }

    public static Set<DynamicObject> getGoodsByMaterType(String code, String name) {
        LOGGER.info(String.format("MaterialInfoUtil getGoodsByMaterType code:%s,name:%s", code, name));
        MaterialInfoUtil miUtil = materialInfoUtilThreadLocal.get();
        if (miUtil == null) {
            return Sets.newHashSet();
        }
        LOGGER.info(String.format("keySet is null code:%s,name:%s", code, name));
        if (StringUtils.isNotBlank((CharSequence)code) && StringUtils.isNotBlank((CharSequence)name)) {
            HashSet set = miUtil.materialTypeMap.get(code + "&" + name);
            return set != null ? set : Sets.newHashSet();
        }
        Set<String> keySet = null;
        if (StringUtils.isNotBlank((CharSequence)code)) {
            keySet = miUtil.materialTypeCodeMap.get(code);
            LOGGER.info(String.format("materialTypeCodeMap:%s", SerializationUtils.toJsonString(miUtil.materialTypeCodeMap)));
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            LOGGER.info(String.format("materialTypeNameMap:%s", SerializationUtils.toJsonString(miUtil.materialTypeNameMap)));
            keySet = miUtil.materialTypeNameMap.get(name);
        }
        if (keySet == null) {
            LOGGER.info(String.format("keySet is null code:%s,name:%s, materialTypeNameMap:%s", code, name, miUtil.materialTypeNameMap));
            return Sets.newHashSet();
        }
        HashSet goodsSet = Sets.newHashSet();
        for (String key : keySet) {
            LOGGER.info(String.format("materialTypeMap:%s", miUtil.materialTypeMap));
            goodsSet.addAll((Collection)miUtil.materialTypeMap.get(key));
        }
        return goodsSet;
    }

    private MaterialInfoUtil(int initializeSize) {
        this.materialNameMap = Maps.newLinkedHashMapWithExpectedSize((int)initializeSize);
        this.materialCodeMap = Maps.newLinkedHashMapWithExpectedSize((int)initializeSize);
        this.materialMap = Maps.newLinkedHashMapWithExpectedSize((int)initializeSize);
        this.materialTypeNameMap = Maps.newLinkedHashMapWithExpectedSize((int)10);
        this.materialTypeMap = Maps.newLinkedHashMapWithExpectedSize((int)10);
        this.materialTypeCodeMap = Maps.newLinkedHashMapWithExpectedSize((int)10);
        this.expenseItemlMap = Maps.newLinkedHashMapWithExpectedSize((int)initializeSize);
    }

    @SdkDeprecated
    public static void clear() {
        materialInfoUtilThreadLocal.remove();
    }

    @SdkDeprecated
    public static void getInstance(long orgId, Set<String> nameSet, Set<String> codeSet, Set<String> typeSet, boolean isBotp) {
        DynamicObject[] goodList;
        QFilter qFilter;
        if (nameSet.isEmpty() && codeSet.isEmpty() && typeSet.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u540d\u79f0\u548c\u7f16\u7801\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (String)"MaterialInfoUtil_0", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        LOGGER.info(String.format("MaterialInfoUtil getInstance orgId:%s nameSet\uff1a%s codeSet:%s", orgId, nameSet, codeSet));
        MaterialInfoUtil miUtil = new MaterialInfoUtil(codeSet.size() + nameSet.size());
        QFilter orgFilter = ImcBaseDataHelper.getGoodsInfoFilter(orgId);
        HashSet materialTypeSet = Sets.newHashSet();
        if (!CollectionUtils.isEmpty(typeSet)) {
            materialTypeSet.addAll(typeSet);
        }
        if (!CollectionUtils.isEmpty(nameSet)) {
            materialTypeSet.addAll(nameSet);
        }
        HashSet<Object> goodsIdSet = new HashSet<Object>((nameSet.size() + 1) * (codeSet.size() + 1));
        String itemKey = "bdm_goods_info_item.";
        if (!CollectionUtils.isEmpty(nameSet)) {
            qFilter = OrgHelper.getIdFilter(nameSet, itemKey + "material_name").and(orgFilter);
            MaterialInfoUtil.addGoodsId(qFilter, goodsIdSet);
            qFilter = OrgHelper.getIdFilter(nameSet, itemKey + "expenseitem".concat(".name")).and(orgFilter);
            MaterialInfoUtil.addGoodsId(qFilter, goodsIdSet);
        }
        if (!CollectionUtils.isEmpty(codeSet)) {
            qFilter = OrgHelper.getIdFilter(codeSet, itemKey + "modelnum_code").and(orgFilter);
            MaterialInfoUtil.addGoodsId(qFilter, goodsIdSet);
            qFilter = OrgHelper.getIdFilter(codeSet, itemKey + "material_no".concat(".number")).and(orgFilter);
            MaterialInfoUtil.addGoodsId(qFilter, goodsIdSet);
            qFilter = OrgHelper.getIdFilter(codeSet, itemKey + "expenseitem".concat(".number")).and(orgFilter);
            MaterialInfoUtil.addGoodsId(qFilter, goodsIdSet);
        }
        for (DynamicObject good : goodList = BusinessDataServiceHelper.load((Object[])goodsIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bdm_goods_info"))) {
            DynamicObjectCollection goodsItemList = good.getDynamicObjectCollection("bdm_goods_info_item");
            for (DynamicObject goodsItem : goodsItemList) {
                String code = goodsItem.getString("material_no".concat(".number"));
                if (StringUtils.isBlank((CharSequence)code)) {
                    code = goodsItem.getString("modelnum_code");
                }
                String name = goodsItem.getString("material_name");
                String key = code + "&" + name;
                Set<Object> materialSet = !miUtil.materialMap.containsKey(key) ? Sets.newHashSet() : miUtil.materialMap.get(key);
                materialSet.add(good);
                miUtil.materialMap.put(key, materialSet);
                Set<Object> materialCodeSet = !miUtil.materialCodeMap.containsKey(code) ? Sets.newHashSet() : miUtil.materialCodeMap.get(code);
                materialCodeSet.add(key);
                miUtil.materialCodeMap.put(code, materialCodeSet);
                Set<Object> materialNameSet = !miUtil.materialNameMap.containsKey(name) ? Sets.newHashSet() : miUtil.materialNameMap.get(name);
                materialNameSet.add(key);
                miUtil.materialNameMap.put(name, materialNameSet);
                MaterialInfoUtil.initExpenseItemMap(good, goodsItem, miUtil);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)materialTypeSet)) {
            MaterialInfoUtil.initMaterialTypeNameSet(miUtil, orgFilter, materialTypeSet, isBotp);
        }
        materialInfoUtilThreadLocal.set(miUtil);
    }

    private static void addGoodsId(QFilter qFilter, Set<Object> goodsIdSet) {
        DynamicObjectCollection query;
        if (CollectionUtils.isNotEmpty(goodsIdSet)) {
            qFilter.and("id", "not in", goodsIdSet);
        }
        if (CollectionUtils.isNotEmpty((Collection)(query = QueryServiceHelper.query((String)"bdm_goods_info", (String)"id", (QFilter[])qFilter.toArray(), (String)"ctrlstrategy desc ,priority")))) {
            goodsIdSet.addAll(query.stream().map(good -> good.get("id")).collect(Collectors.toSet()));
        }
    }

    private static void initExpenseItemMap(DynamicObject good, DynamicObject goodsItem, MaterialInfoUtil miUtil) {
        if ("5".equals(goodsItem.getString("sourcetype"))) {
            String code = goodsItem.getString("expenseitem".concat(".number"));
            String name = goodsItem.getString("expenseitem".concat(".name"));
            String key = code + "&" + name;
            Set<Object> expenseItemGoodsInfo = !miUtil.expenseItemlMap.containsKey(key) ? Sets.newHashSet() : miUtil.expenseItemlMap.get(key);
            expenseItemGoodsInfo.add(good);
            miUtil.expenseItemlMap.put(key, expenseItemGoodsInfo);
        }
    }

    public static Set<DynamicObject> getGoodsByExpenseItem(String code, String name) {
        LOGGER.info(String.format("getGoodsByExpenseItem code%s name\uff1a%s", code, name));
        MaterialInfoUtil miUtil = materialInfoUtilThreadLocal.get();
        if (miUtil == null) {
            return Sets.newHashSet();
        }
        if (StringUtils.isBlank((CharSequence)code) || StringUtils.isBlank((CharSequence)name)) {
            LOGGER.info("\u8d39\u7528\u9879\u76ee\u540d\u79f0\u6216\u8005\u7f16\u7801\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u5339\u914d");
            return Sets.newHashSetWithExpectedSize((int)0);
        }
        HashSet set = miUtil.expenseItemlMap.get(code + "&" + name);
        return set != null ? set : Sets.newHashSet();
    }

    private static void initMaterialTypeNameSet(MaterialInfoUtil miUtil, QFilter orgFilter, Set<String> materialTypeSet, boolean isBotp) {
        QFilter qFilter = OrgHelper.getIdFilter(materialTypeSet, "bdm_goods_info_item.materialtype.number").or(OrgHelper.getIdFilter(materialTypeSet, "bdm_goods_info_item.materialtype.name"));
        DynamicObject[] goodsByTypes = BusinessDataServiceHelper.load((String)"bdm_goods_info", (String)GoodsInfoConstant.SELECT_PROPERTIES, (QFilter[])qFilter.and(orgFilter).toArray(), (String)"priority".concat(" asc"));
        LOGGER.info(String.format("MaterialInfoUtil getInstance goodsByTypes.length=%s", goodsByTypes.length));
        for (DynamicObject goodByType : goodsByTypes) {
            DynamicObjectCollection infoItems = goodByType.getDynamicObjectCollection("bdm_goods_info_item");
            for (DynamicObject infoItem : infoItems) {
                if (!infoItem.getString("sourcetype").equals("1")) continue;
                String code = infoItem.getString("materialtype.number");
                String name = infoItem.getString("materialtype.name");
                String key = code + "&" + name;
                Set<Object> goodSet = !miUtil.materialTypeMap.containsKey(key) ? Sets.newHashSet() : miUtil.materialTypeMap.get(key);
                goodSet.add(goodByType);
                miUtil.materialTypeMap.put(key, goodSet);
                Set<Object> materialTypeCodeSet = !miUtil.materialTypeCodeMap.containsKey(code) ? Sets.newHashSet() : miUtil.materialTypeCodeMap.get(code);
                materialTypeCodeSet.add(key);
                miUtil.materialTypeCodeMap.put(code, materialTypeCodeSet);
                if (isBotp) continue;
                Set<Object> materialTypeNameSet = !miUtil.materialTypeNameMap.containsKey(name) ? Sets.newHashSet() : miUtil.materialTypeNameMap.get(name);
                materialTypeNameSet.add(key);
                miUtil.materialTypeNameMap.put(name, materialTypeNameSet);
            }
        }
    }

    public Map<String, Set<String>> getMaterialNameMap() {
        return this.materialNameMap;
    }

    public Map<String, Set<String>> getMaterialCodeMap() {
        return this.materialCodeMap;
    }

    public Map<String, Set<DynamicObject>> getMaterialMap() {
        return this.materialMap;
    }

    public static MaterialInfoUtil getMaterialInfoUtil() {
        return materialInfoUtilThreadLocal.get();
    }

    public static DynamicObject[] querySourceUnitByMater(Object pkValue, List<QFilter> qFilters) {
        QFilter qFilter = new QFilter("materialid", "=", pkValue);
        if (!CollectionUtils.isEmpty(qFilters)) {
            for (QFilter filter : qFilters) {
                qFilter.and(filter);
            }
        }
        return BusinessDataServiceHelper.load((String)"bd_multimeasureunit", (String)"id,materialid,measureunitid,denominator,numerator", (QFilter[])qFilter.toArray(), (String)"integerfield");
    }

    public static String getModelNumRate(DynamicObject unit) {
        return unit.getBigDecimal("numerator").divide(unit.getBigDecimal("denominator"), 8, 4).stripTrailingZeros().toPlainString();
    }
}

