/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.util.retry;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public abstract class RetryTemplate {
    private static Log LOGGER = LogFactory.getLog(RetryTemplate.class);
    private static final int DEFAULT_RETRY_TIME = 1;
    private int retryTime = 1;
    private int sleepTime = 0;

    public RetryTemplate setSleepTime(int sleepTime) {
        if (sleepTime < 0) {
            throw new IllegalArgumentException("sleepTime should equal or bigger than 0");
        }
        this.sleepTime = sleepTime;
        return this;
    }

    public RetryTemplate setRetryTime(int retryTime) {
        if (retryTime <= 0) {
            throw new IllegalArgumentException("retryTime should bigger than 0");
        }
        this.retryTime = retryTime;
        return this;
    }

    protected abstract Object doBiz() throws Exception;

    public Object execute() throws InterruptedException {
        for (int i = 0; i < this.retryTime; ++i) {
            try {
                return this.doBiz();
            }
            catch (Exception e) {
                LOGGER.info("RetryTemplateError:" + e.getMessage());
                Thread.sleep(this.sleepTime);
                continue;
            }
        }
        return null;
    }
}

