/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.file.fpy.model.ofd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.imc.bdm.file.fpy.model.ofd.OFDFile;
import kd.imc.bdm.file.fpy.model.ofd.OFDId;
import kd.imc.bdm.file.fpy.model.ofd.OFDObject;
import kd.imc.bdm.file.fpy.model.ofd.OFDPage;
import kd.imc.bdm.file.fpy.model.ofd.OFDResource;
import kd.imc.bdm.file.fpy.model.ofd.OFDSize;
import kd.imc.bdm.file.fpy.model.ofd.OFDTemplate;
import kd.imc.bdm.file.fpy.service.ofd.util.XmlHelperUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class OFDDocument
extends OFDObject {
    private final OFDFile ofdFile;
    private Document documentXmlDoc = null;
    private Element pagesNode = null;
    private Document publicResXmlDoc = null;
    private Document documentResXmlDoc = null;
    private final OFDId ofdId;
    private final List<OFDPage> pages = new ArrayList<OFDPage>();
    private final Map<String, OFDTemplate> templates = new HashMap<String, OFDTemplate>();
    private Map<String, OFDResource> resources = null;

    public OFDDocument(OFDFile ofdFile) {
        this.ofdFile = ofdFile;
        this.ofdId = new OFDId();
        this.buildDocumentInfo();
    }

    public OFDFile getOfdFile() {
        return this.ofdFile;
    }

    public String getNewID() {
        return "" + this.ofdId.getNewID();
    }

    @Override
    public String getPath() {
        String strOfdPath = this.ofdFile.getPath();
        return strOfdPath + "Doc_0" + "/";
    }

    private void buildDocumentInfo() {
        this.documentXmlDoc = XmlHelperUtils.createDocument("ofd:Document");
        Element root = this.documentXmlDoc.getRootElement();
        Element eleCommonData = root.addElement("ofd:CommonData");
        XmlHelperUtils.addNode(eleCommonData, "ofd:MaxUnitID", "0");
        this.buildPublicRes();
        this.buildDocumentRes();
        XmlHelperUtils.addNode(eleCommonData, "ofd:PublicRes", "PublicRes.xml");
        XmlHelperUtils.addNode(eleCommonData, "ofd:DocumentRes", "DocumentRes.xml");
        this.pagesNode = XmlHelperUtils.addNode(root, "ofd:Pages", null);
    }

    private void buildPublicRes() {
        this.publicResXmlDoc = XmlHelperUtils.createDocument("ofd:Res");
        Element root = this.publicResXmlDoc.getRootElement();
        root.addAttribute("BaseLoc", "Res");
        Element fonts = root.addElement("ofd:Fonts");
        this.addFontElement(fonts, "8", "\u6977\u4f53");
        this.addFontElement(fonts, "9", "\u5b8b\u4f53");
        this.addFontElement(fonts, "10", "Courier New");
        this.addFontElement(fonts, "11", "\u9ed1\u4f53");
    }

    private void addFontElement(Element fonts, String fontID, String fontName) {
        Element font1 = fonts.addElement("ofd:Font");
        font1.addAttribute("ID", fontID);
        font1.addAttribute("FontName", fontName);
        font1.addAttribute("FamilyName", fontName);
    }

    private void buildDocumentRes() {
        this.documentResXmlDoc = XmlHelperUtils.createDocument("ofd:Res");
        Element root = this.documentResXmlDoc.getRootElement();
        root.addAttribute("BaseLoc", "Res");
        root.addElement("ofd:MultiMedias");
    }

    @Override
    public void flush() throws IOException {
        Object resBytes;
        Element eleCommonData = this.documentXmlDoc.getRootElement().element("CommonData");
        Element eleMaxUnitID = eleCommonData.element("MaxUnitID");
        eleMaxUnitID.setText("" + this.ofdId.getCurrentID());
        Element rootElement = this.documentXmlDoc.getRootElement();
        List elements = rootElement.elements();
        Element element = DocumentHelper.createElement((String)"ofd:CustomTags");
        element.setText("Tags/CustomTags.xml");
        elements.add(element);
        String strDocPath = this.getPath();
        byte[] bytes = XmlHelperUtils.toByteArray(this.documentXmlDoc);
        this.ofdFile.p_AddFile(strDocPath + "Document.xml", bytes);
        for (Map.Entry<String, OFDTemplate> entry : this.templates.entrySet()) {
            entry.getValue().flush();
        }
        if (this.resources != null) {
            resBytes = XmlHelperUtils.toByteArray(this.documentResXmlDoc);
            this.ofdFile.p_AddFile(strDocPath + "DocumentRes.xml", (byte[])resBytes);
            String strResPath = this.getPath() + "Res" + "/";
            for (Map.Entry<String, OFDResource> entry : this.resources.entrySet()) {
                OFDResource it = entry.getValue();
                this.ofdFile.p_AddFile(strResPath + it.getResourceType() + it.getResourceID() + "." + it.getFormat(), it.getResourceData());
            }
        }
        resBytes = this.pages.iterator();
        while (resBytes.hasNext()) {
            OFDPage page = (OFDPage)resBytes.next();
            page.flush();
        }
        byte[] publicResBytes = XmlHelperUtils.toByteArray(this.publicResXmlDoc);
        this.ofdFile.p_AddFile(strDocPath + "PublicRes.xml", publicResBytes);
    }

    public OFDTemplate addTemplate(List<Element> eleList, int idx, OFDSize ofdSize) {
        String strID = this.getNewID();
        OFDTemplate tpl = new OFDTemplate(this, strID, idx, eleList, ofdSize);
        Element eleCommonData = this.documentXmlDoc.getRootElement().element("CommonData");
        Element eleTemplate = eleCommonData.addElement("ofd:TemplatePage");
        eleTemplate.addAttribute("BaseLoc", "Tpls/Tpl_" + idx + "/Content.xml");
        eleTemplate.addAttribute("ID", tpl.getID());
        this.templates.put(tpl.getID(), tpl);
        return tpl;
    }

    public OFDPage addPage(OFDTemplate tpl) {
        int nPageIndex = this.pages.size();
        OFDPage page = new OFDPage(this, nPageIndex, tpl);
        Element pageNode = this.pagesNode.addElement("ofd:Page");
        pageNode.addAttribute("BaseLoc", "Pages/Page_" + nPageIndex + "/Content.xml");
        pageNode.addAttribute("ID", page.getID());
        this.pages.add(page);
        return page;
    }

    public void addResource(String resourceName, String resourceID, String resourceType, String format, byte[] resourceData) {
        if (StringUtils.isEmpty((CharSequence)resourceName)) {
            resourceName = resourceID;
        }
        Element resNode = this.documentResXmlDoc.getRootElement().element("MultiMedias").addElement("ofd:MultiMedia");
        resNode.addAttribute("Type", resourceType);
        resNode.addAttribute("ID", resourceID);
        resNode.addAttribute("Format", format);
        XmlHelperUtils.addNode(resNode, "ofd:MediaFile", resourceType + resourceID + "." + format);
        if (this.resources == null) {
            this.resources = new HashMap<String, OFDResource>();
        }
        OFDResource it = new OFDResource(resourceID, resourceType, format, resourceData);
        this.resources.put(resourceName, it);
    }

    public OFDResource getResource(String resourceName) {
        if (this.resources == null) {
            return null;
        }
        return this.resources.get(resourceName);
    }

    public void addCustomTag(Document tagDocument) {
        try {
            byte[] tagBytes = XmlHelperUtils.toByteArray(tagDocument);
            String pathDir = this.getPath() + "Tags" + "/";
            Document customTags = XmlHelperUtils.createDocument("CustomTags");
            Element customRootElement = customTags.getRootElement();
            Element customElement = customRootElement.addElement("CustomTag");
            XmlHelperUtils.addNode(customElement, "FileLoc", "CustomTag.xml");
            this.getOfdFile().p_AddFile(pathDir + "CustomTags.xml", XmlHelperUtils.toByteArray(customTags));
            this.getOfdFile().p_AddFile(pathDir + "CustomTag.xml", tagBytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

