/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.file.fpy.model.ofd;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.resource.ResManager;
import kd.imc.bdm.common.util.MD5;
import kd.imc.bdm.file.fpy.enums.InvoiceTypeEnum;
import kd.imc.bdm.file.fpy.model.ofd.OFDDocument;
import kd.imc.bdm.file.fpy.model.ofd.OFDObject;
import kd.imc.bdm.file.fpy.model.pdf.fedi.FullDigitalEInvoice;
import kd.imc.bdm.file.fpy.service.ofd.util.CompressHelperUtils;
import kd.imc.bdm.file.fpy.service.ofd.util.XmlHelperUtils;
import kd.imc.bdm.file.fpy.util.EInvoicePdfUtils;
import kd.imc.bdm.file.fpy.util.MoneyUtil;
import kd.imc.bdm.file.util.DateUtils;
import org.dom4j.Document;
import org.dom4j.Element;

public class OFDFile
extends OFDObject {
    private final String docID = MD5.md5Hex((String)UUID.randomUUID().toString());
    Map<String, byte[]> files = new HashMap<String, byte[]>();
    private Document ofdXmlDoc = null;
    private Element bodyNode = null;
    private OFDDocument doc = null;

    public OFDFile(FullDigitalEInvoice fullDigitalEInvoice) {
        this.buildOfdInfo(fullDigitalEInvoice);
    }

    public OFDFile(JSONObject dataJson) {
        this.buildOfdInfo(dataJson);
    }

    public Element getBody() {
        return this.bodyNode;
    }

    public OFDDocument getDocument() {
        return this.doc;
    }

    public OFDDocument createDocument() {
        if (this.doc == null) {
            this.doc = new OFDDocument(this);
        }
        return this.doc;
    }

    public byte[] getData() {
        return CompressHelperUtils.compress(this.files, null, "OFD");
    }

    @Override
    public String getPath() {
        return "";
    }

    public void p_AddFile(String name, byte[] byts) {
        this.files.put(name, byts);
    }

    @Override
    public void flush() throws IOException {
        String strOfdPath = "OFD.xml";
        byte[] bts = XmlHelperUtils.toByteArray(this.ofdXmlDoc);
        this.p_AddFile(strOfdPath, bts);
        this.getDocument().flush();
    }

    private void buildOfdInfo(FullDigitalEInvoice fullDigitalEInvoice) {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        String dateString = formatter.format(currentTime);
        this.ofdXmlDoc = XmlHelperUtils.createDocument("ofd:OFD");
        Element root = this.ofdXmlDoc.getRootElement();
        root.addAttribute("DocType", "OFD");
        root.addAttribute("Version", "1.0");
        this.bodyNode = root.addElement("ofd:DocBody");
        Element eleDocInfo = this.bodyNode.addElement("ofd:DocInfo");
        XmlHelperUtils.addNode(eleDocInfo, "ofd:DocID", this.docID);
        XmlHelperUtils.addNode(eleDocInfo, "ofd:CreationDate", dateString);
        XmlHelperUtils.addNode(eleDocInfo, "ofd:Creator", "Kingdee");
        Element customDatas = eleDocInfo.addElement("ofd:CustomDatas");
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", "\u53d1\u7968\u53f7\u7801", fullDigitalEInvoice.getInvoiceNo());
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", "\u9500\u552e\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", fullDigitalEInvoice.getSalerTaxNo());
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", "\u5408\u8ba1\u91d1\u989d", fullDigitalEInvoice.getInvoiceAmount().toPlainString());
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", "\u8d2d\u4e70\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", fullDigitalEInvoice.getBuyerTaxNo());
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", "\u5408\u8ba1\u7a0e\u989d", fullDigitalEInvoice.getTotalTaxAmount().toPlainString());
        String invoiceDate = DateUtils.format(fullDigitalEInvoice.getIssueTime(), "yyyy\u5e74MM\u6708dd\u65e5");
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", "\u5f00\u7968\u65e5\u671f", invoiceDate);
        XmlHelperUtils.addNode(this.bodyNode, "ofd:DocRoot", "Doc_0/Document.xml");
    }

    private void buildOfdInfo(JSONObject dataJson) {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        String dateString = formatter.format(currentTime);
        this.ofdXmlDoc = XmlHelperUtils.createDocument("ofd:OFD");
        Element root = this.ofdXmlDoc.getRootElement();
        root.addAttribute("DocType", "OFD");
        root.addAttribute("Version", "1.0");
        this.bodyNode = root.addElement("ofd:DocBody");
        Element eleDocInfo = this.bodyNode.addElement("ofd:DocInfo");
        XmlHelperUtils.addNode(eleDocInfo, "ofd:DocID", this.docID);
        XmlHelperUtils.addNode(eleDocInfo, "ofd:CreationDate", dateString);
        XmlHelperUtils.addNode(eleDocInfo, "ofd:Creator", "Kingdee");
        Element customDatas = eleDocInfo.addElement("ofd:CustomDatas");
        String invoiceType = dataJson.getString("invoiceType");
        if (InvoiceTypeEnum.USED_CAR_INVOICE.getValue().equals(invoiceType)) {
            this.setUserCarInfo(customDatas, dataJson);
        } else if (InvoiceTypeEnum.CAR_VEHICLE_INVOICE.getValue().equals(invoiceType)) {
            this.setVehicleCar(customDatas, dataJson);
        }
        XmlHelperUtils.addNode(this.bodyNode, "ofd:DocRoot", "Doc_0/Document.xml");
    }

    private void setUserCarInfo(Element customDatas, JSONObject dataJson) {
        String totalAmount = EInvoicePdfUtils.getPriceWithScale(dataJson.getBigDecimal("totalAmount"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u8f66\u4ef7\u5408\u8ba1\uff08\u5927\u5199\uff09", (String)"OFDFile_0", (String)"imc-bdm-file", (Object[])new Object[0]), MoneyUtil.moneyCapital(totalAmount));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u8f66\u4ef7\u5408\u8ba1\uff08\u5c0f\u5199\uff09", (String)"OFDFile_1", (String)"imc-bdm-file", (Object[])new Object[0]), totalAmount);
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u8f66\u8f86\u8bc6\u522b\u4ee3\u53f7/\u8f66\u67b6\u53f7\u7801", (String)"OFDFile_2", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("vehicleIdentificationNo"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u8f66\u724c\u7167\u53f7", (String)"OFDFile_3", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("licensePlateNumber"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u5382\u724c\u578b\u53f7", (String)"OFDFile_4", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("brandModel"));
        String invoiceDate = DateUtils.format(dataJson.getDate("issueTime"), "yyyy\u5e74MM\u6708dd\u65e5");
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f", (String)"OFDFile_5", (String)"imc-bdm-file", (Object[])new Object[0]), invoiceDate);
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u5f00\u7968\u4eba", (String)"OFDFile_6", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("drawer"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u7ecf\u8425\u3001\u62cd\u5356\u5355\u4f4d", (String)"OFDFile_7", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("auctionName"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u7ecf\u8425\u3001\u62cd\u5356\u5355\u4f4d\u7535\u8bdd", (String)"OFDFile_8", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("auctionPhoneNumber"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u7ecf\u8425\u3001\u62cd\u5356\u5355\u4f4d\u5730\u5740", (String)"OFDFile_9", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("auctionAddress"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u7ecf\u8425\u3001\u62cd\u5356\u5355\u4f4d\u7a0e\u53f7", (String)"OFDFile_10", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("auctionTaxpayerId"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u7ecf\u8425\u3001\u62cd\u5356\u5355\u4f4d\u5f00\u6237\u94f6\u884c\u8d26\u53f7", (String)"OFDFile_11", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("auctionBankAccount"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"OFDFile_12", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("invoiceNo"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u767b\u8bb0\u8bc1\u53f7", (String)"OFDFile_13", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("registrationNumber"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u8f6c\u5165\u5730\u8f66\u8f86\u7ba1\u7406\u6240\u540d\u79f0", (String)"OFDFile_14", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("vehicleManagementName"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u4e70\u65b9\u5355\u4f4d/\u4e2a\u4eba", (String)"OFDFile_15", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("buyerName"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u4e70\u65b9\u5355\u4f4d/\u4e2a\u4eba\u7535\u8bdd", (String)"OFDFile_16", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("buyerTelNum"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u4e70\u65b9\u5355\u4f4d/\u4e2a\u4eba\u5730\u5740", (String)"OFDFile_17", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("buyerAddr"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u4e70\u65b9\u5355\u4f4d\u4ee3\u7801/\u8eab\u4efd\u8bc1\u53f7\u7801", (String)"OFDFile_18", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("buyerTaxNo"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u5356\u65b9\u5355\u4f4d\u4ee3\u7801/\u8eab\u4efd\u8bc1\u53f7\u7801", (String)"OFDFile_19", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("sellerTaxNo"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u5356\u65b9\u5355\u4f4d/\u4e2a\u4eba", (String)"OFDFile_20", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("sellerName"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u5356\u65b9\u5355\u4f4d/\u4e2a\u4eba\u7535\u8bdd", (String)"OFDFile_21", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("sellerPhoneNumber"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u5356\u65b9\u5355\u4f4d/\u4e2a\u4eba\u5730\u5740", (String)"OFDFile_22", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("sellerAddress"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u8f66\u8f86\u7c7b\u578b", (String)"OFDFile_23", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("vehicleType"));
    }

    private void setVehicleCar(Element customDatas, JSONObject dataJson) {
        String totalAmount = EInvoicePdfUtils.getPriceWithScale(dataJson.getBigDecimal("totalAmount"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u53d1\u52a8\u673a\u53f7\u7801", (String)"OFDFile_24", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("engineNum"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u5428\u4f4d", (String)"OFDFile_25", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("totalTon"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1\u5927\u5199", (String)"OFDFile_26", (String)"imc-bdm-file", (Object[])new Object[0]), MoneyUtil.moneyCapital(totalAmount));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1\u5c0f\u5199", (String)"OFDFile_27", (String)"imc-bdm-file", (Object[])new Object[0]), totalAmount);
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u7a0e\u989d", (String)"OFDFile_28", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("totalTaxAmount"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u7a0e\u7387\u6216\u5f81\u6536\u7387", (String)"OFDFile_29", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("taxRate"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u4e0d\u542b\u7a0e\u4ef7\u5c0f\u5199", (String)"OFDFile_30", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("invoiceAmount"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u4e3b\u7ba1\u7a0e\u52a1\u673a\u5173\u53ca\u4ee3\u7801", (String)"OFDFile_31", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("taxAuthorityNameAndCode"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u4ea7\u5730", (String)"OFDFile_32", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("producingArea"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u5382\u724c\u578b\u53f7", (String)"OFDFile_4", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("brandModel"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u5546\u68c0\u5355\u53f7", (String)"OFDFile_33", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("commodityInspectionNum"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u5f00\u7968\u4eba", (String)"OFDFile_6", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("drawer"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f", (String)"OFDFile_5", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("invoiceDate"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"OFDFile_12", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("invoiceNum"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u5408\u683c\u8bc1\u53f7", (String)"OFDFile_34", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("certificateNum"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u8fdb\u53e3\u8bc1\u660e\u4e66\u53f7", (String)"OFDFile_35", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("importCertificateNum"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u9650\u4e58\u4eba\u6570", (String)"OFDFile_36", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("limitePeople"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u540d\u79f0", (String)"OFDFile_37", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("buyerName"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801", (String)"OFDFile_38", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("buyerCreditCode"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u9500\u552e\u5355\u4f4d\u540d\u79f0", (String)"OFDFile_39", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("salerName"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u9500\u552e\u65b9\u5730\u5740", (String)"OFDFile_40", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("salerAddr"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u9500\u552e\u65b9\u7535\u8bdd", (String)"OFDFile_41", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("salerPhone"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u9500\u552e\u65b9\u5f00\u6237\u94f6\u884c", (String)"OFDFile_42", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("salerBank"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u9500\u552e\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", (String)"OFDFile_43", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("salerTaxNum"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u9500\u552e\u65b9\u8d26\u53f7", (String)"OFDFile_44", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("salerBankAccount"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u8f66\u8f86\u7c7b\u578b", (String)"OFDFile_23", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("carType"));
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", ResManager.loadKDString((String)"\u8f66\u8f86\u8bc6\u522b\u4ee3\u53f7/\u8f66\u67b6\u53f7\u7801", (String)"OFDFile_2", (String)"imc-bdm-file", (Object[])new Object[0]), dataJson.getString("carNum"));
    }
}

