/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.file.fpy.model.ofd;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import kd.imc.bdm.file.fpy.model.ofd.OFDBound;
import kd.imc.bdm.file.fpy.model.ofd.OFDDocument;
import kd.imc.bdm.file.fpy.model.ofd.OFDObject;
import kd.imc.bdm.file.fpy.model.ofd.OFDResource;
import kd.imc.bdm.file.fpy.model.ofd.OFDTemplate;
import kd.imc.bdm.file.fpy.service.ofd.util.XmlHelperUtils;
import org.dom4j.Document;
import org.dom4j.Element;

public class OFDPage
extends OFDObject {
    private final String id;
    private final int pageIndex;
    private final Document pageXmlDoc;
    private final Element layerInfo;
    private final OFDDocument doc;

    public OFDPage(OFDDocument doc, int pageIndex, OFDTemplate tpl) {
        this.doc = doc;
        this.pageIndex = pageIndex;
        this.id = doc.getNewID();
        this.pageXmlDoc = XmlHelperUtils.createDocument("ofd:Page");
        Element root = this.pageXmlDoc.getRootElement();
        if (tpl != null) {
            Element eleTpl = root.addElement("ofd:Template");
            eleTpl.addAttribute("TemplateID", tpl.getID());
            eleTpl.addAttribute("ZOrder", "Background");
            Element elePageArea = XmlHelperUtils.addNode(root, "ofd:Area", null);
            XmlHelperUtils.addNode(elePageArea, "ofd:PhysicalBox", tpl.getOfdSize().toString());
        }
        Element eleContent = XmlHelperUtils.addNode(root, "ofd:Content", null);
        Element eleLayer = XmlHelperUtils.addNode(eleContent, "ofd:Layer", null);
        eleLayer.addAttribute("ID", this.doc.getNewID());
        this.layerInfo = eleLayer;
    }

    public String getID() {
        return this.id;
    }

    @Override
    public String getPath() {
        return this.doc.getPath() + "Pages" + "/" + "Page_" + this.pageIndex + "/";
    }

    @Override
    public void flush() throws IOException {
        String strPath = this.getPath();
        byte[] bytes = XmlHelperUtils.toByteArray(this.pageXmlDoc);
        this.doc.getOfdFile().p_AddFile(strPath + "Content.xml", bytes);
    }

    public void addElementArray(JSONArray eleArray) {
        if (eleArray != null && !eleArray.isEmpty()) {
            eleArray.forEach(item -> {
                Element copy = ((Element)item).createCopy();
                this.layerInfo.add(copy);
            });
        }
    }

    public void addElement(Element element) {
        if (element != null) {
            Element copy = element.createCopy();
            copy.addAttribute("ID", this.doc.getNewID());
            this.layerInfo.add(copy);
        }
    }

    public Element addImage(OFDBound bound, String format, byte[] imageData) {
        String resourceID = this.doc.getNewID();
        this.doc.addResource(resourceID, resourceID, "Image", format, imageData);
        return this.showResource(bound, resourceID);
    }

    public Element showResource(OFDBound bound, String resourceName) {
        OFDResource resource = this.doc.getResource(resourceName);
        if (resource == null) {
            return null;
        }
        Element eleImageObject = XmlHelperUtils.addNode(this.layerInfo, "ofd:" + resource.getResourceType() + "Object", null);
        eleImageObject.addAttribute("CTM", bound.getWidth() + " 0 0 " + bound.getHeight() + " 0 0");
        eleImageObject.addAttribute("ResourceID", resource.getResourceID());
        eleImageObject.addAttribute("Boundary", bound.toString());
        return eleImageObject;
    }

    public void setTagElement(Element rootElement, JSONObject idJson) {
        XmlHelperUtils.addRefNode(rootElement, "InvoiceNo", idJson.getString("invoiceNo"), this.id);
        XmlHelperUtils.addRefNode(rootElement, "IssueDate", idJson.getString("issueTime"), this.id);
        Element gmfElement = rootElement.addElement("Buyer");
        XmlHelperUtils.addRefNode(gmfElement, "BuyerName", idJson.getString("buyerName"), this.id);
        XmlHelperUtils.addRefNode(gmfElement, "BuyerTaxID", idJson.getString("buyerTaxNo"), this.id);
        Element xsfElement = rootElement.addElement("Seller");
        XmlHelperUtils.addRefNode(xsfElement, "SellerName", idJson.getString("salerName"), this.id);
        XmlHelperUtils.addRefNode(xsfElement, "SellerTaxID", idJson.getString("salerTaxNo"), this.id);
        XmlHelperUtils.addRefNode(rootElement, "InvoiceClerk", idJson.getString("drawer"), this.id);
        XmlHelperUtils.addRefNode(rootElement, "TaxInclusiveTotalAmount", idJson.getString("totalAmount"), this.id);
        XmlHelperUtils.addRefNode(rootElement, "TaxExclusiveTotalAmount", idJson.getString("invoiceAmount"), this.id);
        XmlHelperUtils.addRefNode(rootElement, "TaxTotalAmount", idJson.getString("totalTaxAmount"), this.id);
        XmlHelperUtils.addRefNode(rootElement, "Note", idJson.getString("remark"), this.id);
        this.addItemNodes(rootElement, idJson.getJSONArray("item"));
        this.addSpecialItemNodes(rootElement, idJson.getJSONArray("specialItemIdArray"));
    }

    private void addItemNodes(Element rootElement, JSONArray itemIdArray) {
        Element itemsElement = rootElement.addElement("GoodsInfos");
        for (int i = 0; i < itemIdArray.size(); ++i) {
            JSONObject itemIdJson = itemIdArray.getJSONObject(i);
            Element itemElement = itemsElement.addElement("GoodsInfo");
            XmlHelperUtils.addRefNode(itemElement, "Item", itemIdJson.getString("goodsName"), this.id);
            XmlHelperUtils.addRefNode(itemElement, "Specification", itemIdJson.getString("specModel"), this.id);
            XmlHelperUtils.addRefNode(itemElement, "MeasurementDimension", itemIdJson.getString("unit"), this.id);
            XmlHelperUtils.addRefNode(itemElement, "Quantity", itemIdJson.getString("num"), this.id);
            XmlHelperUtils.addRefNode(itemElement, "Price", itemIdJson.getString("unitPrice"), this.id);
            XmlHelperUtils.addRefNode(itemElement, "Amount", itemIdJson.getString("detailAmount"), this.id);
            XmlHelperUtils.addRefNode(itemElement, "TaxScheme", itemIdJson.getString("taxRate"), this.id);
            XmlHelperUtils.addRefNode(itemElement, "TaxAmount", itemIdJson.getString("taxAmount"), this.id);
        }
    }

    private void addSpecialItemNodes(Element rootElement, JSONArray itemIdArray) {
        if (itemIdArray == null || itemIdArray.isEmpty()) {
            return;
        }
        Element itemsElement = rootElement.addElement("\u7279\u6b8a\u660e\u7ec6\u5217\u8868");
        for (int i = 0; i < itemIdArray.size(); ++i) {
            JSONObject itemIdJSON = itemIdArray.getJSONObject(i);
            Element itemElement = itemsElement.addElement("\u7279\u6b8a\u660e\u7ec6");
            for (String key : itemIdJSON.keySet()) {
                XmlHelperUtils.addRefNode(itemElement, key, itemIdJSON.getString(key), this.id);
            }
        }
    }

    public void setCarTagElement(Element rootElement, JSONObject idJson) {
        if (idJson == null || idJson.isEmpty()) {
            return;
        }
        for (String key : idJson.keySet()) {
            XmlHelperUtils.addRefNode(rootElement, key, idJson.getString(key), this.id);
        }
    }
}

