/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.file.fpy.service.ofd.fdei;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.file.fpy.constants.FullDigitalEInvoiceConstant;
import kd.imc.bdm.file.fpy.enums.InvoiceTypeEnum;
import kd.imc.bdm.file.fpy.model.ofd.OFDBound;
import kd.imc.bdm.file.fpy.model.ofd.OFDDocument;
import kd.imc.bdm.file.fpy.model.ofd.OFDInvoice;
import kd.imc.bdm.file.fpy.model.ofd.OFDPage;
import kd.imc.bdm.file.fpy.model.ofd.OFDSize;
import kd.imc.bdm.file.fpy.model.ofd.OFDTemplate;
import kd.imc.bdm.file.fpy.model.pdf.fedi.FullDigitalEInvoice;
import kd.imc.bdm.file.fpy.service.ofd.fdei.FullDigitalEInvoiceOfdService;
import kd.imc.bdm.file.fpy.service.ofd.util.XmlHelperUtils;
import kd.imc.bdm.file.fpy.util.EInvoicePdfUtils;
import kd.imc.bdm.file.fpy.util.MoneyUtil;
import kd.imc.bdm.file.fpy.util.PDFXmlUtils;
import kd.imc.bdm.file.fpy.util.QRCodeUtil;
import kd.imc.bdm.file.util.DateUtils;
import kd.imc.bdm.file.util.ErrorType;
import kd.imc.bdm.file.util.Handle;
import kd.imc.bdm.file.util.pdf.PdfUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;

public class FullDigitalEInvoiceCarOfdService {
    private static Log log = LogFactory.getLog(FullDigitalEInvoiceCarOfdService.class);
    FullDigitalEInvoiceOfdService fullDigitalEInvoiceOfdService = new FullDigitalEInvoiceOfdService();

    public byte[] createCarOfd(FullDigitalEInvoice fullDigitalEInvoice) {
        Date startDate = new Date();
        JSONObject dataJson = PdfUtils.getCarDataJson(fullDigitalEInvoice);
        InvoiceTypeEnum invoiceType = InvoiceTypeEnum.getInvoiceTypeByValue(dataJson.getString("invoiceType"));
        if (invoiceType == null) {
            throw new KDBizException(new ErrorCode(ErrorType.USER_ERROR_A0420.errcode, ResManager.loadKDString((String)"\u5f53\u524d\u53d1\u7968\u79cd\u7c7b\u4e0d\u652f\u6301\u751f\u6210OFD!", (String)"FullDigitalEInvoiceOfdService_0", (String)"imc-bdm-file", (Object[])new Object[0])), new Object[0]);
        }
        String templateXml = null;
        try {
            templateXml = PDFXmlUtils.readTempFileStr("template/full-digital-invoice-ofd_20250605.xml");
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(new ErrorCode(ErrorType.USER_ERROR_A0160.errcode, ResManager.loadKDString((String)"OFD\u751f\u6210\u5931\u8d25\uff0c\u6a21\u677f\u4e0d\u5b58\u5728!", (String)"FullDigitalEInvoiceOfdService_1", (String)"imc-bdm-file", (Object[])new Object[0])), new Object[0]);
        }
        Document templateDocument = XmlHelperUtils.loadXML(templateXml);
        Element templateRootElement = templateDocument.getRootElement();
        Element paramElement = templateRootElement.element("PARAM").element(invoiceType.getSpecialInvoiceType());
        OFDInvoice ofdInvoice = new OFDInvoice(dataJson);
        OFDDocument doc = ofdInvoice.ofdFile.getDocument();
        JSONObject detailElementJson = this.getDataElementList(dataJson, paramElement, doc);
        JSONArray everyPageEleArray = detailElementJson.getJSONArray("everyPageEleArray");
        JSONObject idJson = detailElementJson.getJSONObject("idJson");
        Document tagDocument = XmlHelperUtils.createDocument("ofd:eInvoice");
        Element tagRoot = tagDocument.getRootElement();
        tagRoot.addAttribute("version", "1.0");
        OFDSize ofdSize = new OFDSize(FullDigitalEInvoiceConstant.CAR_WIDTH_DECIMAL, FullDigitalEInvoiceConstant.CAR_HEIGHT_DECIMAL);
        OFDTemplate template = this.getTemplate(templateRootElement, dataJson, invoiceType, doc, ofdSize);
        OFDPage page = doc.addPage(template);
        page.addElementArray(everyPageEleArray);
        byte[] imageBytes = QRCodeUtil.encoderQRCodeByte(dataJson);
        page.addImage(new OFDBound("23, 10, 20, 20"), "png", imageBytes);
        page.setCarTagElement(tagRoot, idJson);
        doc.addCustomTag(tagDocument);
        ofdInvoice.flush();
        Date endTime = new Date();
        log.info("OFD\u751f\u6210\u8017\u65f6{}", (Object)(endTime.getTime() - startDate.getTime()));
        return ofdInvoice.getData();
    }

    private JSONObject getDataElementList(JSONObject dataJson, Element paramElement, OFDDocument doc) {
        String taxRateStr;
        BigDecimal diffY = BigDecimal.ZERO;
        JSONObject detailElementJson = new JSONObject();
        JSONObject idJson = new JSONObject();
        JSONArray everyPageEleArray = new JSONArray();
        String issueTimeCn = DateUtils.format(dataJson.getDate("issueTime"), "yyyy\u5e74MM\u6708dd\u65e5");
        this.fullDigitalEInvoiceOfdService.addTextEleArrayWithKey(everyPageEleArray, "issueTime", issueTimeCn, paramElement, diffY, false, idJson, doc);
        dataJson.remove((Object)"issueTime");
        dataJson.put("totalAmountDX", (Object)MoneyUtil.moneyCapital(dataJson.getString("totalAmount")));
        String taxAuthorityName = dataJson.getString("taxAuthorityName");
        String taxAuthorityCode = dataJson.getString("taxAuthorityCode");
        if (StringUtils.isNotEmpty((CharSequence)taxAuthorityName) || StringUtils.isNotEmpty((CharSequence)taxAuthorityCode)) {
            String taxAuthorityNameAndCode = Handle.nullToEmpty(taxAuthorityName) + Handle.nullToEmpty(taxAuthorityCode);
            dataJson.put("taxAuthorityNameAndCode", (Object)taxAuthorityNameAndCode);
        }
        String auctionBankName = dataJson.getString("auctionBankName");
        String auctionBankAccNum = dataJson.getString("auctionBankAccNum");
        if (StringUtils.isNotEmpty((CharSequence)auctionBankName) || StringUtils.isNotEmpty((CharSequence)auctionBankAccNum)) {
            String auctionBankAccount = Handle.nullToEmpty(auctionBankName) + Handle.nullToEmpty(auctionBankAccNum);
            dataJson.put("auctionBankAccount", (Object)auctionBankAccount);
        }
        String marketBankName = dataJson.getString("marketBankName");
        String marketBankAccNum = dataJson.getString("marketBankAccNum");
        if (StringUtils.isNotEmpty((CharSequence)marketBankName) || StringUtils.isNotEmpty((CharSequence)marketBankAccNum)) {
            String marketBankAccount = Handle.nullToEmpty(marketBankName) + Handle.nullToEmpty(marketBankAccNum);
            dataJson.put("marketBankAccount", (Object)marketBankAccount);
        }
        if (StringUtils.isNotEmpty((CharSequence)(taxRateStr = dataJson.getString("taxRate"))) && !taxRateStr.contains("%")) {
            dataJson.put("taxRate", (Object)(new BigDecimal(taxRateStr).multiply(new BigDecimal("100")).stripTrailingZeros().toPlainString() + "%"));
        }
        this.setDataElementList(dataJson, paramElement, doc, everyPageEleArray, idJson);
        if (dataJson.getBooleanValue("test")) {
            this.fullDigitalEInvoiceOfdService.setWaterMark(everyPageEleArray, paramElement, diffY, doc);
        }
        if (dataJson.getBooleanValue("reverseIssuance")) {
            everyPageEleArray.add((Object)paramElement.element("reverseIssuanceFlag").element("TextObject"));
        }
        detailElementJson.put("idJson", (Object)idJson);
        detailElementJson.put("everyPageEleArray", (Object)everyPageEleArray);
        return detailElementJson;
    }

    private void setDataElementList(JSONObject dataJson, Element paramElement, OFDDocument doc, JSONArray everyPageEleArray, JSONObject idJson) {
        for (String key : dataJson.keySet()) {
            String dataValue = dataJson.getString(key);
            if (StringUtils.isEmpty((CharSequence)dataValue)) continue;
            Element currentElement = paramElement.element(key);
            int maxLength = XmlHelperUtils.getAttributeValue(currentElement, "maxLength", -1);
            if (maxLength == -1) {
                this.fullDigitalEInvoiceOfdService.addTextEleArrayWithKey(everyPageEleArray, key, dataValue, paramElement, BigDecimal.ZERO, false, idJson, doc);
                continue;
            }
            List<String> dataList = EInvoicePdfUtils.subStringByChineseLength(dataValue, maxLength, true);
            if (dataList.isEmpty()) continue;
            BigDecimal diffYCurrent = BigDecimal.ZERO;
            if (!key.equals("remark")) {
                diffYCurrent = FullDigitalEInvoiceConstant.OFD_LINE_BREAK_HEIGHT.multiply(new BigDecimal(dataList.size() - 1));
            }
            for (String currentDataValue : dataList) {
                this.fullDigitalEInvoiceOfdService.addTextEleArrayWithKey(everyPageEleArray, key, currentDataValue, paramElement, diffYCurrent, true, idJson, doc);
                diffYCurrent = diffYCurrent.add(FullDigitalEInvoiceConstant.FIRST_REMARK_LINE_SPACING_BIG);
            }
        }
    }

    private OFDTemplate getTemplate(Element templateRootElement, JSONObject dataJson, InvoiceTypeEnum invoiceType, OFDDocument doc, OFDSize ofdSize) {
        List titleElement = templateRootElement.element("TITLE").element(invoiceType.name()).elements();
        String areaCodeStr = EInvoicePdfUtils.getAreaCodeByNsrsbh(dataJson.getString("salerTaxNo"), dataJson.getString("taxBureauCode"));
        Element bodyElement = templateRootElement.element("SPECIALBODY");
        Element carJjzElement = bodyElement.element("CARJJZ");
        List jjzCommonElementList = carJjzElement.element("COMMON").elements();
        List jjzDetailElementList = carJjzElement.element(areaCodeStr).elements();
        List templateElement = bodyElement.element(invoiceType.getSpecialInvoiceType()).elements();
        OFDTemplate template = doc.addTemplate(null, 0, ofdSize);
        template.addElementList(templateElement);
        template.addElementList(jjzCommonElementList);
        template.addElementList(jjzDetailElementList);
        template.addElementList(titleElement);
        return template;
    }
}

