/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.file.fpy.service.ofd.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class CompressHelperUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(Map<String, byte[]> sources, String encoding, String comment) {
        if (sources == null || sources.size() == 0) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        CheckedOutputStream csum = new CheckedOutputStream(bos, new CRC32());
        ZipOutputStream zos = new ZipOutputStream(csum);
        zos.setComment(comment);
        zos.setMethod(8);
        zos.setLevel(9);
        BufferedOutputStream bout = null;
        try {
            bout = new BufferedOutputStream(zos);
            for (Map.Entry<String, byte[]> entry : sources.entrySet()) {
                CompressHelperUtils.compressItem(zos, bout, entry.getKey(), entry.getValue());
            }
            zos.close();
            Object object = bos.toByteArray();
            return object;
        }
        catch (Exception e) {
            try {
                zos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (bout != null) {
                try {
                    bout.close();
                }
                catch (Exception exception) {}
            }
            try {
                bos.close();
            }
            catch (Exception exception) {}
        }
    }

    private static void compressItem(ZipOutputStream zos, BufferedOutputStream bout, String itemName, byte[] itemData) {
        try {
            ZipEntry zipEntry = new ZipEntry(itemName);
            zos.putNextEntry(zipEntry);
            bout.write(itemData, 0, itemData.length);
            bout.flush();
            zos.closeEntry();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

