/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.file.fpy.service.pdf.fdei;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGState;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.file.fpy.constants.FullDigitalEInvoiceConstant;
import kd.imc.bdm.file.fpy.enums.DifferenceTaxTypeEnum;
import kd.imc.bdm.file.fpy.enums.InvoiceTypeEnum;
import kd.imc.bdm.file.fpy.enums.SpecialTypeEnum;
import kd.imc.bdm.file.fpy.enums.ZeroTaxRateFlagEnum;
import kd.imc.bdm.file.fpy.model.CtmBean;
import kd.imc.bdm.file.fpy.model.RgbBean;
import kd.imc.bdm.file.fpy.model.pdf.PDFTemplatePosition;
import kd.imc.bdm.file.fpy.model.pdf.fedi.CargoTransportItem;
import kd.imc.bdm.file.fpy.model.pdf.fedi.FDEIPositionContent;
import kd.imc.bdm.file.fpy.model.pdf.fedi.FullDigitalEInvoice;
import kd.imc.bdm.file.fpy.model.pdf.fedi.PassengerTransportItem;
import kd.imc.bdm.file.fpy.model.pdf.fedi.RightLinePosition;
import kd.imc.bdm.file.fpy.service.pdf.fdei.FullDigitalEInvoicePdfWriteDataService;
import kd.imc.bdm.file.fpy.service.pdf.fdei.FullDigitalEInvoicePdfWritePathService;
import kd.imc.bdm.file.fpy.util.EInvoicePdfUtils;
import kd.imc.bdm.file.fpy.util.MoneyUtil;
import kd.imc.bdm.file.fpy.util.PDFTemplateUtils;
import kd.imc.bdm.file.fpy.util.PDFXmlUtils;
import kd.imc.bdm.file.fpy.util.QRCodeUtil;
import kd.imc.bdm.file.util.DateUtils;
import kd.imc.bdm.file.util.ErrorType;
import kd.imc.bdm.file.util.Handle;
import kd.imc.bdm.file.util.JsonUtils;
import kd.imc.bdm.file.util.LoadFontUtils;
import kd.imc.bdm.file.util.pdf.PdfUtils;
import kd.imc.bdm.file.util.pdf.RgbUtils;
import org.apache.commons.lang3.StringUtils;

public class FullDigitalEInvoicePdfService {
    private static Log log = LogFactory.getLog(FullDigitalEInvoicePdfService.class);
    private FullDigitalEInvoicePdfWriteDataService writeDataService = new FullDigitalEInvoicePdfWriteDataService();
    private FullDigitalEInvoicePdfWritePathService writePathService = new FullDigitalEInvoicePdfWritePathService();

    public byte[] createPdf(FullDigitalEInvoice fullDigitalEInvoice) {
        Date startDate = new Date();
        InvoiceTypeEnum invoiceType = InvoiceTypeEnum.getInvoiceTypeByValue(fullDigitalEInvoice.getInvoiceType());
        if (invoiceType == null) {
            throw new KDBizException(new ErrorCode(ErrorType.USER_ERROR_A0420.errcode, ResManager.loadKDString((String)"\u5f53\u524d\u53d1\u7968\u79cd\u7c7b\u4e0d\u652f\u6301\u751f\u6210PDF!", (String)"FullDigitalEInvoicePdfService_0", (String)"imc-bdm-file", (Object[])new Object[0])), new Object[0]);
        }
        if (InvoiceTypeEnum.CAR_VEHICLE_INVOICE == invoiceType || InvoiceTypeEnum.USED_CAR_INVOICE == invoiceType) {
            return this.createCarPdf(fullDigitalEInvoice);
        }
        String taxNo = fullDigitalEInvoice.getSalerTaxNo();
        String specialTypeStr = fullDigitalEInvoice.getSpecialType();
        SpecialTypeEnum specialType = SpecialTypeEnum.getSpecialTypeByValue(specialTypeStr);
        if (SpecialTypeEnum.PURCHASE_OF_AGRICULTURAL_PRODUCTS == specialType || SpecialTypeEnum.PURCHASE_OF_AGRICULTURAL_PRODUCTS_02 == specialType) {
            taxNo = fullDigitalEInvoice.getBuyerTaxNo();
        }
        JSONObject templateJson = this.getTemplateJson();
        JSONObject jjzJson = templateJson.getJSONObject("JJZ");
        List<PDFTemplatePosition> jjzPositionList = FullDigitalEInvoicePdfService.getJJZPositionList(jjzJson, taxNo, fullDigitalEInvoice.getTaxBureauCode(), true);
        JSONObject titleJson = templateJson.getJSONObject("TITLE");
        List<PDFTemplatePosition> titlePositionList = FullDigitalEInvoicePdfService.getTitlePositionList(titleJson, invoiceType.name());
        PDFTemplatePosition drawerPosition = (PDFTemplatePosition)JSONObject.toJavaObject((JSON)templateJson.getJSONObject("drawer"), PDFTemplatePosition.class);
        PDFTemplatePosition dwfPosition = (PDFTemplatePosition)JSONObject.toJavaObject((JSON)templateJson.getJSONObject("DWF"), PDFTemplatePosition.class);
        PDFTemplatePosition pageNoPosition = (PDFTemplatePosition)JSONObject.toJavaObject((JSON)templateJson.getJSONObject("pageNo"), PDFTemplatePosition.class);
        RightLinePosition rightLinePosition = this.getRightLinePosition(templateJson);
        JSONObject contentJson = this.getContentJsonBySpecialType(templateJson, specialType);
        ArrayList<List<PDFTemplatePosition>> specialDataList = new ArrayList<List<PDFTemplatePosition>>(8);
        ArrayList<Integer> specialLineNumList = new ArrayList<Integer>(8);
        this.setSpecialDataList(specialDataList, specialLineNumList, fullDigitalEInvoice, contentJson, specialType);
        FDEIPositionContent contentPosition = this.getContentPosition(fullDigitalEInvoice, contentJson, specialType, specialLineNumList);
        contentPosition.setJjzPositionList(jjzPositionList);
        contentPosition.setTitlePositionList(titlePositionList);
        contentPosition.getDrawerPositionList().add(drawerPosition);
        contentPosition.getLastPositionList().add(dwfPosition);
        contentPosition.setPageNoPosition(pageNoPosition);
        contentPosition.setRightLinePosition(rightLinePosition);
        contentPosition.setSpecialType(specialType);
        contentPosition.setSpecialPositionList(specialDataList);
        contentPosition.setTest(fullDigitalEInvoice.isTest());
        byte[] pdfBytes = this.createPdfByPosition(contentPosition, specialLineNumList);
        if (pdfBytes == null) {
            throw new KDBizException(new ErrorCode(ErrorType.USER_ERROR_A0421.errcode, ResManager.loadKDString((String)"\u521b\u5efaPDF\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e\u3002", (String)"FullDigitalEInvoicePdfService_1", (String)"imc-bdm-file", (Object[])new Object[0])), new Object[0]);
        }
        Date endTime = new Date();
        log.info("PDF\u751f\u6210\u8017\u65f6{}", (Object)(endTime.getTime() - startDate.getTime()));
        return pdfBytes;
    }

    private JSONObject getTemplateJson() {
        JSONObject templateJson = PDFXmlUtils.getPDFTemplateInfoFromXMLFile("template/full-digital-invoice-pdf_20240614.json");
        if (templateJson.containsKey((Object)"TEMPLATE")) {
            templateJson = templateJson.getJSONObject("TEMPLATE");
        }
        return templateJson;
    }

    private BaseFont[] getFontArr() {
        BaseFont[] fonts;
        try {
            BaseFont courierFont = BaseFont.createFont((String)"fonts/cour.ttf", (String)"Identity-H", (boolean)false);
            BaseFont kaiFont = BaseFont.createFont((String)"fonts/simkai.ttf", (String)"Identity-H", (boolean)false);
            BaseFont songFont = BaseFont.createFont((String)"fonts/simsun.ttc,0", (String)"Identity-H", (boolean)false);
            fonts = new BaseFont[]{songFont, courierFont, kaiFont};
        }
        catch (Exception e) {
            log.error("\u5b57\u4f53\u6587\u4ef6\u4e0d\u5b58\u5728", (Throwable)e);
            throw new KDBizException(new ErrorCode(ErrorType.SYSTEM_ERROR_B0321.errcode, ResManager.loadKDString((String)"\u5b57\u4f53\u6587\u4ef6\u4e0d\u5b58\u5728", (String)"FullDigitalEInvoicePdfService_2", (String)"imc-bdm-file", (Object[])new Object[0])), new Object[0]);
        }
        return fonts;
    }

    private byte[] createCarPdf(FullDigitalEInvoice fullDigitalEInvoice) {
        PDFTemplatePosition currentPosition;
        Date startDate = new Date();
        JSONObject dataJson = PdfUtils.getCarDataJson(fullDigitalEInvoice);
        JSONObject templateJson = this.getTemplateJson();
        String invoiceType = dataJson.getString("invoiceType");
        JSONObject templateContentJson = this.getTemplateContentJson(templateJson, invoiceType);
        this.setSpecialData(dataJson);
        List<PDFTemplatePosition> basicPositionList = this.getBasicContentWithLineBreakPositionList(dataJson, templateContentJson);
        if (basicPositionList == null) {
            throw new KDBizException(new ErrorCode(ErrorType.USER_ERROR_A0420.errcode, ResManager.loadKDString((String)"\u5f53\u524d\u53d1\u7968\u79cd\u7c7b\u4e0d\u652f\u6301\u751f\u6210PDF!", (String)"FullDigitalEInvoicePdfService_0", (String)"imc-bdm-file", (Object[])new Object[0])), new Object[0]);
        }
        if (dataJson.getBooleanValue("test")) {
            currentPosition = this.getContentPositionByXmlAndStr(null, "testFlag", templateContentJson, 0);
            basicPositionList.add(currentPosition);
        }
        if (dataJson.getBooleanValue("reverseIssuance")) {
            currentPosition = this.getContentPositionByXmlAndStr(null, "reverseIssuanceFlag", templateContentJson, 0);
            basicPositionList.add(currentPosition);
        }
        String salerTaxNo = dataJson.getString("salerTaxNo");
        String taxBureauCode = dataJson.getString("taxBureauCode");
        JSONObject jjzJson = templateJson.getJSONObject("JJZ");
        List<PDFTemplatePosition> jjzPositionList = FullDigitalEInvoicePdfService.getJJZPositionList(jjzJson, salerTaxNo, taxBureauCode, false);
        String invoiceDateStr = DateUtils.format(dataJson.getDate("issueTime"), "yyyyMMdd");
        String invoiceNo = dataJson.getString("invoiceNo");
        String totalAmount = dataJson.getString("totalAmount");
        String ewmStr = QRCodeUtil.createStringByStr(invoiceType, invoiceNo, totalAmount, invoiceDateStr);
        Image image = QRCodeUtil.encoderQRCodeImageByString(ewmStr);
        BaseFont[] fonts = this.getFontArr();
        String templatePath = "template/full-digital-user-car-ele.pdf";
        if (InvoiceTypeEnum.CAR_VEHICLE_INVOICE.getValue().equals(invoiceType)) {
            templatePath = "template/full-digital-car-vehicle-ele.pdf";
        }
        byte[] tempBytes = PDFTemplateUtils.getPDFTemplateInfoBytes(templatePath);
        byte[] fileBytes = null;
        PdfReader reader = null;
        PdfStamper stamp = null;
        try (ByteArrayOutputStream bao = new ByteArrayOutputStream();){
            JSONObject jjzIndexJson;
            String jjzIndex;
            reader = new PdfReader(tempBytes);
            stamp = new PdfStamper(reader, (OutputStream)bao);
            PdfContentByte under = stamp.getOverContent(1);
            this.setData(under, fonts, basicPositionList, 0.0f, 0.0f);
            if (jjzPositionList != null && !jjzPositionList.isEmpty() && StringUtils.isNotEmpty((CharSequence)(jjzIndex = (jjzIndexJson = templateContentJson.getJSONObject("jjzIndex")).getString("textLocation")))) {
                String[] jjzIndexArr = jjzIndex.split(",");
                this.setData(under, fonts, jjzPositionList, Float.parseFloat(jjzIndexArr[0]), Float.parseFloat(jjzIndexArr[1]));
            }
            if (dataJson.getBooleanValue("test")) {
                Rectangle rectangle = reader.getPageSize(1);
                this.setWaterMark(under, PdfUtils.getPxByMm(rectangle.getWidth()), PdfUtils.getPxByMm(rectangle.getHeight()), fonts[2]);
            }
            JSONObject qrCode = templateContentJson.getJSONObject("qrCode");
            String[] str = qrCode.getString("textLocation").split(",");
            String str1 = str[0];
            String str2 = str[1];
            float qrcodeScale = 37.0f;
            if (str.length == 3) {
                qrcodeScale = Float.parseFloat(str[2]);
            }
            image.scalePercent(qrcodeScale);
            image.setAbsolutePosition(Float.parseFloat(str1), Float.parseFloat(str2));
            under.addImage(image);
            stamp.setFormFlattening(true);
            stamp.close();
            fileBytes = bao.toByteArray();
        }
        catch (DocumentException | IOException e) {
            log.error("\u751f\u6210PDF\u51fa\u9519\uff0c\u65e0\u6cd5\u6b63\u5e38\u8bfb\u53d6/\u5173\u95ed\u6587\u4ef6\u6d41", e);
            throw new KDBizException(new ErrorCode(ErrorType.USER_ERROR_A0421.errcode, ResManager.loadKDString((String)"\u521b\u5efaPDF\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e\u3002", (String)"FullDigitalEInvoicePdfService_1", (String)"imc-bdm-file", (Object[])new Object[0])), new Object[0]);
        }
        finally {
            if (stamp != null) {
                try {
                    stamp.close();
                }
                catch (DocumentException | IOException throwable) {}
            }
            if (reader != null) {
                reader.close();
            }
        }
        Date endTime = new Date();
        log.info("PDF\u751f\u6210\u8017\u65f6{}", (Object)(endTime.getTime() - startDate.getTime()));
        return fileBytes;
    }

    private void setSpecialData(JSONObject dataJson) {
        Date issueTime;
        String taxRateStr;
        String taxAuthorityName = dataJson.getString("taxAuthorityName");
        String taxAuthorityCode = dataJson.getString("taxAuthorityCode");
        String taxAuthorityNameAndCode = Handle.nullToEmpty(taxAuthorityName) + Handle.nullToEmpty(taxAuthorityCode);
        dataJson.put("taxAuthorityNameAndCode", (Object)taxAuthorityNameAndCode);
        BigDecimal totalAmount = dataJson.getBigDecimal("totalAmount");
        dataJson.put("totalAmountDX", (Object)MoneyUtil.moneyCapital(EInvoicePdfUtils.getPriceWithScale(totalAmount)));
        String auctionBankName = dataJson.getString("auctionBankName");
        String auctionBankAccNum = dataJson.getString("auctionBankAccNum");
        if (StringUtils.isNotEmpty((CharSequence)auctionBankName) || StringUtils.isNotEmpty((CharSequence)auctionBankAccNum)) {
            String auctionBankAccount = Handle.nullToEmpty(auctionBankName) + Handle.nullToEmpty(auctionBankAccNum);
            dataJson.put("auctionBankAccount", (Object)auctionBankAccount);
        }
        String marketBankName = dataJson.getString("marketBankName");
        String marketBankAccNum = dataJson.getString("marketBankAccNum");
        if (StringUtils.isNotEmpty((CharSequence)marketBankName) || StringUtils.isNotEmpty((CharSequence)marketBankAccNum)) {
            String marketBankAccount = Handle.nullToEmpty(marketBankName) + Handle.nullToEmpty(marketBankAccNum);
            dataJson.put("marketBankAccount", (Object)marketBankAccount);
        }
        if (StringUtils.isNotEmpty((CharSequence)(taxRateStr = dataJson.getString("taxRate"))) && !taxRateStr.contains("%")) {
            dataJson.put("taxRate", (Object)(new BigDecimal(taxRateStr).multiply(new BigDecimal("100")).stripTrailingZeros().toPlainString() + "%"));
        }
        if ((issueTime = dataJson.getDate("issueTime")) != null) {
            dataJson.put("issueTime", (Object)DateUtils.format(issueTime, "yyyy\u5e74MM\u6708dd\u65e5"));
        }
        String invoiceType = dataJson.getString("invoiceType");
        if (InvoiceTypeEnum.CAR_VEHICLE_INVOICE.getValue().equals(invoiceType)) {
            dataJson.remove((Object)"remark");
        }
        if (InvoiceTypeEnum.USED_CAR_INVOICE.getValue().equals(invoiceType)) {
            dataJson.remove((Object)"invoiceAmount");
            dataJson.remove((Object)"totalTaxAmount");
        }
    }

    private JSONObject getTemplateContentJson(JSONObject templateJson, String invoiceType) {
        JSONObject contentJson = new JSONObject();
        contentJson.putAll((Map)templateJson.getJSONObject("CONTENT"));
        String specialInvoiceType = null;
        if (InvoiceTypeEnum.USED_CAR_INVOICE.getValue().equals(invoiceType)) {
            specialInvoiceType = "userCarEle";
        } else if (InvoiceTypeEnum.CAR_VEHICLE_INVOICE.getValue().equals(invoiceType)) {
            specialInvoiceType = "carVehicleEle";
        }
        if (specialInvoiceType != null && contentJson.getJSONObject(specialInvoiceType) != null) {
            contentJson.putAll((Map)contentJson.getJSONObject(specialInvoiceType));
        }
        return contentJson;
    }

    private JSONObject getContentJsonBySpecialType(JSONObject templateJson, SpecialTypeEnum specialType) {
        JSONObject contentJson = new JSONObject();
        contentJson.putAll((Map)templateJson.getJSONObject("CONTENT"));
        contentJson.putAll((Map)contentJson.getJSONObject(specialType.getIdentification()));
        return contentJson;
    }

    /*
     * Exception decompiling
     */
    private byte[] createPdfByPosition(FDEIPositionContent contentPosition, List<Integer> specialLineNumList) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setEveryPageDataToPdf(List<byte[]> bytesList, FDEIPositionContent contentPosition, List<PDFTemplatePosition> detailDataList, BaseFont[] fonts, boolean multiPage, boolean lastFlag, int pageTotalNum, int pageIndex, float diffYMM, float tableContentHeight, float specialHeight, boolean moreRemark) {
        double epsilon = 1.0E-6;
        boolean specialFlag = (double)Math.abs(specialHeight - -1.0f) < epsilon;
        List<PDFTemplatePosition> lastPositionList = contentPosition.getLastPositionList();
        List<List<PDFTemplatePosition>> subMoneyPositionList = contentPosition.getSubMoneyPositionList();
        SpecialTypeEnum specialType = contentPosition.getSpecialType();
        List<List<PDFTemplatePosition>> specialPositionList = contentPosition.getSpecialPositionList();
        float diffY = 0.0f;
        if ((double)Math.abs(diffYMM) > epsilon) {
            diffY = EInvoicePdfUtils.getPxByMm(diffYMM);
        }
        PdfReader reader = null;
        PdfStamper stamp = null;
        try (ByteArrayOutputStream bao = new ByteArrayOutputStream();){
            float height = 140.0f + diffYMM;
            byte[] blankBytes = EInvoicePdfUtils.generateBlankPdf(210.0f, height);
            reader = new PdfReader(blankBytes);
            stamp = new PdfStamper(reader, (OutputStream)bao);
            PdfContentByte under = stamp.getOverContent(1);
            this.setCommonData(contentPosition, under, fonts, pageTotalNum, pageIndex + 1, diffY, diffYMM);
            this.writeDataService.drawTable(under, specialType, diffYMM, tableContentHeight, specialHeight, lastFlag, multiPage, moreRemark);
            if (specialFlag) {
                this.setData(under, fonts, detailDataList, 0.0f, diffY + 125.0f);
            } else {
                this.setData(under, fonts, detailDataList, 0.0f, diffY);
                if (pageIndex == 0 && !specialPositionList.isEmpty()) {
                    specialHeight = multiPage ? (specialHeight -= 23.0f) : (specialHeight += 5.0f);
                    this.setData(under, fonts, specialPositionList.get(0), 0.0f, EInvoicePdfUtils.getPxByMm(specialHeight));
                }
            }
            float lastDiffY = 0.0f;
            if (multiPage) {
                if (!specialFlag) {
                    List<PDFTemplatePosition> subMoney = subMoneyPositionList.get(pageIndex);
                    this.setData(under, fonts, subMoney, 0.0f, diffY);
                } else {
                    lastDiffY = 9.0f;
                }
            }
            if (lastFlag) {
                this.setData(under, fonts, lastPositionList, 0.0f, lastDiffY);
            }
            this.setRightLine(under, contentPosition.getRightLinePosition(), specialFlag, diffY);
            if (contentPosition.isTest()) {
                this.setWaterMark(under, 210.0f, height, fonts[2]);
            }
            stamp.setFormFlattening(true);
            stamp.close();
            bytesList.add(bao.toByteArray());
        }
        catch (DocumentException | IOException e) {
            log.error("\u751f\u6210PDF\u51fa\u9519\uff0c\u5904\u7406\u7ed3\u679c\u6587\u4ef6\u65f6\u65e0\u6cd5\u6b63\u5e38\u8bfb\u53d6/\u5173\u95ed\u6587\u4ef6\u6d41", e);
            throw new KDBizException(new ErrorCode(ErrorType.SYSTEM_ERROR_B0001.errcode, ResManager.loadKDString((String)"\u751f\u6210PDF\u51fa\u9519\uff0c\u65e0\u6cd5\u6b63\u5e38\u8bfb\u53d6/\u5173\u95ed\u6587\u4ef6\u6d41", (String)"FullDigitalEInvoicePdfService_3", (String)"imc-bdm-file", (Object[])new Object[0])), new Object[0]);
        }
        finally {
            if (stamp != null) {
                try {
                    stamp.close();
                }
                catch (DocumentException | IOException throwable) {}
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    public void setWaterMark(PdfContentByte under, float x, float y, BaseFont font) {
        if (under == null) {
            return;
        }
        float diff = 35.0f;
        float xTimes = x / diff;
        float yTimes = y / diff;
        float startX = 21.0f;
        float startY = 15.0f;
        int i = 0;
        while ((float)i < xTimes) {
            int j = 0;
            while ((float)j < yTimes) {
                float currentDiffY = startY + (float)j * diff;
                if (!(currentDiffY >= y)) {
                    this.addText(under, 0.3f, Color.gray, font, 17.0f, ResManager.loadKDString((String)"\u6837\u7968", (String)"FullDigitalEInvoicePdfService_4", (String)"imc-bdm-file", (Object[])new Object[0]), startX + (float)i * diff, currentDiffY, 45.0f, true);
                }
                ++j;
            }
            ++i;
        }
    }

    private void addText(PdfContentByte under, float fillOpacity, Color fillColor, BaseFont font, float fontSize, String text, float x, float y, float rotation, boolean isMM) {
        PdfGState gs = new PdfGState();
        gs.setFillOpacity(fillOpacity);
        under.saveState();
        under.beginText();
        under.setGState(gs);
        under.resetRGBColorFill();
        under.setColorFill(fillColor);
        under.setFontAndSize(font, fontSize);
        float pxX = x;
        float pxY = y;
        if (isMM) {
            pxX = EInvoicePdfUtils.getPxByMm(x);
            pxY = EInvoicePdfUtils.getPxByMm(y);
        }
        under.showTextAligned(1, text, pxX, pxY, rotation);
        under.endText();
        under.restoreState();
    }

    private void setRightLine(PdfContentByte under, RightLinePosition rightLinePosition, boolean specialFlag, float diffY) {
        if (rightLinePosition == null) {
            return;
        }
        BigDecimal specialHeight = BigDecimal.ZERO;
        if (specialFlag) {
            specialHeight = EInvoicePdfUtils.getBigPxByMm(new BigDecimal("3"));
        }
        BigDecimal diffPageYMM = BigDecimal.ZERO;
        if (diffY != 0.0f) {
            diffPageYMM = BigDecimal.valueOf(diffY);
        }
        diffPageYMM = diffPageYMM.subtract(specialHeight);
        BigDecimal diffPageYMMHalf = diffPageYMM.divide(new BigDecimal("2"), 6, RoundingMode.HALF_UP);
        BigDecimal rightLineYStart = EInvoicePdfUtils.getBigPxByMm(FullDigitalEInvoiceConstant.RIGHT_LINE_START_Y).add(specialHeight);
        BigDecimal rightLineHighHalf = EInvoicePdfUtils.getBigPxByMm(FullDigitalEInvoiceConstant.RIGHT_LINE_HIGH_HALF).add(diffPageYMMHalf);
        BigDecimal bottomEndY = rightLineYStart.add(rightLineHighHalf);
        BigDecimal topEndY = bottomEndY.add(rightLineHighHalf);
        BigDecimal rightLineX = EInvoicePdfUtils.getBigPxByMm(FullDigitalEInvoiceConstant.RIGHT_LINE_X);
        String bottomPathPosition = String.format("M %s %s L %s %s", rightLineX, rightLineYStart, rightLineX, bottomEndY);
        String topPathPosition = String.format("M %s %s L %s %s", rightLineX, bottomEndY, rightLineX, topEndY);
        PDFTemplatePosition bottom = rightLinePosition.getBottomPosition();
        bottom.setPathLocation(bottomPathPosition);
        PDFTemplatePosition top = rightLinePosition.getTopPosition();
        top.setPathLocation(topPathPosition);
        this.setData(under, null, top, 0.0f, 0.0f);
        this.setData(under, null, bottom, 0.0f, 0.0f);
    }

    private void setCommonData(FDEIPositionContent contentPosition, PdfContentByte under, BaseFont[] fonts, int pageNum, int currentPageNo, float diffY, float diffYMM) throws DocumentException {
        List<PDFTemplatePosition> drawerPosition = contentPosition.getDrawerPositionList();
        String ewmLocation = contentPosition.getEwmLocation();
        List<PDFTemplatePosition> jjzList = contentPosition.getJjzPositionList();
        List<PDFTemplatePosition> titleList = contentPosition.getTitlePositionList();
        PDFTemplatePosition pageNoPosition = contentPosition.getPageNoPosition();
        List<PDFTemplatePosition> basicPositionList = contentPosition.getBasicPositionList();
        this.setData(under, fonts, basicPositionList, 0.0f, diffY);
        this.setData(under, fonts, jjzList, EInvoicePdfUtils.getPxByMm(90.0f), EInvoicePdfUtils.getPxByMm(140.0f + diffYMM - 8.5f - 20.0f));
        this.setData(under, fonts, titleList, 0.0f, diffY);
        if (pageNum > 1) {
            List<PDFTemplatePosition> pageNoList = this.getPageNoList(pageNoPosition, pageNum, currentPageNo);
            this.setData(under, fonts, pageNoList, 0.0f, diffY);
        }
        this.setData(under, fonts, drawerPosition, 0.0f, 0.0f);
        Image ewmImage = contentPosition.getEwmImage();
        String[] str = ewmLocation.split(",");
        String str1 = str[0];
        String str2 = str[str.length - 1];
        ewmImage.setAbsolutePosition(Float.parseFloat(str1), Float.parseFloat(str2) + diffY);
        ewmImage.scalePercent(37.0f);
        under.addImage(ewmImage);
    }

    private void setData(PdfContentByte under, BaseFont[] fonts, List<PDFTemplatePosition> dataList, float diffX, float diffY) {
        for (PDFTemplatePosition position : dataList) {
            if (position == null) continue;
            this.setData(under, fonts, position, diffX, diffY);
        }
    }

    private void setData(PdfContentByte under, BaseFont[] fonts, PDFTemplatePosition position, float diffX, float diffY) {
        if (StringUtils.isNotEmpty((CharSequence)position.getTextLocation())) {
            String ctmStr = position.getCtm();
            CtmBean ctmBean = this.getCtmBean(ctmStr);
            String msg = position.getMsg();
            float fontSize = position.getFontSize();
            String textLocation = position.getTextLocation();
            String color = position.getColor();
            RgbBean colorArr = RgbUtils.strToRGB(color);
            float space = position.getSpace();
            BaseFont font = EInvoicePdfUtils.getFont(position.getFontName(), fonts);
            double epsilon = 1.0E-6;
            if ((double)Math.abs(space) > epsilon) {
                this.writeDataService.writePdfDataWithSpace(msg, under, font, Float.valueOf(fontSize), textLocation, colorArr, diffX, diffY, space);
            } else {
                this.writeDataService.writePdfData(msg, under, font, Float.valueOf(fontSize), textLocation, colorArr, ctmBean, diffX, diffY, position.getFontAlign());
            }
        } else {
            this.writePathService.setPathValue(position, under, diffX, diffY);
        }
    }

    private CtmBean getCtmBean(String ctmStr) {
        CtmBean ctmBean = null;
        if (!StringUtils.isEmpty((CharSequence)ctmStr)) {
            String[] ctmArr = ctmStr.split(",");
            ctmBean = new CtmBean();
            ctmBean.setA(Float.parseFloat(ctmArr[0]));
            ctmBean.setB(Float.parseFloat(ctmArr[2]));
            ctmBean.setC(Float.parseFloat(ctmArr[1]));
            ctmBean.setD(Float.parseFloat(ctmArr[3]));
            ctmBean.setE(Float.parseFloat(ctmArr[4]));
            ctmBean.setF(Float.parseFloat(ctmArr[5]));
        }
        return ctmBean;
    }

    private static List<PDFTemplatePosition> getJJZPositionList(JSONObject jjzJson, String nsrsbh, String taxBureauCode, boolean needCommon) {
        String areaCodeStr = EInvoicePdfUtils.getAreaCodeByNsrsbh(nsrsbh, taxBureauCode);
        JSONArray commonArray = jjzJson.getJSONArray("COMMON");
        JSONArray areaArray = jjzJson.getJSONArray(areaCodeStr);
        JSONArray dataArray = new JSONArray();
        if (needCommon) {
            dataArray.addAll((Collection)commonArray);
        }
        dataArray.addAll((Collection)areaArray);
        return JsonUtils.toList(dataArray, PDFTemplatePosition.class);
    }

    private static List<PDFTemplatePosition> getTitlePositionList(JSONObject titleJson, String type) {
        JSONArray commonArray = titleJson.getJSONArray("COMMON");
        JSONObject typeJson = titleJson.getJSONObject(type);
        JSONArray dataArray = new JSONArray();
        dataArray.addAll((Collection)commonArray);
        dataArray.add((Object)typeJson);
        return JsonUtils.toList(dataArray, PDFTemplatePosition.class);
    }

    private static List<PDFTemplatePosition> getJsonPositionList(JSONObject json, String key) {
        PDFTemplatePosition position = (PDFTemplatePosition)JSONObject.toJavaObject((JSON)json.getJSONObject(key), PDFTemplatePosition.class);
        ArrayList<PDFTemplatePosition> list = new ArrayList<PDFTemplatePosition>(1);
        list.add(position);
        return list;
    }

    private FDEIPositionContent getContentPosition(FullDigitalEInvoice fullDigitalEInvoice, JSONObject contentJson, SpecialTypeEnum specialType, List<Integer> specialLineNumList) {
        PDFTemplatePosition currentPosition;
        JSONObject dataJson = JsonUtils.parseObj(fullDigitalEInvoice);
        if (log.isInfoEnabled()) {
            log.info(String.format("\u751f\u6210pdf\u7684\u53d1\u7968\u6570\u636e\u662f : %s", dataJson.toJSONString()));
        }
        List<PDFTemplatePosition> basicPositionList = this.getBasicContentPositionList(dataJson, contentJson, specialType);
        if (fullDigitalEInvoice.isInput()) {
            currentPosition = this.getContentPositionByXmlAndStr(null, "inputDataFlag", contentJson, 0);
            basicPositionList.add(currentPosition);
        }
        if (fullDigitalEInvoice.isTest()) {
            currentPosition = this.getContentPositionByXmlAndStr(null, "testFlag", contentJson, 0);
            basicPositionList.add(currentPosition);
        }
        ArrayList<List<PDFTemplatePosition>> detailPositionLists = new ArrayList<List<PDFTemplatePosition>>(8);
        ArrayList<List<PDFTemplatePosition>> subMoneyPositionLists = new ArrayList<List<PDFTemplatePosition>>(8);
        ArrayList<Integer> currentPageSizeList = new ArrayList<Integer>(8);
        ArrayList<PDFTemplatePosition> detailPositionList = new ArrayList<PDFTemplatePosition>(8);
        ArrayList<PDFTemplatePosition> subMoneyPositionList = new ArrayList<PDFTemplatePosition>(8);
        ArrayList<PDFTemplatePosition> lastPositionList = new ArrayList<PDFTemplatePosition>(8);
        boolean transferFlag = SpecialTypeEnum.CARGO_TRANSPORT_SERVICE == specialType || SpecialTypeEnum.PASSENGER_TRANSPORT == specialType;
        int currentPageSize = 0;
        int currentPageIndex = 0;
        BigDecimal subMoney = BigDecimal.ZERO;
        BigDecimal subTax = BigDecimal.ZERO;
        boolean lastFlag = false;
        boolean lastDataFlag = false;
        JSONArray detailList = dataJson.getJSONArray("itemList");
        boolean differenceTaxFlag = false;
        String differenceTaxType = fullDigitalEInvoice.getDifferenceTaxType();
        if (DifferenceTaxTypeEnum.PART_DIFF == DifferenceTaxTypeEnum.getDifferenceTaxTypeByValue(differenceTaxType)) {
            differenceTaxFlag = true;
        }
        for (int i = 0; i < detailList.size(); ++i) {
            JSONObject detailJson = detailList.getJSONObject(i);
            for (String key : detailJson.keySet()) {
                PDFTemplatePosition contentPosition;
                if (!contentJson.containsKey((Object)key) || "goodsName".equals(key) || "specModel".equals(key) || "unit".equals(key)) continue;
                if ("unitPrice".equals(key) && StringUtils.isNotEmpty((CharSequence)detailJson.getString("unitPrice"))) {
                    detailJson.put("unitPrice", (Object)EInvoicePdfUtils.getBigDecimalStr(detailJson.getBigDecimal("unitPrice")));
                }
                if ("num".equals(key) && StringUtils.isNotEmpty((CharSequence)detailJson.getString("num"))) {
                    detailJson.put("num", (Object)EInvoicePdfUtils.getBigDecimalStr(detailJson.getBigDecimal("num")));
                }
                if ("taxRate".equals(key)) {
                    this.setTaxRate(detailJson, key, differenceTaxFlag);
                }
                if ((contentPosition = this.getContentPositionByXml(detailJson, key, contentJson, currentPageSize)) == null) continue;
                if (detailPositionList == null) {
                    detailPositionList = new ArrayList(8);
                }
                detailPositionList.add(contentPosition);
            }
            subMoney = subMoney.add(BigDecimalUtil.getJsonBigDecimalVal((Object)detailJson.getString("detailAmount")));
            subTax = subTax.add(BigDecimalUtil.getJsonBigDecimalVal((Object)detailJson.getString("taxAmount")));
            String goodsName = EInvoicePdfUtils.replaceBreakLine(detailJson.getString("goodsName"));
            Integer goodsNameMaxLength = contentJson.getJSONObject("goodsName").getInteger("maxLength");
            if (goodsNameMaxLength == null) {
                goodsNameMaxLength = 11;
            }
            List<String> goodsNameList = EInvoicePdfUtils.subStringByChineseLength(goodsName, goodsNameMaxLength, true);
            String specModel = EInvoicePdfUtils.replaceBreakLine(detailJson.getString("specModel"));
            JSONObject specModelJson = contentJson.getJSONObject("specModel");
            List<Object> specModelList = new ArrayList(8);
            if (specModelJson != null) {
                Integer specModelMaxLength = contentJson.getJSONObject("specModel").getInteger("maxLength");
                if (specModelMaxLength == null) {
                    specModelMaxLength = 7;
                }
                specModelList = EInvoicePdfUtils.subStringByChineseLength(specModel, specModelMaxLength, true);
            }
            String unit = EInvoicePdfUtils.replaceBreakLine(detailJson.getString("unit"));
            Integer unitMaxLength = contentJson.getJSONObject("unit").getInteger("maxLength");
            if (unitMaxLength == null) {
                unitMaxLength = 4;
            }
            List<String> unitList = EInvoicePdfUtils.subStringByChineseLength(unit, unitMaxLength, true);
            int maxNum = Math.max(Math.max(goodsNameList.size(), specModelList.size()), unitList.size());
            for (int j = 0; j < maxNum; ++j) {
                PDFTemplatePosition contentPosition;
                if (detailPositionList == null) {
                    detailPositionList = new ArrayList(8);
                }
                if (subMoneyPositionList == null) {
                    subMoneyPositionList = new ArrayList(8);
                }
                if (j < goodsNameList.size() && !StringUtils.isEmpty((CharSequence)goodsNameList.get(j))) {
                    String currentgoodsName = goodsNameList.get(j);
                    contentPosition = this.getContentPositionByXmlAndStr(currentgoodsName, "goodsName", contentJson, currentPageSize);
                    detailPositionList.add(contentPosition);
                }
                if (j < specModelList.size() && !StringUtils.isEmpty((CharSequence)((CharSequence)specModelList.get(j)))) {
                    String currentspecModel = (String)specModelList.get(j);
                    contentPosition = this.getContentPositionByXmlAndStr(currentspecModel, "specModel", contentJson, currentPageSize);
                    detailPositionList.add(contentPosition);
                }
                if (j < unitList.size() && !StringUtils.isEmpty((CharSequence)unitList.get(j))) {
                    String currentUnit = unitList.get(j);
                    contentPosition = this.getContentPositionByXmlAndStr(currentUnit, "unit", contentJson, currentPageSize);
                    detailPositionList.add(contentPosition);
                }
                ++currentPageSize;
                if (i == detailList.size() - 1 && j == maxNum - 1) {
                    lastDataFlag = true;
                }
                if (lastDataFlag && specialLineNumList.size() < 2) {
                    lastFlag = true;
                }
                int specialMaxNum = 47;
                if (currentPageIndex == 0 && transferFlag) {
                    specialMaxNum = 20;
                }
                if (!lastDataFlag && currentPageSize < specialMaxNum) continue;
                int diffPageY = currentPageSize - 8;
                float totalAmountY = 0.0f;
                if (lastFlag && currentPageIndex == 0) {
                    totalAmountY = EInvoicePdfUtils.getPxByMm(5.0f);
                }
                this.setTotalMoneyList(detailPositionLists, detailPositionList, fullDigitalEInvoice, contentJson, totalAmountY, diffPageY);
                this.setSubMoneyList(subMoneyPositionLists, subMoneyPositionList, contentJson, subMoney, subTax, diffPageY);
                currentPageSizeList.add(currentPageSize);
                ++currentPageIndex;
                currentPageSize = 0;
                subMoney = BigDecimal.ZERO;
                subTax = BigDecimal.ZERO;
                detailPositionList = null;
                subMoneyPositionList = null;
            }
        }
        PDFTemplatePosition drawer = this.getContentPositionByXmlAndStr(fullDigitalEInvoice.getDrawer(), "drawer", contentJson, 0);
        ArrayList<PDFTemplatePosition> drawerList = new ArrayList<PDFTemplatePosition>(8);
        drawerList.add(drawer);
        this.setLastDataList(lastPositionList, contentJson, fullDigitalEInvoice);
        List<List<PDFTemplatePosition>> remarkList = this.getRemarkList(contentJson, fullDigitalEInvoice.getRemark());
        if (!remarkList.isEmpty()) {
            lastPositionList.addAll((Collection<PDFTemplatePosition>)remarkList.get(0));
        }
        Image image = QRCodeUtil.encoderQRCodeImage(dataJson);
        String ewmLocation = this.getTextLocationByXml(contentJson.getJSONObject("qrCode"), 0);
        FDEIPositionContent content = new FDEIPositionContent();
        content.setBasicPositionList(basicPositionList);
        content.setCurrentPageSizeList(currentPageSizeList);
        content.setDetailPositionList(detailPositionLists);
        content.setSubMoneyPositionList(subMoneyPositionLists);
        content.setLastPositionList(lastPositionList);
        content.setRemarkPositionList(remarkList);
        content.setEwmImage(image);
        content.setPageNumber(currentPageIndex);
        content.setEwmLocation(ewmLocation);
        content.setDrawerPositionList(drawerList);
        return content;
    }

    private void setSpecialDataList(List<List<PDFTemplatePosition>> specialDataList, List<Integer> specialLineNumList, FullDigitalEInvoice fullDigitalEInvoice, JSONObject contentJson, SpecialTypeEnum specialType) {
        JSONArray specialArray;
        if (SpecialTypeEnum.CARGO_TRANSPORT_SERVICE == specialType) {
            List<CargoTransportItem> cargoTransportList = fullDigitalEInvoice.getCargoTransportList();
            specialArray = new JSONArray(cargoTransportList.size());
            specialArray.addAll(cargoTransportList);
        } else if (SpecialTypeEnum.PASSENGER_TRANSPORT == specialType) {
            List<PassengerTransportItem> passengerTransportList = fullDigitalEInvoice.getTravelerList();
            specialArray = new JSONArray(passengerTransportList.size());
            specialArray.addAll(passengerTransportList);
        } else {
            return;
        }
        if (!specialArray.isEmpty()) {
            Map<String, List<String>> specialDataMap = EInvoicePdfUtils.getSpecialDataMap(fullDigitalEInvoice, contentJson, specialType);
            if (specialDataMap.isEmpty()) {
                return;
            }
            int maxNum = Integer.parseInt(specialDataMap.get("maxNum").get(0));
            if (specialDataMap.get("maxNum") != null) {
                specialDataMap.remove("maxNum");
            }
            ArrayList<PDFTemplatePosition> specialPositionList = null;
            int pageNo = 0;
            int lineNum = 0;
            for (int i = 0; i < maxNum; ++i) {
                int maxLineNum;
                if (specialPositionList == null) {
                    specialPositionList = new ArrayList<PDFTemplatePosition>(8);
                }
                for (Map.Entry<String, List<String>> entry : specialDataMap.entrySet()) {
                    String key = entry.getKey();
                    List<String> valueList = entry.getValue();
                    if (i >= valueList.size()) continue;
                    String value = valueList.get(i);
                    PDFTemplatePosition contentPosition = this.getContentPositionByXmlAndStr(value, key, contentJson, lineNum);
                    specialPositionList.add(contentPosition);
                }
                int n = maxLineNum = pageNo == 0 ? 21 : 47;
                if (++lineNum != maxLineNum && i != maxNum - 1) continue;
                specialDataList.add(specialPositionList);
                if (lineNum < 8) {
                    lineNum = 8;
                }
                specialLineNumList.add(lineNum);
                specialPositionList = null;
                lineNum = 0;
                ++pageNo;
            }
        }
    }

    private void setTaxRate(JSONObject detailJson, String key, boolean differenceTaxFlag) {
        ZeroTaxRateFlagEnum zeroTaxRateFlag;
        String taxRateStr = "***";
        String zeroTaxRateFlagStr = detailJson.getString("zeroTaxRateFlag");
        boolean zeroTaxFlag = false;
        if (!StringUtils.isEmpty((CharSequence)zeroTaxRateFlagStr) && (zeroTaxRateFlag = ZeroTaxRateFlagEnum.getZeroTaxRateFlagByValue(zeroTaxRateFlagStr)) != null) {
            if (!differenceTaxFlag) {
                taxRateStr = zeroTaxRateFlag.getMsg();
            }
            detailJson.put("taxAmount", (Object)zeroTaxRateFlag.getTaxAmount());
            zeroTaxFlag = true;
        }
        if (!differenceTaxFlag && !zeroTaxFlag) {
            BigDecimal taxRate = detailJson.getBigDecimal(key);
            if (taxRate == null) {
                taxRate = BigDecimal.ZERO;
            }
            taxRateStr = taxRate.compareTo(new BigDecimal("1")) <= 0 ? taxRate.multiply(new BigDecimal("100")).stripTrailingZeros().toPlainString() + "%" : taxRate.stripTrailingZeros().toPlainString() + "%";
        }
        detailJson.put(key, (Object)taxRateStr);
    }

    private void setLastDataList(List<PDFTemplatePosition> lastPositionList, JSONObject contentJson, FullDigitalEInvoice fullDigitalEInvoice) {
        ArrayList<PDFTemplatePosition> lastPositionList1 = new ArrayList<PDFTemplatePosition>(16);
        lastPositionList1.addAll(lastPositionList);
        BigDecimal totalAmount = fullDigitalEInvoice.getTotalAmount();
        lastPositionList1.add(this.getContentPositionByXmlAndStr(EInvoicePdfUtils.getPriceWithSymbol(totalAmount), "totalAmount", contentJson, 0));
        lastPositionList1.add(this.getContentPositionByXmlAndStr(MoneyUtil.moneyCapital(EInvoicePdfUtils.getPriceWithScale(totalAmount)), "totalAmountDX", contentJson, 0));
        lastPositionList.addAll(lastPositionList1);
    }

    private void setTotalMoneyList(List<List<PDFTemplatePosition>> detailPositionLists, List<PDFTemplatePosition> detailPositionList, FullDigitalEInvoice fullDigitalEInvoice, JSONObject contentJson, float totalAmountY, int diffPageY) {
        ArrayList<PDFTemplatePosition> detailPositionList2 = new ArrayList<PDFTemplatePosition>(16);
        detailPositionList2.addAll(detailPositionList);
        BigDecimal invoiceAmount = fullDigitalEInvoice.getInvoiceAmount();
        BigDecimal totalTaxAmount = fullDigitalEInvoice.getTotalTaxAmount();
        detailPositionList2.add(this.getContentPositionByXmlAndStrWithDiff(EInvoicePdfUtils.getPriceWithSymbol(invoiceAmount), "invoiceAmount", contentJson, diffPageY, totalAmountY));
        detailPositionList2.add(this.getContentPositionByXmlAndStrWithDiff(EInvoicePdfUtils.getPriceWithSymbol(totalTaxAmount), "totalTaxAmount", contentJson, diffPageY, totalAmountY));
        detailPositionLists.add(detailPositionList2);
    }

    private void setSubMoneyList(List<List<PDFTemplatePosition>> subMoneyPositionLists, List<PDFTemplatePosition> subMoneyPositionList, JSONObject contentJson, BigDecimal subMoney, BigDecimal subTax, int diffPageY) {
        ArrayList<PDFTemplatePosition> subMoneyPositionList1 = new ArrayList<PDFTemplatePosition>(8);
        subMoneyPositionList1.addAll(subMoneyPositionList);
        subMoneyPositionList1.add(this.getContentPositionByXmlAndStr(EInvoicePdfUtils.getPriceWithSymbol(subMoney), "subAmWithoutTax", contentJson, diffPageY));
        subMoneyPositionList1.add(this.getContentPositionByXmlAndStr(EInvoicePdfUtils.getPriceWithSymbol(subTax), "subTaxAm", contentJson, diffPageY));
        subMoneyPositionLists.add(subMoneyPositionList1);
    }

    private List<PDFTemplatePosition> getBasicContentPositionList(JSONObject dataJson, JSONObject contentJson, SpecialTypeEnum specialType) {
        ArrayList<PDFTemplatePosition> list = new ArrayList<PDFTemplatePosition>(8);
        for (String key : contentJson.keySet()) {
            PDFTemplatePosition currentPosition;
            if ("differenceTaxType".equals(key)) {
                DifferenceTaxTypeEnum differenceTaxType = DifferenceTaxTypeEnum.getDifferenceTaxTypeByValue(dataJson.getString(key));
                if (differenceTaxType == null) continue;
                PDFTemplatePosition currentPosition2 = this.getContentPositionByXmlAndStr(differenceTaxType.getMsg(), key, contentJson, 0);
                list.add(currentPosition2);
                continue;
            }
            if (specialType != null && "specialMark".equals(key)) {
                currentPosition = this.getContentPositionByXmlAndStr(specialType.getMsg(), key, contentJson, 0);
                list.add(currentPosition);
                continue;
            }
            if (!dataJson.containsKey((Object)key) || "itemList".equals(key) || "drawer".equals(key) || "invoiceAmount".equals(key) || "totalTaxAmount".equals(key) || "totalAmount".equals(key) || "remark".equals(key) || "qrCode".equals(key)) continue;
            if ("issueTime".equals(key)) {
                String issueTimeCn = DateUtils.format(dataJson.getDate(key), "yyyy\u5e74MM\u6708dd\u65e5");
                dataJson.put(key, (Object)issueTimeCn);
            }
            if ((currentPosition = this.getContentPositionByXml(dataJson, key, contentJson, 0)) == null) continue;
            list.add(currentPosition);
        }
        return list;
    }

    public List<PDFTemplatePosition> getBasicContentWithLineBreakPositionList(JSONObject dataJson, JSONObject contentJson) {
        ArrayList<PDFTemplatePosition> list = new ArrayList<PDFTemplatePosition>(8);
        for (String key : contentJson.keySet()) {
            PDFTemplatePosition position;
            String str = dataJson.getString(key);
            if (StringUtils.isEmpty((CharSequence)str) || (position = (PDFTemplatePosition)contentJson.getObject(key, PDFTemplatePosition.class)) == null) continue;
            Integer maxLength = position.getMaxLength();
            if (maxLength == null || maxLength <= 0) {
                position.setMsg(str);
                String textLocation = this.getTextLocation(position.getTextLocation(), 0, 0.0f);
                position.setTextLocation(textLocation);
                list.add(position);
                continue;
            }
            List<PDFTemplatePosition> fieldList = this.getFieldList(contentJson, key, str, maxLength);
            if (fieldList.isEmpty()) continue;
            list.addAll(fieldList);
        }
        return list;
    }

    private List<PDFTemplatePosition> getFieldList(JSONObject contentJson, String key, String str, int maxLength) {
        List<String> dataList = EInvoicePdfUtils.subStringByChineseLength(str, maxLength, true);
        float diffY = 0.0f;
        if (!key.equals("remark")) {
            diffY = (float)(dataList.size() - 1) * 4.5f;
        }
        ArrayList<PDFTemplatePosition> fieldInfoList = new ArrayList<PDFTemplatePosition>(8);
        for (String remarkStr : dataList) {
            fieldInfoList.add(this.getContentPositionByXmlAndStrWithDiff(remarkStr, key, contentJson, 0, diffY));
            diffY -= EInvoicePdfUtils.getPxByMm(3.0f);
        }
        return fieldInfoList;
    }

    private void setNegativeMark(JSONObject contentJson, JSONObject dataJson, List<PDFTemplatePosition> list) {
        BigDecimal totalAmount = BigDecimalUtil.getJsonBigDecimalVal((Object)dataJson.getString("totalAmount"));
        if (totalAmount.compareTo(BigDecimal.ZERO) < 0) {
            PDFTemplatePosition currentPosition = this.getContentPositionByXmlAndStr(null, "negativeMark", contentJson, 0);
            list.add(currentPosition);
        }
    }

    private PDFTemplatePosition getContentPositionByXml(JSONObject dataJson, String key, JSONObject positionJson, int currentPageSize) {
        return this.getContentPositionByXmlAndStr(dataJson.getString(key), key, positionJson, currentPageSize);
    }

    private PDFTemplatePosition getContentPositionByXmlAndStr(String str, String key, JSONObject positionJson, int currentPageSize) {
        return this.getContentPositionByXmlAndStrWithDiff(str, key, positionJson, currentPageSize, 0.0f);
    }

    private PDFTemplatePosition getContentPositionByXmlAndStrWithDiff(String str, String key, JSONObject positionJson, int currentPageSize, float diffY) {
        PDFTemplatePosition position = (PDFTemplatePosition)JSONObject.toJavaObject((JSON)positionJson.getJSONObject(key), PDFTemplatePosition.class);
        if (position == null) {
            return null;
        }
        if (str != null) {
            position.setMsg(str);
        }
        String textLocation = this.getTextLocation(position.getTextLocation(), currentPageSize, diffY);
        position.setTextLocation(textLocation);
        return position;
    }

    private String getTextLocation(String textLocation, int currentPageSize, float diffY) {
        if (currentPageSize > 0 || BigDecimal.valueOf(diffY).compareTo(BigDecimal.ZERO) != 0) {
            StringBuilder textLocationBd = new StringBuilder();
            String[] textLocationArr = textLocation.split(",");
            diffY = Float.parseFloat(textLocationArr[1]) + diffY;
            if (currentPageSize > 0) {
                diffY -= EInvoicePdfUtils.getPxByMm(4.5f * (float)currentPageSize);
            }
            textLocationBd.append(textLocationArr[0]).append(',').append(diffY);
            if (textLocationArr.length > 2) {
                for (int i = 2; i < textLocationArr.length; ++i) {
                    textLocationBd.append(',').append(textLocationArr[i]);
                }
            }
            textLocation = textLocationBd.toString();
        }
        return textLocation;
    }

    private String getTextLocationByXml(JSONObject contentJson, int currentPageSize) {
        String textLocation = contentJson.getString("textLocation");
        if (currentPageSize > 0) {
            StringBuilder sb = new StringBuilder();
            String[] textLocationArr = textLocation.split(",");
            float diffY = Float.parseFloat(textLocationArr[1]);
            if (currentPageSize > 0) {
                diffY -= EInvoicePdfUtils.getPxByMm(4.5f * (float)currentPageSize);
            }
            sb.append(textLocationArr[0]).append(',').append(diffY);
            if (textLocationArr.length > 2) {
                for (int i = 2; i < textLocationArr.length; ++i) {
                    sb.append(',').append(textLocationArr[i]);
                }
            }
            return sb.toString();
        }
        return textLocation;
    }

    private List<PDFTemplatePosition> getPageNoList(PDFTemplatePosition pageNoPosition, int pageNum, int currentPageNo) {
        PDFTemplatePosition currentPosition = (PDFTemplatePosition)JsonUtils.clone(pageNoPosition);
        String msg = currentPosition.getMsg();
        msg = msg.replace("A", String.valueOf(pageNum));
        msg = msg.replace("B", String.valueOf(currentPageNo));
        String textLocation = currentPosition.getTextLocation();
        String[] textLocationArr = textLocation.split(",");
        if (pageNum >= 10) {
            float ymX = Float.parseFloat(textLocationArr[0]) - 4.1f;
            if (currentPageNo >= 10) {
                ymX -= 4.2f;
            }
            textLocation = ymX + "," + textLocationArr[1];
        }
        currentPosition.setMsg(msg);
        currentPosition.setTextLocation(textLocation);
        ArrayList<PDFTemplatePosition> pageNoList = new ArrayList<PDFTemplatePosition>(1);
        pageNoList.add(currentPosition);
        return pageNoList;
    }

    private List<List<PDFTemplatePosition>> getRemarkList(JSONObject contentJson, String remark) {
        List<String> remarkDetailList = EInvoicePdfUtils.subStringByChineseLength(remark, 61, true);
        float diffY = 0.0f;
        ArrayList<List<PDFTemplatePosition>> remarkPositionList = new ArrayList<List<PDFTemplatePosition>>(8);
        ArrayList<PDFTemplatePosition> remarkList = new ArrayList<PDFTemplatePosition>(8);
        boolean firstPage = true;
        int pageSize = 0;
        float firstLineHigh = EInvoicePdfUtils.getPxByMm(3.0f);
        float moreLineHigh = EInvoicePdfUtils.getPxByMm(3.5f);
        for (String remarkStr : remarkDetailList) {
            remarkList.add(this.getContentPositionByXmlAndStrWithDiff(remarkStr, "remark", contentJson, 0, diffY));
            diffY -= firstPage ? firstLineHigh : moreLineHigh;
            if ((++pageSize != 6 || !firstPage) && pageSize != 66) continue;
            remarkPositionList.add(remarkList);
            pageSize = 0;
            diffY = EInvoicePdfUtils.getPxByMm(8.0f);
            firstPage = false;
            remarkList = new ArrayList(8);
        }
        if (!remarkList.isEmpty()) {
            remarkPositionList.add(remarkList);
        }
        return remarkPositionList;
    }

    private RightLinePosition getRightLinePosition(JSONObject templateJson) {
        JSONObject rightLine = templateJson.getJSONObject("RIGHT_LINE");
        PDFTemplatePosition topPosition = (PDFTemplatePosition)JSONObject.toJavaObject((JSON)rightLine.getJSONObject("TOP"), PDFTemplatePosition.class);
        PDFTemplatePosition bottomPosition = (PDFTemplatePosition)JSONObject.toJavaObject((JSON)rightLine.getJSONObject("BOTTOM"), PDFTemplatePosition.class);
        return new RightLinePosition(topPosition, bottomPosition);
    }

    static {
        LoadFontUtils.init();
    }
}

