/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.file.fpy.service.pdf.input;

import com.lowagie.text.Image;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.file.fpy.model.protocol.PdfProduceBean;
import kd.imc.bdm.file.fpy.model.protocol.REQUEST_COMMON_FPKJ;
import kd.imc.bdm.file.fpy.model.protocol.RESPONSE_FPKJ;
import kd.imc.bdm.file.fpy.model.qrcode.QrcodeBean;
import kd.imc.bdm.file.util.DateUtils;
import kd.imc.bdm.file.util.Handle;
import kd.imc.bdm.file.util.MathUtil;
import kd.imc.bdm.file.util.QrcodeUtil;

public class TaxCodeService {
    private static final Log logger = LogFactory.getLog(TaxCodeService.class);

    public PdfProduceBean taxCode(REQUEST_COMMON_FPKJ REQUEST_COMMON_FPKJ2, Map<String, Object> paramMap) {
        PdfProduceBean pdfProduceBean = new PdfProduceBean();
        pdfProduceBean = this.mapToBean(pdfProduceBean, REQUEST_COMMON_FPKJ2, paramMap);
        return pdfProduceBean;
    }

    private PdfProduceBean mapToBean(PdfProduceBean pdfProduceBean, REQUEST_COMMON_FPKJ request_COMMON_FPKJ, Map<String, Object> paramMap) {
        logger.info("\u5f00\u59cb\u8f6c\u6362......");
        RESPONSE_FPKJ RESPONSE_FPKJ2 = new RESPONSE_FPKJ();
        RESPONSE_FPKJ2.setJYM((String)paramMap.get("JYM"));
        RESPONSE_FPKJ2.setFP_HM((String)paramMap.get("FP_HM"));
        RESPONSE_FPKJ2.setFP_DM((String)paramMap.get("FP_DM"));
        RESPONSE_FPKJ2.setFWMW((String)paramMap.get("FWMW"));
        RESPONSE_FPKJ2.setSSYF((String)paramMap.get("SSYF"));
        RESPONSE_FPKJ2.setKPRQ((String)paramMap.get("KPRQ"));
        RESPONSE_FPKJ2.setHJBHSJE((String)paramMap.get("HJBHSJE"));
        RESPONSE_FPKJ2.setSehj((String)paramMap.get("HJSE"));
        RESPONSE_FPKJ2.setEWM(this.generateTwoDimCode(paramMap));
        String JQBH = (String)paramMap.get("jqbh");
        pdfProduceBean.setTemplatePath((String)paramMap.get("templatePath"));
        pdfProduceBean.setImage((Image)paramMap.get("image"));
        pdfProduceBean.setInvoiceType((String)paramMap.get("invoiceType"));
        pdfProduceBean.setTag((String)paramMap.get("tag"));
        pdfProduceBean.setBlockchain((String)paramMap.get("blockchain"));
        pdfProduceBean.setInventoryFlag((String)paramMap.get("inventoryFlag"));
        pdfProduceBean.setJQBH(JQBH);
        pdfProduceBean.setCOMMON_FPKJ_FPT(request_COMMON_FPKJ.getCOMMON_FPKJ_FPT());
        pdfProduceBean.setCOMMON_FPKJ_XMXXS(request_COMMON_FPKJ.getCOMMON_FPKJ_XMXXS());
        pdfProduceBean.setRESPONSE_FPKJ(RESPONSE_FPKJ2);
        return pdfProduceBean;
    }

    private String generateTwoDimCode(Map<String, Object> map) {
        QrcodeBean QrcodeBean2 = new QrcodeBean();
        QrcodeBean2.setHEAD_version("01");
        QrcodeBean2.setEXPRESS_eInvoiceType("10");
        QrcodeBean2.setEXPRESS_eInvoiceCode(map.get("FP_DM").toString());
        QrcodeBean2.setEXPRESS_EInvoiceNo(map.get("FP_HM").toString());
        String hjbhsje = map.get("HJBHSJE").toString();
        try {
            hjbhsje = MathUtil.formatDoubleDigit(Double.parseDouble(hjbhsje));
        }
        catch (Exception e) {
            logger.error("--\u7ebf\u7a0b\uff08ID\uff1a" + Thread.currentThread().getId() + "\uff09\uff0c\u683c\u5f0f\u5316\u5408\u8ba1\u4e0d\u542b\u7a0e\u91d1\u989d\u4e3a\u4fdd\u7559\u4e24\u4f4d\u5c0f\u6570\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u8be6\u60c5\u4e3a\uff1a", (Throwable)e);
            hjbhsje = map.get("HJBHSJE").toString();
        }
        QrcodeBean2.setEXPRESS_billingAmount(hjbhsje);
        if (Handle.isNotEmpty(map.get("KPRQ"))) {
            String dateString = map.get("KPRQ").toString();
            Date date = null;
            String fmtDate = "";
            try {
                if (dateString.length() > 10) {
                    date = DateUtils.parseDate("yyyy-MM-dd HH:mm:ss", dateString);
                    fmtDate = DateUtils.format(date, "yyyyMMdd");
                } else {
                    date = DateUtils.parseDate("yyyy-MM-dd", dateString);
                    fmtDate = DateUtils.format(date, "yyyyMMdd");
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            QrcodeBean2.setEXPRESS_billingDate(fmtDate);
        }
        QrcodeBean2.setEXPRESS_checkCode((String)map.get("JYM"));
        return QrcodeUtil.generationQrcode(QrcodeBean2);
    }
}

