/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.file.fpy.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.file.fpy.util.PDFXmlUtils;

public class PDFTemplateUtils {
    private static final Log log = LogFactory.getLog(PDFXmlUtils.class);
    private static ConcurrentHashMap<String, byte[]> cacheTemplateMap = new ConcurrentHashMap();

    public static byte[] getPDFTemplateInfoBytes(String filePath) {
        File file = new File(filePath);
        String fileName = file.getName();
        if (!cacheTemplateMap.containsKey(fileName)) {
            try {
                cacheTemplateMap.putIfAbsent(fileName, PDFTemplateUtils.readTempFileBytes(filePath));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return cacheTemplateMap.get(fileName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readTempFileBytes(String path) throws FileNotFoundException {
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);){
            int n;
            if (is == null) {
                throw new FileNotFoundException(String.format(ResManager.loadKDString((String)"\u6a21\u7248\u6587\u4ef6\u4e0d\u5b58\u5728%s", (String)"PDFTemplateUtils_1", (String)"imc-bdm-file", (Object[])new Object[0]), path));
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[4096];
            while ((n = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, n);
            }
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new FileNotFoundException(String.format(ResManager.loadKDString((String)"\u6a21\u7248\u6587\u4ef6\u4e0d\u5b58\u5728%s", (String)"PDFTemplateUtils_1", (String)"imc-bdm-file", (Object[])new Object[0]), path));
        }
    }
}

