/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.lqpt.formplugin;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.lqpt.service.InvoiceNoService;

public class LqptYfmListPlugin
extends AbstractListPlugin {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void itemClick(ItemClickEvent evt) {
        if ("collectinvoiceno".equals(evt.getOperationKey())) {
            PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.LQPT_COLLECT_INVOICENO);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bdm_lqpt_invoicenocollect");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, evt.getItemKey());
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("btnok".equals(control.getKey())) {
            String taxNo = (String)this.getModel().getValue("taxno");
            int collectsize = (Integer)this.getModel().getValue("collectsize");
            if (0 == collectsize || collectsize > 1000) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9886\u7528\u5f20\u6570\u8303\u56f41-1000", (String)"LqptYfmListPlugin_1", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
                return;
            }
            if (StringUtils.isBlank((CharSequence)taxNo)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"LqptYfmListPlugin_2", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
                return;
            }
            boolean isLqpt = EnterpriseHelper.isLqptChannel((String)taxNo);
            if (!isLqpt) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u6ca1\u6709\u4e50\u4f01\u5f00\u7968\u901a\u9053", (String)"LqptYfmListPlugin_0", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
                return;
            }
            InvoiceNoService invoiceNoService = new InvoiceNoService();
            boolean collctFlag = invoiceNoService.collectInvoiceNoByHandler(taxNo, collectsize);
            if (!collctFlag) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53f7\u6bb5\u9886\u7528\u5931\u8d25\u7a0d\u540e\u91cd\u8bd5", (String)"LqptYfmListPlugin_3", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
                return;
            }
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("orginfo".equals(name)) {
            DynamicObject orginfo = (DynamicObject)this.getModel().getValue("orginfo");
            SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)orginfo.getLong("id"));
            this.getModel().setValue("taxno", (Object)saleInfo.getSaleTaxNo());
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        this.getView().invokeOperation("refresh");
    }
}

