/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.lqpt.schedule;

import java.util.Collection;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.table.EnterPriseBaseInfoConstant;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.lqpt.service.SpbmAndSlvService;
import kd.imc.bdm.lqpt.service.SxedService;
import kd.imc.bdm.lqpt.service.TaxpayerService;
import org.apache.commons.collections.CollectionUtils;

public class TaxpayerQueryTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(TaxpayerQueryTask.class);

    public MessageHandler getMessageHandle() {
        return null;
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("\u7eb3\u7a0e\u4eba\u98ce\u9669/\u57fa\u672c\u4fe1\u606f\u67e5\u8be2\u4fdd\u5b58\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb...");
        DynamicObjectCollection epInfoList = this.getAllTaxNo();
        if (CollectionUtils.isEmpty((Collection)epInfoList)) {
            logger.info("\u7eb3\u7a0e\u4eba\u98ce\u9669/\u57fa\u672c\u4fe1\u606f\u67e5\u8be2\u4fdd\u5b58\uff0c\u672a\u627e\u5230\u7a0e\u53f7");
            return;
        }
        SpbmAndSlvService taxpayerService = new SpbmAndSlvService();
        for (DynamicObject epInfo : epInfoList) {
            String taxNo = epInfo.getString("number");
            if (StringUtils.isBlank((CharSequence)taxNo)) continue;
            logger.info("\u540c\u6b65\u57fa\u672c\u4fe1\u606f{}\u5f00\u59cb", (Object)taxNo);
            this.queryBaseInfo(taxNo);
            this.downLoadSxed(taxNo);
            taxpayerService.queryLvFromLq(taxNo);
            logger.info("\u540c\u6b65\u57fa\u672c\u4fe1\u606f{}\u7ed3\u675f", (Object)taxNo);
        }
    }

    private void queryBaseInfo(String taxNo) {
        TaxpayerService taxpayerService = new TaxpayerService();
        try {
            taxpayerService.queryAndSaveBaseInfo(taxNo);
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u57fa\u672c\u4fe1\u606f\u5931\u8d25" + taxNo, (Throwable)e);
        }
        try {
            taxpayerService.queryAndSaveRiskInfo(taxNo);
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u98ce\u9669\u4fe1\u606f\u5931\u8d25" + taxNo, (Throwable)e);
        }
    }

    private void downLoadSxed(String taxNo) {
        try {
            SxedService sxedService = new SxedService();
            DynamicObject sxedObject = sxedService.getDynamicObject(taxNo);
            if (sxedObject == null) {
                sxedService.downLoadSxedFromLqpt(taxNo);
            } else {
                String cacheKey = "lqpt_sxed_query" + taxNo;
                if (StringUtils.isBlank((CharSequence)CacheHelper.get((String)cacheKey))) {
                    sxedService.querySxed(taxNo, sxedObject);
                    sxedService.afterQuerySxed(taxNo, sxedObject);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u6388\u4fe1\u989d\u5ea6\u5931\u8d25" + taxNo, (Throwable)e);
        }
    }

    private DynamicObjectCollection getAllTaxNo() {
        QFilter qFilter = new QFilter("issuechannel", "in", (Object)EnterPriseBaseInfoConstant.LQPT_CHANNEL_DIRECT);
        return QueryServiceHelper.query((String)"bdm_enterprise_baseinfo", (String)String.join((CharSequence)",", "number", "enterpriserole"), (QFilter[])qFilter.toArray());
    }
}

