/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.lqpt.service;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.lqpt.constant.LqptErrorCode;
import kd.imc.bdm.lqpt.model.LqEpConfig;
import kd.imc.bdm.lqpt.model.request.base.TaxpayerBaseRequest;
import kd.imc.bdm.lqpt.model.request.base.TaxpayerRiskRequest;
import kd.imc.bdm.lqpt.model.response.LqptResponse;
import kd.imc.bdm.lqpt.model.response.base.TaxpayerBaseResponse;
import kd.imc.bdm.lqpt.model.response.base.TaxpayerBaseResponseJcxx;
import kd.imc.bdm.lqpt.model.response.base.TaxpayerBaseResponseQyhyxz;
import kd.imc.bdm.lqpt.model.response.base.TaxpayerBaseResponseXfsnsrlx;
import kd.imc.bdm.lqpt.model.response.base.TaxpayerRiskResponse;
import kd.imc.bdm.lqpt.service.LqptService;
import kd.imc.bdm.lqpt.service.SpbmAndSlvService;
import kd.imc.bdm.lqpt.service.SxedService;
import kd.imc.bdm.lqpt.utils.CommonUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class TaxpayerService {
    private static Log LOGGER = LogFactory.getLog(TaxpayerService.class);

    @Deprecated
    public void requestTest(String currentTaxNo, Long epInfo, String lqid, String leqisecret, String issueChannel) {
        LqEpConfig lqEpConfig = new LqEpConfig();
        lqEpConfig.setNsrsbh(currentTaxNo);
        lqEpConfig.setJrdwptbh(lqid);
        lqEpConfig.setSydwptbh(lqid);
        lqEpConfig.setLqSecret(leqisecret);
        lqEpConfig.setIssueChannel(issueChannel);
        this.requestTest(lqEpConfig, epInfo);
    }

    public void requestTest(LqEpConfig lqEpConfig, Long epInfo) {
        if (epInfo != null && epInfo > 0L) {
            DynamicObject ep2 = QueryServiceHelper.queryOne((String)"bdm_enterprise_baseinfo", (String)String.join((CharSequence)",", "leqiid", "leqisecret", "leqiurl"), (QFilter[])new QFilter("id", "=", (Object)epInfo).toArray());
            if (ep2 != null) {
                lqEpConfig.setJrdwptbh(ep2.getString("leqiid"));
                lqEpConfig.setLqSecret(ep2.getString("leqisecret"));
                new LqptService().setEpLqUrl(ep2.getString("leqiurl"), lqEpConfig);
            }
        } else {
            new LqptService().setEpLqUrl(lqEpConfig.getBaseUrl(), lqEpConfig);
        }
        Map map = ImcConfigUtil.getValue((String)"bdm_lqpt");
        if (StringUtils.isBlank((String)lqEpConfig.getBaseUrl())) {
            lqEpConfig.setBaseUrl((String)map.get("baseurl"));
        }
        if (StringUtils.isBlank((String)lqEpConfig.getProxy())) {
            lqEpConfig.setProxy((String)map.get("proxy"));
        }
        if (StringUtils.isNotBlank((String)((String)map.get("connect_timeout")))) {
            lqEpConfig.setConnectTimeout(Integer.parseInt((String)map.get("connect_timeout")));
        }
        if (StringUtils.isNotBlank((String)((String)map.get("socket_timeout")))) {
            lqEpConfig.setSocketTimeout(Integer.parseInt((String)map.get("socket_timeout")));
        }
        if (StringUtils.isNotBlank((String)((String)map.get("sxcsbz")))) {
            lqEpConfig.setSxcsbz((String)map.get("sxcsbz"));
        }
        TaxpayerBaseRequest request = new TaxpayerBaseRequest();
        request.setNsrsbh(lqEpConfig.getNsrsbh());
        LqptService service = new LqptService();
        LqptResponse response = service.send(request, lqEpConfig, null);
        if (!response.success()) {
            throw new KDException(new ErrorCode(response.getErrcode(), response.getDescription()), new Object[0]);
        }
    }

    public void init(String taxNo, String enterpriseRole) {
        boolean result = this.queryAndSaveBaseInfo(taxNo);
        if (result) {
            result = this.queryAndSaveRiskInfo(taxNo);
        }
        try {
            SxedService service = new SxedService();
            service.downLoadSxed(taxNo, null);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u4e0b\u8f7d\u6388\u4fe1\u989d\u5ea6\u62a5\u9519" + e.getMessage(), (Throwable)e);
        }
        SpbmAndSlvService taxpayerService = new SpbmAndSlvService();
        taxpayerService.queryLvFromLq(taxNo);
        if ("1".equals(enterpriseRole)) {
            taxpayerService.querySpbmFromLq(taxNo);
        }
    }

    public boolean queryAndSaveRiskInfo(String taxNo) {
        if (StringUtils.isEmpty((String)taxNo)) {
            throw new KDBizException(LqptErrorCode.PARAM_EMPTY, new Object[0]);
        }
        TaxpayerRiskRequest request = new TaxpayerRiskRequest();
        request.setNsrsbh(taxNo);
        LqptService service = new LqptService();
        LqptResponse response = service.send(request);
        if (response.success()) {
            TaxpayerRiskResponse trr = (TaxpayerRiskResponse)response.getData();
            LOGGER.info("\u7a0e\u53f7\uff1a{} \u7eb3\u7a0e\u4eba\u98ce\u9669\u4fe1\u606f\u7ed3\u679c\uff1a{}", (Object)taxNo, (Object)trr.toString());
            this.saveRiskResult(taxNo, trr);
            return true;
        }
        return false;
    }

    public boolean queryAndSaveBaseInfo(String taxNo) {
        if (StringUtils.isEmpty((String)taxNo)) {
            throw new KDBizException(LqptErrorCode.PARAM_EMPTY, new Object[0]);
        }
        TaxpayerBaseRequest request = new TaxpayerBaseRequest();
        request.setNsrsbh(taxNo);
        LqptService service = new LqptService();
        LqptResponse response = service.send(request);
        if (response.success()) {
            TaxpayerBaseResponse tbr = (TaxpayerBaseResponse)response.getData();
            LOGGER.info("\u7a0e\u53f7\uff1a{} \u7eb3\u7a0e\u4eba\u57fa\u672c\u4fe1\u606f\u7ed3\u679c\uff1a{}", (Object)taxNo, (Object)tbr.toString());
            this.saveBaseResult(taxNo, tbr);
            return true;
        }
        return false;
    }

    private void saveBaseResult(String taxNo, TaxpayerBaseResponse response) {
        List<TaxpayerBaseResponseXfsnsrlx> xfsnsrlxGrid;
        List<TaxpayerBaseResponseQyhyxz> qyhyxzGrid;
        DynamicObject baseObject = this.getDynamicObject(taxNo, "bdm_enterprise_info");
        if (baseObject == null) {
            return;
        }
        TaxpayerBaseResponseJcxx jcxx = response.getJcxx();
        if (jcxx != null) {
            Field[] fields;
            for (Field field : fields = jcxx.getClass().getDeclaredFields()) {
                try {
                    Method m = jcxx.getClass().getMethod("get" + CommonUtil.toUpperFirstOne(field.getName()), new Class[0]);
                    baseObject.set(field.getName(), m.invoke((Object)jcxx, new Object[0]));
                }
                catch (Exception e) {
                    LOGGER.info("\u4fdd\u5b58\u7eb3\u7a0e\u4eba\u57fa\u672c\u4fe1\u606f\u51fa\u9519", (Object)e);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(qyhyxzGrid = response.getQyhyxzGrid())) {
            baseObject.set("qyhyxzdm", (Object)qyhyxzGrid.stream().map(TaxpayerBaseResponseQyhyxz::getQyhyxzdm).collect(Collectors.joining(",")));
        }
        if (CollectionUtils.isNotEmpty(xfsnsrlxGrid = response.getXfsnsrlxGrid())) {
            baseObject.set("xfsnsrlxdm", (Object)xfsnsrlxGrid.stream().map(TaxpayerBaseResponseXfsnsrlx::getXfsnsrlxdm).collect(Collectors.joining(",")));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{baseObject});
    }

    private void saveRiskResult(String taxNo, TaxpayerRiskResponse response) {
        DynamicObject riskObject = this.getDynamicObject(taxNo, "bdm_enterprise_baseinfo");
        if (riskObject == null) {
            return;
        }
        riskObject.set("fxnsrlx", (Object)response.getFxnsrlx());
        riskObject.set("nsrxydj", (Object)response.getNsrxydj());
        riskObject.set("nsryjjb", (Object)response.getNsryjjb());
        riskObject.set("fxnasrbz", (Object)response.getFxnsrbz());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{riskObject});
    }

    private DynamicObject getDynamicObject(String taxNo, String entity) {
        DynamicObject object = "bdm_enterprise_baseinfo".equals(entity) ? BusinessDataServiceHelper.loadSingle((String)entity, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)taxNo)}) : BusinessDataServiceHelper.loadSingle((String)entity, (QFilter[])new QFilter[]{new QFilter("epinfo.number", "=", (Object)taxNo)});
        return object;
    }

    public DynamicObject isRiskTaxPayer(String taxNo) {
        if (StringUtils.isEmpty((String)taxNo)) {
            throw new KDBizException(LqptErrorCode.PARAM_EMPTY, new Object[0]);
        }
        DynamicObject epBaseInfo = this.getEnterPriseBaseInfo(taxNo);
        if (epBaseInfo == null) {
            boolean isSuccess = this.queryAndSaveRiskInfo(taxNo);
            if (!isSuccess) {
                throw new KDBizException(LqptErrorCode.RISK_EMPTY, new Object[0]);
            }
            epBaseInfo = this.getEnterPriseBaseInfo(taxNo);
        }
        if (epBaseInfo != null) {
            String fxnsrlx = epBaseInfo.getString("fxnsrlx");
            String nsryjjb = epBaseInfo.getString("nsryjjb");
            String fxnasrbz = epBaseInfo.getString("fxnasrbz");
            if ("01".equals(fxnsrlx)) {
                throw new KDBizException(LqptErrorCode.RISK_TAXPAYER_I, new Object[0]);
            }
            if ("01".equals(nsryjjb)) {
                throw new KDBizException(LqptErrorCode.RISK_TAXPAYER_REDLEVEL, new Object[0]);
            }
            if ("Y".equals(fxnasrbz)) {
                throw new KDBizException(LqptErrorCode.RISK_TAXPAYER_Y, new Object[0]);
            }
            Object id = epBaseInfo.get("id");
            DynamicObject epInfo = this.getEnterPriseInfo(id);
            if (epInfo == null) {
                boolean isSuccess = this.queryAndSaveBaseInfo(taxNo);
                if (!isSuccess) {
                    throw new KDBizException(LqptErrorCode.BASE_EMPTY, new Object[0]);
                }
                epInfo = this.getEnterPriseInfo(id);
                if (epInfo != null) {
                    String nsrztdm = epInfo.getString("nsrztdm");
                    if (!"03".equals(nsrztdm) && "09".equals(nsrztdm)) {
                        throw new KDBizException(LqptErrorCode.RISK_TAXPAYER_UNNORMAL, new Object[0]);
                    }
                } else {
                    throw new KDBizException(LqptErrorCode.BASE_EMPTY, new Object[0]);
                }
            }
            return epInfo;
        }
        throw new KDBizException(LqptErrorCode.RISK_EMPTY, new Object[0]);
    }

    private DynamicObject getEnterPriseInfo(Object id) {
        if (ObjectUtils.isEmpty((Object)id)) {
            return null;
        }
        return QueryServiceHelper.queryOne((String)"bdm_enterprise_info", (String)"nsrztdm, zgswskfjdm", (QFilter[])new QFilter[]{new QFilter("epinfo", "=", id)});
    }

    private DynamicObject getEnterPriseBaseInfo(String taxNo) {
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bdm_enterprise_baseinfo", (String)"id, fxnsrlx, nsryjjb, fxnasrbz", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)taxNo)});
    }
}

