/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.lqpt.service.check;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.lqpt.constant.LqptErrorCode;
import kd.imc.bdm.lqpt.model.request.LqptRequest;
import kd.imc.bdm.lqpt.model.request.check.CheckRequest;
import kd.imc.bdm.lqpt.model.response.LqptResponse;
import kd.imc.bdm.lqpt.service.LqptService;
import kd.imc.bdm.lqpt.utils.RequestValidateUtil;

public class CheckApiService {
    private static final Log LOGGER = LogFactory.getLog(CheckApiService.class);

    public JSONObject send(JSONObject param) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("errorcode", (Object)ErrorType.FAIL.getCode());
        try {
            LOGGER.info("CheckApiService send param\uff1a{}", (Object)param);
            if (param.isEmpty()) {
                throw new KDBizException(LqptErrorCode.PARAM_EMPTY, new Object[0]);
            }
            LqptRequest request = (LqptRequest)JSON.parseObject((String)JSONObject.toJSONString((Object)param), CheckRequest.class);
            if (!RequestValidateUtil.checkRequestParam(request)) {
                throw new KDBizException(LqptErrorCode.PARAM_EMPTY, new Object[0]);
            }
            this.validateParam(param);
            LqptResponse response = new LqptService().send(request);
            return (JSONObject)JSONObject.toJSON((Object)response);
        }
        catch (KDBizException e) {
            ErrorCode errorCode = e.getErrorCode();
            if (errorCode != null) {
                jsonObject.put("errorcode", (Object)errorCode.getCode());
                jsonObject.put("description", (Object)errorCode.getMessage());
            }
        }
        catch (Exception e) {
            LOGGER.info("CheckApiService send error\uff1a{}", (Object)e);
        }
        return jsonObject;
    }

    private void validateParam(JSONObject param) {
        String fplx = param.getString("fplx");
        String fphm = param.getString("fphm");
        String kprq = param.getString("kprq");
        String nsrsbh = param.getString("nsrsbh");
        if (fplx == null || fplx.length() != 2) {
            throw new KDBizException(LqptErrorCode.TYPE_ERROR, new Object[0]);
        }
        if (fphm == null) {
            throw new KDBizException(LqptErrorCode.NUMBER_ERROR, new Object[0]);
        }
        try {
            LocalDate localDate = LocalDate.parse(kprq, DateTimeFormatter.BASIC_ISO_DATE);
        }
        catch (Exception e) {
            throw new KDBizException(LqptErrorCode.DATE_ERROR, new Object[0]);
        }
        if (nsrsbh == null) {
            throw new KDBizException(LqptErrorCode.NSRSBH_ERROR, new Object[0]);
        }
    }
}

