/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.mservice.upgrade;

import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.DBServiceHelper;

public class BdmMailBaseDataUpgradeImpl
implements IUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(BdmMailBaseDataUpgradeImpl.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        try {
            result.setLog("Start Mail Base Data Migration");
            this.updateData();
            result.setSuccess(true);
            result.setLog("Mail Base Data Migration Success");
        }
        catch (Throwable e) {
            result.setErrorInfo(e.getMessage());
            result.setSuccess(false);
            result.setLog("Mail Base Data Migration Fail");
            LOGGER.error(e);
        }
        return result;
    }

    private void updateData() {
        try (DataSet mailSettingDataSet = DB.queryDataSet((String)"queryMailSetting", (DBRoute)new DBRoute("taxc"), (String)"select fid, fnumber, fname from t_bdm_mail_setting where fepinfos != 'DONE'");){
            for (Row mailSettingRow : mailSettingDataSet) {
                long mailSettingId = mailSettingRow.getLong("fid");
                String name = mailSettingRow.getString("fname");
                if ("YZYXSZ01_s".equals(mailSettingRow.getString("fnumber"))) {
                    DB.execute((DBRoute)new DBRoute("taxc"), (String)("update t_bdm_mail_setting set fepinfos = 'DONE' where fid = " + mailSettingId));
                    this.updateSQL(100000L, "5", mailSettingId, name);
                    continue;
                }
                try (DataSet itemDataSet = DB.queryDataSet((String)"queryMailSettingItems", (DBRoute)new DBRoute("taxc"), (String)("select distinct fepinfo from t_bdm_mail_items where fid = " + mailSettingId));){
                    Iterator itemIterator = itemDataSet.iterator();
                    int j = 0;
                    while (itemIterator.hasNext()) {
                        Row itemRow = (Row)itemIterator.next();
                        long epInfoId = itemRow.getLong("fepinfo");
                        if (epInfoId == 0L) continue;
                        try (DataSet orgDataSet = DB.queryDataSet((String)"queryBdmOrg", (DBRoute)new DBRoute("taxc"), (String)("select fid from t_bdm_org where fepinfo = " + epInfoId));){
                            Iterator orgIterator = orgDataSet.iterator();
                            int i = 0;
                            while (orgIterator.hasNext()) {
                                Long orgId = ((Row)orgIterator.next()).getLong("fid");
                                LOGGER.info(String.format("Copy data org:[%s]", orgId));
                                if (i == 0 && j == 0) {
                                    LOGGER.info("update 0 start");
                                    this.updateSQL(orgId, "7", mailSettingId, name);
                                    LOGGER.info("update 0 end");
                                } else {
                                    LOGGER.info(String.format("Copy data start j:[%s],i:[%s]", j, i));
                                    long newMailSettingId = DBServiceHelper.genGlobalLongId();
                                    String number = mailSettingRow.getString("fnumber") + j + i;
                                    String sql = "INSERT INTO t_bdm_mail_setting (fid, fnumber, fname, fsendinvoiceoption, fusername, fpassword, fserveraddress, fport, fssl, fmailtempoption, fmailtitle, fmailbody, fmailbody_tag, fseparator, fnowfilename, fcreater, fcreatedate, fepinfos, fclientname, fstatus, fmaillinkformat, fattachementsend, fmultimailbody, fmultifields, fmodernauth, fmultimailbody_tag, fmultimailtitle, fcreateorgid, fsourcedataid, fbitindex, fsourcebitindex, fsrccreateorgid, fmodifierid, fenable, fcreatetime, fmodifytime, fmasterid, forgid, fctrlstrategy, fuseorg, ffilter, ffilter_tag, fsendemail) select " + newMailSettingId + ", '" + number + "' , fname, fsendinvoiceoption, fusername, fpassword, fserveraddress, fport, fssl, fmailtempoption, fmailtitle, fmailbody, fmailbody_tag, fseparator, fnowfilename, fcreater, fcreatedate, 'DONE', fclientname, fstatus, fmaillinkformat, fattachementsend, fmultimailbody, fmultifields, fmodernauth, fmultimailbody_tag, fmultimailtitle, fcreateorgid, fsourcedataid, fbitindex, fsourcebitindex, fsrccreateorgid, fmodifierid, fenable, fcreatetime, fmodifytime, fmasterid, forgid, fctrlstrategy, fuseorg, ffilter, ffilter_tag, fsendemail from t_bdm_mail_setting where fid = " + mailSettingId;
                                    try {
                                        LOGGER.info(String.format("Copy data save start j:[%s],i:[%s]", j, i));
                                        DB.execute((DBRoute)new DBRoute("taxc"), (String)sql);
                                        LOGGER.info(String.format("Copy data success, pkValue:[%s], orgId:[%s], epInfo:[%s]", newMailSettingId, orgId, epInfoId));
                                        this.updateSQL(orgId, "7", newMailSettingId, name);
                                    }
                                    catch (Exception e) {
                                        LOGGER.info(String.format("Copy data fail, pkValue:[%s], orgId:[%s], epInfo:[%s]", newMailSettingId, orgId, epInfoId));
                                    }
                                }
                                ++i;
                            }
                        }
                        ++j;
                    }
                }
                DB.execute((DBRoute)new DBRoute("taxc"), (String)("update t_bdm_mail_setting set fepinfos = 'DONE' where fid = " + mailSettingId));
            }
        }
    }

    private void updateSQL(long orgId, String strategy, long objectId, String name) {
        LOGGER.info(String.format("Main table start orgId[%s], objectId[%s]", orgId, objectId));
        DB.execute((DBRoute)new DBRoute("taxc"), (String)"UPDATE t_bdm_mail_setting SET fcreateorgid = ?, fctrlstrategy = ?, fmasterid = ?, fstatus = ? WHERE fid = ?;", (Object[])new Object[]{orgId, strategy, objectId, "C", objectId});
        LOGGER.info("Main table end");
        try {
            LOGGER.info(String.format("U table start orgId[%s], objectId[%s]", orgId, objectId));
            DB.execute((DBRoute)new DBRoute("taxc"), (String)"INSERT INTO t_bdm_mail_setting_u (fdataid, fuseorgid) VALUES (?, ?);", (Object[])new Object[]{objectId, orgId});
            LOGGER.info("U table end");
        }
        catch (Exception e) {
            LOGGER.info("insert error: t_bdm_mail_setting_u");
        }
        try {
            LOGGER.info(String.format("USE table start orgId[%s], objectId[%s]", orgId, objectId));
            DB.execute((DBRoute)new DBRoute("taxc"), (String)"INSERT INTO t_bdm_mail_settingusereg (fuseorgid, fdataid, fcreateorgid, fadminorgid, fctrlstrategy, fisassign, fassignorgid) VALUES (?, ?, ?, ?, ?, ?, ?);", (Object[])new Object[]{orgId, objectId, orgId, orgId, strategy, Character.valueOf('0'), 0});
            LOGGER.info("USE table end");
        }
        catch (Exception e) {
            LOGGER.info("insert error: t_bdm_mail_setting_usereg");
        }
        String SQL_l = String.format("SELECT count(1) AS count FROM t_bdm_mail_setting_l WHERE fid = %s AND flocaleid = 'zh_CN';", objectId);
        LOGGER.info(String.format("L table start orgId[%s], objectId[%s]", orgId, objectId));
        try (DataSet dataSet = DB.queryDataSet((String)"getLanguageData", (DBRoute)new DBRoute("taxc"), (String)SQL_l);){
            LOGGER.info(String.format("DB build success orgId[%s], objectId[%s], DB[%s]", orgId, objectId, dataSet));
            if (dataSet == null || dataSet.next().getLong("count") == 0L) {
                try {
                    LOGGER.info(String.format("L table insert start orgId[%s], objectId[%s]", orgId, objectId));
                    DB.execute((DBRoute)new DBRoute("taxc"), (String)"INSERT INTO t_bdm_mail_setting_l (fpkid, fid, flocaleid, fname) VALUES (?, ?, ?, ?);", (Object[])new Object[]{DBServiceHelper.genStringId(), objectId, "zh_CN", name});
                    LOGGER.info("L table end");
                }
                catch (Exception e) {
                    LOGGER.info("insert error: t_bdm_mail_setting_l");
                }
            }
        }
        catch (Exception e) {
            LOGGER.info(String.format("table_l error: objectId[%s], error:[%s]", objectId, e.getMessage()));
        }
    }
}

