/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.alleinvoice;

import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.dto.allele.AllEleActiveProcessDTO;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.ImcLogHelper;
import kd.imc.bdm.common.helper.UnitTestHelper;
import kd.imc.bdm.common.util.ViewUtil;

public class ActiveCodeImportPlugin
extends AbstractFormPlugin {
    private static final int YES = 6;
    private static final Log LOGGER = LogFactory.getLog(ActiveCodeImportPlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if ("btnok".equals(key)) {
            String code = (String)this.getModel().getValue("code");
            if (StringUtils.isBlank((CharSequence)code)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u6fc0\u6d3b\u7801\u3002", (String)"ActiveCodeImportPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                return;
            }
            String tenant = RequestContext.get().getTenantInfo().getName();
            if (UnitTestHelper.isUnitTest()) {
                this.active(6);
            }
            ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)String.format(ResManager.loadKDString((String)"\u672c\u6b21\u5bfc\u5165\u7684\u79df\u6237\u4e3a\uff1a%s,\u662f\u5426\u7ee7\u7eed\u5bfc\u5165", (String)"ActiveCodeImportPlugin_13", (String)"imc-bdm-formplugin", (Object[])new Object[0]), tenant), (String)"activecode");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        int result = messageBoxClosedEvent.getResult().getValue();
        if ("activecode".equals(callBackId) && this.active(result)) {
            return;
        }
        if ("activeSuccess".equals(callBackId)) {
            this.getView().close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean active(int result) {
        String code = (String)this.getModel().getValue("code");
        LOGGER.info("activecode:" + code);
        String opName = ResManager.loadKDString((String)"\u5bfc\u5165\u6fc0\u6d3b\u7801", (String)"ActiveCodeImportPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        if (6 != result) return false;
        String lockKey = "activecode_activetenant";
        try (DLock lock = DLock.create((String)lockKey);){
            if (!lock.tryLock(10L)) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("\u672a\u83b7\u53d6\u5230\u9501");
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6fc0\u6d3b\u7801\u6b63\u5728\u88ab\u5176\u4ed6\u7528\u6237\u4f7f\u7528\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ActiveCodeImportPlugin_6", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                boolean bl = true;
                return bl;
            }
            AllEleActiveProcessDTO dto = AllEleAuthHelper.saveAuthAndEpInfo((String)code);
            Integer totalQueryNum = dto.getTotalQueryNum();
            Integer success = dto.getSuccessNum();
            int error = totalQueryNum - success;
            String totalDescription = String.format(ResManager.loadKDString((String)"\u672c\u6388\u6743\u53ef\u5bfc\u5165%1$s\u6761\u6570\u636e\uff0c\u672c\u6b21\u5bfc\u5165\u6210\u529f%2$s\u6761\uff0c\u672a\u5bfc\u5165%3$s\u6761\u3002", (String)"ActiveCodeImportPlugin_14", (String)"imc-bdm-formplugin", (Object[])new Object[0]), totalQueryNum, success, error);
            ImcLogHelper.addLog((String)"bdm", (String)"bdm_einvoice_account", (String)opName, (String)totalDescription);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("activeSuccess", (IFormPlugin)this);
            this.getView().showConfirm(totalDescription, AllEleAuthHelper.getDescription(), MessageBoxOptions.OK, ConfirmTypes.Default, confirmCallBacks);
            return false;
        }
        catch (KDBizException e) {
            String message = e.getMessage();
            LOGGER.error(message, (Throwable)e);
            if (String.valueOf(message).startsWith("Connect")) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:%s", (String)"ActiveCodeImportPlugin_15", (String)"imc-bdm-formplugin", (Object[])new Object[0]), message);
                this.getView().showErrorNotification(errMsg);
                ImcLogHelper.addLog((String)"bdm", (String)"bdm_einvoice_account", (String)opName, (String)errMsg);
                return false;
            }
            if (StringUtils.isBlank((CharSequence)message)) {
                String errMsg = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25", (String)"ActiveCodeImportPlugin_12", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
                ImcLogHelper.addLog((String)"bdm", (String)"bdm_einvoice_account", (String)opName, (String)errMsg);
                throw new KDBizException(errMsg);
            }
            ImcLogHelper.addLog((String)"bdm", (String)"bdm_einvoice_account", (String)opName, (String)message);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            ImcLogHelper.addLog((String)"bdm", (String)"bdm_einvoice_account", (String)opName, (String)e.getMessage());
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:%s", (String)"ActiveCodeImportPlugin_15", (String)"imc-bdm-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
        return false;
    }
}

