/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.alleinvoice.op;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.dto.allele.AllEleAddOrUpdateAccountDTO;
import kd.imc.bdm.common.dto.allele.AllEleBatchAddOrUpdateAccountQueryResponseDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseDTO;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.service.AllEleAccountSyncServiceImpl;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import org.apache.commons.collections.CollectionUtils;

public class EInvoiceAccountSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("name");
        e.getFieldKeys().add("taxno");
        e.getFieldKeys().add("cityname");
        e.getFieldKeys().add("channeltype");
        e.getFieldKeys().add("account");
        e.getFieldKeys().add("isdefault");
        e.getFieldKeys().add("defaultbusiness");
        e.getFieldKeys().add("password");
        e.getFieldKeys().add("etaxroletype");
        e.getFieldKeys().add("logintypes");
        e.getFieldKeys().add("appkey");
        e.getFieldKeys().add("appsecret");
        e.getFieldKeys().add("user");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject account;
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<AllEleAddOrUpdateAccountDTO> accountList = new ArrayList<AllEleAddOrUpdateAccountDTO>(dataEntities.length);
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject dataEntity = dataEntities[i];
            AllEleAddOrUpdateAccountDTO account2 = (AllEleAddOrUpdateAccountDTO)DynamicObjectUtil.dynamicObject2Bean(AllEleAddOrUpdateAccountDTO.class, (DynamicObject)dataEntity);
            account2.setCityName(dataEntity.getDynamicObject("cityname").getLocaleString("name").getLocaleValue());
            account2.setIndex(Integer.valueOf(i));
            accountList.add(account2);
        }
        if (CollectionUtils.isEmpty(accountList)) {
            return;
        }
        if (this.addOrUpdateAccount(accountList) && (account = BusinessDataServiceHelper.loadSingle((String)"bdm_einvoice_account", (String)"", (QFilter[])new QFilter("taxno", "=", (Object)dataEntities[0].getString("taxno")).toArray())) != null && (account = BusinessDataServiceHelper.loadSingle((Object)account.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bdm_einvoice_account"))) != null) {
            DynamicObjectCollection accountItems = account.getDynamicObjectCollection("entryentity");
            Optional<DynamicObject> first = accountItems.stream().filter(item -> dataEntities[0].getString("account").equals(item.getString("account"))).findFirst();
            if (first.isPresent()) {
                DynamicObject accountItem = first.get();
                accountItem.set("isdefault", dataEntities[0].get("isdefault"));
                accountItem.set("defaultbusiness", dataEntities[0].get("defaultbusiness"));
                accountItem.set("user", dataEntities[0].get("user"));
                this.checkAccountDefault(accountItem, accountItems, false);
            } else {
                DynamicObject accountItem = accountItems.addNew();
                accountItem.set("channeltype", dataEntities[0].get("channeltype"));
                accountItem.set("account", dataEntities[0].get("account"));
                accountItem.set("isdefault", dataEntities[0].get("isdefault"));
                accountItem.set("accounttype", (Object)"3");
                accountItem.set("isenable", (Object)"1");
                accountItem.set("defaultbusiness", dataEntities[0].get("defaultbusiness"));
                accountItem.set("user", dataEntities[0].get("user"));
                accountItem.set("logintype", (Object)"0");
                this.checkAccountDefault(accountItem, accountItems, true);
            }
            ImcSaveServiceHelper.save((DynamicObject)account);
        }
    }

    private void checkAccountDefault(DynamicObject accountItem, DynamicObjectCollection accountItems, boolean isNewAccount) {
        if (!"1".equals(accountItem.get("isdefault"))) {
            return;
        }
        int issueDefaultNum = 0;
        int inputDefaultNum = 0;
        for (DynamicObject item : accountItems) {
            String defaultBusiness = item.getString("defaultbusiness");
            if (!"1".equals(item.get("isdefault"))) continue;
            if (AllEleAuthHelper.isOutputBusiness((String)defaultBusiness)) {
                ++issueDefaultNum;
            }
            if (!AllEleAuthHelper.isInputBusiness((String)defaultBusiness)) continue;
            ++inputDefaultNum;
        }
        if (issueDefaultNum > 1) {
            if (isNewAccount) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65b0\u589e\u5931\u8d25\uff0c\u9ed8\u8ba4\u4e1a\u52a1\u5305\u542b\u5f00\u7968\u7ba1\u7406\u7684\u9ed8\u8ba4\u8d26\u53f7\u53ea\u80fd\u67091\u4e2a!", (String)"EInvoiceAccountSaveOp_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u4fee\u6539\u5931\u8d25\uff0c\u9ed8\u8ba4\u4e1a\u52a1\u5305\u542b\u5f00\u7968\u7ba1\u7406\u7684\u9ed8\u8ba4\u8d26\u53f7\u53ea\u80fd\u67091\u4e2a!", (String)"EInvoiceAccountSaveOp_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        if (inputDefaultNum > 1) {
            if (isNewAccount) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65b0\u589e\u5931\u8d25\uff0c\u9ed8\u8ba4\u4e1a\u52a1\u5305\u542b\u6536\u7968\u7ba1\u7406\u7684\u9ed8\u8ba4\u8d26\u53f7\u53ea\u80fd\u67091\u4e2a!", (String)"EInvoiceAccountSaveOp_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u4fee\u6539\u5931\u8d25\uff0c\u9ed8\u8ba4\u4e1a\u52a1\u5305\u542b\u6536\u7968\u7ba1\u7406\u7684\u9ed8\u8ba4\u8d26\u53f7\u53ea\u80fd\u67091\u4e2a!", (String)"EInvoiceAccountSaveOp_4", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean addOrUpdateAccount(List<AllEleAddOrUpdateAccountDTO> accountList) {
        AllEleAccountSyncServiceImpl allEleAccountSyncService = new AllEleAccountSyncServiceImpl();
        AllEleResponseDTO response = allEleAccountSyncService.addOrUpdateAccount2Aws(accountList);
        if (!response.getSuccess().booleanValue()) {
            throw new KDBizException(response.getDescription());
        }
        try {
            Thread.sleep(5000L);
            for (int i = 0; i < 10; ++i) {
                AllEleResponseDTO queryResponse = allEleAccountSyncService.queryAddOrUpDateResponse(accountList, response);
                if (!queryResponse.getSuccess().booleanValue()) {
                    throw new KDBizException(queryResponse.getDescription());
                }
                List queryDataResponse = JSONArray.parseArray((String)((JSONArray)queryResponse.getData()).toString(), AllEleBatchAddOrUpdateAccountQueryResponseDTO.class);
                if (!"0".equals(((AllEleBatchAddOrUpdateAccountQueryResponseDTO)queryDataResponse.get(0)).getStatus())) {
                    if ("-1".equals(((AllEleBatchAddOrUpdateAccountQueryResponseDTO)queryDataResponse.get(0)).getStatus())) {
                        throw new KDBizException(((AllEleBatchAddOrUpdateAccountQueryResponseDTO)queryDataResponse.get(0)).getDescription());
                    }
                    return true;
                }
                Thread.sleep(5000L);
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u65b0\u589e/\u4fee\u6539\u7535\u5b50\u7a0e\u5c40\u8d26\u53f7\u7ed3\u679c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5!", (String)"EInvoiceAccountSaveOp_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }
}

